<?php

class new_base_model extends MY_Model
{


    public $userSession;
    public $CI;
    public $broker_account_id;
	public $uid;
	public $username;
	public $agentcode;
	public $truename;
	public $package_id;
    public function __construct()
    {

        parent::__construct(1, 1,1);
        $this->CI = &get_instance();
        $this->CI->load->library('session');
        $this->userSession = $this->CI->session->userdata(USER_SESSION_KEY);
        $this->broker_account_id = $this->userSession['broker_account_id'];
	    $this->uid = $this->userSession['uid'];
	    $this->username = $this->userSession['username'];
	    $this->truename = $this->userSession['truename'];
	    $this->agentcode = $this->userSession['agentcode'];
	    $this->package_id = $this->userSession['package_id'];

    }


    public function newException($msg='',$state = 0,$data = array(),$return_array = false){

        try{
            throw new Exception($msg,$state);
        }catch (Exception $e){
            return $this->asJson($data,$e->getMessage(),$e->getCode(),$return_array);
        }
    }

    public function asJson($data,$msg,$state,$return_array){

        $return = array(
            'code'=>$state,
            'msg'=> iconv('gbk','utf-8',$msg),
            'data'=>$data
        );
        if($return_array){
            return $return;
        }
        echo json_encode($return);die;
    }

    function gbk2utf8($data){

        foreach ($data as $k=>$v){
            $data[$k] = iconv('gbk','utf-8',$v);
        }
        return $data;
    }


    function stringUncode($msg,$incode='GBK',$outcode='UTF-8'){
    	if(!$msg){
    		return '';
	    }
	    $msg = iconv($incode,$outcode,$msg);
	    return $msg;
    }


    public function checkParam($param = array(),$filed = array()){

        foreach ($filed as $v){
            if(!array_key_exists($v,$param) || strlen($param[$v]) <=0){
                $this->newException($v.'Ϊ');
            }
        }
    }


    public function getClientIp(){
        $ip = $_SERVER["REMOTE_ADDR"];
        if (!empty($_SERVER["HTTP_X_FORWARDED_FOR"])) {
            $tip = explode(",", $_SERVER["HTTP_X_FORWARDED_FOR"]);
            $ip = $tip[0];
        }
        return(trim($ip));
    }


    public function kefuTel(){

    }

}