<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');


/**
 * Guide Class 
 *
 * @package         zsb
 * @subpackage      Libraries
 * @category        Libraries
 * @author          esf Dev Team
 * @link		
 */
class Guide
{
    private $mc;
    private $db;
    private $dbback;
    private $guide_tbl;

    public function __construct()
    {
        $ci =& get_instance();
        $ci->load->library('My_memcached',null,'memcached');
        $this->mc = $ci->memcached;

        $this->db = $ci->load->database('db',TRUE);
        $this->dbback = $ci->load->database('dbback',TRUE);

        $this->set_guide_tbl('log_common_guide');
    }
    
    //ñ
    protected function set_guide_tbl($guide_tbl)
    {
        $this->guide_tbl = $guide_tbl;
    }
    
    //ǷҪ
    public function check_guide($uid, $guide)
    {
        $memkey = 'zsb_v4.0_guide_'.$uid.'_'.$guide;
        $nowtime = time();

        $uid = intval($uid);
        $guide = trim($guide);

        $check = FALSE;
        //$this->mc->delete($memkey);
        $cache = $this->mc->get($memkey);
        if($cache['isok'] != 1)
        {
            //ѯֶ
            $this->dbback->select('dateline');
            //ѯ
            $this->dbback->where("uid = '".$uid."' and guide = '".$guide."'");
            //ѯ
            $arr_data = $this->dbback->get($this->guide_tbl)->row_array();

            $dateline = isset($arr_data['dateline']) ? $arr_data['dateline'] : 0;

            if($dateline == 0)
            {
                $guide_id = $this->log_guide($uid, $guide, $nowtime);

                $dateline = $nowtime;

                $check = TRUE;
            }

            $this->mc->add($memkey, array('isok'=>1, 'data'=>$dateline), 86400);
        }

        return $check;
    }
    
    //¼־
    protected function log_guide($uid, $guide, $logtime)
    {
        $insert_data['uid'] = $uid;
        $insert_data['guide'] = $guide;
        $insert_data['dateline'] = $logtime;
        
        $this->db->insert($this->guide_tbl,$insert_data);
        $insert_id = $this->db->insert_id();

        return $insert_id;
    }
}
?>