<?php !defined('APP_DIR') ? die('acceess not defined') : '';
class image{
    static $pic_num = 0;
    
    static public function resize($file_path, $size_arr=array(40,80,100,200,400)){
        if (empty($size_arr)) {
        	$size_arr = tool::config('images.size');
        }
        $file_exp = explode('.',$file_path);
        $file_store = $file_exp[0];
        $file_postfix = $file_exp[count($file_exp)-1];
        
        $img_info = getimagesize($file_path);
        $img_type = $img_info['mime'];
        
        $img_width  = $img_info[0];
        $img_height = $img_info[1];
        
        switch ($img_type){
            case 'image/jpeg':
                $img_handle = imagecreatefromjpeg($file_path);
                break;
            case 'image/gif':
                $img_handle = imagecreatefromgif($file_path);
                break;
            case 'image/png':
                $img_handle = imagecreatefrompng($file_path);
                break;
            case 'image/wbmp':
                $img_handle = imagecreatefromwbmp($file_path);
                break;
            default:
                $img_handle = imagecreatefromjpeg($file_path);
                break;
        }
        
        foreach ($size_arr as $size){
            $store_name = "{$file_store}_{$size}.{$file_postfix}";
            if ( $img_width <= $size ) {
            	copy($file_path, $store_name);
            }
            $rate = $size/$img_width;
            
            $new_width  = $size;
            $new_height = $img_height*$rate;
            
            $img_new_handle = imagecreatetruecolor($new_width, $new_height);
            imagecopyresized($img_new_handle, $img_handle, 0, 0, 0, 0, $new_width, $new_height, $img_width, $img_height);
            
            switch ($img_rs_type){
                case 'image/jpeg':
                    imagejpeg($img_new_handle, $store_name);
                    break;
                case 'image/gif':
                    imagegif($img_new_handle, $store_name);
                    break;
                case 'image/png':
                    imagepng($img_new_handle, $store_name);
                    break;
                case 'image/wbmp':
                    imagewbmp($img_new_handle, $store_name);
                    break;
                default:
                    imagejpeg($img_new_handle, $store_name);
                    break;
            }
        }
    }
    
    static public function manage_product_pic( $file_path, $product_id = 0 ){
        $size_arr = get_config('image.product');
        $store_dir = '/images/product/'.date('Y-m-d').'/';
        $file_dir = ROOT . $store_dir;
        
        if(!is_dir($file_dir)){
            mkdir($file_dir, 0777);
        }
        
        self::$pic_num += 1;
        srand(time()+self::$pic_num);
        $file_front = time(). '_' .rand() . '_' . $product_id;
        
        $img_info = getimagesize($file_path);
        $img_type = $img_info['mime'];
        switch ($img_type){
            case 'image/jpeg':
                $file_new = $file_dir  . $file_front . '.jpg';
                $url      = $store_dir . $file_front . '.jpg';
                move_uploaded_file($file_path, $file_new);
                break;
            case 'image/gif':
                $file_new = $file_dir . $file_front . '.gif';
                $url      = $store_dir . $file_front . '.gif';
                move_uploaded_file($file_path, $file_new);
                break;
            case 'image/png':
                $file_new = $file_dir . $file_front . '.png';
                $url      = $store_dir . $file_front . '.png';
                move_uploaded_file($file_path, $file_new);
                break;
            case 'image/wbmp':
                $file_new = $file_dir . $file_front . '.bmp';
                $url      = $store_dir . $file_front . '.bmp';
                move_uploaded_file($file_path, $file_new);
                break;
            default:
                $file_new = $file_dir . $file_front . '.jpg';
                $url      = $store_dir . $file_front . '.jpg';
                move_uploaded_file($file_path, $file_new);
                break;
        }
        self::manage_pic_2($file_new, $file_dir, $size_arr, $file_front);
        return $url;
    }
    
    /**
     * ͼƬѹмλò
     *
     * @param string $file_path Դļ·
     * @param string $file_dir  Ĵ洢Ŀ¼
     * @param array  $size_arr  ļС
     */
    static public function manage_pic( $file_path, $file_dir, $size_arr, $file_front='' ){
        $file_front = $file_front == '' ? $file_front = time() : $file_front;
        
        $img_info = getimagesize($file_path);
        $img_rs_width  = $img_info[0];
        $img_rs_height = $img_info[1];
        $img_rs_type   = $img_info['mime'];
        
        switch ($img_rs_type){
            case 'image/jpeg':
                $img_rs_handle = imagecreatefromjpeg($file_path);
                break;
            case 'image/gif':
                $img_rs_handle = imagecreatefromgif($file_path);
                break;
            case 'image/png':
                $img_rs_handle = imagecreatefrompng($file_path);
                break;
            case 'image/wbmp':
                $img_rs_handle = imagecreatefromwbmp($file_path);
                break;
            default:
                $img_rs_handle = imagecreatefromjpeg($file_path);
                break;
        }
        
        foreach ($size_arr as $size_str){
            $size = explode('x',$size_str);
            $img_new_width  = $size[0];
            $img_new_height = $size[1];
            
            $rate_width  = $img_new_width  / $img_rs_width;
            $rate_height = $img_new_height / $img_rs_height;
            if ($rate_width > $rate_height) {
                $width  = $img_new_width  / $rate_width;
            	$height = $img_new_height / $rate_width;
            	$width_start  = 0;
            	$height_start = ($img_rs_height - $height) / 2;
            }else {
                $width  = $img_new_width  / $rate_height;
                $height = $img_new_height / $rate_height;
            	$width_start  = ($img_rs_width - $width) / 2;
            	$height_start = 0;
            }
            $img_new_handle = imagecreatetruecolor($img_new_width, $img_new_height);
            imagecopyresized($img_new_handle, $img_rs_handle, 0, 0, $width_start, $height_start, $img_new_width, $img_new_height, $width, $height);
            
            $file_store = $file_front . '_' . $size_str;
            switch ($img_rs_type){
                case 'image/jpeg':
                    $file_name = $file_dir . $file_store . '.jpg';
                    imagejpeg($img_new_handle, $file_name, 100);
                    break;
                case 'image/gif':
                    $file_name = $file_dir . $file_store . '.gif';
                    imagegif($img_new_handle, $file_name, 100);
                    break;
                case 'image/png':
                    $file_name = $file_dir . $file_store . '.png';
                    imagepng($img_new_handle, $file_name, 100);
                    break;
                case 'image/wbmp':
                    $file_name = $file_dir . $file_store . '.bmp';
                    imagewbmp($img_new_handle, $file_name, 100);
                    break;
                default:
                    $file_name = $file_dir . $file_store . '.jpg';
                    imagejpeg($img_new_handle, $file_name, 100);
                    break;
            }
        }
    }
    
    /**
     * ͼƬѹλò
     *
     * @param string $file_path Դļ·
     * @param string $file_dir  Ĵ洢Ŀ¼
     * @param array  $size_arr  ļС
     */
    static public function manage_pic_2( $file_path, $file_dir, $size_arr, $file_front='' ){
        $file_front = $file_front == '' ? $file_front = time() : $file_front;
        
        $img_info = getimagesize($file_path);
        $img_rs_width  = $img_info[0];
        $img_rs_height = $img_info[1];
        $img_rs_type   = $img_info['mime'];
        
        switch ($img_rs_type){
            case 'image/jpeg':
                $img_rs_handle = imagecreatefromjpeg($file_path);
                break;
            case 'image/gif':
                $img_rs_handle = imagecreatefromgif($file_path);
                break;
            case 'image/png':
                $img_rs_handle = imagecreatefrompng($file_path);
                break;
            case 'image/wbmp':
                $img_rs_handle = imagecreatefromwbmp($file_path);
                break;
            default:
                $img_rs_handle = imagecreatefromjpeg($file_path);
                break;
        }
        
        foreach ($size_arr as $size_str){
            $size = explode('x',$size_str);
            $img_new_width  = $size[0];
            $img_new_height = $size[1];
            
            $rate_width  = $img_new_width  / $img_rs_width;
            $rate_height = $img_new_height / $img_rs_height;
            if ($rate_width > $rate_height) {
                $width  = $img_rs_width * $rate_height;
                $height = $height;
            	$width_start  = ($img_new_width - $width) / 2;
            	$height_start = 0;
            }else {
                $width  = $img_new_width;
                $height = $img_rs_height * $rate_width;
            	$width_start  = 0;
            	$height_start = ($img_new_height - $height) / 2;
            }
            $img_new_handle = imagecreatetruecolor($img_new_width, $img_new_height);
            imagecopyresized($img_new_handle, $img_rs_handle, $width_start, $height_start, 0, 0, $width, $height, $img_rs_width, $img_rs_height);
            
            $file_store = $file_front . '_' . $size_str;
            switch ($img_rs_type){
                case 'image/jpeg':
                    $file_name = $file_dir . $file_store . '.jpg';
                    imagejpeg($img_new_handle, $file_name, 100);
                    break;
                case 'image/gif':
                    $file_name = $file_dir . $file_store . '.gif';
                    imagegif($img_new_handle, $file_name, 100);
                    break;
                case 'image/png':
                    $file_name = $file_dir . $file_store . '.png';
                    imagepng($img_new_handle, $file_name, 100);
                    break;
                case 'image/wbmp':
                    $file_name = $file_dir . $file_store . '.bmp';
                    imagewbmp($img_new_handle, $file_name, 100);
                    break;
                default:
                    $file_name = $file_dir . $file_store . '.jpg';
                    imagejpeg($img_new_handle, $file_name, 100);
                    break;
            }
        }
    }
}
?>