<?php
/**
 *  uri
 *
 * @author		xz
 * @version		1.0  addtime	2013-08-16
 * @copyright	www.house365.com
 */
include_once('rewrite.conf.php');
require_once('Mutex.php');

//ģʽ
if($test_model == 1)
{
    include_once('rewrite.conf.php');
}

class UriRewrite{
	
	 public $uri_string;        //ַ
	 public $dir;               //Դλ
	 public $dir_value;         //һԴλӦֵ
	 public $domain;            //
	 public $uri_params;        //ƵõURIڸƵbase.inc
	 public $uri;               //ǰURI
	 public $split_dir;         //Ŀ¼ָ
	 public $split_param;       //ָ
     public $split_mulit_param; //ѡָ
     public $analy_param;       //Ƿǰҳ
     public $test_domain;       //ģʽ
	

	/*캯ʼ
	* $unique_str	ȫΨһʶ
	* $analy_param  ǷǰҳURI
	* $split_dir    Ŀ¼ָ
	* $split_param  ָ
	*/
	public function UriRewrite($unique_str,$analy_param=true,$city='',$split_arr = array('split_dir'=>'/','split_param'=>'_','split_mulit_param'=>'|'))
	{	
		GLOBAL $conf_uri_params,$conf_city,$conf_test_domain;//ļȫURI
		
		//Ƶλ
		$this->set_dir($conf_uri_params[$unique_str]['dir']);
                   
         //Ƿǰҳ
		$this->set_analy_param($analy_param);
                
		//URI
		$this->set_uri_string();

		//ƵURL
		$this->set_uri_params($conf_uri_params[$unique_str]);
		
        //õ
        $this->set_test_domain($conf_test_domain);
		
		//Ƶ
		if(!$city) $city = $conf_city;

		$this->set_domain($conf_uri_params[$unique_str]['domain'],$city);
		
		//Ŀ¼ָ
		$this->set_split_dir($split_arr['split_dir']);

		//òָ
		$this->set_split_param($split_arr['split_param']);
                
        $this->set_split_mulit_param($split_arr['split_mulit_param']);

		//ʼǰURI
		$this->init_uri();
	}

    //õ
    public function set_test_domain($conf_test_domain)
    {
        $this->conf_test_domain = $conf_test_domain;
    }


	//Ƶλ
	public function set_dir($dir)
	{	
		$this->dir  = array();
		//DIRֵ
		for( $i = 0 ; $i < count($dir) ; $i++){
			$this->dir[$i]	= $dir[$i].'_';
		}
	}
        
        
	//ȡλ
	public function get_dir()
	{
		return $this->dir;
	}
	

	//Ƿǰҳ
	function set_analy_param($analy_param){ 
		$this->analy_param  = $analy_param;
	}

	//URIַuri_string
	public function set_uri_string ()
	{	
		if($this->analy_param) 
		{	
			$this->uri_string= preg_replace('#^/|.html(.*)|/$#','',$_SERVER['REQUEST_URI']);
		}else 
		{
			$this->uri_string	= '';
		}
	}

	
	//ȡURI
	public function get_uri_string()
	{
		return $this->uri_string;
	}

	
	//ƵURL
	public function set_uri_params($conf_uri_params)
	{	
		$this->uri_params = array();

		if(!empty($conf_uri_params))
		{
			$this->uri_params = array_merge($this->uri_params,$conf_uri_params);
		}
	}


	//ȡƵURLõ
	public function get_uri_params()
	{	
		return $this->uri_params;
	}


	//ȡƵURLõķת
	public function get_uri_params_asc($key='param')
	{	
        $uri_params = $this->get_uri_params();

		if(is_array($uri_params[$key])){
			$uri_params_asc =  array_flip($uri_params[$key]);
		}else{
			$uri_params_asc = array();
		}
		
		return $uri_params_asc;
	}

	
	//һԴλֵΪ
	public function set_dir_value($dir_value){
		
		$this->dir_value = intval($dir_value);
	}
	

	//Ŀ¼ָ
	public function set_split_dir($split)
	{
		$this->split_dir = trim(strip_tags($split));
	}


	//òָ
	public function set_split_param($split)
	{
		$this->split_param = trim(strip_tags($split));
	}
     
	
	//ѡָ
    public function  set_split_mulit_param($split)
        {
		$this->split_mulit_param = trim(strip_tags($split));
	}
	

	//ȡĿ¼ָ
	public function get_split_dir()
	{
		return $this->split_dir;
	}


	//ȡָ
	public function get_split_param()
	{
		return $this->split_param;
	}
        
        //ȡѡָ
	public function get_split_mulit_param()
	{
		return $this->split_mulit_param;
	}
	

	//Ƶ
	public function set_domain($domain,$city='hz')
	{
		if(in_array($domain,array('rent','sell')))
		{	
			$this->domain = 'http://'.$city.'.'.strip_tags(trim($domain)).'.house365.com';
		}
        else if(isset( $this->conf_test_domain))
        {
            $this->domain = 'http://sell.'.$city.'.house365.com';
        }
		else
		{
			$this->domain = 'http://'.$city.'.sell.house365.com';
		}
	}


	//Ƶ
	public function get_domain()
	{
		return $this->domain;
	}
	

	//ȡǰҳURI
	public function get_uri()
	{
		return $this->uri;
	}

	
	//keyvalue
	public function getValueByName($name)
	{	
		$uri = $this->uri;
		
		return $uri[strip_tags($name)];
	}


	/**
	 * ʵURI
	 *
	 * @return array
	**/
	private function init_uri()
	{	
		$arguments = array();
		
		if(empty($this->uri_string))
		{
			return $arguments;
		}
        
		/**ַָ
		 * /xq_1538/esf_a1-b2-c3.html
		 * => array('0'=>'xq_1538','1'=>'esf_a1-b2-c3')
		**/
		$direct	= explode($this->split_dir,$this->uri_string);
		
		//Ŀ¼-(1ֻһ/2ж/)
		$direct_level	= count($direct);	
		
		//ѭÿһĿ¼Ĳ
		for( $i = 0, $j = 0; $i < $direct_level ; $i++)
		{	
			/**ʹ÷ָ'_'붨λURI
			*	esf_a1-b2-c3
			*	=> array('0'=>'esf','1'=>'a1-b2-c3')
			**/
			$uri_child_arr	= explode($this->split_param,trim($direct[$i]));
			
			//ĵڶԪزΪգ˵һԪΪλ
			if( !empty($uri_child_arr['1']))
			{
				//URIλ¸ֵ($i+1)Ŀ¼ʶ
				//$this->dir[$i]	= $uri_child_arr['0'].'_';
				
				//URIַ
				$periods[$j]	= $uri_child_arr['1'];
                $j++;

				//һԪΪ֣Ϊһλֵ(йִУ̫)
				if($i == 0 && $this->is_num($uri_child_arr['1']))
				{	
					$this->dir_value = $uri_child_arr['1'];
				}
			}
		}
		
		$len_prams = count($periods);
		
		//Ŀ¼URIĸֵ
		for($i = 0 ; $i < $len_prams ; $i++)
		{
			$value	= trim($periods[$i]);

			//ǿղ
			if(!empty($value))
			{
				$arguments	= array_merge($this->get_Parameters($value),$arguments);
			}
            
		}	
		
		$this->uri	= $arguments;
	}


	/**
	 * ȡҳԭʼĲ顣
	 *
	 * @param none
	 * return array
	**/
	public function get_Parameters($str)
	{
		$arguments	= array();
		$periods	= explode('-',$str);
		
		//
		$periods_mum	= count($periods);

		if($periods_mum == 0)
		{
			return $arguments;
		}

		//ֵ
		foreach($periods as $k => $v) 
		{	
			//ؼ
			if( preg_match('#^kw(.+)#',$v,$matchs)) 
			{
				$arguments['keyword'] = trim($matchs['1']);
				
				continue;
			}

			//
			list($key,$value) = preg_split('#^([a-z]{1,2})#',$v,-1,PREG_SPLIT_NO_EMPTY | PREG_SPLIT_DELIM_CAPTURE);
			
			//Ƿ
			if(!isset($this->uri_params['params'][$key]))
			{
				continue;
			}
                        
			//ѧɫѡ⴦
			if($this->uri_params['params'][$key] == 'features')
			{  
			   $value = explode($this->split_mulit_param,urldecode($value));
			}

			$arguments[$this->uri_params['params'][$key]] = $value;
		}
		
		//ҳ
		if( isset($arguments['page']) && $arguments['page'] <=1 )
		{
			unset($arguments['page']);
		}

		return $arguments;
	}

	/**
	* α̬ӵַ(ṩɰ汾ת°汾URLʹ)
	*
	* @param $param2 Լֵʽṩ
	* @param int ֵ
	* @return string
	*/
	public function getUrlByParam($param2,$value2=0)
	{	
		
		if(is_array($param2))
		{
			$arguments = $param2;
		}
		else 
		{
			$arguments = array($param2 => $value2);
		}

		$url = $this->get_url('','',$arguments,'');

		return $url;
	}
	

	/**
	* α̬ӵַ(ʺtabҳлĲ)
	*
	* @param mixed (Ϊ飬value踳ֵ)
	* @param int ֵ
	* @return string
	*/
	public function get_tab_url($param='',$value=0,$analy_param=false)
	{
		//ǰƵ
		$domain	= $this->get_domain();
		$uri_params = $this->get_uri_params();

		$arguments = array();
		//
		if(!empty($param)) 
		{
			if(is_array($param))
			{
				$arguments = $param;
			}
			else 
			{
				$arguments = array($param => $value);
			}
		}
                
		$url = $this->get_url($arguments,'','','',$analy_param);

		return $url;
	}
	

	/**
	* α̬ӵַ
	*
	* @param mixed (Ϊ飬value踳ֵ)
	* @param int ֵ(paramΪʱֵ)
	* @param mixed (Ϊ飬value踳ֵ)
	* @param int ֵ(param2Ϊʱֵ)
        * @parmam boolean $analy_param ǷǰҳĲ 
	* @return string
	*/
	public function get_url($param='',$value=0,$param2='',$value2=0,$analy_param='')
	{	
		//ǰƵ
		$domain	= $this->get_domain();
		$uri_params = $this->get_uri_params();
		
		//ǰҳURI
		$arguments = array();
		
		if( !is_array( $uri_params) || empty($uri_params) )
		{
			return $domain;
		}
		
		//ǷҪҳʺҳTABҳƲ
                $analy_param = $analy_param === '' ? $this->analy_param : $analy_param;
		if($analy_param)
                    $arguments = $this->get_uri();
		
		//ƴӲURI
		if( is_array($param) )
		{	
			//ύҳ
			if( !array_key_exists('page',$param) ) unset($arguments['page']);

			if(is_array($arguments) && !empty($arguments))
			{
				$temp	= array_merge($arguments,$param);
			}
			else
			{
				$temp	= $param;
			}
		}
		else if( !empty($arguments[$param]) ) 
		{
			if(!$value) 
			{	
				unset( $arguments[$param] );
				$temp	= array();
			} 
			else 
			{	
                //ύҳ
				if($param != 'page') unset($arguments['page']);
				$temp	= array( $param => $value );
			}
		}
		else 
		{       
            //ύҳ
			if($param != 'page') unset($arguments['page']);
			$temp	= array( $param => $value );
		}
		
        
		if(is_array($arguments))
		{
			$arguments = array_merge($arguments,$temp);
		}
		else
		{	
			$arguments = $temp;
		}
		

		//ƴ
		if(!empty($param2)) 
		{
			if(is_array($param2))
			{       
                if( !array_key_exists('page',$param2)) unset($arguments['page']);
				$arguments = array_merge($arguments,$param2);
			}
			else 
			{
				$arguments = array_merge($arguments,array($param2 => $value2));
			}
		}

		if(is_array($arguments) && !empty($arguments))
		{
			//˺˵ЧĲųĲ
			$arguments	= $this->uri_filter($arguments);

            //ѭ飬ƴװһĿ¼URIַ
			if(is_array($uri_params['dir_params']) && !empty($uri_params['dir_params']) )
			{
				foreach($uri_params['dir_params'] as $k => $v) 
				{
					if(!empty($arguments[$v])) 
					{	
						$arguments[$k] = strip_tags(trim($arguments[$v]));
						//ѭƴװURI
						$dir_child	.= $k.$arguments[$k].'-';

						unset($arguments[$v]);
					}
				}
			}
            
			//ѭ飬˳Ѳŵ
			foreach($uri_params['params'] as $k => $v) {

				if(!empty($arguments[$v])) 
				{	
					//ƵؼֵĬֵͬδ
					if( $v == 'keyword' && ($arguments['keyword'] == '' ) ) 
					{
						unset($arguments[$v]);
						continue;
					} 
					else 
					{
						if( $v == 'keyword') 
						{
							$arguments[$k] = strip_tags(trim($arguments[$v]));
						}else if( is_array($arguments[$v]) &&!empty($arguments[$v]) ) {       
							$arguments[$v] = urlencode(implode($this->split_mulit_param, $arguments[$v]));
							$arguments[$k] = strip_tags(trim($arguments[$v]));
						}else if(!empty($arguments[$v])) {
							$arguments[$k] = strip_tags(trim($arguments[$v]));
						}
						
						if( $v == 'page' && isset($arguments[$k]) && $arguments[$k] <= 1)
						{
							unset($arguments[$v]);
							continue;
						}
						
						//ѭƴװURI
						$uri_child	.= $k.$arguments[$k].'-';
					}
				}
			}
		}

        //Ŀ¼
		$dir	= !empty($dir_child) ? substr($dir_child,0,-1) : '';
		
		//URI
		$uri	= !empty($uri_child) ? substr($uri_child,0,-1).'.html' : '';

		$dir_level	= count($this->get_dir());

		$init_url = $uri_params['default_url'];

		for($i = 0 ;$i < $dir_level ; $i++ )
		{
			//һĿ¼ֵΪ
			if($i == 0 && $dir_level == 2)
			{
				if( $dir != '')
				{
					$uri_sub .= '/'.$this->dir["$i"] . $dir;
				}
				else if( $this->dir_value != '')
				{
					$uri_sub .= '/'.$this->dir["$i"] . $this->dir_value;
				}
				else
				{
					$init_dir = $uri_params['default_dir_url'];

					if($init_dir != '')
					{
						$uri_sub .= '/'.$init_dir;
					}
				}
			}
            else
            {
				if($uri	!='')
				{
					$uri_sub .= '/'.$this->dir["$i"];
				}
				else
				{	
					$init_url = $uri_params['default_url'];

					if($init_url !='')
					{
						$uri_sub .= '/'.$init_url;
					}else
					{
						$uri_sub .= '/';
					}
				}
			}
		}
    
		//ƴURL
		$url	= !empty($uri) ? $domain.$uri_sub.$uri : $domain.$uri_sub;

		return $url;
	}
	
	
	//
	public function uri_filter(&$arguments){

		//ݶλ˲
		$dir = $this->get_dir();
		
		if( in_array('asklist_' , $dir ) ){
			//ؼͻ
			if( !empty($arguments['keyword']) )
			{
				unset($arguments['type']);
			}
			else if( !empty($arguments['type']) )
			{
				unset($arguments['keyword']);
			}

			$arguments['is_best'] = !empty($arguments['is_best']) ? $arguments['is_best'] : 1;
		}
		else if (in_array('xl_',$dir ))
		{
			//ûֵ
			if( !isset($arguments['district']) )
			{	
				unset($arguments['streetid']);
			}
        }else if(in_array('community_',$dir )){
			if($arguments['price'] != 99) {
				unset($arguments['price1']);
				unset($arguments['price2']);
			}

			if($arguments['buildarea'] != 99) {
				unset($arguments['buildarea1']);
				unset($arguments['buildarea2']);
			}

			if($arguments['roomtype'] != 99) {
				unset($arguments['room']);
				unset($arguments['toilet']);
				unset($arguments['hall']);
			}
		}else if(in_array('xq_',$dir )){
			if($arguments['price'] != 99) {
				unset($arguments['price1']);
				unset($arguments['price2']);
			}

			if($arguments['buildarea'] != 99) {
				unset($arguments['buildarea1']);
				unset($arguments['buildarea2']);
			}

			if($arguments['roomtype'] != 99) {
				unset($arguments['room']);
				unset($arguments['toilet']);
				unset($arguments['hall']);
			}
		} else if( in_array('dl_',$dir) && strpos($this->domain,'rent.house365.com')!==false) {
			if($arguments['price'] != 99) 
			{
				unset($arguments['price1']);
				unset($arguments['price2']);
			}
			if($arguments['infofrom'] == 1) {
				unset($arguments['istag']);
			}
		}
		else if(  in_array('dl_',$dir ) || in_array('wl_',$dir ) || in_array('sl_',$dir )|| in_array('brt_',$dir ) )
		{	
			if($arguments['roomtype'] != 99) 
			{
				unset($arguments['room']);
				unset($arguments['hall']);
				unset($arguments['toilet']);
				unset($arguments['kitchen']);
			}

			if($arguments['price_sell'] != 99) 
			{
				unset($arguments['price1']);
                unset($arguments['price_price1']);
				unset($arguments['price2']);
                unset($arguments['price_price2']);
			}

			if($arguments['buildarea'] != 99) 
			{
				unset($arguments['buildarea1']);
                unset($arguments['buildarea_buildarea1']);
				unset($arguments['buildarea2']);
                unset($arguments['buildarea_buildarea2']);
			}
		
		}
		$this->handleMutex($arguments); 
		return $arguments;
	}

	/**
	 * ֵ
	 *
	 * @param string
	 * @return mixed
	 */
	private function is_num($value)
	{
		if(preg_match("#^[0-9]+$#",$value)) {
			return $value;
		} else {
			return '';
		}
	}

    private function handleMutex(&$arguments) {
        if($this->mutexs) {
            foreach($this->mutexs as $v) {
                $v->handle($arguments);
            }
        }
    }

    public function setMutex($mutex) {
        $k = $mutex->getKey();
        if(!($this->mutexs&&array_key_exists($k,$this->mutexs))) {
            $this->mutexs[] = $mutex;
        }
    }

}