<?php
/**
 * ¼
 *
 * @author sun
 */
class PaymentHousebeanRecord {
    
    /**
     * ݿ 
     * @var TINY_ADODB 
     */    
    private $db;
    
    /**
     * ݿ
     * @var type 
     */
    private $dbback;
    
    /**
     * 
     * @var type 
     */
    private $mc;

    /**
     * ı 
     * @var String 
     */
    private $table;
    
    /**
     * 캯ʼdb memcache ȡ
     * @param string $table ʹĬֵ
     */
    public function __construct() {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->table = $this->getTableName();
        $this->mc = $container->get('mc');
        $sqlfield = "DESC $this->table";
        $fieldsMKey = $sqlfield;
        $this->fields = $this->mc->get($fieldsMKey);
        if($this->fields === false) {
            $fields = $this->dbback->getAll($sqlfield);
            foreach ($fields as $field) {
                $this->fields[] = $field['Field'];
            }
            $this->mc->set($fieldsMKey, $this->fields, 3600);
        }
    }
    
    /**
     * ѯ䷶Χ
     * @param int $start ʼֵ
     * @param int $limit ÿҳʾ
     * @return string
     */
    private function getLimitCond($start, $limit) {
        $start = $start > 0 ? $start : 0;
        $limit_cond = ($start == 0 && $limit == 0) ? '' : ' LIMIT '
                      . $start . ' , ' . $limit;
        return $limit_cond;
    }
    
    /**
     * ֶ֤ǷϷ
     * @param type $field
     * @return type
     */
    private function validateFiled($field) {
        return in_array($field, $this->fields);
    }
    
    /**
     * 
     * @param string $orderField ֶ
     * @param string $order 
     * @return string
     */
    private function getOrder($orderField, $order = 'ASC') {
        $strOrder = '';
        if ($this->validateFiled($orderField)) {
            $strOrder = "ORDER BY $orderField $order";
        }
        return $strOrder;
    }
    
    private function getTableName() {
        $tbl = 'payment_housebean_record';
        return $tbl;
    }
    
    /**
     * ȡ
     */
    private function getOpertorTypeWhere($opertorType) {
        return $opertorType == 'expend' ? ' num < 0' : ' num > 0';
    }
    
    /**
     * þ˵ǰֵ顣
     * @return array  
     */
    public function getBrokerCredit($brokerId) {
        $credit = new GrowthCredit();
        return $credit->getValidCredit($brokerId);
    }
    
    /**
     * 뷿¼
     * @param int $brokerId ˱
     * @param string $transactionId ׺
     * @param string $wayAlias 
     * @param int $source Դ
     * @param int $num 
     * @param string $description ˵
     * @param int $discard Ƿ10״̬
     * @return int
     */
    public function insert($brokerId, $transactionId, $wayAlias, $source, 
            $num, $description, $ishidden, $discard = 0) {
        global $functionSwitch,$housebeanExpirationTimeType;
        $fieldsValue = array();
        $credit = $this->getBrokerCredit($brokerId);
        $fieldsValue['broker_id'] = $brokerId;
        $fieldsValue['transaction_id'] = $transactionId;
        $fieldsValue['way_alias'] = $wayAlias;
        $fieldsValue['source'] = $source;
        $fieldsValue['num'] = $num;
        $fieldsValue['remain_num'] = $credit;
        $fieldsValue['description'] = $description;
        $fieldsValue['ishidden'] = $ishidden;
        $fieldsValue['status'] = 0;
        $fieldsValue['ip'] = GetIp();
        $fieldsValue['discard'] = $discard;
        $fieldsValue['ctime'] = date('Y-m-d H:i:s');
		$fieldsValue['createtime'] = time();


        //ȷȨ
        //$functionSwitch = config_item('functionSwitch');

        //$housebeanExpirationTimeType = config_item('housebeanExpirationTimeType');
        if($num > 0 && !empty($functionSwitch['priorityHousebeanConsume']) && !empty($housebeanExpirationTimeType) && in_array($wayAlias,array('recharge','AgencyAllo')))
        {

            $endtime = 0;
            if($wayAlias == 'recharge' && !empty($housebeanExpirationTimeType['paymentExpireTime']))
            {
                $endtime = $housebeanExpirationTimeType['paymentExpireTime'];
            }
            elseif(!empty($housebeanExpirationTimeType['otherExpireTime']))
            {
                $endtime = $housebeanExpirationTimeType['otherExpireTime'];
            }

            $fieldsValue['endtime'] = $endtime;
            $fieldsValue['total'] = $num;
        }

        $sql = SqlCombinHelper::insert_sql($this->table, $fieldsValue);

        return $this->db->execute($sql);
    }
    
    /**
     * ȡб
     * @param int $brokerId ˱
     * @param date $starttime ʼʱ
     * @param date $endtime ʱ
     * @param string $opertorType  
     * @param int $source Դ
     * @param string $wayAlias 
     * @param int $start ʼ
     * @param int $pagesize ÿҳ
     * @param string $order 
     * @return array
     */
    public function getListBy($brokerId, $starttime, $endtime, $opertorType = null, 
            $source = null, $wayAlias = null, $start = null, $pagesize = null, 
            $order = null) {
        $where = '';
        $where .= "broker_id = $brokerId AND ctime >= "
                . "'{$starttime}' " . " AND ctime <= '{$endtime}' AND ishidden = 1";
        //ȡget  pay
        if ($opertorType != null) 
		{
            $where .= ' AND' . $this->getOpertorTypeWhere($opertorType);
        }

        //Դ 1 PC 2 APP
        if ($source != null && $source != '0') 
		{
            $where .= ' AND source = ' . $source;
        }

        //
        if ($wayAlias != null && $wayAlias != '0' ) 
		{
            if (is_array($wayAlias))
            {
                $where .= " AND way_alias in ('".  implode("','", $wayAlias)."')";
            }
            else
            {
                $where .= ' AND way_alias = ' . "'$wayAlias'";
            }
        }

        if($start !== null && $pagesize !== null) 
		{
            $limit = $this->getLimitCond($start, $pagesize);
        } 
		else 
		{
            $limit = '';
        }

		if($order !== null)
		{
		    $order = $this->getOrder('ctime', $order);
        } 
		else 
		{
            $order = $this->getOrder('id', 'desc');
        }

        $where .=  ' ' . $order . ' ' . $limit;
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, $where);
        return $this->dbback->getAll($sql);
    }


	/**
     * ȡ¼׼¼
     * @param int $brokerId ˱
     * @param array wayAlias ˱
     * @param int $limit 
     * @return array
     */
    public function getNewByWayAlias($brokerId,$wayAlias = null, $limit = 6) {      
        $where = '';
        $where .= "broker_id = $brokerId and ishidden = 1 ";
          //
        if ($wayAlias != null && $wayAlias != '0' ) {
            if (is_array($wayAlias))
            {
                $where .= " and way_alias in ('".  implode("','", $wayAlias)."')";
            }
            else
            {
                $where .= ' and way_alias = ' . "'$wayAlias'";
            }
        }
        $limit = $this->getLimitCond(0, $limit);
        $where .= " order by id desc {$limit}";
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, $where);		
        return $this->dbback->getAll($sql);
    }
    
    
    /**
     * ȡ¼׼¼
     * @param int $brokerId ˱
     * @param int $limit 
     * @return array
     */
    public function getNewBy($brokerId, $limit = 6) {
        $where = '';
        $limit = $this->getLimitCond(0, $limit);
        $where .= "broker_id = $brokerId and ishidden = 1 order by id desc {$limit}";
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, $where);
        return $this->dbback->getAll($sql);
    }
    
    /**
     * ȡ
     * @param int $brokerId ˱
     * @param date $starttime ʼʱ
     * @param date $endtime ʱ
     * @param string $opertorType  
     * @param int $source Դ
     * @param string or array $wayAlias 
     * @return array
     */
    public function getCountBy($brokerId, $starttime, $endtime, 
            $opertorType = null, $source = null, $wayAlias = null) {

		$starttime = strtotime($starttime);
		$endtime = strtotime($endtime);

        $where = '';
        $where .= "broker_id = $brokerId  and ishidden = 1 and createtime >= "
                . "'$starttime' and createtime <= '$endtime'";
        //ȡget  pay
        if ($opertorType != null) {
            $where .= ' and' . $this->getOpertorTypeWhere($opertorType);
        }
        //Դ 1 PC 2 APP
        if ($source != null && $source != '0') {
            $where .= ' and source = ' . $source;
        }
        //
        if ($wayAlias != null && $wayAlias != '0') {
            if (is_array($wayAlias))
            {
                $where .= " and way_alias in ('".  implode("','", $wayAlias)."')";
            }
            else
            {
                $where .= ' and way_alias = ' . "'$wayAlias'";
            }
        }
        $sql = SqlCombinHelper::count_sql($this->table, $where);

        return $this->dbback->getOne($sql);
    }
    
    /**
     * ȡĺͻȡ
     * @param int $brokerId ˱
     * @param date $starttime ʼʱ
     * @param date $endtime ʱ
     * @param string $opertorType  
     * @param int $source Դ
     * @param string or array $wayAlias 
     * @return array
     */
    public function getSumBy($brokerId, $starttime, $endtime, 
            $opertorType = null, $source = null, $wayAlias = null) {
         $where = '';
        $where .= "broker_id = $brokerId  and ishidden = 1 and ctime >= "
                . "'$starttime' and ctime <= '$endtime'";
        //ȡget  pay
        /**
        if ($opertorType != null) {
            $where .= ' and' . $this->getOpertorTypeWhere($opertorType);
        }***/
        //Դ 1 PC 2 APP
        if ($source != null && $source != '0') {
            $where .= ' and source = ' . $source;
        }
        //
        if ($wayAlias != null && $wayAlias != '0') {
            if (is_array($wayAlias))
            {
                $where .= " and way_alias in ('".  implode("','", $wayAlias)."')";
            }
            else
            {
                $where .= ' and way_alias = ' . "'$wayAlias'";
            }
        }
        $sql = SqlCombinHelper::sum_sql($this->table, 'num', $where);
		//echo $sql;
        return $this->dbback->getOne($sql);
    }
}
