<?php
/**
 * ¼
 *
 * @author sun
 */
class PayHousebeanRecord {
    
    /**
     * ݿ 
     * @var TINY_ADODB 
     */    
    private $db;
    
    /**
     * ݿ
     * @var type 
     */
    private $dbback;
    
    /**
     * 
     * @var type 
     */
    private $mc;

    /**
     * ı 
     * @var String 
     */
    private $table;
    
    /**
     * 캯ʼdb memcache ȡ
     * @param string $table ʹĬֵ
     */
    public function __construct() {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->table = $this->getTableName();
        $this->mc = $container->get('mc');
        $sqlfield = "DESC $this->table";
        $fieldsMKey = $sqlfield;
        $this->fields = $this->mc->get($fieldsMKey);
        if($this->fields === false) {
            $fields = $this->dbback->getAll($sqlfield);
            foreach ($fields as $field) {
                $this->fields[] = $field['Field'];
            }
            $this->mc->set($fieldsMKey, $this->fields, 3600);
        }
    }
    
    /**
     * ѯ䷶Χ
     * @param int $start ʼֵ
     * @param int $limit ÿҳʾ
     * @return string
     */
    private function getLimitCond($start, $limit) {
        $start = $start > 0 ? $start : 0;
        $limit_cond = ($start == 0 && $limit == 0) ? '' : ' LIMIT '
                      . $start . ' , ' . $limit;
        return $limit_cond;
    }
    
    /**
     * ֶ֤ǷϷ
     * @param type $field
     * @return type
     */
    private function validateFiled($field) {
        return in_array($field, $this->fields);
    }
    
    /**
     * 
     * @param string $orderField ֶ
     * @param string $order 
     * @return string
     */
    private function getOrder($orderField, $order = 'ASC') {
        $strOrder = '';
        if ($this->validateFiled($orderField)) {
            $strOrder = "ORDER BY $orderField $order";
        }
        return $strOrder;
    }
    
    private function getTableName() {
        $tbl = 'pay_housebean_record';
        return $tbl . '_' . date('m');
    }
    
    /**
     * ȡ
     */
    private function getOpertorTypeWhere($opertorType) {
        return $opertorType == 'pay' ? ' num < 0' : 'num > 0';
    }
    
    /**
     * þ˵ǰֵ顣
     * @return array  
     */
    public function getBrokerCredit($brokerId) {
        $credit = new GrowthCredit();
        return $credit->getValidCredit($brokerId);
    }
    
    /**
     * 뷿¼
     * @param int $brokerId ˱
     * @param string $orderId 
     * @param string $wayAlias 
     * @param int $source Դ
     * @param int $num 
     * @param string $description ˵
     * @param int $discard Ƿ10״̬
     * @return int
     */
    public function insert($brokerId, $orderId, $wayAlias, $source, 
            $num, $description, $ishidden, $discard = 0) {
        $fieldsValue = array();
        $credit = $this->getBrokerCredit($brokerId);
        $fieldsValue['broker_id'] = $brokerId;
        $fieldsValue['orderid'] = $orderId;
        $fieldsValue['way_alias'] = $wayAlias;
        $fieldsValue['source'] = $source;
        $fieldsValue['num'] = $num;
        $fieldsValue['remain_num'] = $credit;
        $fieldsValue['description'] = $description;
        $fieldsValue['ishidden'] = $ishidden;
        $fieldsValue['status'] = 0;
        $fieldsValue['ip'] = GetIp();
        $fieldsValue['discard'] = $discard;
        $fieldsValue['ctime'] = date('Y-m-d H:i:s');
        $sql = SqlCombinHelper::insert_sql($this->table, $fieldsValue);
        return $this->db->execute($sql);
    }
    
    /**
     * ȡб
     * @param int $brokerId ˱
     * @param date $starttime ʼʱ
     * @param date $endtime ʱ
     * @param string $opertorType  
     * @param int $source Դ
     * @param string $wayAlias 
     * @param int $start ʼ
     * @param int $pagesize ÿҳ
     * @param string $order 
     * @return array
     */
    public function getListBy($brokerId, $starttime, $endtime, $opertorType = null, 
            $source = null, $wayAlias = null, $start = null, $pagesize = null, 
            $order = null) {
        $where = '';
        $where .= "broker_id = $brokerId and ctime >= $starttime and ctime <= $endtime";
        //ȡget  pay
        if ($opertorType != null) {
            $where .= ' and' . $this->getOpertorTypeWhere($opertorType);
        }
        //Դ 1 PC 2 APP
        if ($source != null) {
            $where .= ' and source = ' . $source;
        }
        //
        if ($wayAlias != null) {
            $where .= ' and way_alias = ' . "'$wayAlias'";
        }
        if($start !== null && $pagesize !== null) {
            $limit = $this->getLimitCond($start, $pagesize);
        } else {
            $limit = '';
        }
		if($order !== null){
		    $order = $this->getOrder('ctime', $order);
        } else {
            $order = '';
        }
        $where .= $limit . ' ' . $order;
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, $where);
        return $this->dbback->getAll($sql);
    }
    
    /**
     * ȡ
     * @param int $brokerId ˱
     * @param date $starttime ʼʱ
     * @param date $endtime ʱ
     * @param string $opertorType  
     * @param int $source Դ
     * @param string $wayAlias 
     * @return array
     */
    public function getCountBy($brokerId, $starttime, $endtime, 
            $opertorType = null, $source = null, $wayAlias = null) {
        $where = '';
        $where .= "broker_id = $brokerId and ctime >= $starttime and ctime <= $endtime";
        //ȡget  pay
        if ($opertorType != null) {
            $where .= ' and' . $this->getOpertorTypeWhere($opertorType);
        }
        //Դ 1 PC 2 APP
        if ($source != null) {
            $where .= ' and source = ' . $source;
        }
        //
        if ($wayAlias != null) {
            $where .= ' and way_alias = ' . "'$wayAlias'";
        }
        $sql = SqlCombinHelper::count_sql($this->table, $where);
        return $this->dbback->getOne($sql);
    }
}
