<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * ZSB
 *
 * MODEL
 *
 * @package         ZSB
 * @author          ESF Dev Team
 * @copyright       Copyright (c) 2006 - 2014, HOUSE365, Inc.
 * @link            http://nj.sell.house.com
 * @since           Version 1.0
 */

// ------------------------------------------------------------------------

/**
 * 
 *
 * ļ
 *
 * @package         zsb
 * @subpackage      Models
 * @category        Models
 * @author          fisher
 */

load_m("Broker_base_model");

class Broker_test_model extends Broker_base_model {
    
    /**
    * KEY
    *
    * @access private
    * @var string
    */
    private $_mem_key = 'broker_model';

	/**
    * ûsessionϢ
    *
    * @access private
    * @var array
    */
    public $user_session = array();
    
    /**
    * Constructor
    */
    public function __construct() 
    {
        parent::__construct();
        
		$this->user_session = $this->load->get_var('user_session');
		if(!$this->user_session || $this->user_session['uid'] <= 0){
			//ȡSESSIONݲΪԸֵ
			$this->user_session = $this->get_user_session();
			$this->load->vars(array('user_session'=>$this->user_session));
		}

        $this->set_uid($this->user_session['uid']);
    }
    
    
    /**
     * 龭˵½
     *
     * @access	public
     * @param	string  $username ˺
     * @param	string  $password 
     * @return	array   ˻Ϣ
     */
    public function login($username, $password, $needencrypt = TRUE)
    {   
        $password = $needencrypt ? $this->encrypt_broker_pwd($password) : $password;
        //ѯֶ
        $this->dbback->select("uid");
        //ѯ
        $this->dbback->where("username = '".$username."' and password = '".$password."'");
        //ѯ
        $arr_data = $this->dbback->get('broker')->row_array();
        
        return isset($arr_data['uid']) ? intval($arr_data['uid']) : 0;
    }
    
    
    /**
     * 龭Ƿ
     *
     * @access	public
     * @param	string  $username ˺
     * @param	string  $password 
     * @return	array   ˻Ϣ
     */
    public function check_online()
    {   
        $u_session = $this->get_user_session();
        
        //ûSESSIONֵUID0
        return isset($u_session['uid']) && intval($u_session['uid']) > 0 ? TRUE : FALSE;
    }


	//õڶmemcache xue add 2015-01-14
	private function set_memcache_session($data){
		$key = $this->getSessionId();
		$this->mc->set($key ,$data, 86400);
	}

	//ȡڶmemcache xue add 2015-01-14
	public function get_memcache_session(){
		$key = $this->getSessionId();
		$cache = $this->mc->get($key);
		return $cache;
	}

	//ȡsessionId   xue add 2015-01-14
	private function getSessionId(){
		return $this->session->userdata("session_id");
	}

	//ɾڶmemcache
	private function deleteSession(){
		$key = $this->getSessionId();
		$this->mc->delete($key);
	}
    
    
    /**
     * ûSESSION
     *
     * @access	public
     * @param	array  $session_data û
     * @return	void
     */
    public function set_user_session($session_data = array())
    {   
        $app_key = $this->get_appkey();
        
        //ûSESSIONݴApp key
        $this->session->set_userdata(array($app_key => $session_data));
		//ڶsession		
		$this->set_memcache_session($session_data);

        /*
		//½¼cookie
		$cookie = array(
               'name'   => 'zsb_login_test',
               'value'  => 1,
               'expire' => 1800,    // Ч            
        );
        $this->input->set_cookie($cookie);*/

    }

    /**
     * ûSESSION
     *
     * @access	public
     * @return	void
     */
    public function reset_user_session()
    {   
        $app_key = $this->get_appkey();

        $session_data = $this->get_user_session();

        //ûSESSIONݴApp key
        $this->session->set_userdata(array($app_key => $session_data));
    }
    
    
    /**
     * ûSESSION
     *
     * @access	public
     * @param	void
     * @return	void
     */
    public function logout()
    {   
        $app_key = $this->get_appkey();

        //SESSION
        $this->session->unset_userdata($app_key);
		//ڶ
		$this->deleteSession();

        //
        $cookie = array(
               'name'   => 'broker_id',
               'value'  => 0,
               'expire' => 1800,    // һЧ            
        );
        $this->input->set_cookie($cookie);
    }
    
    
    /**
     * ûSESSION
     *
     * @access	public
     * @return	array   ûSESSION
     */
    public function get_user_session()
    {   
		//֮ǰѾȡݣԼ
		if($this->user_session['uid'] > 0){
			return $this->user_session;
		}

        $app_key = $this->get_appkey();
		$userdata = $this->session->userdata($app_key);



		if($userdata['uid'] <= 0){
			//ӱûȡ
			$user_arr = $this->get_memcache_session();

			//ٴΰsessionmemcache
			//ûSESSIONݴApp key
			$this->session->set_userdata(array($app_key => $user_arr));

            //ûSESSIONݴȫֱ
			$this->load->vars(array('user_session'=>$user_arr));
			$this->user_session = $user_arr;
		 

		   /*
			$num = $this->mc->get('getLostNum_memcache_057');
			$this->mc->set('getLostNum_memcache_057',$num+1,86400);

			if($user_arr['uid']<=0){
				$num2 = $this->mc->get('getLostNum_memcache_type2_098');
				$this->mc->set('getLostNum_memcache_type2_098',$num2+1,86400);
			}


			if($this->input->cookie("zsb_login_test") == 1 ){

				$num3 = $this->mc->get('getLostNum_memcache_8989');
				$this->mc->set('getLostNum_memcache_8989',$num3+1,86400);

				if($user_arr['uid']<=0){
					$num5 = $this->mc->get('getLostNum_memcache_type2_05656');
					$this->mc->set('getLostNum_memcache_type2_05656',$num5+1,86400);
				}
			
			}*/
	
		
		}else{
			$user_arr = $userdata;
		}

		return $user_arr;
    }
    
    
    /**
     * ȡAPP KEY
     *
     * @access	public
     * @return	string   APPKEY
     */
    public function get_appkey()
    {
        return USER_SESSION_KEY;
    }
    
    
    /**
     * ȡ
     *
     * @access	public
     * @return	string   
     */
    public function get_broker_district()
    {   
        $user_info = $this->get_user_session();
        $arr_data = array();
        
        //ѹҿŵľ
        if('A2467' != $user_info['agentcode'] && '' != $user_info['agentcode'])
        {
            //ѯֶ
            $this->dbback->select('dist');
            //ѯ
            $this->dbback->where("agentcode = '".$user_info['agentcode']."'");
            //ѯ
            $arr_data = $this->dbback->get('agency')->row_array();
        }
        
        //ŵδ趨δ
        if(empty($arr_data) OR 'A2467' == $user_info['agentcode'] OR '' == $user_info['agentcode'])
        {
            //ѯֶ
            $this->dbback->select('dist');
            //ѯ
            $this->dbback->where("uid = '".$user_info['uid']."'");
            //ѯ
            $arr_data = $this->dbback->get('broker')->row_array();
        }
        
        return $arr_data['dist'];
    }
    
    
    /**
     * 龭˵½
     * @access	public
     * @param	array   $data ־
     * @param	string  $tbl ־
     * @return	array   ˻Ϣ
     */
    public function get_broker_company()
    {   
        $user_arr = $this->get_user_session();
        
        $arr_data = array();
        
        if( '' != $user_arr['agentcode'])
        {   
            $this->load->model('agency_model');
            $select_field = array("agentshortname");
            $this->agency_model->set_select_fields($select_field);
            $arr_data = $this->agency_model->get_company_info_by_code($user_arr['agentcode']);
        }
        
        return $arr_data;
    }
    

    
    /**
     * ȡ˿ͻ
     * @param string $master ͻʺ
     * @return string
     */
    public function get_account_manager($master)
    {
        $mem_key = $this->_mem_key.'_get_account_manager_'.$master;
        //$this->mc->delete($mem_key);
        $cache = $this->mc->get($mem_key);
        
        if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
        {
            $arr_data = $cache['data'];
        }
        else
        {
            //ѯֶ
            $this->db->select("truename,telno");
            //ѯ
            $this->db->where("authname = '".$master."'");
            //print_r($this->dbback);
            //ѯ
            $arr_data = $this->db->get('home_auth')->row_array();
            $this->mc->add($mem_key , array('is_ok'=>1 , 'data'=>$arr_data) ,  86400);
        }
        
        return $arr_data;
    }
    
    
    /*
     * 
     * @access public 
     * @param string $telno 绰
     * @return int 
     */
    public function get_findpwd_count($telno)
    {
        $count_num = 0;
        
        $daytime = strtotime(date('Y-m-d'));
        $cond_where = "mobile = '".$telno."' AND tbl='broker' AND dateline > $daytime ";
        $this->dbback->where($cond_where);
        $count_num = $this->dbback->from('info_sms')->count_all_results();
        
        return $count_num;
    }
    
    
    /**
     * get_lastst_sms
     * ż¼
     * @access  public
     * @param string $telno 绰
     * @return array һ¼
     */
    public function get_lastst_sms($telno)
    {
        //ѯֶ
        $this->dbback->select('id,rowid,validcode,mobile,dateline');
        $cond_where = "mobile = '".$telno."' and valid_flag='1' order by id desc ";
        $this->dbback->where( $cond_where );
        $arr_data = $this->dbback->get('info_sms')->row_array();
        
        return $arr_data;
    }
    
    
    /**
     * ֤Ƿ
     * @access public
     * @param string $dateline ʱ
     * @return Boolean Ƿ
     */
    public function is_expire_code($dateline){
        $timelimit = time() - 1800;
        $result = $dateline > $timelimit ? TRUE : FALSE;
        return $result;
    }
    
    
    /**
     * update_broker_pwd
     * ¾Ĭ
     * @access public
     * @param string $brokerid
     * return void
     */
    public function update_broker_pwd($brokerid){
        $newpwd = md5('111111');
	$this->db->where('uid',$brokerid);	
	$this->db->update("broker", array("password"=>$newpwd));
    }
    
    
    /**
     * ֤־λ
     * @access public
     * @param int smsid
     * @return void
     */
    public function update_sms_flag($smsid)
    {
        $this->db->where('id',$smsid);	
	$this->db->update("info_sms", array("valid_flag"=>0));
    }
    
    
    /**
     * ȡ˵ЧԴ
     * @param string $type ͣĬϻȡۺͳ֮
     * type = sell Ч rent = rent Ч
     * @return int
     */
    public function valid_house_num($type = '')
    {
        $user_arr = $this->get_user_session();
        $valid_num = 0;
        
        if ($type == 'sell' || $type == '')
        {
            $this->load->model('sell_model');
            $sell_valid = $this->sell_model->valid_house_num($user_arr['uid']);
            $valid_num += $sell_valid;
        }
        
        if ($type == 'rent' || $type == '')
        {
            $this->load->model('rent_model');
            $rent_valid = $this->rent_model->valid_house_num($user_arr['uid']);
            $valid_num += $rent_valid;
        }
        
        return $valid_num;
    }
    
    
    /**
     * ȡ˵ЧԴ
     * @param string $type ͣĬϻȡۺͳ֮
     * type = sell Ч rent = rent Ч
     * @return int
     */
    public function stock_house_num($type = '')
    {
        $user_arr = $this->get_user_session();
        $stock_num = 0;
        if ($type == 'sell' || $type == '')
        {
            $this->load->model('sell_model');
            $sell_stock = $this->sell_model->stock_house_num($user_arr['uid']);
            $stock_num += $sell_stock;
        }
        
        if ($type == 'rent' || $type == '')
        {
            $this->load->model('rent_model');
            $rent_stock = $this->rent_model->stock_house_num($user_arr['uid']);
            $stock_num += $rent_stock;
        }
        
        return $stock_num;
    }
    
    
    /**
     * ֤ѯ
     * @param string $type ֤ :headcard ͷ֤, 
     *                      idcard ֤ buscard Ƭ֤occup ְҵ֤ 
     * @param int $uid ûid
     * @return array
     */
    public function get_certificate_info($type,$uid)
    {
        switch ($type)
        {
            case 'headcard' : 
                $cond_kind = "kind='p_1'";
                break;
            case 'idcard' : 
                $cond_kind = "kind='p_2'";
                break;
            case 'buscard' : 
                $cond_kind = "kind='p_3'";
                break;
            case 'occup' : 
                $cond_kind = "kind in('p_4_1','p_4_2')";
                break;            
        }
        
       $cond_where = "uid = '".$uid."' and $cond_kind";
       $this->db->where($cond_where);
       $this->db->order_by('id','desc');
       $data_arr = $this->db->select('valid_flag,pic1')->get('broker_certificate')->row_array();
       return $data_arr;        
    }
    
    
    /**
     * ֤
     * @param int $uid
     * @param string $type ֤
     * @param int $current_stats ǰ״̬
     * @param int $check_stats ˺״̬
     * @param string $reason ԭ
     * @return void
     */
    public function check_certificate($uid,$type,$current_stats=0,$check_stats=1,$reason='')
    {
        $where_cond['uid'] = $uid;
        $where_cond['valid_flag'] = $current_stats;
        $where_cond['kind'] = $type;
        $this->db->where($where_cond);
        $updata_data['valid_flag'] = $check_stats;
        $updata_data['reason'] = $reason;
        $this->db->update('broker_certificate',$updata_data);        
    }
    
    
    /**
     * ϴ֤
     * @param int $uid ûid
     * @param string  $type ϴ
     * @param string $picurl ͼƬַ
     * @return void
     */
    public function add_certificate($uid,$type,$picurl)
    {
        $insert_data = array();
        
        $insert_data['uid'] = $uid;
        $insert_data['kind'] = $type;
        $insert_data['valid_flag'] = 0;
        $insert_data['indate'] = date('Y-m-d H:i');
        $insert_data['pic1'] = $picurl;
        
        $this->db->insert('broker_certificate',$insert_data);
        $insert_id = $this->db->insert_id();
        
	return $insert_id;
    }
    
    
    /**
     * ϵֻĴ
     * @param int $uid ûID
     * @return int 
     */
    public function change_phone_num($uid)
    {
        $starttime  = strtotime(date('Y-m-d',time())."00:00:00");
	$endtime   = strtotime(date('Y-m-d',time())."23:59:59");
        
        $where_cond['uid'] = $uid;
        $where_cond['valid_flag'] = 0;
        $where_cond['dateline >'] = $starttime;
        $where_cond['dateline <'] = $endtime;
        
        $this->dbback->where($where_cond);
        $this->dbback->from('broker_certifycode');
        $num = $this->dbback->count_all_results();
        
        return $num;
    }
    
    
    /**
     * ϻȡ֤
     * get_certifycode_num
     * @param int $uid ûid
     * @return int 
     */
    public function get_certifycode_num($uid)
    {
        $starttime  = strtotime(date('Y-m-d',time())."00:00:00");
	$endtime   = strtotime(date('Y-m-d',time())."23:59:59");
        
        $where_cond['uid'] = $uid;        
        $where_cond['dateline >'] = $starttime;
        $where_cond['dateline <'] = $endtime;
        
        $this->dbback->where($where_cond);
        $this->dbback->from('broker_certifycode');
        $num = $this->dbback->count_all_results();
        
        return $num;
    }
    
    
    /**
     * 鿴60SǷѾȡ֤
     * @param int $uid ûid
     * @param int $mobile ֻ
     * @return int 
     */
    public function is_get_certifycode($mobile)
    {
        $nowtime = time() - 59;         
        $where_cond['mobile'] = $mobile;
        $where_cond['dateline >='] = $nowtime;
        
        $this->dbback->where($where_cond);
        $this->dbback->from('broker_certifycode');
        $num = $this->dbback->count_all_results();
        
        return $num;
    }
    
    
    /**
     * 뾭֤¼
     * @param int $uid ûid
     * @param int $mobile ֻ
     * @param int $certifycode ֤
     * @return void
     */
    public function add_certifycode($uid,$mobile,$certifycode)
    {      
        $insert_data = array();
        
        $insert_data['uid'] = $uid;
        $insert_data['validcode'] = $certifycode;
        $insert_data['mobile']	= $mobile;
        $insert_data['type'] = "user_mod";
        $insert_data['intime']	= date("Y-m-d H:i:s",time());
        $insert_data['dateline'] = time();
        
        $this->db->insert('broker_certifycode',$insert_data);	
        
        return $this->db->insert_id();
    }
    
    
    /**
     * 3޸ֻ֤
     * @param int $uid ûid
     * @param int $mobile ûֻ
     * @return array
     */
    public function get_certifycode($uid,$mobile)
    {
        $tbl ='broker_certifycode';
        $timelimit = time() - 180;
        
        $where_cond ['uid'] = $uid;
        $where_cond ['mobile'] = $mobile;
        $where_cond ['valid_flag'] = 1;
        $where_cond ['dateline >'] = $timelimit;
        
        $this->dbback->where($where_cond);
        $data_arr = $this->dbback->select('id,validcode,mobile')->order_by('id','desc')->get($tbl)->row_array();
        
        return $data_arr;
    }
    
    
    /**
     * ֤ɹ޸״̬
     * @param int $id
     * @return void
     */
    public function update_certifycode($id)
    {
        $tbl ='broker_certifycode';
        
        $this->db->where('id',$id);
        $update_arr['valid_flag']= 0;
        $update_arr['dateline'] = time();
        
        $this->db->update($tbl,$update_arr);
    }
    
    
    /**
     * Ƿ
     */
    public function is_brithday()
    {
        $u_session = $this->get_user_session();
        $birthday = date('md', time());
        
        //ѯ
        $this->dbback->where("uid = ".$u_session['uid']." and valid_flag =1  AND  substring( idno, 11, 4 ) = $birthday");
        //ѯ
        $count_num = $this->dbback->from('broker')->count_all_results(); 
        
        return  $count_num > 0 ? TRUE :FALSE;           
    }


	 /*
     * ȡҪεĹ˾code
     *  prohibit_company
     * return array
     */
    public function prohibit_company($pcompany_code){
        $mem_key = $this->_mem_key.'_get_prohibit_company_'.$pcompany_code;
        $cache = $this->mc->get($mem_key);
        
        if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
        {
            $temp_agent = $cache['data'];
        }
        else
        {
            $this->dbback->select('agentcode');
            $cond_where = "parentcode = '".$pcompany_code."'";
            $this->dbback->where( $cond_where );
            $arr_data = $this->dbback->get('agency')->result_array();    
            if(is_array($arr_data)&&!empty($arr_data)){
                foreach ($arr_data as $value){
                   $temp_agent[] =  $value['agentcode'];
                }
            }
            
            $this->mc->add($mem_key , array('is_ok'=>1 , 'data'=>$temp_agent) ,  86400);
        }
        return $temp_agent;        
    }
    
    /**
     *Ƿ 
     */
    public function is_prohibit($agent_code,$parent_code='A2313'){      
        $prohibit_arr = $this->prohibit_company($parent_code);       
        $is_prohibit = in_array($agent_code, $prohibit_arr) ? TRUE : FALSE;
        return $is_prohibit;        
    }
    
	/**
	 *ͷ״̬
	 */
	public function statusHeadPic($uid)
	{
		$mem_key = $this->_mem_key.'_get_status_head_pic_'.$uid;
        $cache = $this->mc->get($mem_key);
		if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
        {
			
            $status = $cache['data'];
        }
        else
        {
			
			$this->dbback->select('id');
			$cond_where = "uid = '$uid' && kind ='p_1' && valid_flag='1'";
			$this->dbback->where( $cond_where );
			$arr_data = $this->dbback->get('broker_certificate')->result_array(); 
			if(is_array($arr_data) && !empty($arr_data))
			{
				$status =1;
			}
			else
			{
				$status =0;
			}
			$this->mc->add($mem_key , array('is_ok'=>1 , 'data'=>$status) ,  86400);
		}
		
		return $status;
	
	}
    
}
/* End of file Broker_model.php */
/* Location: ./zsb/model/Broker_model.php */