<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * zsb
 *
 * ۱ϵͳ
 *
 * @package         zsb
 * @author          EllisLab Dev Team
 * @copyright      Copyright (c) 2006 - 2014, HOUSE365, Inc.
 * @link            http://nj.sell.house.com
 * @since           Version 1.0
 */

// ------------------------------------------------------------------------

/**
 * House_match_base_model CLASS
 *
 * ԴƥϢࡣ
 *
 * @package         zsb
 * @subpackage      Models
 * @category        Models
 * @author          xz     
 */
class House_match_base_model extends MY_Model {
    
    /**
     * 󹺡û
     *
     * @access private
     * @var integer
     */
    private $_want_uid    = 0;
    
    /**
     * 󹺡Ϣ
     *
     * @access private
     * @var integer
     */
    private $_want_id    = 0;

    /**
     * ƥ䷿Դû
     *
     * @access private
     * @var integer
     */
    private $_match_uid    = 0;
    
    /**
     * ƥ䷿Դ
     *
     * @access private
     * @var integer
     */
    private $_match_id    = 0;

    /**
     * ûڵĳ
     *
     * @access private
     * @var string
     */
    private $_city = NULL;
    
    /**
     * ƥ䷿ԴϢ
     *
     * @access private
     * @var string
     */
    private $_tbl_match = NULL;
    
    /**
     * 󹺡Ϣ
     *
     * @access private
     * @var string
     */
    protected $_tbl_arr = array( 'buy_match' , 'rentwanted_match' );
    
    /**
     * ѯֶ
     *
     * @access private
     * @var string
     */
    private $_search_fields = array();
    
    /**
     * Constructor
     */
    public function __construct() 
    {
        parent::__construct(1,1,1);
    }


    /**
     * û
     *
     * @access	public
     * @param	int $want_uid û
     * @return	void
     */
    public function set_want_uid($want_uid)
    {
        $this->_want_uid = intval( $want_uid );
    }
    
    
    /**
     * ȡû
     *
     * @access	public
     * @return	void
     */
    public function get_want_uid()
    {
        return $this->_want_uid;
    }
    
    
    /**
     * Ϣ
     *
     * @access	public
     * @param	int $want_id Ϣ
     * @return	void
     */
    public function set_want_id($want_id)
    {
        $this->_want_id = intval( $want_id );
    }
   
    
    /**
     * ȡϢ
     *
     * @access	public
     * @return	void
     */
    public function get_want_id()
    {
        return $this->_want_id;
    }
    
    
    /**
     * ƥû
     *
     * @access	public
     * @param	int $match_uid ƥû
     * @return	void
     */
    public function set_match_uid( $match_uid )
    {
        $this->_match_uid = intval( $match_uid );
    }
    
    
    /**
     * ȡƥû
     *
     * @access	public
     * @return	void
     */
    public function get_match_uid()
    {
        return $this->_match_uid;
    }
    
    
    /**
     * ƥ䷿Դ
     *
     * @access	public
     * @param	int $match_id ƥ䷿Դ
     * @return	void
     */
    public function set_match_id($match_id)
    {
        $this->_match_id = intval( $match_id );
    }
    
    
    /**
     * ȡƥ䷿Դ
     *
     * @access	public
     * @return	void
     */
    public function get_match_id()
    {
        return $this->_match_id;
    }
    
    
    /**
     * 󹺡ƥ
     *
     * @access	public
     * @param	string $tbl_name 
     * @return	void
     */
    public function set_tbl_match( $tbl_name )
    {
        $this->_tbl_match = strip_tags( $tbl_name );
    }
    
    
    /**
     * ȡ󹺡ƥ
     *
     * @access	public
     * @param	void
     * @return	string 󹺡ƥ
     */
    public function get_tbl_match( )
    {
        return $this->_tbl_match;
    }
    
    
    /**
     * òѯֶ
     *
     * @access	public
     * @param	array $serach_fields Ҫѯ
     * @return	void
     */
    public function set_search_fields( $serach_fields )
    {
        return $this->_search_fields = $serach_fields;
    }
    
   
    /**
     * ȡõĲѯֶ
     *
     * @access	public
     * @return	array ѯֶ
     */
    public function get_search_fields( )
    {
        return $this->_search_fields;
    }
    
    
    
    /**
     * ƥϢ
     *
     * @access	public
     * @return	int Ƿӳɹ0ӳɹ0ʧܡ
     */
    public function add_match_info( $data_info )
    {   
        $result = 0;
        if( is_array($data_info) && !empty($data_info) )
        {
            $this->db->insert( $this->get_tbl_match() , $data_info );
            $result=  ( $this->db->affected_rows() == 1 ) ? $this->db->insert_id() : 0;
        }
        
        return $result;
    }
    
    
    /**
     * ɾƥϢ
     *
     * @access	private
     * @param string  $cond_where ɾ
     * @return boolean true-ɾɹfalse-ɾʧܡ
     */
    protected function delete_matchinfo_by_cond( $cond_where )
    {   
        $result = FALSE;
        
        if( $cond_where != '' )
        {   
            $this->db->where( $cond_where );
            $this->db->delete( $this->get_tbl_match());
            $result =  ( $this->db->affected_rows() == 1 ) ? TURE : FALSE;
        }
        
        return $result;
    }
    
    
    /**
     * IDɾƥϢ
     *
     * @access	public
     * @return boolean TRUE-ɾɹFALSE-ɾʧ
     */
    public function delete_matchinfo_by_wantid( )
    {   
        $result = FALSE;
        
        $want_id = $this->get_want_id();
        
        if( $wantid > 0 )
        {   
            $cond_where = "want_id = '.$want_id.' ";
            $result = $this->delete_matchinfo_by_cond($cond_where);
        }
        
        return $result;
    }
    
    
    /**
     * ƥ䷿ԴIDɾƥϢ
     *
     * @access	public
     * @return boolean TRUE-ɾɹFALSE-ɾʧ
     */
    public function delete_matchinfo_by_matchid( )
    {   
        $result = FALSE;
        
        $match_id = $this->get_match_id_id();
        
        if( $match_id > 0 )
        {   
            $cond_where = "match_id = '.$match_id.' ";
            $result = $this->delete_matchinfo_by_cond($cond_where);
        }
        
        return $result;
    }
    
    
    /**
     * ˱ɾƥϢ
     *
     * @access	public
     * @return boolean TRUE-ɾɹFALSE-ɾʧ
     */
    public function delete_matchinfo_by_wantuid( )
    {   
        $result = FALSE;
        
        $want_id = $this->get_want_uid();
        
        if( $want_id > 0 )
        {   
            $cond_where = "want_uid = '.$want_uid.' ";
            $result = $this->delete_matchinfo_by_cond($cond_where);
        }
        
        return $result;
    }
    
    
    /**
     * ƥ˱ɾƥϢ
     *
     * @access	public
     * @param int $infofrom  ˺ 1ˡ5 
     * @return boolean TRUE-ɾɹFALSE-ɾʧ
     */
    public function delete_matchinfo_by_match_uid( $infofrom = '' )
    {   
        $result = FALSE;
        
        $match_uid = $this->get_match_uid();
        
        if( $match_uid > 0 )
        {   
            $cond_where = "match_uid = '.$match_uid.'";
            
            if( $infofrom != '')
            {
                $cond_where .= " AND infofrom = '.$infofrom.' ";
            }
            
            $result = $this->delete_matchinfo_by_cond($cond_where);
        }
        
        return $result;
    }
    
    
    /**
     * ƥ˱ɾƥϢ
     *
     * @access	protected
     * @param array $update_arr  Ҫµֶμֵ
     * @param string $cond_where ݵĲѯ
     * @return boolean TRUE-³ɹFALSE-ʧ
     */
    protected function update_matchinfo_by_cond( $update_arr , $cond_where )
    {   
        $result = FALSE;
        
        if(is_array($update_arr) && !empty($update_arr) && $cond_where != '')
        {
           $this->db->where( $cond_where ); 
           $this->db->update( $this->get_tbl_match() , $update_arr);
           $result=  ( $this->db->affected_rows() == 1 ) ? TRUE : FALSE;
        }
        
        return  $result ;
    }
    
    
    /**
     * idƥϢ
     *
     * @access	protected
     * @param int    $id id 
     * @param array  $update_arr  Ҫµֶμֵ
     * @return boolean TRUE-³ɹFALSE-ʧ
     */
    public function update_matchinfo_by_id( $id , $update_arr )
    {   
        $result = FALSE;
        
        if( $id > 0 )
        {   
            $cond_where = "id = '.$id.' ";
            $result = $this->update_matchinfo_by_cond( $update_arr, $cond_where);
        }
        
        return $result;
    }
    
    
    /**
     * 
     *
     * @access	protected
     * @param string  $cond_where  
     * @return int  ļ¼
     */
    protected function get_count_by_cond( $cond_where )
    {
        $count_num = 0;
        
        //ѯ
        if( $cond_where != '')
        {
            $this->dbback->where( $cond_where );
            $count_num = $this->dbback->count_all_results($this->get_tbl_match());
        }
        
        return  intval( $count_num );
    }
    
    
    /**
     * ŻȡƥϢ
     *
     * @access   public
     * @param    string  $infofrom  ƥ䷿ԴԴ
     * @param    int  starttime  Ӹʱʱ㿪ʼͳ
     * @return   int  ļ¼
     */
    public function get_count_by_wantid( $infofrom = '' , $starttime = 0 )
    {
        $count_num = 0;

        $want_id = $this->get_want_id();

        if( $want_id > 0 )
        {   
            $cond_where = "want_id = '".$want_id."'";
            
            if( $infofrom != '')
            {
                $cond_where .= " AND infofrom = '".$infofrom."' ";
            }
            
            if( $starttime == 0)
            {
                $start_time = time() - 86400 * 30;
            }
            
            $cond_where .= " AND creattime >= '".$start_time."' ";
            
            $count_num = $this->get_count_by_cond($cond_where);
            //echo $this->dbback->last_query();
        }

        return  intval( $count_num );
    }
    
    
    /**
     * ƥ˺ŻȡƥϢ
     *
     * @access   public
     * @param    string  $infofrom  ƥ䷿ԴԴ
     * @param    int  starttime  Ӹʱʱ㿪ʼͳ
     * @return   int  ļ¼
     */
    public function get_count_by_matchuid( $infofrom = '' , $starttime = 0 )
    {
        $count_num = 0;

        $match_uid = $this->get_match_uid();

        if( $match_uid > 0 )
        {   
            $cond_where = "match_uid = '".$match_uid."'";
            
            if( $infofrom != '')
            {
                $cond_where .= " AND infofrom = '".$infofrom."' ";
            }
            
            if( $starttime == 0)
            {
                $start_time = time() - 86400 * 30;
            }
            
            $cond_where .= " AND creattime >= '".$start_time."' ";
            
            
            $count_num = $this->get_count_by_cond($cond_where);
        }

        return  intval( $count_num );
    }
    

    /**
     * ݱŻȡƥϢ
     *
     * @access   public
     * @param    int  $id  Ϣ
     * @return   int  ƥϢ
     */
    public function get_info_by_id( $id )
    {
        $data_info = array();
        
        $tbl_match = $this->get_tbl_match();

        if( $id > 0 )
        {   
            $cond_where = "id = '.$id.'";
            $this->dbback->where( $cond_where );
            
            //ҪѯķԴϢֶ
            $select_fields = $this->get_search_fields();

            if( isset( $select_fields ) && !empty( $select_fields ) )
            {   
                //ѯֶ
                $select_fields_str = implode( ',' , $select_fields ) ;
                $this->dbback->select( $select_fields );
            }
        
            $data_info = $this->dbback->get( $tbl_match )->row_array();
        }

        return  $data_info;
    }
    
    
    /**
     * ݱŻȡƥϢ
     *
     * @access   protected
     * @param	string  $cond_where ѯ
     * @param	int     $offset ƫ,ĬֵΪ0
     * @param	int     $limit ÿȡĬֵΪ10
     * @param	string  $order_key ֶΣĬֵ
     * @param	string  $order_by  򡢽ĬϽ
     * @return   int  ƥϢ
     */
    protected function get_list_by_cond( $cond_where , $offset = 0 , $limit = 10 
            , $order_key = 'creattime' , $order_by = 'DESC' )
    {
        //ԴϢ
        $tbl_match = $this->get_tbl_match();
        
        //ҪѯķԴϢֶ
        $select_fields = $this->get_search_fields();
        
        if( isset( $select_fields ) && !empty( $select_fields ) )
        {   
            //ѯֶ
            $select_fields_str = implode( ',' , $select_fields ) ;
            $this->dbback->select( $select_fields );
        }
        
        //ѯ
        if( $cond_where != '')
        {
            $this->dbback->where( $cond_where );
        }

        //
        $this->dbback->order_by( $order_key , $order_by );

        //ѯ
        $arr_data = $this->dbback->get( $tbl_match , $limit , $offset )->result_array();

        return  $arr_data;
    }
    
    
    /**
     * Żȡƥ¼
     *
     * @access   public
     * @param	int  $infofrom ƥϢԴ 1 ˡ5н
     * @param	int     $offset ƫ,ĬֵΪ0
     * @param	int     $limit ÿȡĬֵΪ10
     * @param	string  $order_key ֶΣĬֵ
     * @param	string  $order_by  򡢽ĬϽ
     * @return   int  ƥϢ
     */
    public function get_list_by_wantid( $infofrom = '' , $offset = 0 
                , $limit = 10 , $order_key = 'creattime' , $order_by = 'DESC' )
    {   
        $arr_data = array();
        
        $want_id = $this->get_want_id();
        
        if( $want_id > 0 )
        {  
            $cond_where = "want_id = '".$want_id."' ";
            
            if($infofrom != '')
            {
                $cond_where .= " AND infofrom = '".$infofrom."'";
            }
            
            $arr_data = $this->get_list_by_cond( $cond_where , $offset , 
                    $limit , $order_key , $order_by );
        }
        
        return $arr_data;
    }
    
    
    /**
     * ݸƥ˱Żȡƥ¼
     *
     * @access   public
     * @param	int  $infofrom ƥϢԴ 1 ˡ5н
     * @param	int     $offset ƫ,ĬֵΪ0
     * @param	int     $limit ÿȡĬֵΪ10
     * @param	string  $order_key ֶΣĬֵ
     * @param	string  $order_by  򡢽ĬϽ
     * @param	int  $starttime  ʼͳʱʱ
     * @return   int  ƥϢ
     */
    public function get_list_by_matchuid( $infofrom = '' , $offset = 0 , $limit = 10 
                    , $order_key = 'creattime' , $order_by = 'DESC' , $starttime = 0 )
    {   
        $arr_data = array();
        
        $match_uid = $this->get_match_uid();
        
        if( $match_uid > 0 )
        {  
            $cond_where = "match_uid = '".$match_uid."' ";
            
            if($infofrom != '')
            {
                $cond_where .= " AND infofrom = '".$infofrom."'";
            }
            
            if( $starttime == 0)
            {
                $start_time = time() - 86400 * 30;
            }
            
            $cond_where .= " AND creattime >= '".$start_time."' ";

            
            $arr_data = $this->get_list_by_cond( $cond_where , $offset , $limit 
                    , $order_key , $order_by );
        }
        
        return $arr_data;
    }
    
    
    /**
     * ȡѲ
     *
     * @access  public
     * @param   int  $infofrom ƥϢԴ 1 ˡ5н
     * @param   string  $counttype Ƿȥ
     * @return  int  ƥ
     */
    public function get_matchednum( $infofrom = 5 , $counttype = 'distinct'  )
    {   
        $matched_num = 0;
        
        //ԴϢ
        $tbl_match = $this->get_tbl_match();
        
        if( $tbl_match != '')
        {   
            if( $counttype == 'distinct')
            {
                $sql = "SELECT DISTINCT(match_uid) FROM  $tbl_match ";
            }
            else
            {
                $sql = "SELECT match_uid  FROM  $tbl_match ";
            }
            
            $cond_where = " WHERE infofrom = '".$infofrom."'";
            $sql .= $cond_where;
            
            $matched_num  = $this->dbback->query( $sql )->num_rows();
        }
        
        return  $matched_num;
    }
}
/* End of file house_match_base_model.php */
/* Location: ./app/models/house_match_base_model.php */