<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * zsb
 *
 * Դ
 *
 * @package         zsb
 * @author          EllisLab Dev Team
 * @copyright      Copyright (c) 2006 - 2014, HOUSE365, Inc.
 * @link            http://nj.sell.house.com
 * @since           Version 1.0
 */

// ------------------------------------------------------------------------

/**
 * House_attr_model CLASS
 *
 * Դ,ṩԴɾĲ顣
 *
 * @package         zsb
 * @subpackage      Models
 * @category        Models
 * @author          sun
 * @link            
 */
class House_base_model extends MY_Model {
    
    /**
     * Ҫı
     * @var string 
     */
    protected $tbl = '';
    
    /**
     * key
     * @var string
     */
    private $_mem_key = '';
    
    /**
     * Դ״̬
     * @var array 
     */
    protected $house_esta = array(
        'active' => 1,/**/ 'invalid' => 2/*ʧЧ*/, 
        'delete' => 4 , /*ɾ*/ 'frozen' => 5 /**/,
        'sysfrozen' => 51 /*ϵͳ*/,);
    
    /**
     * Դ
     * @var array 
     */
    protected $house_attr = array(
        'isstar' => 3,/*ͼ*/ 'istag' => 1 /**/
    );

    /**
     * Ҫѯݱֶ
     * @var string 
     */
    protected $select_fields = '';
    
    /**
     * ֶ
     * @var string 
     */
    protected $fileds = array();


	/**
     * ʼ
     */
    public function __construct() 
    {
        parent::__construct(1,1,1);
		$this->_mem_key = GB_CITY.'house_base_model';
    }


    /**
     * òѯݵı
     * @param string $tbl
     */
    public function set_tbl($tbl) 
    {
        $this->tbl = $tbl;
    }
    
    /**
     * ȡѯݵı
     * @return string $tbl 
     */
    public function get_tbl() 
    {
         return $this->tbl;
    }
    
    /**
     * ȡԴ״̬
     * @return string $house_esta Դ״̬
     */
    public function get_house_esta() 
    {
        return $this->house_esta;
    }
    
    
    /**
     * Դ
     * @return string $house_attr Դ
     */
    public function get_house_attr() 
    {
        return $this->house_attr;
    }

    
    /**
     * ñֶ
     */
    public function set_fields()
    {
        $fields = $this->db->field_data($this->get_tbl());
        if ($fields)
        {
            foreach($fields as $v)
            {
                $this->fileds[] = $v->name; 
            }
        }
    }
    
    /**
     * ȡֶ
     * @access	public
     */
    public function get_fields()
    {
        return $this->fileds;
    }
    
    /**
     * Ҫѯֶ
     * @param array $select_fields
     */
    public function set_select_fields($select_fields)
    {
        $select_fields_str = '';
        if(isset( $select_fields ) && !empty($select_fields))
        {   
            $select_fields_str = implode( ',', $select_fields) ;
        }
        $this->select_fields = $select_fields;
    }
    
    /**
     * ȡҪѯֶ
     * @return type
     */
    public function get_select_fields()
    {
        return $this->select_fields;
    }

    /**
     * ȡѯķԴ
     * @param string $where ѯ
     * @return int Դ
     */
    public function find_count_by($where, $selectdb = 0)
    {   
        $num_rows = 0;
        $tbl = $this->get_tbl();
        
        if ($selectdb == 0) 
        {
            $this->dbback->where($where);
            $num_rows = $this->dbback->count_all_results($tbl); 
        } 
        else 
        {
            $this->db->where($where);
            $num_rows = $this->db->count_all_results($tbl); 
        }
        
        return $num_rows;
    }
    
    /**
     * ȡԴбҳ
     * @param string $where ѯ
     * @param int $start ѯʼ
     * @param int $limit ƫ
     * @param int $order_key ֶ
     * @param string $order_by 򡢽ĬϽ
     * @return array ضԴ¼ɵĶά
     */
    public function find_all_by($where, $start = 0, $limit = 20, 
            $order_key = 'updatetime' , $order_by = 'DESC') 
    {   
        $data_info = array();
        //ѯֶ
        if ($this->select_fields)
        {
            $this->dbback->select($this->select_fields);
        }
        //ѯ
        $this->dbback->where($where);
        //
        $this->dbback->order_by($order_key, $order_by);
        
        if ( $start >= 0 && $limit > 0 )
        {
            $this->dbback->limit($limit, $start);
        }
        
        $data_info =  $this->dbback->get($this->tbl)->result_array();
        //echo $this->dbback->last_query();
        
        return $data_info;
    }
    
    /**
     * ݲѯһԴļ¼
     * @param string $where ѯ
     * @return array һһάķԴ¼
     */
    public function find_one_by($where = '')
    {
        //ѯֶ
        if ($this->select_fields)
        {
            $this->dbback->select($this->select_fields);
        }
        //ѯ
        $this->dbback->where($where);
        return $this->dbback->get($this->get_tbl())->row_array();
    }
    
    /**
     * ݾ˱źͷԴŻȡ¼
     * @param int $uid ˱
     * @param int $id Դ
     * @return array Դ¼ɵһά
     */
    public function find_by_uid_id($uid, $id) 
    {
        //ѯֶ
        if ($this->select_fields)
        {
            $this->dbback->select($this->select_fields);
        }
        //ѯ
        $this->dbback->where('id', $id);
        $this->dbback->where('uid', $uid);
        return $this->dbback->get($this->get_tbl())->row_array();
    }
    
    /**
     * ͨԴŻȡԴ¼
     * @param int $id Դ
     * @return array Դ¼ɵһά
     */
    public function find_by_id($id) 
    {
        //ѯֶ
        if ($this->select_fields)
        {
            $this->dbback->select($this->select_fields);
        }
        //ѯ
        $this->dbback->where('id', $id);
        return $this->dbback->get($this->get_tbl())->row_array();
    }

    /**
     * 뷿Դ
     * @param array $insert_data  Դ
     * @return int ɹ زɹķԴid ʧ false
     */
    protected function insert_data($insert_data) 
    {
        if (isset($insert_data[0]) && is_array($insert_data[0]))
        {
            //
            if ($this->db->insert_batch($this->get_tbl(), $insert_data))
            {
                return $this->db->insert_id();
            }
        } 
        else 
        {
            //
            if ($this->db->insert($this->get_tbl(), $insert_data))
            {
                return $this->db->insert_id();
            }
        }
        return false;
    }
    
    
    /**
     * ɾԴ
     * @param array or int $ids Դ ɽ߷Դ
     * @param int $uid ˱
     * @return boolean true ɹ false ʧ
     */
    protected function delete_data($ids, $uid = '')        
    {
        //ɾ
        if (is_array($ids))
        {
            $arrIds = $ids;
        }
        else
        {
            $arrIds[0] = $ids;
        }

        if ($arrIds)
        {
            if ($uid)
            {
                $this->db->where('uid', $uid);
            }

            $this->db->where_in('id', $arrIds);
            $this->db->delete($this->get_tbl());
        }

        if ($this->db->affected_rows() >0)
        {
            return true;
        }
        else 
        {
            return false;
        }
    }

    /**
     * ·Դ
     * @param array $update_data µԴ
     * @param array $ids Դ
     * @param int $uid ˱
     * @return int ɹ󷵻Ӱ
     */
    protected function update_data($update_data, $ids, $uid = '')
    {   
        if (is_array($ids))
        {
            $arrIds = $ids;
        }
        else
        {
            $arrIds[0] = $ids;
        }

        $this->db->where_in('id', $arrIds);

        if ($uid)
        {
            $this->db->where('uid', $uid);
        }
        
        if (isset($update_data[0]) && is_array($update_data[0]))
        {
            $this->db->update_batch($this->get_tbl(), $update_data);
        }
        else 
        {
            $this->db->update($this->get_tbl(), $update_data);
        }

        return $this->db->affected_rows();
    }
    

    /**
     * ȡ˼Դ
     * @param int $uid ˱
     * @return int ؾ˼Դ
     */
    public function find_active_house_count($uid)
    {
        $this->dbback->where('uid', $uid);
        $this->dbback->where('esta', $this->house_esta['active']);
        return $this->dbback->count_all_results($this->get_tbl());
    }
    

    /**
     * ȡͼԴ
     * @param type $uid ˱
     * @return int  ؾ˼ͼԴ
     */
    public function find_active_star_house_count($uid)
    {
        $this->dbback->where('uid', $uid);
        $this->dbback->where('esta', $this->house_esta['active']);
        $this->dbback->where('isstar', $this->house_attr['isstar']);
        return $this->dbback->count_all_results($this->get_tbl());
    }
    

    /**
     * ȡԴС
     * @param int $uid ˱
	 * @param string $house_esta Դ״̬
     * @return array Сɶά
     */
    public function find_publish_block( $uid ,$house_esta = 'active')
    {	
		$publish_block = array();
		$mem_key = $this->_mem_key.'_find_publish_block_'.$uid.'_'.$house_esta.'_'.$this->tbl.'_'.$this->select_fields;
		$cache = $this->mc->get($mem_key);

		if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
		{
			$publish_block = $cache['data'];
		}
		else
		{
			//ѯֶ
			if ($this->select_fields)
			{
				$this->dbback->select($this->select_fields);
			}

			$this->dbback->where('uid', $uid);
			if($house_esta == 'active')
			{
				$this->dbback->where('esta', $this->house_esta['active']);
			}
			else if(isset($this->house_esta[$house_esta]) && $this->house_esta[$house_esta] > 0 )
			{
				$this->dbback->where('esta', $this->house_esta[$house_esta]);
			}
			
			$this->dbback->where('blockshowname != ', '');
			$this->dbback->where('blockid != ', 0);
			$this->dbback->group_by('blockid');
			$publish_block =  $this->dbback->get($this->tbl)->result_array();
			
			$this->mc->add($mem_key, array('is_ok'=>1,'data'=>$publish_block),120);
		}

		return $publish_block;
    }
    

    /**
     * ȡЧԴ Ĭ +
     * @param int $uid ˱
     * @return int 
     */
    public function valid_house_num($uid)
    {
        $where = "uid = $uid AND esta in ({$this->house_esta['active']},{$this->house_esta['frozen']}) AND infofrom = '5'";
        //$where = "uid = $uid AND esta={$this->house_esta['active']} AND infofrom = '5'"; //2020-08-31 chenlei ȥ᷿Դ
        return $this->find_count_by($where, 1);
    }
    

    /**
     * ȡⷿԴ Ĭ ++ʧЧ
     * @param int $uid ˱
     * @return int 
     */
    public function stock_house_num($uid)
    {
        $where = "uid = $uid AND esta in ({$this->house_esta['active']},{$this->house_esta['frozen']},{$this->house_esta['invalid']})  AND infofrom = '5'";

        return $this->find_count_by($where,0);
    }
    

    /**
     * ¼ûԴ״̬Ϊ켣
     * @param string $companycode ˾
     * @param int $uid ˱
     * @param string $tbl 
     * @param int $rowid Դ
     * @param int $msg Դ״̬λ 0:ɾԴ 1:ͨЧԴ 
     *   2:ͨʧЧԴ 3:Դٷ 4:ʧЧԴ 5:ͼЧԴ 
     *   6:ͼʧЧԴ 7:۱ˢ 8:ֻ۱ˢ 9:ͼΪǶͼ
     */
    public function action_log($companycode, $uid, $tbl, $rowid, $msg)
    {
		//
        $oper_table = 'log_broker_oper';
		//
        $tmp_table = 'log_broker_tmp';
        
        $arr = explode( ',' , $rowid);
        $ss = array();
        $ss["agentcode"]    = $companycode;
        $ss["uid"]  = $uid;
        $ss["tbl"]  = $tbl;
        $ss["msg"]  = $msg;       
        $ss["y"]    = date('Y');
        $ss["m"]    = date('m');
        $ss["d"]    = date('d');
        $ss["time"] = date('Hi');
		$ss["date"]	= date('Ymd');
        $ss["ip"]   = get_ip();
        
        foreach( $arr as $k=>$v ) 
        {

			//ű
			$kind = rand(1,2);

			if($kind == 1){
				$oper_table = 'log_broker_oper';
			}elseif($kind == 2){
				$oper_table = 'log_broker_oper2';
			}

            $ss["rowid"] = $v;
            $this->db->insert($oper_table, $ss);
        }
        
        if( $msg == 1 || $msg == 2 )
        {
            $time = date("Y-m-d");
            $num = count($arr);
            $this->dbback->select('id');
            $this->dbback->where('uid', $uid);
            $this->dbback->where('updatetime', $time);
            
            $result = array();
            $result = $this->dbback->get($tmp_table)->row_array();
            
            if($result)
            {
                $this->db->where('id', $result['id']);
                $update_data = array('num' => 'num + 1');
                $this->db->update($tmp_table, $update_data);
            }
            else
            {
                $insert_data = array(
                    'num' => $num, 'agentcode' => $companycode,
                    'uid' => $uid, 'updatetime' => $time
                );
                $this->db->insert($tmp_table, $insert_data);
            }
        }
    }
}

/* End of file house_base_model.php */
/* Location: ./zsb/model/house_base_model.php */