<?php !defined('APP_DIR') ? die('acceess not defined') : '';
class cookie{
    
    /**
     * cookie
     *
     * @param string $name
     * @param string $value
     * @param int $time
     */
    static public function set($name, $value, $time = 86400){
        $path     = tool::config('cookie.path');
        $domain   = tool::config('cookie.domain');
        $secure   = tool::config('cookie.secure');
        $httponly = tool::config('cookie.httponly');
        $expires  = time()+$time;
        setcookie($name,$value,$expires,$path,$domain,$secure,$httponly);
    }
    
    /**
     * ȡcookieֵ
     *
     * @param string $name
     * @return string
     */
    static public function get($name){
        if (isset($_COOKIE[$name])) {
        	return $_COOKIE[$name];
        }
        return '';
    }
    
    /**
     * ɾcookie
     *
     * @param string $name
     * @return bool
     */
    static public function delete($name){
        if ( !isset($_COOKIE[$name]) ) {
        	return true;
        }
        unset($_COOKIE[$name]);
        return cookie::set($name, '', -86400);
    }
    
}
?>