//ͼ

var Draw = {

	//ͼļ
	config    : {},

	container : 'allmap',

	mapState  : true,

	searchState : false,

	initConfig: function()
	{
		switch (window.LocalCity)
		{
			case 'hf':
				this.config = {'lng' : 117.282699, 'lat' : 31.866942, 'zoom' : 12};
				break;
			case 'wx':
				this.config = {'lng' : 120.328453, 'lat' : 31.551329, 'zoom' : 12};
				break;
			case 'sz':
				this.config = {'lng' : 120.59921, 'lat' : 31.304659, 'zoom' : 12};
				break;
			case 'xa':
				this.config = {'lng' : 108.953098, 'lat' : 34.2778, 'zoom' : 12};
				break;
			case 'cq':
				this.config = {'lng' : 106.555931, 'lat' : 29.566222, 'zoom' : 12};
				break;
			case 'ks':
				this.config = {'lng' : 120.98593, 'lat' : 31.384196, 'zoom' : 12};
				break;
			case 'hz':
				this.config = {'lng' : 120.165333, 'lat' : 30.269226, 'zoom' : 12};
				break;
			case 'cz':
				this.config = {'lng' : 119.981861, 'lat' : 31.813628, 'zoom' : 12};
				break;
			case 'wh':
				this.config = {'lng' : 118.381233, 'lat' : 31.329506, 'zoom' : 12};
				break;
			default:
		}
	},

	init: function()
	{
		this.initConfig();
		//this.buildMap();
	},

	initMap: function()
	{
		objMap = new BMap.Map(this.container);
		this.buildMap();
		objMap.addControl(new BMap.NavigationControl());  
		
		objMap.addControl(new BMap.ScaleControl()); 
		//objMap.addControl(new ShortControl());
		//objMap.addControl(new BMap.MapTypeControl({anchor: BMAP_ANCHOR_TOP_RIGHT}))
			
		objMap.addControl(new BMap.OverviewMapControl());              //ĬԵͼؼ

		objMap.addControl(new BMap.OverviewMapControl({isOpen:true, anchor: BMAP_ANCHOR_BOTTOM_RIGHT}));   //Ͻǣ
		objMap.enableScrollWheelZoom();                     //ùַŴС
		this.addListenerEvent();
	},

	buildMap: function()
	{
		 // Mapʵ
		var point = new BMap.Point(this.config.lng, this.config.lat);     // 
		objMap.centerAndZoom(point, this.config.zoom);                     // ʼͼ,ĵ͵ͼ
	},

	clearChild: function()
	{
		$('.qu').each(function() {
			var type = $(this).find('.usual').attr('type');
			if (type == 'block' || type == 'district')
			{
				$(this).remove();
			}
		});
	},

	addListenerEvent: function()
	{
		//󶨷Ŵ飬
		objMap.removeEventListener("zoomend", Draw.zoomendEvent);
		objMap.removeEventListener("dragend", Draw.dragendEvent);
		objMap.addEventListener("zoomend", function(e) {
			//return false;
			//console.log(Draw.mapState);
			if (Draw.mapState)
			{
				Draw.clearChild();
				Draw.zoomendEvent(e.target.centerPoint, this.getZoom());
			}
		}); 

		objMap.addEventListener("dragend", function(){ 
			Draw.clearChild();
			Draw.dragendEvent(objMap.getCenter());
		});
	},

	zoomendEvent: function(arrPoint, zoom)
	{
		if (zoom <= 12) {
			Model.getDistrict();
			Model.specialLocation = {};
			Draw.init();
		} else if (zoom > 12) {
			Model.getPoint();
		}
		Draw.resetLngAndLat(arrPoint.lng, arrPoint.lat, zoom);
	},

	dragendEvent: function(arrPoint)
	{
		Draw.resetLngAndLat(arrPoint.lng, arrPoint.lat, Draw.config.zoom);
		if (Draw.config.zoom > 12)
		{
			/**
			Draw.clearDraw();
			if (!$.isEmptyObject(Model.specialLocation))
			{
				Model.displaySpecialPoint();
			}***/
			Model.getPoint();
		} else if (Draw.config.zoom == 12) {
			Model.getDistrict();
			Model.specialLocation = {};
			Draw.init();
		}
	},

	resetLngAndLat: function(lng, lat, zoom)
	{
		Draw.config.lng = lng;
		Draw.config.lat = lat;
		Draw.config.zoom = zoom;
	},

	panTo: function(x, y)
	{
		//return false;
		var pixelsw = objMap.pointToPixel(new BMap.Point(Draw.config.lng, Draw.config.lat));
		var pointsw = objMap.pixelToPoint(new BMap.Pixel(pixelsw.x + x, pixelsw.y + y));
		if (x < 0)
		{
			$(".content").css({"width" : IntPageWidth, "height" : IntPageHeight - 131, "overflow" : "hidden"});
			$("#allmap,#map").css({"width" : IntPageWidth, "height" : IntPageHeight - 131, "overflow" : "hidden"});
			//$("#map").css("width","100%");
		} else {
			$(".content").css({"width" : IntPageWidth, "height" : IntPageHeight-131, "overflow":"hidden"});
			$("#allmap,#map").css({"width" : IntPageWidth - 300, "height" : IntPageHeight-131, "overflow":"hidden"});
			//$("#map").css("width","auto");
		}
		objMap.panTo(new BMap.Point(pointsw.lng, pointsw.lat));
	},

	clearDraw: function()
	{
		objMap.clearOverlays();
	},

	addOverlay: function(arrPoint, html)
	{
		var myOverlay = new DeOverlayC(new BMap.Point(arrPoint.lng, arrPoint.lat), html);
		objMap.addOverlay(myOverlay);
	},

	assignDistrict: function(arrPoint, name)
	{
		var html = '<div class="mapfinding" type="speical"><table  border="0" cellspacing="0" cellpadding="0">'
				 + '<tr><td class="qul">&nbsp;</td><td class="qum" ><img src="images/icon004.gif" /><font color="#333333">'
				 + name + '</font></td><td class="qur" width="5">&nbsp;</td> </tr>' 
				 + '<tr><td class="sanjiao" colspan="3">&nbsp;</td></tr> </table></div>'; 
		Draw.addOverlay({lng : arrPoint.lng, lat : arrPoint.lat}, html);
		$('.mapfinding').parent().css('z-index', '50');
	},

	drawDistrict: function(arrDistrictCount)
	{
		var arrDistrictCoordinate = {};
		var intHouseNum = 0;
		var html = '';
		//console.log(Config.district);
		for (var i in Config.district)
		{
			if (i == 'unlimited') {continue;}
			//console.log(i);
			arrDistrictCoordinate = Config.coordinate[i];
			//console.log(i);
			intHouseNum = arrDistrictCount[i];
			html = '<div class="usual" type="district"><table  border="0" cellspacing="0" cellpadding="0">'
				 + '<tr><td class="qul">&nbsp;</td><td class="qum" district = ' + i + '>' + Config.district[i] 
				 + ' | ' + intHouseNum + '' + '</td><td class="qur" width="4">&nbsp;</td> </tr>' 
				 + '<tr><td class="sanjiao" colspan="3">&nbsp;</td></tr> </table></div>'; 
			Draw.addOverlay({lng : arrDistrictCoordinate.lng, lat :arrDistrictCoordinate.lat}, html);
		}
	},

	drawBlock: function(arrBlockInfo)
	{
		var arrBlockProject = arrBlockInfo['project'];
		for(var i in arrBlockProject) {
			if (Model.specialLocation.blockid == arrBlockProject[i].blockid) {continue;}
			html = '<div class="usual" type="block" blockid="'+ arrBlockProject[i].blockid + '"><table  border="0" cellspacing="0" cellpadding="0">'
				 + '<tr><td class="qul">&nbsp;</td><td class="qum" district = ' + i + '>' + arrBlockProject[i].blockname 
				 + '<span class="taoshu"> | ' + arrBlockProject[i].housecount + '</span></td><td class="qur" width="5">&nbsp;</td> </tr>' 
				 + '<tr><td class="sanjiao" colspan="3">&nbsp;</td></tr> </table></div>'; 
			Draw.addOverlay({lng : arrBlockProject[i].lng, lat : arrBlockProject[i].lat}, html);
		}
	},

	drawKeyWordPoint: function(arrPoint, value)
	{
		var strBlock = '';
		if (arrPoint.blockid != '')
		{
			 strBlock = 'type="block" blockid="'+ arrPoint.blockid+ '"';
		}
		html = '<div class="block" ' + strBlock + '><table  border="0" cellspacing="0" cellpadding="0">'
			 + '<tr><td class="qul">&nbsp;</td><td class="qum">' + value 
			 + '</td><td class="qur" width="5">&nbsp;</td> </tr>' 
			 + '<tr><td class="sanjiao" colspan="3">&nbsp;</td></tr> </table></div>';
		Draw.addOverlay({lng : arrPoint.lng, lat : arrPoint.lat}, html);
		$('.block').parent().css('z-index', '50');
	},

	drawMetro: function(arrMetorPoint)
	{
		var arrNewMetroPoint = arrMetorPoint['project'];
		var html = '';
		for(var i in arrNewMetroPoint) {
			 html = '<div class="mapfinding" type="speical"><table  border="0" cellspacing="0" cellpadding="0">'
				 + '<tr><td class="qul">&nbsp;</td><td class="qum" ><img src="images/icon005.gif" /><font color="#333333">'
				 + arrNewMetroPoint[i].sitename + '</font></td><td class="qur" width="5">&nbsp;</td> </tr>' 
				 + '<tr><td class="sanjiao" colspan="3">&nbsp;</td></tr> </table></div>'; 
			Draw.addOverlay({lng : arrNewMetroPoint[i].lng, lat : arrNewMetroPoint[i].lat}, html);
		}
		$('.mapfinding').parent().css('z-index', '50');
	},

	drawSchool: function(arrSchoolPoint)
	{
		var html = '<div class="mapfinding" type="speical"><table  border="0" cellspacing="0" cellpadding="0">'
				 + '<tr><td class="qul">&nbsp;</td><td class="qum" ><img src="images/icon003.gif" /><font color="#333333">'
				 + arrSchoolPoint.schoolname + '</font></td><td class="qur" width="5">&nbsp;</td> </tr>' 
				 + '<tr><td class="sanjiao" colspan="3">&nbsp;</td></tr> </table></div>'; 
		Draw.addOverlay({lng : arrSchoolPoint.lng, lat : arrSchoolPoint.lat}, html);
		$('.mapfinding').parent().css('z-index', '50');
	},

	addMark: function(point, index)
	{
		var myIcon = new BMap.Icon('images/icon_' + index + '.gif', new BMap.Size(16, 16), {    
		   offset: new BMap.Size(-11, -31) 
		 });    
		 var marker = new BMap.Marker(point, {icon: myIcon}); 
		 MyIcon[index].push(marker);
		 objMap.addOverlay(marker);  
	}
}
