<?php

class VasRecord{
     /**
     *
     * @var TINY_ADODB ݿ
     */
    protected $db;
    /**
     *
     * @var TINY_ADODB ݿ
     */
    protected $dbback;
    /**
     *
     * @var Memcache 
     */
    protected $mc;
    /**
     *
     * @var string 
     */
    protected $table;
    /**
     *
     * @var ֶ 
     */
    protected $fields;
    
    /**
     * ʼ
     * @param string $table ĬΪgrowth_bid_periods
     */
    public function __construct($table='') {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->table = $table;
        $this->mc = $container->get('mc');
        $sqlfield = "DESC $this->table";
        $fieldsMKey = $sqlfield;
        $this->fields = $this->mc->get($fieldsMKey);
        if($this->fields === false) {
            $fields = $this->dbback->getAll($sqlfield);
            foreach ($fields as $field) {
                $this->fields[] = $field['Field'];
            }
            $this->mc->set($fieldsMKey, $this->fields, 3600);
        }
    }
    
    
    
    
    
    
    /*
     * ݾuidҼ¼
     */
     public function findByBroker($uid,$order='',$limit='',$offset='') {
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, "uid='$uid'");
        if($order) {
            $sql .= " ORDER BY $order";
        }
        if($limit && $offset){
          $sql .= " LIMIT ".$offset.",".$limit;
         }elseif($limit) {
            $sql .= " LIMIT $limit";
        }

        return $this->db->GetAll($sql);
    }
    
    /*
     * ݾid״̬ͳ
     */
	public function findCountByBrokerAndStatus($uid,$status=1) {
		$sql = SqlCombinHelper::count_sql($this->table, "uid=$uid and status $status");
        return $this->dbback->getOne($sql);
	}  
    
    /**
     * ݼ¼idȡ¼
     */
    public function findTypeByRecordId($id){
        $sql = SqlCombinHelper::select_sql($this->table, 'type',
                "id = $id");
        return $this->dbback->getOne($sql);
    }
    
    /*
     * ͳ
     */
    public function findNumberBy($conf) {
        $sql = SqlCombinHelper::count_sql($this->table, $conf);
        return $this->dbback->getOne($sql);
    }
    
    public function findBy($conf,$order='',$limit='',$offset='') {
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields,$conf);
       //$sql = SqlCombinHelper::innerSelect_sql($this->table, 'broker', implode(",", $this->fields).',agentcode' , "$this->table.broker_id=broker.uid", $conf);
        if($order) {
            $sql .= " ORDER BY $order";
        }
        if($limit && $offset){
          $sql .= " LIMIT ".$offset.",".$limit;
         }elseif($limit) {
            $sql .= " LIMIT $limit";
        }

        return $this->db->GetAll($sql);
    }
    
    /*
     * ͳŶ
     */
    public function queueNumber($type){
        $conf = "type='type' and status=1";
        return $this->findNumberBy($conf);
    }
    
    /*
     * ͳʹĳ
     */
    public function usingNumber($type){
        $conf = "type='type' and status=2";
        return $this->findNumberBy($conf);        
    }
    
    
    
    /**
     * ȡĳԴ
     * @param type $bid
     * @param type $houseId
     * @return type
     */
    public function findByBrokerAndHouseId($uid, $houseId) {
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields,
                "uid = $uid  AND house_id = $houseId ");
        return $this->dbback->getRow($sql);
    }
   
    /**
     * Ѿʹù
     * @param type $fieldData
     * @return boolean
     */
    public function usedNumber(){
        $field = "count(uid)";
        $strWhere = "type = 3 ";
        $sql = SqlCombinHelper::select_sql($this->table, $field, $strWhere);
        $sql .= "group by uid";
        return $this->dbback->GetOne($sql);
    }

   
    

    public function insert($fieldData) {
        if($this->checkField($fieldData)){
            $sql = SqlCombinHelper::insert_sql($this->table, $fieldData);
            $this->db->execute($sql);
            return $this->db->Insert_ID();
        } else {
            return false;
        }
    }
    
   

    /**
     * 
     * @param array $fieldData
     * @param string $conf
     * @return boolean
     */
    public function update($fieldData,$conf) {
        if($this->checkField($fieldData)){
            $sql = SqlCombinHelper::update_sql($this->table, $fieldData, $conf);
            $this->db->Execute($sql);
            return $this->db->Affected_Rows();
        } else {
            return false;
        }
    }

   
    /**
     * Ƿȷ
     * @param array $fields Ҫ
     * @return boolean ȷtrueʧܷfalse
     */
    public function checkField($fieldData) {
        $fields = array_keys($fieldData);
        if(array_intersect($fields, $this->fields)==$fields){
            return true;
        } else {
            return false;
        }
    }
    
 
    
    public function getTable() {
        return $this->table;
    } 

  
    
    
    public function getFields() {
        return $this->fields;
    }
    /**
     * ձ
     */
    public function emptyAll() {
        $sql = "DELETE FROM $this->table";
        return $this->db->Execute($sql);
    }
    
    public function insertMutl(array $filedData) {
        $sql = SqlCombinHelper::insertMutil_sql($this->table, $filedData);
        $this->db->execute($sql);
        return $this->db->Affected_Rows();
    }
    
    
    
    
}
