<?php

/*
 * ȨУزˮ
 */

/**
 * Description of GrowthBrokerBid
 *
 * @author Administrator
 */
class GrowthBrokerBidSchoolExpert {
    
    const HOUSE_NUMBER_LIMIT = 4;
    const BID_ERROR_AUTH_IS_PAY = 1;//ʾǸѾ
    const BID_ERROR_AUTH_CREDIT = 2;//ʾֲ
    const BID_ERROR_AUTH_HOUSE=3;//ʾڸСķԴ
    const BID_ERROR_AUTH_LEVEL=4;//ʾ˵ȼ
    const BID_ERROR_AUTH_SCORE = 5;//ʾͶĻֲ
    const BID_ERROR_SYS_DB = 10;//ݿ
    const BID_ERROR_FINISH = 100;//ͶύͶ
    const BID_ERROR_MIN_TIME = 200;//ʱ䲻

    const BID_NEED_SCORE_TYPE_WIN = 2;//Ͷ
    const BID_NEED_SCORE_TYPE_NOT_WIN_1 = 1;//δͶ,Ͷ>=4
    const BID_NEED_SCORE_TYPE_NOT_WIN_0 = 0;//δͶ,Ͷ<4

    const BID_MIN_TIME = 2;//ͶСʱ,λ
    
    /**
     * ģʽ 򷿶ģʽ
     * @var type 
     */
    private $mode;

        /**
     * 1,ɹ 2,ʧ,3,δͶ,4,δͶ,5,Ͷ
     * @var type 
     */
    public static $bidBehavior = array(
        'success' => 1, 'failure' => 2, 'noPut' => 3, 
        'noHit' => 4, 'on' => 5, 'tempHit' => 6
    );
    
    public static $bidProjectName = 'ѧר';
    
    private $broker;
    /**
     *
     * @var GrowthBid 
     */
    private $growthBid;
    /**
     *
     * @var GrowthBidRecordOn 
     */
    private $growthBidRecord;
    /**
     *
     * @var GrowthBidRecordHistory 
     */
    private $growthBidRecordHistory;
    
    /**
     *
     * @var GrowthBrokerCredit 
     */
    private $growthBrokerCredit;
    
    /**
     *
     * @var Adodb 
     */
    private $dbback;
    
    private $brokerBlock;
    /**
     *
     * @var Ͷ 
     */
    private $schoolExpertBidsNew;
    /**
     *
     * @var array 
     */
    private $bidError;
    
    private $growthBidPeriods;

    /**
     * Զ徺Ͷб
     * @var type 
     */
    private $customNumberList = array();

    private $additionalScore=1;
    /**
     * 
     * @param array $broker array("id"=>'','agentcode'=>'','agentname'=>'','level'=>'','is_pay'=>'')
     */
    public function __construct($broker,$growthBrokerCredit,$mode='credit') {
        $this->dbback = Container::getInstance()->get('dbback');
        $this->broker= $broker;
        $this->growthBid = new GrowthBidSchoolExpert();
        $this->growthBidRecord = new GrowthBidSchoolExpertRecordOn();
        $this->growthBidRecordHistory = new GrowthBidSchoolExpertRecordHistory();
        $this->growthBrokerCredit = $growthBrokerCredit;
        $this->growthBidPeriods = new GrowthBidPeriods();
        $this->mode = $mode;
    }
    
    /**
     * ׷ӵͷ
     * @param type $additionalScore
     */
    public function setAdditionalScore($additionalScore) {
        $this->additionalScore = $additionalScore;
    }

    /**
     * ȡ׷ӷ
     * @return type
     */
    public function getAdditionalScore() {
        return $this->additionalScore;
    }

    public function setCustomNumberList($customNumberList) {
        $this->customNumberList = $customNumberList;
    }
    
    public function getCustomExpertNumberList() {
        return $this->customNumberList;
    }
    
    public function bid($bidId,$score) {
        //var_dump($this->controlTime());exit;
        if($this->controlTime()==false) {
            $this->bidError['errorCode'] = self::BID_ERROR_MIN_TIME;
            return false;
        }
        $brokerId = $this->broker['id'];
        $bid = $this->growthBid->findById($bidId);
        if(!$bid) {
            return false;
        }
        $bidPeriodsId = $bid['bid_periods_id'];
        $schoolId = $bid['school_id'];
        $schoolMg = new School();
        $school = $schoolMg->findOneBy($schoolId);//ѧ
        //ҵľͶ¼
        $myRecord = $this->growthBidRecord->findOneBy($brokerId, $bidId);
        //Ͷļ¼
        $winnerRecord = $this->findTempWinnerRecord($bid);
        $x = $this->checkByRecord($bid,$score,$winnerRecord,$myRecord);
        if($x) {
            //ԾͶ
            //жϵǰ־Ͷ״̬-1δͶ0δͶУ1234Ͷ˵ǰ׷
            $winFlag = $this->checkWinBid($winnerRecord, $myRecord);
            switch ($winFlag) {
                case '-1'://δͶ
                    //״--ӾͶ¼statua=1μӾͶnumber=number+1score
                    $fieldData = array('broker_id'=>$brokerId,
                        'bid_id'=>$bidId,
                        'score'=>$score,
                        'school_id'=>$schoolId,
                        'school_name'=>$school['schoolname'],
                        'bid_periods_id'=>$bidPeriodsId);
                    $recordId = $this->growthBidRecord->insert($fieldData);
                    
                    if($recordId) {
                        //
                        $this->growthBid->addJoinNumber($bidId);
                        //
                        $this->growthBrokerCredit->frozenCredit($score,null,'','ѧרҾͶͶ롾'.$school['schoolname'].'');
                        //˷
                        $this->complete($bid);
                        //ͳжʹ
                        $growthBidUserBroker = new GrowthBidUserBroker();
                        $growthBidUserBroker->addJoinBidSchoolExpertRecord($brokerId);
                        
                        //ͬʱע
                        if(!$this->hasAttention($bidId)) {//ûע
                            $attentionNumber = GrowthBidAttentionHelper::totalNumber($this->broker);
                            if($attentionNumber<GrowthBidAttentionHelper::ATTENTION_MAX_NUMBER) {
                                $this->attent($bidId,$bidPeriodsId);
                            }
                        }
                        
                    } else {
                        $this->bidError['errorCode'] = self::BID_ERROR_SYS_DB;
                        //¼־
                    }
                    break;
                case '0'://ͶδͶ
                    $fieldData = array('score'=>$score,'status'=>'1');
                    $conf = "broker_id='$brokerId' and bid_id='$bidId'";
                    $affectRows = $this->growthBidRecord->update($fieldData, $conf);
                    if($affectRows) {
                        //$this->growthBrokerCredit->frozenCredit($score);
                        $this->growthBrokerCredit->frozenCredit($score,null,'','ѧרҾͶͶ롾'.$school['schoolname'].'');
                        //֣ľˣbid=$bidand ֡score and status = 1
                        //ּ¼ ⶳ֣frozen= frozen-scoreע֪ͨ
                        $this->complete($bid);
                    } else {
                        
                    }
                    
                    break;
                case '1'://׷
                case '2':
                case '3':
                case '4':
                    $fieldData = array('score'=>$score);
                    $conf = "broker_id='$brokerId' and bid_id='$bidId'";
                    $affectRows = $this->growthBidRecord->add($fieldData, $conf);
                    if($affectRows) {
                        //$this->growthBrokerCredit->frozenCredit($score);
                        $this->growthBrokerCredit->frozenCredit($score,null,'','ѧרҾͶ׷ӡ'.$school['schoolname'].'');
                    } else {
                        
                    }
                    break;
                default:
                    break;
            }
            //ھ͸£ھͲ(Ͷ״Ͷ֣Ǻӷ)X
            
            
            //ӷ--¼¼status=1scoreX
            
            //ּ¼
            return true;
        } else {
            return false;
        }
    }
    
    public function complete($bid) {
        //֣ľˣbid=$bidand ֡score and status = 1
        //ּ¼ ⶳ֣frozen= frozen-scoreע֪ͨ
        $refundRecord = $this->findRecordForRefund($bid);
        if($refundRecord) {
            //ЩΪʧ
            $ids = array();
            $refundBroker = array();
            foreach ($refundRecord as $value) {
                $ids[] = $value['id'];
                $temp = array();
                $temp['broker_id'] = $value['broker_id'];
                $temp['score'] = "-".$value['score'];
                $temp['school_name'] = $value['school_name'];
                $refundBroker[] = $temp;
            }
            //statusΪʧ
            $this->growthBidRecord->update(array('status'=>0), "id in ('".  implode("','", $ids)."')");
            //ⶳ
            if($refundBroker) {
                //$growthCredit = $this->growthBrokerCredit->getGrowthCredit();
                foreach ($refundBroker as $value) {
                    $this->growthBrokerCredit->frozenCredit($value['score'],$value['broker_id'],'','ѧרҾͶʧܷ'.$value['school_name'].'');
                    //$growthCredit->unfreeze($value['broker_id'],$value['score']);
                }
            }
            
        }
        
    }

    public function getBidError() {
        return $this->bidError;
    }

    /**
     * ǷԾͶ3
     * @param int $bidId
     * @return boolean
     */
    public function check($bid,$score) {
        return false;
        if($this->checkBroker()&&$this->checkCredit($score)) {
            //$bid = $this->growthBid->findByBidId($bidId);
            if($bid) {
                //ͶķǷڱξͶǰҪͷ
                $this->getNeedScore($bid,$winnerRecord,$myRecord);
                $schoolId = $bid['broker_id'];
                $bidBrokerLevel = $bid['broker_level'];//ԾͶĵȼ
                return $this->checkHouseNumber($schoolId)&&$this->checkBrokerLevel($bidBrokerLevel);
            } else {
                return false;
            }
        } else {
            return false;
        }
    }
    
    /**
     * ṩľͶ;Ͷ¼жǷԾͶ
     * @param array $bid
     * @param int $score
     * @param array $winnerRecord
     * @param array $myRecord
     * @return boolean
     */
    public function checkByRecord($bid,$score,$winnerRecord,$myRecord) {
        //ʱ
        //$bidڵڴ
        $bidPeriodsId = $bid['bid_periods_id'];
        $bidPeriods = $this->growthBidPeriods->findById($bidPeriodsId);
        if(!GrowthBidPeriods::isBidOn($bidPeriods)) {
            //Ͷ
            $this->bidError['errorCode']= self::BID_ERROR_FINISH;
            return false;
        }
        if($this->checkBroker()&&$this->checkCredit($score)) {
            //$bid = $this->growthBid->findByBidId($bidId);
            if($bid) {
                //ͶķǷڱξͶǰҪͷ
                $needScore = $this->getNeedScore($bid,$winnerRecord,$myRecord);
                
                if($this->checkScore($score, $needScore)) {
                    $schoolId = $bid['school_id'];
                    $bidBrokerLevel = $bid['broker_level'];//ԾͶĵȼ
                    return $this->checkHouseNumber($schoolId)&&$this->checkBrokerLevel($bidBrokerLevel);
                } else {
                    return false;
                }
                
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    /**
     * ͶĻǷС
     * @param int $score
     * @param array $needScore $this->getNeedScore($bid,$winnerRecord,$myRecord)ֵ
     */
    public function checkScore($score,$needScore) {
        $type = $needScore['type'];
        $flag = $score>=$needScore['score'];
        if(!$flag) {
            $this->bidError['errorCode']= self::BID_ERROR_AUTH_SCORE;
            return false;
        }
        return true;
    }


    /**
     * ֹ
     * @param int $score
     * @return boolean
     */
    public function checkCredit($score) {
        $myCredit = $this->broker['credit'];
        if($myCredit<$score) {
            $this->bidError['errorCode']= self::BID_ERROR_AUTH_CREDIT;
            return false;
        }
        return true;
    }

    /**
     * 龭ǷǸѾˣ
     * 
     */
    public function checkBroker() {
        if($this->broker['is_pay']==0){
            return true;
        } else {
            $this->bidError['errorCode']= self::BID_ERROR_AUTH_IS_PAY;
            return false;
        }
    }
    //ǷиС4ϷԴ,
    public function checkHouseNumber($schoolId) {
        $brokerid = $this->broker['id'];
        $sql = "SELECT count(school_block.school_id) FROM school_block LEFT JOIN sell on school_block.block_id = sell.blockid where sell.uid = '$brokerid' AND school_block.school_id='$schoolId' AND  sell.esta=1 AND sell.infofrom=5";
       // $sql = "SELECT count(blockid) FROM `sell` WHERE uid = '$brokerid' and blockid='$blockId' and  esta=1 and infofrom=5";
        $houseNumber = $this->dbback->getOne($sql);
        if($houseNumber>=self::HOUSE_NUMBER_LIMIT) {
            return true;
        } else {
            $this->bidError['errorCode']= self::BID_ERROR_AUTH_HOUSE;
            return false;
        }
    }
    //˵ȼǷСȼ
    public function checkBrokerLevel($bidBrokerLevel) {
        $brokerLevel = $this->broker['level'];//˵ȼ
        $arr = explode(",", $bidBrokerLevel);
        if(in_array($brokerLevel, $arr)) {
            return true;
        } else {
            $this->bidError['errorCode']= self::BID_ERROR_AUTH_LEVEL;
            return false;
        }
    }

    /**
     * ҾȫõѧרҾͶ
     */
    public function findAllBid($houseNumber) {
        $schoolids = $this->findAllSchoolHouserNumber($houseNumber);
        $brokerLevel = $this->broker['level'];
        //$bLevelHeat = new BlockLevelHeat();
        $conf = "school_id in ('".implode("','", $schoolids)."') and broker_level like '%LV".$brokerLevel."%'";
        $bids = $this->growthBid->findBy($conf);
        //$blockLevel = $bLevelHeat->findBy("block_id,level", "block_id in ('".implode("','", $blockids)."')", 0);
        //print_r($bids);
        return $bids;
    }
    
    /**
     * Ҿ˵ķԴڵ$houseNumberԴѧ
     * @param int $houseNumber Դ
     * @return array Сid
     */
    public function findAllSchoolHouserNumber($houseNumber=0) {
        $brokerid = $this->broker['id'];
        $sql = "SELECT school_block.school_id,count(school_block.school_id)  FROM school_block LEFT JOIN sell ON school_block.block_id = sell.blockid  WHERE sell.uid='$brokerid' AND sell.esta=1 AND sell.isstar=3 AND sell.infofrom=5 GROUP BY school_block.school_id";
        $this->brokerSchool = $this->dbback->getAssoc($sql);
        $temp= array();
        if($this->brokerSchool) {
            foreach ($this->brokerSchool as $key=>$value) {
                if($value>=$houseNumber) {
                    $temp[] = $key;
                }
            }
        }
        return $temp;
        //return $this->brokerSchool;
    }
    
    public function findAllBlock($blockids) {
        ///
    }
    
    public function hasAttention($bidId) {
        //Ƿע
        $growthAttention = new GrowthBidAttention();
        $brokerId = $this->broker['id'];
        $conf = "broker_id='$brokerId' and type=4 and target_id='$bidId'";
        $number = $growthAttention->findNumberBy($conf);
        if($number==1) {
            return true;
        } else {
            return false;
        }
    }
    
    /**
     * ǷԹע
     * @param int $bidid Ͷid
     */
    public function checkAttention($bidId) {
        if($this->hasAttention($bidId)) {
            return false;
        }
        if($this->checkBroker()) {
            $bid = $this->growthBid->findById($bidId);
            if($bid) {
                $schoolId = $bid['school_id'];
                $bidBrokerLevel = $bid['broker_level'];//ԾͶĵȼ
                return $this->checkHouseNumber($schoolId)&&$this->checkBrokerLevel($bidBrokerLevel);
            } else {
                return false;
            }
        } else {
            return false;
        }
    }
    
    public function findAttention($bidPeriodsId) {
        $brokerId = $this->broker['id'];
        $growthAttention = new GrowthBidAttention();
        return $growthAttention->findBy("broker_id='$brokerId' and bid_periods_id='$bidPeriodsId' and type=4");
    }
    
    public function attent($bidId,$cBidPeriods) {
        $fieldData = array();
        $fieldData['broker_id'] = $this->broker['id'];
        $fieldData['type'] = 4;
        $fieldData['target_id'] = $bidId;
        $fieldData['bid_periods_id'] = $cBidPeriods;
        $growthAttention = new GrowthBidAttention();
        return $growthAttention->insert($fieldData);
        
    }
    
    public function cancelAttent($attentionId) {
        $growthAttention = new GrowthBidAttention();
        $brokerId = $this->broker['id'];
        $conf = "id='$attentionId' and broker_id='$brokerId'";
        return $growthAttention->delBy($conf);;
    }
    
    /**
     * ڴidұڲľͶ¼
     * @param int $bidPeriodsId
     * @return array Ͷ¼
     */
    public function findBidRecord($bidPeriodsId=0) {
        $brokerId = $this->broker['id'];
        if($bidPeriodsId) {
            $conf = "broker_id='$brokerId' and bid_periods_id='$bidPeriodsId'";
            return $this->growthBidRecord->findBy($conf);
        } else {
            return $this->growthBidRecord->findByBrokerId($brokerId);
        }
    }
    
    /**
     * Ҿ˵ľͶʷ¼
     * @param int $bidPeriodsId
     * @param string $order
     * @param string $limit
     * @return array
     */
    public function findBidHistoryRecord($bidPeriodsId=0,$schoolName='',$order='',$limit='') {
        $brokerId = $this->broker['id'];
        $conf = "broker_id='$brokerId'";
        if($bidPeriodsId) {
            $conf .= " and bid_periods_id='$bidPeriodsId'";
        } 
        if($schoolName) {
            $conf .= " and school_name like '%$schoolName%' ";
        }
        return $this->growthBidRecordHistory->findBy($conf,$order,$limit);
    }

    public function findBidHistoryRecordNumber($bidPeriodsId=0,$schoolName='') {
        $brokerId = $this->broker['id'];
        $conf = "broker_id='$brokerId'";
        if($bidPeriodsId) {
            $conf .= " and bid_periods_id='$bidPeriodsId'";
        } 
        if($schoolName) {
            $conf .=" and school_name like '%$schoolName%'";
        }
        return $this->growthBidRecordHistory->findNumberBy($conf);
    }

    /**
     * Ҳѧ
     * @return array С
     */
    public function findSchoolBid() {
        $bidRecords = $this->findBidRecord();
        $schools = array();
        if($bidRecords) {
        foreach($bidRecords as $b) {
            $schools[$b['school_id']] = $b['school_name'];
        }
        }
        return $schools;
    }
    
    /**
     * ͶûԼڼλ
     * @param array $winnerRecord
     * @param array $myRecord
     * @return int Σ0ʾδͶУ1234ʾڼλ -1,ʾûͶ
     */
    public function checkWinBid($winnerRecord,$myRecord) {
        $number = 0;
        if($myRecord&&$winnerRecord) {
            $myRecordId = $myRecord['id'];
            $i = 0;
            foreach ($winnerRecord as $value) {
                $i++;
                if($value['id']==$myRecordId) {
                    $number = $i;
                    break;
                }
            }
        } else {
            $number = '-1';
        }
        return $number;
    }
    
    /**
     * ӮþͶļ¼statusж
     * @param type $bidId
     */
    public function findWinner($bidId) {
        
    }

    /**
     * ʱӮþͶ˵ľͶ¼
     * @param int $bid Ͷ
     * @return array Ͷļ¼
     */
    public function findTempWinnerRecord($bid) {
        $bidId = $bid['id'];
        $maxWinNumber = $bid['max_win_number']?$bid['max_win_number']:4;
        return $this->growthBidRecord->findByBid($bidId, "score desc, utime asc", "0,$maxWinNumber");
    }
    
     /**
     * ӮþͶ˵ľͶ¼
     * @param int $bidId Ͷid
     * @return array Ͷļ¼
     */
    public function findWinnerRecord($bid) {
        $bidId = $bid['id'];
        $maxWinNumber = $bid['max_win_number']?$bid['max_win_number']:4;
        return $this->growthBidRecordHistory->findBy("bid_id='$bidId' and status=1", "score desc, utime asc", "0,$maxWinNumber");
    }
    /**
     * 
     * @param int $bid
     * @return array
     */
    public function findRecordForRefund($bid) {
        $bidId = $bid['id'];
        $maxWinNumber = $bid['max_win_number']?$bid['max_win_number']:4;
        $res = $this->growthBidRecord->findBy("bid_id='$bidId' and status=1", "score desc, utime asc", "$maxWinNumber,10");
        if($res) {
            return $res;
        } else {
            return array();
        }
    }
    
    public function isWinBid($bidId) {
        
    }
    
    /**
     * ؾͶҪͶͻ
     * @return array $result = array('type'=>'','score'=>'');typeʾǷģ0ķ,1,ķ֣2,׷ӷ
     */
    public function getNeedScore($bid,$winnerRecord,$myRecord) {		
        //Ͷû
        $score = 0;
        $result = array('type'=>'','score'=>'');
        if($this->checkWinBid($winnerRecord, $myRecord)>0) {//Ͷ
                $result['type'] = self::BID_NEED_SCORE_TYPE_WIN;
                $result['score'] = $this->additionalScore;
        } else {//δͶ
            $maxWinNumber = $bid['max_win_number']?$bid['max_win_number']:4;
            if(count($winnerRecord)==$maxWinNumber) {
                $result['type'] = self::BID_NEED_SCORE_TYPE_NOT_WIN_1;
                $result['score'] = $winnerRecord[$maxWinNumber-1]['score']+1;//$this->additionalScore;
            } else {
                $result['type'] = self::BID_NEED_SCORE_TYPE_NOT_WIN_0;
                $result['score'] = $bid['min_score'];
            }
        }
        return $result;
    }
    
    /**
     * һͶķ
     * @param array $bid
     */
    public function lastBidScore($myRecord) {
        if($myRecord) {
            return  $myRecord['score'];
        } else {
            return 0;
        }
        
    }
    
    /**
     * ؾͶϵʾֹʾ
     * @param int $myCredit ҵĻ
     * @param array $needScore ͶҪĻ ͨ getNeedScore($bid,$winnerRecord,$myRecord)
     * @return string ʾַ
     */
    public function tipOnPanel($myCredit,$needScore) {
        //$needScore = $this->getNeedScore($bid,$winnerRecord,$myRecord);
        $tip = "";
        if($needScore) {
            $type = $needScore['type'];
            $minScore = $needScore['score'];
            if($this->mode='dou') {
                $t = "".$this->modeString()."Ŷ ";
            } else {
                $t = "".$this->modeString()."Ŷ ".'<a target="_blank" href="./my_growth.php">ȥ׬'.$this->modeString().'&gt;&gt;</a>';
            }
            if($type == 0) {
                $tip = $myCredit<$minScore?$t:"";
            }
            if($type == 1) {
                $tip = $myCredit<$minScore?$t:"";
            }
            if($type == 2) {
                $tip = $myCredit<1?$t:"";
            }
        }
        return $tip;
    }
    
    /**
     * Ͷɹʧܵʾ
     * @param array $myRecord
     * @param int $winFlag
     * @return string
     */
    public function tip1OnPanel($myRecord,$winFlag,$maxWinNumber=4) {
        $myScore = $this->lastBidScore($myRecord);
        if($winFlag=='-1') {
            $tip2 = "";
        } elseif($winFlag==0) {
            $tip2 = "Ͷ".$myScore."".$this->modeString().",δǰ".$maxWinNumber."˻";
        } else {
            $tip2 = "Ͷ".$myScore.$this->modeString();
        }
        return $tip2;
    }
    
    /**
     * Ͷ
     * @param array $needScore
     * @return array
     */
    public function scoreInputDefault($needScore,$myScore) {
        $default = array('span'=>'','value'=>'','totalTip'=>'');
        if($needScore) {
            $type = $needScore['type'];
            $minScore = $needScore['score'];
            if($type == 0) {
                $default['value'] = "".$minScore;
                $default['span'] = "ҪͶ";
                $default['totalTip'] = '';
            }
            if($type == 1) {
                $default['value'] = "".$minScore;
                $default['span'] = "ҪͶ";
                $default['totalTip'] = "";
            }
            if($type == 2) {
                $default['value'] = "".$minScore;
                $default['span'] = "Ҫ׷";
                $default['totalTip'] = 'Ͷ'.$this->modeString().':<span class="calScore" value="'.$myScore.'" style="width: 21px; color: red;">'.$myScore.'</span>'.$this->modeString(2);
            }
        }
        return $default;
    }
    
    /**
     * ɼʱԲ
     * @param string $startTime ͶƱʼʱ
     * @param string $endTime ͶƱʱ
     */
    public function TimeRing($startTime,$endTime) {
        $time = time();
        $stime= strtotime($startTime);
        $etime= strtotime($endTime);
        $hours = ($etime-$stime)/3600;
        $ev = $hours/4;
        if($time>=$stime&&$time<$stime+3600*$ev) {
            return 1;
        } elseif($time>=$stime+3600*$ev&&$time<$stime+3600*$ev*2) {
            return 2;
        } elseif($time>=$stime+3600*$ev*2&&$time<$stime+3600*$ev*4) {
            return 3;
        } else {
            return 4;
        }
    }
    
    /**
     * Ͷб
     */
    public function get_bid_school_expert_list($schools,$cBidPeriods,$myrecords) {     
        $myCredit = $this->broker['credit'];
            $list = array();
            if($schools) {//С
                //print_r($cBidPeriods);
                    $schoolsNew = SqlCombinHelper::changeToKeyArray($schools, 'id');
                    $schoolids = array_keys($schoolsNew);
                    $bidPeriodsStatus = $cBidPeriods['status'];
                    $cBidPeriodsId = $cBidPeriods['id'];
                    $cBidPeriodsTgStartTime = $cBidPeriods['tg_start_time'];//ƹʱ
                    $cBidPeriodsTgEndTime = $cBidPeriods['tg_end_time'];
                    $cBidPeriodsStartTime = $cBidPeriods['start_time'];//Ͷʼʱ
                    $cBidPeriodsendTime = $cBidPeriods['end_time'];//Ͷʱ
                    //ѧͶ
                    $growthBidSchoolExpert = new GrowthBidSchoolExpert();
                    $schoolExpertBids = $growthBidSchoolExpert->findBy("school_id in ('".implode("','", $schoolids)."') and bid_periods_id='$cBidPeriodsId'",array("school_level"=>"asc"));
                    $schoolExpertBidsNew = SqlCombinHelper::changeToKeyArray($schoolExpertBids, 'school_id');
                    //ע¼
                    $attentionList = $this->findAttention($cBidPeriodsId);
                    //Ԥ
                    $attentionListNew = SqlCombinHelper::changeToKeyArray($attentionList, 'target_id');
                    //print_r($attentionListNew);
                    if($bidPeriodsStatus==1) {
                        //ھͶ
                        //ҶӦľͶid
                        foreach($schoolExpertBidsNew as $key=>$bid) {
                            $temp = array();
                            $tempBid = $bid;
                            $temp['bid'] = $tempBid;
                            $b = $schoolsNew[$tempBid['school_id']];
                            $schoolId = $b['id'];
                            $temp['school_id'] = $schoolId;
                            $temp['school_name'] = $b['schoolname'];
                            $temp['school_image'] = $b['coverphoto']?$b['coverphoto']:'<?=STATIC_SOURCE_URL?>/zsb/images/v1.0/nopic1.gif';
                            $temp['school_heat_level'] = $tempBid['school_level'];//Сȶȵȼ
                            //ͶϢ
                            $temp['bid_id'] = $tempBid['id'];
                            $temp['bid_status'] = $bidPeriodsStatus;
                            $temp['bid_status_str'] = 'Ͷ';
                            $temp['tg_start_time'] = $cBidPeriodsTgStartTime;//ƹʱ
                            $temp['tg_end_time'] = $cBidPeriodsTgEndTime;//ƹʱ
                            $temp['time'] = $cBidPeriodsendTime;//Ͷʱ
                            $temp['timeRing'] = $this->TimeRing($cBidPeriodsStartTime, $cBidPeriodsendTime);
                            $temp['number'] = $tempBid['number'];//μ
                            //Ͷǰ4λ
                            $temp['record'] = $this->findTempWinnerRecord($tempBid);
                            //print_r($tempBid);
                            //print_r($tempRecord);exit;
                            //ע״̬
                            if(array_key_exists($tempBid['id'], $attentionListNew)) {
                                $temp['attention_id'] = $attentionListNew[$tempBid['id']];
                            } else {
                                $temp['attention_id'] = array();
                            }
                            //ļ¼
                            //echo $tempBid['id'].'x';
                            if(array_key_exists($tempBid['id'], $myrecords)) {
                                $temp['my_record'] = $myrecords[$tempBid['id']];//ҵļ¼
                            } else {
                                $temp['my_record'] = array();//ҵļ¼
                            }
                            $temp['my_credit'] = $myCredit;//ҵĿû
                            //ͳ
                            $allBidStat = $this->allPrevBidStat();
                            $temp['all_prev_stat'] = array_key_exists($schoolId, $allBidStat)?$allBidStat[$schoolId]:array();
                            //Ļ
                            //㣬ûͶ
                            //ϴͶĻ
                            $temp['my_score'] = $this->lastBidScore($temp['my_record']);
                            //ͻ֣Ǹ
                            $temp['min_score'] = $this->getNeedScore($tempBid, $temp['record'], $temp['my_record']);
                            //ʾ
                            $temp['tip'] = $this->tipOnPanel($temp['my_credit'], $temp['min_score']);
                            //ǷͶб
                            $winFlag = $this->checkWinBid($temp['record'], $temp['my_record']);
                            $temp['winFlag'] = $winFlag;
                            //ʾ1
                            $temp['tip1'] = $this->tip1OnPanel($temp['my_record'], $winFlag,$tempBid['max_win_number']); 
                            //Ĭ
                            $temp['score_input_default'] = $this->scoreInputDefault($temp['min_score'],$temp['my_score']);
							$temp['type']=4;
                            $list[] = $temp;
                        }  
                    }

                    if($bidPeriodsStatus==2) {//¾Ͷûʼ
                        foreach($schools as $b) {
                            $temp = array();
                            $schoolId = $b['id'];
                            $tempBid = $schoolExpertBidsNew[$schoolId];
                            $temp['bid'] = $tempBid;
                            $temp['school_id'] = $schoolId;
                            $temp['school_name'] = $b['schoolname'];
                            $temp['school_image'] = $b['coverphoto']?$b['coverphoto']:'./images/no_img_small.gif';
                            $temp['school_heat_level'] = $tempBid['school_level'];//Сȶȵȼ
                            //ͶϢ
                            $temp['bid_id'] = $tempBid['id'];
                            $temp['bid_status'] = $bidPeriodsStatus;
                            $temp['bid_status_str'] = 'ھͶ';//'ھͶ';
                            $temp['tg_start_time'] = $cBidPeriodsTgStartTime;//ƹʱ
                            $temp['tg_end_time'] = $cBidPeriodsTgEndTime;//ƹʱ
                            $temp['start_time'] = $cBidPeriodsStartTime;//Ͷʼʱ
                            $temp['time'] = $cBidPeriodsendTime;//Ͷʱ
                            $temp['timeRing'] = $this->TimeRing($cBidPeriodsStartTime, $cBidPeriodsendTime);
                            $temp['number'] = $tempBid['number'];//μ
                            $temp['my_credit'] = $myCredit;//ҵĿû
                            $temp['min_score'] = $this->getNeedScore($tempBid, array(), array());
                            $temp['score_input_default'] = $this->scoreInputDefault($temp['min_score'],0);
                            //ڣСͶʷ
                            //$prevRecord =$this->growthBidRecordHistory->findBy("block_id='$blockId' and status=1", "score desc, utime asc", "0,4");
                            //$template = '<div style="float: left; width: 120px;margin-bottom: 2px;"><span class="m_l_33 blod">NO.%s</span><span style="border-right-width: 0px; margin-right: 5px;" class="rank %s">%s</span></div>';
                            //$temp['record_list'] = $this->rankList($prevRecord,  GrowthBidPeriods::BID_PERIODS_STATUS_FINISH,$template,null);
                            //print_r($tempBid);
                            //print_r($tempRecord);exit;
                            //ͳ
                            $allBidStat = $this->allPrevBidStat();
                            $temp['all_prev_stat'] = array_key_exists($schoolId, $allBidStat)?$allBidStat[$schoolId]:array();
                            //ע״̬
                            /**
                            if($attentionListNew[$tempBid['id']]) {
                                //$temp['attention_id'] = $attentionListNew[$tempBid['id']];
                            }**/
                            $list[] = $temp;
                        }  
                    }
                    
                    if($bidPeriodsStatus==3) {
                        foreach($schoolExpertBidsNew as $key=>$bid) {
                            $temp = array();
                            $tempBid = $bid;
                            $temp['bid'] = $tempBid;
                            $b = $schoolsNew[$tempBid['school_id']];
                            $schoolId = $b['id'];
                            $temp['school_id'] = $schoolId;
                            $temp['school_name'] = $b['schoolname'];
                            $temp['school_image'] = $b['coverphoto']?$b['coverphoto']:'./images/no_img_small.gif';
                            $temp['school_heat_level'] = $tempBid['school_level'];//Сȶȵȼ
                            //ͶϢ
                            $temp['bid_id'] = $tempBid['id'];
                            $temp['bid_status'] = $bidPeriodsStatus;
                            $temp['bid_status_str'] = 'Ͷ';
                            $temp['tg_start_time'] = $cBidPeriodsTgStartTime;//ƹʱ
                            $temp['tg_end_time'] = $cBidPeriodsTgEndTime;//ƹʱ
                            $temp['time'] = $cBidPeriodsendTime;//Ͷʱ
                            $temp['timeRing'] = $this->TimeRing($cBidPeriodsStartTime, $cBidPeriodsendTime);
                            $temp['number'] = $tempBid['number'];//μ
                            //Ͷǰ4λ
                            $temp['record'] = $this->findTempWinnerRecord($tempBid);
                            //print_r($tempBid);
                            //print_r($tempRecord);exit;
                            //ͳ
                            $allBidStat = $this->allPrevBidStat();
                            if(array_key_exists($schoolId, $allBidStat)) {
                                $temp['all_prev_stat'] = $allBidStat[$schoolId];
                            } else {
                                $temp['all_prev_stat'] = array();
                            }
                            
                            //ע״̬
                            if(array_key_exists($tempBid['id'], $attentionListNew)) {
                                $temp['attention_id'] = $attentionListNew[$tempBid['id']];
                            }
                            //ļ¼
                            //echo $tempBid['id'].'x';
                            if(array_key_exists($tempBid['id'], $myrecords)){
                                $temp['my_record'] = $myrecords[$tempBid['id']];//ҵļ¼
                            } else {
                                $temp['my_record'] = array();
                            }
                            $temp['my_credit'] = $myCredit;//ҵĿû
                            //Ļ
                            //㣬ûͶ
                            //ϴͶĻ
                            $temp['my_score'] = $this->lastBidScore($temp['my_record']);
                            //ͻ֣Ǹ
                            $temp['min_score'] = $this->getNeedScore($tempBid, $temp['record'], $temp['my_record']);
                            //ʾ
                            $temp['tip'] = $this->tipOnPanel($temp['my_credit'], $temp['min_score']);
                            //ǷͶб
                            $winFlag = $this->checkWinBid($temp['record'], $temp['my_record']);
                            $temp['winFlag'] = $winFlag;
                            //ʾ1
                            $temp['tip1'] = $this->tip1OnPanel($temp['my_record'], $winFlag,$tempBid['max_win_number']); 
                            //Ĭ
                            $temp['score_input_default'] = $this->scoreInputDefault($temp['min_score'],$temp['my_score']);
                            $list[] = $temp;
                        }  
                    }
            }
            //print_r($list);exit;
            return $list;
        }

    public function getAttentionList($cBidPeriods) {
        $bidPeriodsId = $cBidPeriods['id'];
        $attentionList = $this->findAttention($bidPeriodsId);
        //print_r($attentionList);
        if(!$attentionList) {//ûйעؿ
            return array();
        }

        $bidIds = array();
        foreach ($attentionList as $value) {
            $bidIds[] = $value["target_id"];
        }
        //龺Ͷ
        $conf = "id in ('".  implode("','", $bidIds)."')";
        $bids = $this->growthBid->findBy($conf);
        $bids = SqlCombinHelper::changeToKeyArray($bids, "school_id");
	
      
        $schoolIds = array_keys($bids);
        $schoolMg = new School();
        $schools = $schoolMg->findAllBy("id in ('".implode("','", $schoolIds)."')");
        //print_r($blocks);
        //ҵļ¼
        $myrecords = $this->findBidRecord($bidPeriodsId);
        $myrecords = SqlCombinHelper::changeToKeyArray($myrecords, 'bid_id');

        $attentionBidList = array();

        $attentionList = $this->get_bid_school_expert_list($schools, $cBidPeriods, $myrecords);
      
		
       // print_r($attentionList);
        return $attentionList;
    }

    /**
     * б
     * @param array $records ¼
     * @param string $tType  Ͷ״̬GrowthBidPeriods::BID_PERIODS_STATUS_ON;
                                     GrowthBidPeriods::BID_PERIODS_STATUS_NOT_START;
                                     GrowthBidPeriods::BID_PERIODS_STATUS_FINISH//ַonhistory,Ĭon
     * @param type $template
     * @param type $myrecord
     * @return type
     */
    public function rankList($records, $tType = GrowthBidPeriods::BID_PERIODS_STATUS_ON, $template=null, $myrecord = null,$maxWinNumer=4) {
        if(!$records) {$records = array();}
        $records = array_pad($records, $maxWinNumer, array());
        $html = "";
        foreach($records as $k=>$r) {
            //$funcName = "renderRank".ucfirst($tType);
            if($tType==GrowthBidPeriods::BID_PERIODS_STATUS_ON) {
                $html .= $this->renderRankHasScore($k,$r,$myrecord,$template);
            } else {
                $html .= $this->renderRankNoScore($k,$r,$myrecord,$template);
            }
        } 
        return $html;
    }

    /**
     * Ͷеʾ
     * @param type $k
     * @param type $r
     * @param type $myrecord
     * @param type $template
     * @return string
     */
    private function renderRankHasScore($k,$r,$myrecord=null,$template=null) {
        $no = $k+1;
        $rank02 = 'rank02';
        if(!empty($r)) {
            if($myrecord&&$myrecord['id']==$r['id']) {//жǲԼ
                $rank02 = '';
                $score = '<strong class="num">'.$r['score'].'</strong>'.$this->modeString(2);
            } else {
                $score = '<strong class="num">ѱռ</strong>';
            }
        } else {
                $score = '<strong class="num">ȱϯ</strong>';
        }

        if($template) {
            $html = sprintf($template,$no,$rank02,$score);
        } else {
            $html = '<div class="fraction_rank radius3" style="margin: 5px;"><span class="rank '.$rank02.'">NO.'.$no.'</span><span class="fraction">'.$score.'</span></div>';
        }
        return $html;
    }
    /**
     * Ͷʾ
     * @param type $k
     * @param type $r
     * @param type $myrecord
     * @param type $template
     * @return string
     */
    private function renderRankNoScore($k,$r,$myrecord=null,$template=null) {
        $no = $k+1;
        //$rank02 = $no>2?'rank02':'';
        $score = $r&&$r['score']?$r['score']:' ';
        $rank02 = 'rank02';
        if($myrecord) {//жǲԼ
                //echo 'xxx';
                //echo "#".$r['id']."--#".$myrecord['id'];
            if($r&&$r['id']==$myrecord['id']) {
                $rank02 = '';
            }
        }
        if($template) {
            $html = sprintf($template,$no,$rank02,$score);
        } else {
            $html = '<div class="fraction_rank radius3"  style="margin: 5px;"><span class="rank '.$rank02.'">NO.'.$no.'</span><span class="fraction"><strong class="num">'.$score.'</strong>'.$this->modeString(2).'</span></div>';
        }
        return $html;
    }
    /**
     * 鿴Ȩ
     * @param int $bid
     */
    public function checkViewAuth($cBidPeriodsId,$bid) {
        $schoolId = $bid['school_id'];
        $schools = $this->get_valid_bid_school($cBidPeriodsId,array(), '');
        $schools = SqlCombinHelper::changeToKeyArray($schools, "id");
        if(in_array($schoolId, array_keys($schools))) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * пԲ뾺Ͷѧid
     * @param type $cBidPeriodsId
     */
    public function get_valid_bid_school_id($cBidPeriodsId) {
        $schoolids = $this->findAllSchoolHouserNumber(GrowthBrokerBidSchoolExpert::HOUSE_NUMBER_LIMIT);
        //ˣоͶҾ˵ȼ
        //ѧͶ
        $growthBidSchoolExpert = new GrowthBidSchoolExpert();
        $schoolExpertBids = $growthBidSchoolExpert->findBy("school_id in ('".implode("','", $schoolids)."') and bid_periods_id='$cBidPeriodsId'");
        $schoolExpertBidsNew = SqlCombinHelper::changeToKeyArray($schoolExpertBids, 'school_id');
        $this->schoolExpertBidsNew = $schoolExpertBidsNew;
        $schoolids = array();
        //print_r($blockExpertBidsNew);
        foreach ($schoolExpertBidsNew as $value) {
            if($this->checkBrokerLevel($value['broker_level'])) {
                $schoolids[] = $value['school_id'];
            }
        }
        return $schoolids;
    }
    /**
     * ԵСרҾͶС
     * @param type $growthBrokerBidBlockExpert
     * @param array $myrecords ҵľͶ¼
     * @param string $action Ļеı
     * @return array С
     */
    public function get_valid_bid_school ($cBidPeriodsId,$myrecords,$action,$schoolName='') {
        //ҳ˷ҪķԴС
        $schoolids = $this->findAllSchoolHouserNumber(GrowthBrokerBidSchoolExpert::HOUSE_NUMBER_LIMIT);
        //ˣоͶҾ˵ȼ
        //СͶ
        $growthBidSchoolExpert = new GrowthBidSchoolExpert();
        $schoolExpertBids = $growthBidSchoolExpert->findBy("school_id in ('".implode("','", $schoolids)."') and bid_periods_id='$cBidPeriodsId'");
        $schoolExpertBidsNew = SqlCombinHelper::changeToKeyArray($schoolExpertBids, 'school_id');
        $this->schoolExpertBidsNew = $schoolExpertBidsNew;
        $schoolids = array();
        //print_r($blockExpertBidsNew);
        foreach ($schoolExpertBidsNew as $value) {
            if($this->checkBrokerLevel($value['broker_level'])) {
                $schoolids[] = $value['school_id'];
            }
        }
		
        $school = new School();
		
        if($schoolName) {
			//echo "id in ('".  implode("','", $schoolids)."') and schoolname like '%$schoolName%'";exit;
            $schools = $school->findAllBy("id in ('".  implode("','", $schoolids)."') and schoolname like '%$schoolName%'");

        } else {
            $schools = $school->findAllBy("id in ('".  implode("','", $schoolids)."')");
        }
        if(!$schools) {
            $schools = array();
        }
        if($action=='on') {
            $schoolOn = array();//$growthBrokerBidBlockExpert->findBlockBid();
            foreach($myrecords as $mr) {
                $schoolOn[$mr['school_id']] = $mr['school_name'];
            }
            $schoolIdsOn = array_keys($schoolOn);
            if($schools) {//δС
                foreach($schools as $k=>$v) {
                    if(!in_array($v['id'],$schoolIdsOn)) {
                        unset($schools[$k]);
                    }
                }
            } 
        }
        $levels = array();//Сȼ
        foreach ($schools as $key=>$v) {
            $levels[$key] = $schoolExpertBidsNew[$v['id']]['school_level'];
            $schools[$key]['school_level'] = $levels[$key];
        }
        array_multisort($levels, SORT_ASC, $schools);
        //print_r($blocks);
        return $schools;
    }

    /**
     * ؾͶʷб
     * @param array $myrecords ҵľͶ¼
     * @return array ʷб
     */
    public function get_bid_school_expert_history_list($myrecords) {
        if(!$myrecords) {
            return array();
        }
        $mc = Container::getInstance()->get('mc');
        //ڴbid_periods
        $bidPeriodsIds = array();
        $bidIds = array();
        $historyList = array();
        foreach ($myrecords as $value) {
            $bidPeriodsIds[] = $value['bid_periods_id'];
            $bidIds[] = $value['bid_id'];
        }
        $bidPeriodsIds = array_unique($bidPeriodsIds);
        $growthBidPeriods = new GrowthBidPeriods();
        $bidPeriodsMKey = array( $bidPeriodsIds);
        $bidPs = $mc->get($bidPeriodsMKey);
        if($bidPs === false) {
            $bidPs = $growthBidPeriods->findBy("id in ('".  implode("','", $bidPeriodsIds)."')");
            $mc->set($bidPeriodsMKey,$bidPs,3600);
        }
        
        $bidPs = SqlCombinHelper::changeToKeyArray($bidPs, 'id');
        //龺Ͷbid
        $bids = $this->growthBid->findBy("id in ('".  implode("','", $bidIds)."')");
        $bids = SqlCombinHelper::changeToKeyArray($bids, 'id');
        //print_r($bids);exit;
        //ʤļ¼
        foreach ($myrecords as &$value) {
            $temp = array();
            $temp['school_name'] = $value['school_name'];
            $bidP = $bidPs[$value['bid_periods_id']];
            $temp['tg_start_time'] = $bidP['tg_start_time'];
            $temp['tg_end_time'] = $bidP['tg_end_time'];
            $temp['number'] = $bids[$value['bid_id']]['number'];
            $maxWinNumber = $bids[$value['bid_id']]['max_win_number'];
            $temp['bid_status'] = "ѽ";
            if($value['status'] == 1) {
                $temp['my_result'] = '<span class="s_color ">Ͷɹ</span>';
                $temp['my_result_tip'] = '';
            } else {
                $temp['my_result'] = '<span class="f_color ">Ͷʧ</span>';
                $temp['my_result_tip'] = ' ˻';
            }
            $temp['my_score'] = $value['score'];
            $bidNum = $bids[$value['bid_id']]['max_win_number'];
            $recordsMKey = array($value['bid_id'], "score desc, utime asc", "0,$bidNum");
            $records = $mc->get($recordsMKey);
            if($records === false){
                $records = $this->growthBidRecordHistory->findByBid($value['bid_id'], "score desc, utime asc", "0,$bidNum");
                $mc->set($recordsMKey,$records,3600);
            }
            if($this->mode=='dou'){
                $template = '<div style="float: left; width: 130px;margin-bottom: 2px;"><span class="m_l_33 blod">NO.%s</span><span style="border-right-width: 0px; margin-right: 5px;" class="rank %s">%s</span>'.$this->modeString(2).'</div>';
            } else {
                $template = '<div style="float: left; width: 120px;margin-bottom: 2px;"><span class="m_l_33 blod">NO.%s</span><span style="border-right-width: 0px; margin-right: 5px;" class="rank %s">%s</span>'.$this->modeString(2).'</div>';
            }
            $temp['record_list'] = $this->rankList($records,  GrowthBidPeriods::BID_PERIODS_STATUS_FINISH,$template,$value,$maxWinNumber);
            $historyList[] = $temp;
        }
        //print_r($historyList);exit;
        return $historyList;
    }
    
    /**
     * ȡһڵľͶ¼,Ӫҳ
     * @return type
     */
    public function findNewBidRecord($cPeriods) {
        $brokerId = $this->getBrokerId();
		$cPeriodsStatus = $cPeriods['status'];
        if ($cPeriods['status'] == 1 || $cPeriods['status'] == 3) {
            $growthBidRecord = $this->growthBidRecord;
        } else {
            //һ
            $growBidPeriods = new GrowthBidPeriods();
            $cPeriods = $growBidPeriods->upBidPeriods(1, $cPeriods['id']);
            $cPeriods['status'] = isset($cPeriods['status']) ?  $cPeriods['status'] : 0;
            $growthBidRecord = $this->growthBidRecordHistory;
        }
        if (!isset($cPeriods['id']) || $cPeriods['id'] == '') {
            return array();
        }
        $periodsId = $cPeriods['id'];
        $bidAllRecord = $growthBidRecord->findByPidAndBrokerId($periodsId, $brokerId, 10);
        if (!CommonBase::isFullArray($bidAllRecord)) {return array();}
        $arrBidRecord = array();
        foreach($bidAllRecord as $k => $v) {
            $bidId = $v['bid_id'];
            $bid = $this->growthBid->findById($bidId);
            $bidMaxMinScore = $growthBidRecord->findMaxMinScoreByBidSuccess($bidId);
 			if ($cPeriods['status'] == 1 || $cPeriods['status'] == 3) {
				$bidRecord = $this->findTempWinnerRecord($bid);
			} else {
				$bidRecord = $this->findWinnerRecord($bid);
			}
            $myRecord = $growthBidRecord->findOneBy($brokerId,$bidId);//$growthBidRecord->findBidRecordByBidAndHouseId($v['bid_id'], $v['house_id']);
            //print_r($myRecord);
            $bidRank = $this->checkWinBid($bidRecord, $myRecord);
            if ($cPeriods['status'] == 1) {
                if ($bidRank > 0) {
                    $intBehavior = self::$bidBehavior['tempHit'];
                    $arrBidRecord[$k]['rank'] = $bidRank;
                } else {
                    $intBehavior = self::$bidBehavior['noHit'];
                }
            } else {
                $intBehavior = $bidRank > 0 ? self::$bidBehavior['success'] 
                        : self::$bidBehavior['failure'];
            }
            if ($cPeriodsStatus == 2) {
                $bidRankUrl = 'market_bid_school_expert_history.php';
            } else {
                $bidRankUrl = 'market_bid_school_expert.php?tab=on';
            }
            $content = $v['school_name'];
            $tgStartTime = $cPeriods['tg_start_time'];
            $tgEndTime = $cPeriods['tg_end_time'];
            $arrBidRecord[$k]['projectname'] = self::$bidProjectName;
            $arrBidRecord[$k]['tg_start_time'] = date('m.d', strtotime($tgStartTime));
            $arrBidRecord[$k]['tg_end_time'] = date('m.d', strtotime($tgEndTime));
            $arrBidRecord[$k]['content'] = $content;
            $arrBidRecord[$k]['score'] = $v['score'];
            $arrBidRecord[$k]['utime'] = $v['utime'];
            $arrBidRecord[$k]['behavior'] = $intBehavior;
            $arrBidRecord[$k]['max_score'] = $cPeriods['status']==  GrowthBidPeriods::BID_PERIODS_STATUS_ON?'':$bidMaxMinScore['max'];
            $arrBidRecord[$k]['min_score'] = $bidMaxMinScore['min'];
            $arrBidRecord[$k]['operate'] = $bidRankUrl;
            $arrBidRecord[$k]['esta'] = 1;
        }
        return $arrBidRecord;
    }
    
    public function getBrokerId() {
        return $this->broker['id'];
    }
    
        /**
     * ƿԲ뾺Ͷʱ
     */
    public function  controlTime() {
        if(isset($_SESSION['last_bid_time'])) {
            $lastTime = $_SESSION['last_bid_time'];
            if($lastTime>time()) {
                return false;
            } else {
                $_SESSION['last_bid_time'] = time()+GrowthBrokerBidSchoolExpert::BID_MIN_TIME;
                return true;
            }
        } else {
            $_SESSION['last_bid_time'] = time()+GrowthBrokerBidSchoolExpert::BID_MIN_TIME;
            return true;
        }
        
        
    }
    
    /**
     * ھͶͳƣܹжӣ
     * ͶɹͶ߻ֵͻֵ
     * @return array 
     */
    public function allPrevBidStat() {
        $mc = Container::getInstance()->get('mc');
        $sql = "SELECT school_id,MAX(score) as max,MIN(score) as min FROM growth_bid_school_expert_record_history WHERE `status`=1 GROUP BY school_id";
        $sql1 = "SELECT school_id, count(id) as number FROM growth_bid_school_expert_record_history  GROUP BY school_id";
        $recordsMKey = array($sql, $sql1);
        $data = $mc->get($recordsMKey);
        if($data === false){
            $creditData = $this->dbback->getAll($sql);
            $data = SqlCombinHelper::changeToKeyArray($creditData, 'school_id');
            $numberData = $this->dbback->getAll($sql1);
            foreach ($numberData as $value) {
                $schoolId = $value['school_id'];
                $data[$schoolId]['number'] = $value['number'];
            }
             $mc->set($recordsMKey,$data,3600);
        }
        return $data;
    }
    
    /**
     * 
     * @param type $type 1֣2λ
     * @return array
     */
    private function modeString($type=1) {
        $mode = $this->mode;
        $arr = array(
            'credit'=>array(1=>'',2=>''),
            'dou'=>array(1=>'',2=>''));
        return $arr[$mode][$type];
    }
}

?>
