<?php
/**
 * Description of GrowthBidHouseRecordHistory
 *
 * @author user
 */
class GrowthBidRentRecordHistory extends GrowthBidHouseRecord {
    public function __construct($table = 'growth_bid_rent_record_history') {
        parent::__construct($table);
        $this->growthBidPeriods = new GrowthBidPeriods();
    }
    
    public function findByBrokerId($brokerId) {
        $arrCurrentPeriods = $this->growthBidPeriods->currentBidPeriods($this->arrType);
        if (!CommonBase::isFullArray($arrCurrentPeriods)) {return array();}
        $type = $arrCurrentPeriods['type'];
        $growthBid = GrowthBidHouseFactory::getBidHouseClass($type);
        $arrBid = $growthBid->findAllIdByPeriodsId($arrCurrentPeriods['id']);
        $arrBidId = array();
        foreach ($arrBid as $key => $value) {
            $arrBidId[] = $value['id'];
        }
        $strBidId = implode(',', $arrBidId);
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, 
                "type = $type AND broker_id = $brokerId AND bid_id IN($strBidId)");
        return $this->dbback->getAll($sql);
    }
}
