<?php

/**
 * @˶˿Լ
 * @author	xz
 * @version ڣ2013-6-20
 */

class BrokerCheck {

	var $uid ;
	var $dbback;
	var $cityflag;
	var $score_baseinfo_limit	= 20;		//Ϣ
	var $score_houseMamage_limit	= 40;	//ԴϢ
	var $score_houseRefresh_limit	= 40;	//ԴˢϢ
	var $score_min = 0;
	var $tbl_broker;
	var $tbl_certificate;
	var $tbl_sell;
	var $tbl_rent;
	var $tbl_housefreeze;
	var $tbl_picdel;
	var $tbl_refresh;
	var $start_time;
	var $end_time;
	var $brokerInfo = array();
	var $is_cache;


	function BrokerCheck($uid,$is_cache=0){

		GLOBAL $dbback,$mc,$conf_cityflag;

		$this->uid	= intval( $uid );
		$this->mc	= $mc;
		$this->dbback	= $dbback;
		$this->cityflag	= $conf_cityflag;
		$this->tbl_broker	= 'broker';
		$this->tbl_certificate	= 'broker_certificate';
		$this->tbl_sell	= 'sell';
		$this->tbl_rent	= 'rent';
		$this->tbl_housefreeze	= 'house_freeze';
		$this->tbl_picdel	= 'upload_log';
		$this->tbl_refresh	= 'log_refresh';
		$this->brokerInfo	= $this->Get_BrokerInfo();
		$this->is_cache		= $is_cache;
	}
	

	/**
	* ȡ˻Ϣ
	* @param 
	* @return array ˻Ϣ
	* @author xz 2013-6-20
	**/
	function Get_brokerScore(){
	
		$mem_key = $this->cityflag.'_BrokerCheck_BrokerScore_'.$this->uid;
		
		//
		if($this->is_cache == '1'){
			$this->mc->delete($mem_key);
		}

		$temp_brokerScore = $this->mc->get($mem_key);
		
		if( $temp_brokerScore['is_ok'] == '1' ){
			$brokerScore	= $temp_brokerScore['data'];
		}else{
			$brokerScore	= array();
			//жϾǷǸײͣ򷵻false.
			if( $this->brokerInfo['is_pay'] == 0){
				$BaseInfo_Score		= $this->Get_BaseInfo_Score();
				$HouseMamage_Score	= $this->Get_HouseMamage_Score();
				$HouseRefresh_Score	= $this->Get_HouseRefresh_Score();
				$total_score	=  $BaseInfo_Score + $HouseMamage_Score + $HouseRefresh_Score;

				$brokerScore	= array(
									'time'				=> time(),
									'total_score'		=> $total_score,
									'BaseInfo_Score'	=> $BaseInfo_Score,
									'HouseMamage_Score'	=> $HouseMamage_Score,
									'HouseRefresh_Score'=> $HouseRefresh_Score
									);
			}
			
			$this->mc->add($mem_key,array('is_ok'=>'1','data'=>$brokerScore),false,60);
		}

		return $brokerScore;
	}

	
	/**
	* ȡ˻Ϣ
	* @param 
	* @return array ˻Ϣ
	* @author xz 2013-6-20
	**/
	function Get_BrokerInfo(){
		
		$broker_info	= array();

		$mem_key = $this->cityflag.'_BrokerCheck_BrokerInfo_'.$this->uid;
		
		//
		if($this->is_cache == '1'){
			$this->mc->delete($mem_key);
		}

		$temp_BrokerInfo = $this->mc->get($mem_key);

		if( $temp_BrokerInfo['is_ok'] == '1' ){
			$broker_info	= $temp_BrokerInfo['data'];
		}else{
			//ѯϢ
			$sql	= " SELECT uid, username , groupid , valid_flag , postlimit,is_pay "
					." FROM ".$this->tbl_broker." WHERE uid = ".$this->uid." ";
			$broker_info	= $this->dbback->GetRow($sql);
			
			//ӻ湦
			$this->mc->add($mem_key,array('is_ok'=>1,'data'=>$broker_info),false,600);
		}

		return $broker_info;
	}

	
	/**
	* ȡ˻Ϣ÷
	* @param 
	* @return int ˻÷
	* @author xz 2013-6-20
	**/
	function Get_BaseInfo_Score(){
		
		//ȡͷ÷(ͨ6֣˵4֣޵0)
		$score_photo	= 0;
		$valid_flag_photo	= $this->Get_SmallPhoto_Status();

		if( $valid_flag_photo == '0' ){
			$score_photo = 3;
		}else if($valid_flag_photo == '1'){
			$score_photo = 6;
		}

		//ȡ֤÷(ͨ6֣˵4֣޵0)
		$score_Idcard	= 0;
		$valid_flag_Idcard	= $this->Get_Identity_Card_Status();

		if( $valid_flag_Idcard == '0' ){
			$score_Idcard = 3;
		}else if($valid_flag_Idcard == '1'){
			$score_Idcard = 6;
		}

		//ȡƬ֤(ͨ4֣˵2֣޵0)
		$score_Bcard	= 0;
		$valid_flag_Bcard	= $this->Get_Business_Card_Status();

		if( $valid_flag_Bcard == '0' ){
			$score_Bcard = 2;
		}else if( $valid_flag_Bcard == '1' ){
			$score_Bcard = 4;
		}

		//ȡҵ֤÷(ͨ4֣˵2֣޵0)
		$score_Cert	= 0;
		$valid_flag_Cert	= $this->Get_Certification_Status();

		if( $valid_flag_Cert == '0' ){
			$score_Cert = 2;
		}else if( $valid_flag_Cert == '1' ){
			$score_Cert = 4;
		}
		
		//ֵ÷
		@$score_baseinfo	= $score_photo + $score_Idcard + $score_Bcard + $score_Cert;
		
		//ߵ÷
		$score_baseinfo	= $this->score_baseinfo_limit >= $score_baseinfo ? $score_baseinfo : $this->score_baseinfo_limit;
		
		//ȡ
		return  intval($score_baseinfo) ;
	}

	
	/**
	* ȡ˷Դֵ÷
	* @param 
	* @return int ȡ˷Դֵ÷
	* @author xz 2013-6-20
	**/
	function Get_HouseMamage_Score(){
		
		//˿
		$postlimit	= intval($this->brokerInfo['postlimit']);

		//Դ
		$HouseNum = $this->Get_HouseNum($this->tbl_sell) + $this->Get_HouseNum($this->tbl_rent);

		//ͼԴ
		$StarHouseNum = $this->Get_StarHouseNum($this->tbl_sell) + $this->Get_StarHouseNum($this->tbl_rent);

		//Դʵ÷(=Դ/ЧԴޣ÷=*10)
		$house_score	= 0;
		$house_score	= $postlimit > 0 ? ( $HouseNum / $postlimit ) * 10 : 0;

		//ͼԴʵ÷(ͼ=ͼԴ/ЧԴ÷=ͼ*30)
		$star_house_score	= 0;
		$star_house_score	= $HouseNum > 0 ? ( $StarHouseNum / $HouseNum ) * 30 : 0;

		//ֵʱ
		$this->start_time	= strtotime(date('Y-m-d'));
		$this->end_time	= $this->start_time + 86399;

		//Υ淿Դ÷(챻12֣24֣36֣5Ͽ10)
		$Violation_House_score	= 0;
		$Violation_HouseNum = $this->Get_Violation_HouseNum();

		$Violation_House_score = $Violation_HouseNum * ( -2 );
		$Violation_House_score = $Violation_House_score >= -10 ? $Violation_House_score : -10;

		//ɾͼƬ÷(챻һſ1֣2ſ2֣3ſ3֡10żϿ10)
		$Violation_Pic_score	= 0;
		$Violation_PicNum = $this->Get_Violation_PicNum();

		$Violation_Pic_score = $Violation_PicNum * ( -1 );
		$Violation_Pic_score = $Violation_Pic_score >= -10 ? $Violation_Pic_score : -10;

		$score_HouseMamage	= $house_score + $star_house_score + $Violation_House_score + $Violation_Pic_score;

		//СֵΪ0
		$score_HouseMamage	=  $score_HouseMamage > 0 ? $score_HouseMamage : 0;

		//֤
		$score_HouseMamage	=  $this->score_houseMamage_limit > $score_HouseMamage ? $score_HouseMamage : $this->score_houseMamage_limit;

		return  floor( $score_HouseMamage ) ;
	}



	/**
	* ȡ˷Դֵ÷
	* @param 
	* @return int ȡ˷Դֵ÷
	* @author xz 2013-6-20
	**/
	function Get_HouseRefresh_Score(){
		
		//˿
		$postlimit		= intval($this->brokerInfo['postlimit']);
		$refresh_num	= $this->Get_Refresh_Num();
		
		//ˢ·Դ÷(ˢ=ˢ´/˿ˢ´ޣ÷=ˢ*40)
		$refresh_score	= 0;
		$refresh_score	= $postlimit > 0 ? ( $refresh_num / ( $postlimit * 3 ) ) * 40 : 0 ;
		
		//֤÷
		$refresh_score	= $this->score_houseRefresh_limit > $refresh_score ? $refresh_score : $this->score_houseRefresh_limit;
		
		//ȡ֤֤Ӳᳬ100
		return floor( $refresh_score );
	}


	/**
	* ȡͷ֤Ϣ״̬
	* @param 
	* @return string ͷ֤Ϣ״̬
	* @author xz 2013-6-20
	**/
	function Get_SmallPhoto_Status(){

		$valid_info = array();
		$sql	= "SELECT valid_flag FROM ".$this->tbl_certificate." "
				." WHERE uid = ".$this->uid." AND kind = 'p_2_2' ";
		$valid_info	= $this->dbback->GetAll($sql);

		$valid_yx	= 0;
		$valid_dl	= 0;

		for($i =0 ; $i < count($valid_info) ; $i++){

			//Ƿ񼤻
			if($valid_info[$i]['valid_flag'] == '1' ){
				$valid_yx ++;
			}

			//Ƿ
			if($valid_info[$i]['valid_flag'] == '0' ){
				$valid_dl ++;
			}
		}
		
		if( $valid_yx > 0 ){
			$valid_flag = 1;
		}elseif($valid_dl > 0){
			$valid_flag = 0;
		}else{
			$valid_flag = 2;
		}
		
		return $valid_flag ;
	}
	

	/**
	* ȡ֤֤Ϣ״̬
	* @param 
	* @return string ֤֤Ϣ״̬
	* @author xz 2013-6-20
	**/
	function Get_Identity_Card_Status(){
		
		$sql	= "SELECT valid_flag FROM ".$this->tbl_certificate." "
				." WHERE uid = ".$this->uid." AND kind = 'p_2_3' ";
		$valid_info	= $this->dbback->GetAll($sql);

		$valid_yx	= 0;
		$valid_dl	= 0;

		for($i = 0 ; $i < count($valid_info) ; $i++){

			//Ƿ񼤻
			if($valid_info[$i]['valid_flag'] == '1' ){
				$valid_yx ++;
			}

			//Ƿ
			if($valid_info[$i]['valid_flag'] == '0' ){
				$valid_dl ++;
			}
		}
		
		if( $valid_yx > 0 ){
			$valid_flag = 1;
		}elseif($valid_dl > 0){
			$valid_flag = 0;
		}else{
			$valid_flag = 2;
		}

		return $valid_flag ;
	}

	
	/**
	* ȡƬ֤Ϣ״̬
	* @param 
	* @return string ֤֤Ϣ״̬
	* @author xz 2013-6-20
	**/
	function Get_Business_Card_Status(){
		
		$sql	= "SELECT valid_flag FROM ".$this->tbl_certificate." "
				." WHERE uid = ".$this->uid." AND kind = 'p_3' ";
		$valid_info	= $this->dbback->GetAll($sql);

		$valid_yx	= 0;
		$valid_dl	= 0;

		for($i = 0 ; $i < count($valid_info) ; $i++){

			//Ƿ񼤻
			if($valid_info[$i]['valid_flag'] == '1' ){
				$valid_yx ++;
			}

			//Ƿ
			if($valid_info[$i]['valid_flag'] == '0' ){
				$valid_dl ++;
			}
		}
		
		if( $valid_yx > 0 ){
			$valid_flag = 1;
		}elseif($valid_dl > 0){
			$valid_flag = 0;
		}else{
			$valid_flag = 2;
		}

		return $valid_flag ;
	}


	/**
	* ȡȫҵ֤֤Ϣ״̬
	* @param 
	* @return string ȫҵ֤֤Ϣ״̬
	* @author xz 2013-6-20
	**/
	function Get_Certification_Status(){
		
		$sql	= "SELECT valid_flag FROM ".$this->tbl_certificate." "
				." WHERE uid = ".$this->uid." AND kind = 'p_4_2' ";
		$valid_info	= $this->dbback->GetAll($sql);

		$valid_yx	= 0;
		$valid_dl	= 0;

		for($i = 0 ; $i < count($valid_info) ; $i++){

			//Ƿ񼤻
			if($valid_info[$i]['valid_flag'] == '1' ){
				$valid_yx ++;
			}

			//Ƿ
			if($valid_info[$i]['valid_flag'] == '0' ){
				$valid_dl ++;
			}
		}
		
		if( $valid_yx > 0 ){
			$valid_flag = 1;
		}elseif($valid_dl > 0){
			$valid_flag = 0;
		}else{
			$valid_flag = 2;
		}

		return $valid_flag ;
	}


	/**
	* ȡ˼Դ
	* @param $tbl Դ sell\rent
	* @return int ˼Դ
	* @author xz 2013-6-20
	**/
	function Get_HouseNum($tbl){
		
		$sql	= "SELECT COUNT(*) FROM ".$tbl." WHERE esta = 1 "
				." AND agentcode = 'B000' AND uid = $this->uid ";
		$num	= $this->dbback->GetOne($sql);

		return intval($num);
	}


	/**
	* ȡ˶ͼԴ
	* @param $tbl Դ sell\rent
	* @return int ˶ͼԴ
	* @author xz 2013-6-20
	**/
	function Get_StarHouseNum($tbl){
		
		$sql	= "SELECT COUNT(*) FROM $tbl WHERE esta = 1 "
				." AND agentcode = 'B000' AND uid = $this->uid AND isstar = 3 ";
		$num	= $this->dbback->GetOne($sql);

		return intval($num);
	}

	
	/**
	* ȡΥ淿Դ
	* @param 
	* @return int Υ淿Դ
	* @author xz 2013-6-20
	**/
	function Get_Violation_HouseNum(){
		
		$cond	= " WHERE agentcode = 'B000' AND uid = ".$this->uid;
		$cond	.= ' AND freezetime BETWEEN '.$this->start_time.' AND '.$this->end_time;

		$sql    = "SELECT COUNT(*) FROM ".$this->tbl_housefreeze." $cond ";
		$num   = $this->dbback->GetOne($sql);

		return intval($num);
	}


	/**
	* ȡΥͼƬ
	* @param 
	* @return int ΥͼƬ
	* @author xz 2013-6-20
	**/
	function Get_Violation_PicNum(){
		
		$cond	= " WHERE uid = '".$this->uid."' AND sort != '99'   ";
		$cond	.= " AND optime >= '".$this->start_time."' AND optime <= '".$this->end_time."'";
		
		$sql	= " SELECT COUNT(*) FROM ".$this->tbl_picdel." $cond ";
		$num	= $this->dbback->GetOne($sql);
		
		return intval($num);
	}

	
	/**
	* ȡ˷Դˢ´
	* @param 
	* @return int ˷Դˢ´
	* @author xz 2013-6-20
	**/
	function Get_Refresh_Num(){
		
		$day	= date('Y-m-d',time());
		$sql	= " SELECT SUM(num) FROM $this->tbl_refresh WHERE "
			." uid = '".$this->uid."' AND ymd = '".$day."'";
		$refresh_num	= $this->dbback->GetOne($sql);
		
		return intval($refresh_num);
	}

}