<?php

/**
 * core\lib\growth\GrowthCreditDayCount.php
 */

/**
 * ͨͬʽȡֵۼ
 *
 * @author wxj
 */
class GrowthCreditDayCount {
	/**
     *
     * @var TINY_ADODB ݿ 
     */    
    private $db;
    
    /**
     *
     * @var type ݿ
     */
    private $dbback;
    
    /**
     *
     * @var type 
     */
    private $mc;
    /**
     *
     * @var ȫַ 
     */
    private $container;
    /**
     *
     * @var String  
     */
    private $table;
    /**
     *
     * @var array аֶ 
     */
    public static $fields = array('id','ctime','way_alias','broker_id','day_credit');

    
    /**
     * 캯ʼ
     * @param String $table ĬΪ
     */
    public function __construct($table = null) {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->mc = $container->get('mc');
        $this->table = "growth_credit_day_count";
        
    }
    
    /**
     * idÿۼƻ
     * @param int $id GrowthCreditDayCountid
     * @return array ɹһۼƻֵ
     */
    public function findById($id) {
       $sql = SqlCombinHelper::select_sql($this->table, implode(",", self::$fields), 'id ='.$id);
       return $this->dbback->getRow($sql);
    }
    
    /**
     * ݻȡʽÿջ
     * @param string $wayAlias ȡʽı
     * @return type
     */
    public function findAllByWayIAlias($wayAlias) {
       $sql = SqlCombinHelper::select_sql($this->table, implode(",", self::$fields), "way_alias ='$wayAlias'");
       return $this->dbback->getAll($sql);
    }
    
    /**
     * ݾid ڻÿջ,$ctimeʱ
     * @param int $brokerId id
     * @param String $ctime ڣʽ2014-02-20
     * @return type
     */
    public function findByBrokerId($brokerId,$ctime=null) {
        $where = 'broker_id ='.$brokerId;
        if($ctime) $where .= " and ctime = $ctime";
        $sql = SqlCombinHelper::select_sql($this->table, implode(",", self::$fields), $where);
       return $this->dbback->getAll($sql);
    }
    
    /**
     * ڻÿջ,$wayAliasƻȡʽ
     * @param string $ctime ʽ磺2014-02-20
     * @param String $wayAlias ȡʽ
     * @return type
     */
    public function findByCtime($ctime,$wayAlias = null) {
        $where = '1';
        $where .= " and ctime = '$ctime'";
        if($wayAlias!==null)  {$where .= " and way_alias = '$wayAlias'";}
        $sql = SqlCombinHelper::select_sql($this->table, implode(",", self::$fields), $where);
       return $this->dbback->getAll($sql);
    }
    
    /**
     * ʱ䣬ȡʽid;idÿջ
     * @param string $ctime ڣʽ磺2014-02-20
     * @param String $wayAlias ȡʽ
     * @param int $brokerId id
     * @return type
     */
    public function findByTimeWayAliasBrokerId($ctime,$wayAlias,$brokerId) {
        $sql = SqlCombinHelper::select_sql($this->table, implode(",", self::$fields), "ctime ='".$ctime."' and way_alias='".$wayAlias."' and broker_id=$brokerId");
       return $this->dbback->getRow($sql);
    }
    
	/**
     * ʱ䣬;idÿջܺ
     * @param string $ctime ڣʽ磺2014-02-20
     * @param array $wayAliasArr ȡʽ
     * @param int $brokerId id
     * @return int ܵĻ
     */
    public function findArrayByTimeWayAliasBrokerId($ctime,$wayAliasArr,$brokerId) {	
        $wayAlias = '';
        for($i=0;$i<$j=count($wayAliasArr);$i++){
            $i == $j-1 ? $wayAlias .="'".$wayAliasArr[$i]."'" : $wayAlias .="'".$wayAliasArr[$i]."',";			
		}
        $sql = SqlCombinHelper::select_sql($this->table, "sum(day_credit) as sum_credit", "ctime ='".$ctime."' and way_alias in (".$wayAlias.") and broker_id=$brokerId");
       return $this->dbback->getOne($sql);
    }
    

	/**
     * ʱ䣬ȡʽÿջܺ
     * @param string $ctime ڣʽ磺2014-02-20    
     * @param int $brokerId id
     * @return int ܵĻ
     */
    public function findCreditSumByTimeBrokerId($ctime,$brokerId) {		
    
        $sql = SqlCombinHelper::select_sql($this->table, "sum(day_credit) as sum_credit", "ctime ='".$ctime."' and broker_id=$brokerId");
       return $this->dbback->getOne($sql);
    }

    




    /**
     * ʱ䣬ȡʽid;idÿջ
     * @param string $ctime ڣʽ磺2014-02-20
     * @param String $wayAlias ȡʽ
     * @param int $brokerId id
     * @return type
     */
    public function findByUniqueIndex($ctime,$wayAlias,$brokerId) {
        $sql = SqlCombinHelper::select_sql($this->table, implode(",", self::$fields), 'ctime ='.$ctime." and way_alias=$wayAlias and broker_id=$brokerId");
       return $this->dbback->getRow($sql);
    }
    
    /**
     * һ
     * @param array $fields 'ctime','way_alias','broker_id','day_credit'
     * @return boolean ɹtrueʧܷfalse
     */
    public function insert($fields) {
        $sql = SqlCombinHelper::insert_sql($this->table, $fields);
        echo $sql;
        exit;

        if($this->db->execute($sql)) {
            return true;
        } else {
            return false;
        }
    }
    
    /**
     * ݾ˱šʽͳʱȡز
     * @param type $ctime ͳʱ
     * @param type $wayAlias ʽ
     * @param type $brokerId ˱
     * @return array
     */
    public function findOneByUniqueIndex($ctime,$wayAlias,$brokerId) {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields, 
                "ctime = '$ctime' AND way_alias='$wayAlias'"
                . " AND broker_id=$brokerId");
        return $this->dbback->getRow($sql);
    }
    
    public function insertData($ctime,$wayAlias,$brokerId,$dayCredit) {
        $arrFieldsValue = array();
        $arrFieldsValue['broker_id'] = $brokerId;
        $arrFieldsValue['way_alias'] = $wayAlias;
        $arrFieldsValue['day_credit'] = $dayCredit;
        $arrFieldsValue['ctime'] = $ctime;
        $sql = SqlCombinHelper::insert_sql($this->table, $arrFieldsValue);
        return $this->db->execute($sql);
    }
    
    public function addScoreToOneByUniqueIndex($ctime,$wayAlias,$brokerId, $score) {
        $score = $score > 0 ? '+' . $score : $score;
        $arrField['day_credit'] =  $score;
        $sql = SqlCombinHelper::updateSelf_sql($this->table, $arrField, 
                "ctime = '$ctime' AND way_alias='$wayAlias'"
                . " AND broker_id=$brokerId");
        return $this->db->execute($sql);
    }

    
    /**
     * ÿջ
     * @param string $ctime ʱʽ磺2014-02-20
     * @param String $wayAlias ȡַʽı
     * @param Integer $brokerId id
     * @param Integer $score ҪӵĻֵ
     */
    public function increase($ctime,$wayAlias,$brokerId,$score) {
        $arrRow = $this->findOneByUniqueIndex($ctime, $wayAlias, $brokerId);
        if (count($arrRow) == 0) {
            $status = $this->insertData($ctime, $wayAlias, $brokerId, $score);
        } else {
            $status = $this->addScoreToOneByUniqueIndex($ctime, $wayAlias, 
                    $brokerId, $score);
        }
        return $status;
    }

	/**
	**ȡȡֵ
	**@param string $ctime  ʱʽ磺2014-02-23
	**@return int 
	**
	**/
	public function findBrokerNumber($ctime=null){
		$ctime = $ctime != null ? $ctime : date('Y-m-d');
		$sql = SqlCombinHelper::select_sql($this->table, "COUNT( DISTINCT (broker_id) ) AS num", "ctime = '$ctime'");
        return $this->dbback->getOne($sql);
	}

	/**
	**ȡĳеȡĳֵ
	**@param string $ctime  ʱʽ磺2014-02-23
	**@return int 
	**
	**/
	public function findBelowCreditBroker($conf_cityflag,$score,$ctime=null){
		$ctime = $ctime != null ? $ctime : date('Y-m-d');
    
        $sql = SqlCombinHelper::select_sql($this->table, "broker_id", "ctime = '$ctime' GROUP BY broker_id
HAVING SUM( day_credit ) <$score");

		$brokerArr = $this->dbback->getAll($sql);
        return $brokerArr;
	}


   /**
	**ȡСƵȡֵ
	**@param string $ctime  ʱʽ磺2014-02-23
	**@return int 
	**
	**/
	public function findBrokerImproveNumber($ctime,$wayAliasArr){
		$j=count($wayAliasArr);
		for($i=0;$i<$j;$i++){
            $i == $j-1 ? $wayAlias .="'".$wayAliasArr[$i]."'" : $wayAlias .="'".$wayAliasArr[$i]."',";			
		}
		$sql = SqlCombinHelper::select_sql($this->table, "count(DISTINCT(broker_id)) as num", "ctime ='".$ctime."' and way_alias in (".$wayAlias.") ");
        return $this->dbback->getOne($sql);
	}

   /**
	**ȡСƵȡֱٵľ˸
	**@param string $ctime  ʱʽ磺2014-02-23  
	**@param array    $wayAliasArr ȡ; 
	**@param int   $myCredit һȡĻ
	**return  int  
	**/
	public function findImproveBelowCreditBroker($ctime,$wayAliasArr,$myCredit){
		$j=count($wayAliasArr);
		for($i=0;$i<$j;$i++){
            $i == $j-1 ? $wayAlias .="'".$wayAliasArr[$i]."'" : $wayAlias .="'".$wayAliasArr[$i]."',";			
		}
	   $sql = SqlCombinHelper::select_sql($this->table, "count(id) as num", "ctime = '$ctime' and way_alias in (".$wayAlias.") GROUP BY broker_id HAVING SUM(day_credit) < $myCredit");
	   $brokerArr = $this->dbback->getAll($sql);
       $result = count($brokerArr);
       return $result;
	}


  	/**
     * ǰСƻȡֵ
     * @param type $brokerId  id
     * @param type $wayAliasArr ȡ; 
     */
    public function getImproveCreditCountByUid($brokerId,$wayAliasArr) {
		$j=count($wayAliasArr);
		for($i=0;$i<$j;$i++){
            $i == $j-1 ? $wayAlias .="'".$wayAliasArr[$i]."'" : $wayAlias .="'".$wayAliasArr[$i]."',";			
		}
        $sql = SqlCombinHelper::select_sql($this->table,'sum(day_credit) as num', "broker_id='$brokerId'   and way_alias in (".$wayAlias.")");
	    $result = $this->dbback->getOne($sql);
	 
		return $result;
    }


	/**
     * Сƻȡֵľ
     * @param type $wayAliasArr ȡ; 
     */
    public function getImproveCreditCountAllByUid($wayAliasArr) {
		$j=count($wayAliasArr);
		for($i=0;$i<$j;$i++){
            $i == $j-1 ? $wayAlias .="'".$wayAliasArr[$i]."'" : $wayAlias .="'".$wayAliasArr[$i]."',";			
		}
        $sql = SqlCombinHelper::select_sql($this->table,'count(DISTINCT(broker_id)) as num', " way_alias in (".$wayAlias.")");

	    $result = $this->dbback->getOne($sql);
		return $result;
    }
	

   /**
	**ȡСֱܻҵ͵ľ 
	**@param array    $wayAliasArr ȡ; 
	**@param int   $myCredit һȡĻ
	**return  int  
	**/
	public function getImproveCreditBelow($wayAliasArr,$myCredit){
		$j=count($wayAliasArr);
		for($i=0;$i<$j;$i++){
            $i == $j-1 ? $wayAlias .="'".$wayAliasArr[$i]."'" : $wayAlias .="'".$wayAliasArr[$i]."',";			
		}
	   $sql = SqlCombinHelper::select_sql($this->table, "count(id) as num", "  way_alias in (".$wayAlias.") GROUP BY broker_id HAVING SUM(day_credit) < $myCredit");
	   $result = $this->dbback->getAll($sql);
	   $num = count($result);
       return $num;
	}
	
}

?>
