<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of GrowBrokerCredit
 *
 * @author Administrator
 */
class GrowthBrokerCredit {
    //put your code here
    /**
     *
     * @var GrowthCredit 
     */
    private $credit;
    
    /**
     *
     * @var GrowthCreditDayCount 
     */
    private $creditDayCount;
    /**
     *
     * @var GrowthCreditRecord 
     */
    private $creditRecord;
    
    /**
     *
     * @var type 
     */
    private $broker;
    
    /**
     * 
     * @param array $broker 
     * @param type $weekday ܼ $weekday nullʱȥܼ
     */
    public function __construct($broker,$weekday = null) {
        $this->broker = $broker;
        $this->credit = new GrowthCredit();
        $this->creditDayCount = new GrowthCreditDayCount();
        $this->creditRecord = new GrowthCreditRecord($weekday);
    }

    private function getTime() {
        return date('Y') . '' . date('m') . '' . date('d') . '';
    }
    
    /**
     * ӻ
     * @param string $wayAlias ȡֵķʽ
     * @param string $description ȡַʽԶ
     * @param type ظ÷ʽĻֻԶ
     */
    public function increase($wayAlias,$description = null,$score = null) {
        if ($wayAlias == null) {
            return array('status' => false, 'msg' => 'wayAliasֶβΪ');
        }
        if($score == null) {
            $score = $this->getScoreByWayAlias($wayAlias);
        } else {
            $score = abs($score);
        }
        if($description == null) {
            $description = $this->getWayAliasName($wayAlias);
           
        }
        $description = $this->getTime() . ' ' . $description . ''
                         . $score . '';
        
        if ($wayAlias == 'false'/**'openPayPackage'**/ ) {
            $updateScoreStatus = $this->credit->insertData($this->getBrokerId(), $score);
        } else {
            $updateScoreStatus = $this->credit->addCreditToOne($this->getBrokerId(), $score);
        }
        $arrRtnResult = array();
    //    echo $wayAlias."--".$this->getBrokerId()."--".$score."--".$description;
     // exit;
        if ($updateScoreStatus) {
            //޸ÿջ
            $ctime = date("Y-m-d");//2014-02-13
            $this->creditDayCount->increase($ctime, $wayAlias, $this->getBrokerId(), $score);
            //Ӽ¼
            $this->creditRecord->insertData($this->getBrokerId(), $wayAlias, $score, $description);
            $arrRtnResult['status'] = 1;
            $arrRtnResult['score'] = $score;
        } else {
            $arrRtnResult['status'] = 0;
            $arrRtnResult['msg'] = 'ӻʧ';
        }
        return $arrRtnResult;
    }
    
    /**
     * ٻ
     * @param string $wayAlias ȡֵķʽ
     * @param string $description ȡַʽԶ
     * @param type ظ÷ʽĻֻԶ
     * @param int $type 1,ûɼ2ϵͳɼ
     */
    public function reduce($wayAlias,$description = null,$score = null,$type=1) {
        if ($wayAlias == null) {
            return array('status' => false, 'msg' => 'wayAliasֶβΪ');
        }
        if($score == null) {
            $score = $this->getScoreByWayAlias($wayAlias);
        } else {
            $score = '-'.abs($score);
        }

        if ($wayAlias == 'openPayPackage') {
            $updateScoreStatus = $this->credit->insertData($this->getBrokerId(), $score);
        } elseif($wayAlias == 'accountFailure') {
			//˻
			$brokerCreditArr = $this->getBrokerCredit();
			$score = '-'.abs($brokerCreditArr['credit']);   
			//Ϊ0
            $updateScoreStatus = $this->credit->setCreditToOne($this->getBrokerId(), 0);
            
        }else{
            $updateScoreStatus = $this->credit->addCreditToOne($this->getBrokerId(), $score);
        }

        if($wayAlias != 'accountFailure') {
            if ($description == null) {
                $description = $this->getWayAliasName($wayAlias);
                $description = $this->getTime() . ' ' . $description . '۳' . abs($score) . '';
            }
        }
		
        
        $arrRtnResult = array();
        if ($updateScoreStatus) {
            //޸ÿջ
            $ctime = date("Y-m-d");//2014-02-13
            $this->creditDayCount->increase($ctime, $wayAlias, $this->getBrokerId(), $score);
            //Ӽ¼
            $this->creditRecord->insertData($this->getBrokerId(), $wayAlias, $score, $description,$type);
            $arrRtnResult['status'] = 1;
            $arrRtnResult['score'] = $score;
        } else {
            $arrRtnResult['status'] = 0;
            $arrRtnResult['msg'] = '۳ʧ';
        }
        return $arrRtnResult;
    }
    
    private function getBrokerId() {
        return $this->broker['id'];
    }
    
    /**
     * ˵ײ
     * @return int 
     */
    private function getBrokerPackage() {
        return $this->broker['groupid'];
    }
    
    /**
     * 
     * @return array  þ˵ǰֵ顣
     */
    public function getBrokerCredit() {
        return $this->credit->findByBrokerId($this->broker['id']);
    }
    
    /**
     * ȡֻȡʽķֵʾ ͨ÷ʽӻĵķֵ
     * @param int $wayAlias
     * @return int ֻȡʽķֵʾ ͨ÷ʽӻĵķֵ
     */
    public function getScoreByWayAlias($wayAlias) {
        //wayid ײid ҶӦ
        $wayPackageScore = new GrowthCreditWayPackage();
        $packageId = $this->getBrokerPackage();
        $score = $wayPackageScore->getScoreByWayAliasAndPackageId($wayAlias, $packageId);
        return $score;
    }
    
    /**
     * ȡĿ
     * @return string Ŀ
     */
    public function getWayAliasName($alias) {
        $creditWay = new GrowthCreditWay();
        return $creditWay->findNameByAlias($alias);
    }
    
    /**
     * ؿû
     */
    public function getValidCredit() {
        $res = $this->credit->findByBrokerId($this->broker['id']);
        if($res) {
            return $res['credit']-$res['frozen'];
        } else {
            return 0;
        }
    }
    
    /**
     * 
     * @param type $score 
     * @param type $brokerId id
     * @param type $alisWay ȡʽ
     * @param type $info Ҫ¼Ϣ
     * @param type $type Ҫ¼Ϣͣ1ûɼ2ϵͳɼ
     * @return type
     */
    public function frozenCredit($score,$brokerId=null,$alisWay='',$info='',$type=1) {
        if($score>0) { $x = -$score;}if($score<=0){$x =  abs($score); }
        if($brokerId===null) { $brokerId = $this->getBrokerId();}
        $this->creditRecord->insertData($brokerId, 'bidFrozenCredit', $x, $info,$type);
        return $this->credit->frozen($brokerId,$score);
    }
    
    /**
     * 
     * @return GrowthCredit
     */
    public function getGrowthCredit() {
        return $this->credit;
    }
}

?>
