<?php
/**
 * Description of GrowthBidHouseRecordFactory
 *
 * @author user
 */
class GrowthBidRecordFactory {
    public static function getRecordClassByTime($bidType, $isBidOn) {
        if ($isBidOn) {
            return self::getRecordOnClass($bidType);
        } else {
            return self::getRecordHistoryClass($bidType);
        }
    }
    
    public static function getRecordHistoryClass($bidType) {
        return $bidType == 'house' ? new GrowthBidHouseRecordHistory()
                : new GrowthBidBlockExpertRecordHistory();
    }
    
    public static function getRecordFinishClass($bidType) {
        return $bidType == 'house' ? new GrowthBidHouseRecordFinish()
                : new GrowthBidBlockExpertRecordFinish();
    }
    
    public static function getRecordOnClass($bidType) {
        return $bidType == 'house' ? new GrowthBidHouseRecordOn()
                : new GrowthBidBlockExpertRecordOn();
    }
}
