<?php
require_once "config.php";
require_once "Curl.class.php";
class Encryption {

	private $rsaPriKeyFile = null;
	private $rsaPubKeyFile = null;
    private $gatewayUrl = 'https://openapi.alipay.com/gateway.do';

	/**
	 * ˽Կļ·
	 * @param  String $path ˽Կļ·
	 */
	public function setRsaPriKeyFile($path) {
		$this->rsaPriKeyFile = $path;
	}

	/**
	 * ùԿļ·
	 * @param  String $path Կļ·
	 */
	public function setRsaPubKeyFile($path) {
		$this->rsaPubKeyFile = $path;
	}

    /**
     * ֧
     * @param $sParam
     * @return string
     */
	public function requestAlipay($sParam) {
	    //ȡǩ
        $tempStr = $this->Assembling($sParam);		/** ƴӴǩַ */
        $sign = $this->Signature($tempStr);
        $sParam['sign'] = $sign;
        return $this->buildRequestForm($sParam);
	}


    /**
     * ԱHTMLʽ죨Ĭϣ
     * @param array $para_temp 
     * @return string ύHTMLı
     */
    protected function buildRequestForm($para_temp) {

        $sHtml = "<form id='alipaysubmit' name='alipaysubmit' action='".$this->gatewayUrl."?charset=".trim($para_temp['charset'])."' method='POST'>";
        while (list ($key, $val) = each ($para_temp)) {
            if (false === $this->checkEmpty($val)) {
                //$val = $this->characet($val, $this->postCharset);
                $val = str_replace("'","&apos;",$val);
                //$val = str_replace("\"","&quot;",$val);
                $sHtml.= "<input type='hidden' name='".$key."' value='".$val."'/>";
            }
        }

        //submitťؼ벻Ҫname
        $sHtml = $sHtml."<input type='submit' value='ok' style='display:none;'></form>";
        $sHtml = $sHtml."<script>document.forms['alipaysubmit'].submit();</script>";

        return $sHtml;
    }

    /**
     * У$valueǷǿ
     * @param $value
     * @return bool
     */
    protected function checkEmpty($value) {
        if (!isset($value))
            return true;
        if ($value === null)
            return true;
        if (trim($value) === "")
            return true;

        return false;
    }

    /**
     * ȡ
     * @param array $sParam 
     * @return string
     */
	public function getSignature($sParam) {
		$tempStr = $this->Assembling($sParam);		/** ƴӴǩַ */
		$sign = $this->Signature($tempStr);			/** ȡǩ */
		$encode_str = $this->Assembling($sParam, false, false);
		$str = $encode_str.'&sign='.rawurlencode($sign);
		return $str;
	}

    /**ǩַƴӺ
     * @param $params
     * @param bool $filterSignType
     * @param bool $isEncode
     * @return string
     */
	private function Assembling($params, $filterSignType = false, $isEncode = false) {
		/** filterSignTypeΪʱ޳sign_type */
		if ($filterSignType) {
			unset($params['sign_type']);
		}
		ksort($params);			/** 鰴ռȻ˳ */
        $filterArr = array();
		foreach ($params as $k => $v) {
			if (false === empty($v) && 'sign' != $k) {
				// תĿַ
				//$v = mb_convert_encoding($v, $params['charset']);
				$filterArr[] = ($isEncode) ? $k.'='.rawurlencode($v) : $k.'='.$v;
			}
		}
		$stringToBeSigned = implode("&", $filterArr);		//ʹ & Ӳ
		unset ($k, $v);
		return $stringToBeSigned;
	}

	/**
	 * ȡǩ
	 * @param  string $tempStr ǩĲַ
	 * @return mixed 
	 *         StringǩĲַ
	 *         boolean˽Կļڣ
	 */
	private function Signature($tempStr) {
		//ȡ˽Կļ
		$priKey = file_get_contents($this->rsaPriKeyFile);
		$res = openssl_get_privatekey($priKey);
		($res) or die('ʹõ˽ԿʽRSA˽Կ');
		openssl_sign($tempStr, $sign, $res);
		openssl_free_key($res);
		$sign = base64_encode($sign);
		return $sign;
	}

	/**
	 * ֧첽֪ͨ
	 * @param  array $rParam 첽֪ͨĲ
	 * @return array ذǩַʹ֤ǩ
	 */
	public function disposeResponseData($rParam) {
		/** ȡǩַ */
        $stringToBeSigned = $this->Assembling($rParam, true, false);
		//$stringToBeSigned = rawurlencode($stringToBeSigned);
		/** ȡsignڵ */
		$signature = $rParam['sign'];
		$ret = array(
			'stringToBeSigned'	=>	$stringToBeSigned,
			'signature'			=>	$signature
			);
		return $ret;
	}

	/**
	 * ֤ǩ
	 * @param  string $stringToBeSigned ǩĲ
	 * @param  string $signature        ֤ǩ
	 * @return boolean                   ֤
	 */
	public function verify($stringToBeSigned, $signature) {
		/** ʹRSAǩͨǩַǩbase64룩֧Կ֤ǩ */
		if (file_exists($this->rsaPubKeyFile)) {
			//ȡԿļ
			$pubKey = file_get_contents($this->rsaPubKeyFile);
			//תΪopensslʽԿ
			$res = openssl_get_publickey($pubKey);
			($res) or die('֧RSAԿ鹫ԿļʽǷȷ');
			//openssl÷ǩboolֵ
			$result = (bool)openssl_verify($stringToBeSigned, base64_decode($signature), $res);
			openssl_free_key($res);	//ͷԴ
			return $result;
		}
		return false;
	}

    /**
     * ˵ѯӿ
     * @param string $out_trade_no     ˿
     * @param string $out_request_no     󵥺
     * @return resource     ѯ
     */
    public function refundQuery($out_trade_no, $out_request_no)
    {
        $biz_Content = array(
            'out_trade_no'      =>  $out_trade_no,
            'out_request_no'    =>  $out_request_no
        );
        $bizContent = json_encode($biz_Content);
        $signData = array(
            'app_id'        =>  APP_ID,
            'method'        =>  'alipay.trade.fastpay.refund.query',
            'format'        =>  'JSON',
            'charset'       =>  'utf-8',
            'sign_type'     =>  'RSA',
            'sign'          =>  '',
            'timestamp'     =>  date('Y-m-d H:i:s',time()),
            'version'       =>  '1.0',
            'biz_content'   =>  $bizContent
        );

        /** ˽Կ */
        $this->setRsaPriKeyFile(PRIVATE_KEY);

        $sign = $this->getSignature($signData);
        $curl = new Curl();
        $curl->setUrl('https://openapi.alipay.com/gateway.do');
        $response = $curl->execute(true, 'GET', $sign);
        return $response;
	}
}