<?php

//Ϣ
class Message_model extends MY_Model{
    /**
     *
     * @var string
     */
    protected $tbl = '';
    
    /**ѯֶ
     * @var string
     */
    protected $select_fields = '';
    
    /**
     * ѯ
     * @var array
     */
    protected $join_arr = array();
    
    /**
     * 
     * @var string
     */
    protected $join_type = '';
     
    /**
     * key
     * @var string
     */
    private $_mem_key = "message_model";


    /**
     * ʼ
     */
    public function __construct() 
    {
        parent::__construct(1,1,0);
    }
    
    
     /**
     * òѯݵı
     * @param string $tbl
     */
    public function set_tbl($tbl) 
    {
        $this->tbl = $tbl;
    }
    
    /**
     * ȡѯݵı
    * @return string $tbl 
    */
   public function get_tbl() {
           return $this->tbl;
   }
    
     /**
     * Ҫѯֶ
     * @param array $select_fields
     */
    public function set_select_fields($select_fields)
    {
        $select_fields_str = '';
        if(isset( $select_fields ) && !empty($select_fields))
        {   
            $select_fields_str = implode( ',', $select_fields) ;
        }
        $this->select_fields = $select_fields;
    }
    
    
    /**
     * ȡҪѯֶ
     * @return type
     */
    public function get_select_fields()
    {
        return $this->select_fields;
    }
    
    /**
     * ϲѯ
     */
    public function set_join_table($join_arr,$join_type){
        $this->join_arr = $join_arr;
        $this->join_type = $join_type;
    }
    
    /**
     * ϲѯ
     */
    public function clear_join_table(){
        $this->join_arr = '';
        $this->join_type = '';
    }
    
    /**
     * ȡϲѯ
     */
    public function get_join_table(){
        return $this->join_arr;
    }
    
     /**
     * ȡϢбҳ
     * @param string $where ѯ
     * @param int $start ѯʼ
     * @param int $limit ƫ
     * @param int $order_key ֶ
     * @param string $order_by 򡢽ĬϽ
     * @return array Ϣ
     */
    public function find_all_by($where, $start = 0, $limit = 20, 
            $order_key = 'id' , $order_by = 'DESC') 
    {
        
        //ѯֶ
        if ($this->select_fields)
        {
            $this->dbback->select($this->select_fields);
        }
		
		//ѯ
		$this->dbback->where($where);
		//
		$this->dbback->order_by($order_key, $order_by);

		if ( $start >= 0 && $limit > 0 )
		{
			$this->dbback->limit($limit, $start);
		}
		
		if(is_array($this->join_arr)&&!empty($this->join_arr))
		{
			foreach ($this->join_arr as $key=>$value)
			{
				$this->dbback->join($key,$value,$this->join_type);
			}            
		}

		$result_array = $this->dbback->get($this->tbl)->result_array();
        
        return $result_array;
    }
    
    
    /**
     * ȡѯϢ
     * @param string $where ѯ
     * @return int Ϣ
     */
    public function find_count_by($where)
    {   
		$this->dbback->where($where);
		$this->dbback->from($this->tbl);
		
		if(is_array($this->join_arr)&&!empty($this->join_arr))
		{
			foreach ($this->join_arr as $key=>$value)
			{
				$this->dbback->join($key,$value,$this->join_type);
			}            
		}
		
		$count = $this->dbback->count_all_results();
      

        return $count;
    }
    
    
    /**
     * ݲѯһϢļ¼
     * @param string $where ѯ
     * @return array һһάϢ¼
     */
    public function find_one_by($where = '')
    {
        //ѯֶ
        if ($this->select_fields)
        {
            $this->dbback->select($this->select_fields);
        }
        //ѯ
        $this->dbback->where($where);       
        if(is_array($this->join_arr)&&!empty($this->join_arr)){
            foreach ($this->join_arr as $key=>$value){
                $this->dbback->join($key,$value,$this->join_type);
            }            
        }
        return $this->dbback->get($this->get_tbl())->row_array();
    }
    
    /**
     * ɾϢ
     * delete_message
     * @param str $del_where ɾ
     * @param int $id_field 
     * @param array $id_arrҪɾļ¼id
     */
    public function delete_message($del_where,$id_field,$id_arr)
	{
        if(is_array($id_arr)&&!empty($id_arr))
		{	
			if($id_field != '' && !empty($id_arr))
			{
				$this->db->where_in($id_field,$id_arr);
			}

			if($del_where != '')
			{
				$this->db->where($del_where);
			}
             
            $this->db->delete($this->get_tbl());

			if( $_COOKIE['admin_debug'] && $_COOKIE['admin_debug'] == 1)
			{
				echo $this->db->last_query();
			}

			return $this->db->affected_rows();
        }
    }
    
    /**
     * ԤԼɾ
     * see_house_del
     * @param int $uid ûid
     * @param array $id_arr ɾid
     */
    public function sell_house_del($uid,$id_arr)
	{
        $this->db->where('uid',$uid);

        if(is_array($id_arr)&&!empty($id_arr))
		{
            $this->db->where_in('id',$id__str);
            $db->update($this->tbl,array('esta'=>2));           
        }        
        
    }
    

    
    /**
     * ޸Ϣ鿴״
     * update_message_status
     * @param array $where_cond where
     * @param string  $flag_field ־λֶ 
     * @param string $flag_value ־λֵ
     */
    public function update_message_status($where_cond,$flag_field,$flag_value)
	{ 
        $this->db->where($where_cond);
        $this->db->update($this->get_tbl(),array($flag_field=>$flag_value));
		//echo $this->db->last_query();
    }
    

    //ȡδϢ
    public function get_message_no_read($uid)
	{
        //
        $no_announce_num = $this->get_announce_no_read($uid);

        //ϵͳ
        $no_system_num = $this->get_announce_no_read($uid,'system');

        //
        $no_shop_num = $this->get_shop_no_read($uid);

        //ԤԼ
        $no_see_num = 0;
        $no_read_count = $no_announce_num + $no_system_num + $no_shop_num + $no_see_num;
        $no_read_num = array($no_announce_num,$no_system_num,$no_shop_num,$no_see_num,$no_read_count);
       
        return $no_read_num;
    }
    

    //ϵͳδϢ
    private function get_announce_no_read($uid,$type='')
	{       
        $tbl = 'agent_announceitem';        
        $this->set_tbl($tbl);       
        $join_arr = array('agent_announce'=>'agent_announceitem.announceid=agent_announce.id');
        $this->set_join_table($join_arr,'left');
        $strInfofrom = $type == 'system' ? 'agent_announce.issystem = 1 ' : 'agent_announce.issystem = 0 ';       
        $cond_where_no = "agent_announceitem.uid = $uid and $strInfofrom and agent_announceitem.new = 1";
        $no_read_num = $this->find_count_by($cond_where_no);
     
        return $no_read_num;
    }
    

    
    //δϢ
    private function get_shop_no_read($uid)
	{
        $tbl = "broker_guestbook";
        $this->set_tbl($tbl);  
        $this->clear_join_table();
        $cond_where_no = "uid = $uid and new = 1";
        $no_read_num = $this->find_count_by($cond_where_no);
        return $no_read_num;
    }
    

    //ԤԼδϢ
    private function get_see_no_read($uid){
        $tbl = "see_house";
        $this->set_tbl($tbl);
        $this->clear_join_table();
        $cond_where_no = "uid = $uid and esta = 1 and new = 1";        
        $no_read_num = $this->find_count_by($cond_where_no); 
        return $no_read_num;
    }


	public function get_annouce_list_by_cond($cond_where,$start,$limit)
	{
		//ѯֶ
        if ($this->select_fields)
        {
            $this->dbback->select($this->select_fields);
        }

        //ѯ
		
		$this->dbback->limit($limit,$start);
        $this->dbback->where($cond_where);
		$this->dbback->order_by('id','asc');
        return $this->dbback->get($this->get_tbl())->result_array();
	}


	public function annouce_count_by($where)
    {   
		$this->dbback->where($where);
		$this->dbback->from($this->tbl);

		$count = $this->dbback->count_all_results();
      

        return $count;
    }


    public function delete_message_annouce($del_where)
	{	

		
		if($del_where != '')
		{
			$this->db->where($del_where);
			$this->db->delete('agent_announce');
		}

		if( $_COOKIE['admin_debug'] && $_COOKIE['admin_debug'] == 1)
		{
			echo $this->db->last_query();
		}

		return $this->db->affected_rows();
    }
}