<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * Sell_star_base_model CLASS
 *
 * ۶ͼ
 *
 * @package         zsb
 * @subpackage      Models
 * @category        Models
 * @author          xz
 */

//ظ
load_m("sell_attr_model");

class Sell_star_base_model extends Sell_attr_model {
    
    /**
     * ͼʶӦֵ
     * @var const
     */
    const  ISSTAR_VALUE = 3;
    
    /**
     * ʼ
     */
    public function __construct() 
    {
        parent::__construct();
    }
    
    /**
     * ضͼ־ֵ
     */
    public function get_isstar_value()
    {
        return self::ISSTAR_VALUE;
    }
    
    
    /**
     * жϷԴǷΪͼԴ
     *
     * @access	public
     * @return	boolean   ǷΪͼԴ
     */
    public function is_star()
    {   
        $is_star = FALSE;
        
        $house_info = $this->init_houseinfo();
        
        if( is_array( $house_info ) && !empty( $house_info ) )
        {
            $is_star = self::ISSTAR_VALUE == $house_info['isstar'] 
                    ? TRUE : FALSE;
        }
        
        return $is_star;
    }
    
    
    /**
     * öͼԴ
     *
     * @access  protected
     * @return  boolean  Ƿóɹ
     */
    public function set_star()
    {   
        $result = FALSE;
        
        $house_info = $this->init_houseinfo();
        $row_id = intval($house_info['id']);
        
        if( $row_id > 0 )
        {   
            $update_info = array();
            
            //ҪõķԴֵ
            $update_info['isstar'] = self::ISSTAR_VALUE;
            
            //öͼԴ
            $result = $this->update_house_atrr_val( $update_info , $row_id );
        }
        
        return $result;
    }
    
    
    /**
     * ȥͼԴ
     *
     * @access  public
     * @return  boolean  Ƿóɹ
     */
    public function remove_star()
    {   
        $result = FALSE;
        
        $house_info = $this->init_houseinfo();
        $rowid = intval($house_info['id']);
        
        if( $rowid > 0 )
        {   
            $update_info = array();
            
            //ҪõķԴֵ
            $update_info['isstar'] = 0;
            
            //öͼԴ
            $result = $this->update_house_atrr_val( $update_info , $rowid );
        }
        
        return $result;
    }
    
    
    /**
     * ǷԴǷ϶ͼԴ׼
     *
     * @access  protected
     * @return  boolean  Ƿ϶ͼԴ׼
     */
    public function check_star_standard()
    {   
        $tbl = 'sell';
        $is_star = FALSE;
      
        $houseinfo = $this->init_houseinfo();
        
        //1շѾ˲оͷ
        $this->load->model('broker_model');
        
        $this->broker_model->set_uid($houseinfo['uid']);
        $broker_info = $this->broker_model->get_broker_info();
        
        if($broker_info['smallphoto'] == '')
        {
            return $is_star;
        }
         
        //2Դ20ּ
        if( strlen( $houseinfo['address'] ) < 20)
        {
            return $is_star;
        }
        
        //3Դ
        if( strlen( $houseinfo['remark'] ) < 60 )
        {
            return $is_star;
        }

        //4ϷԴͼƬ
        $pic_info = array();
        $this->load->model('pic_model');
        $pic_info = $this->pic_model->find_house_pic_by($tbl , $houseinfo['id']);
        
        //ͼ
        $pic_indoor = 0;
        //⾰ͼ
        $pic_outdoor = 0;
        //ͼ
        $pic_layout = 0;
        
        if( is_array( $pic_info ) && isset( $pic_info ) )
        {   
            $pic_num = count( $pic_info );
            
            for($i = 0 ; $i < $pic_num ; $i ++ )
            {   
                if( $pic_info[$i]['sort'] == 2 )//
                {
                    $pic_indoor ++ ;
                }  
                else if ( $pic_info[$i]['sort'] == 1 )//⾰ͼ
                {
                    $pic_outdoor ++;
                }
                else if( $pic_info[$i]['sort'] == 0 )//ͼ
                {
                    $pic_layout ++;
                }
            }
        }
        
        if( $houseinfo['infotype'] == 1)
        {
			if(GB_CITY=='nj')
			{
				$pic_indoor_limit = 5;
			}
			else
			{
				$pic_indoor_limit = 3;
			}
			$pic_outdoor_limit = 1;
			$pic_layout_limit = 1;
        }
        else
        {
            $pic_indoor_limit = 3;
			$pic_outdoor_limit = 0;
			$pic_layout_limit = 0;
        }
        //ļͨûڽվ
        $cityArr = array('nj','hf','wx','wlmq');
        /*
		if(GB_CITY=='wh'  || GB_CITY=='mianyang' || GB_CITY=='dz' || GB_CITY=='jx' || GB_CITY=='ph' || GB_CITY=='tx')
		{
        */
        if(!in_array(GB_CITY,$cityArr)){
			$pic_indoor_limit = 3;
			$pic_outdoor_limit = 0;
			$pic_layout_limit = 0;
		}
        
        if( $pic_indoor >= $pic_indoor_limit && $pic_outdoor >= $pic_outdoor_limit && $pic_layout >= $pic_layout_limit)
        {
            $is_star = TRUE;
        }
        
        return $is_star;
    }
}
/* End of file sell_attr_base_model.php */
/* Location: ./applications/models/sell_attr_base_model.php */