<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * zsb
 *
 * ۱ϵͳ
 *
 * @package         zsb
 * @author          EllisLab Dev Team
 * @copyright      Copyright (c) 2006 - 2014, HOUSE365, Inc.
 * @link            http://nj.sell.house.com
 * @since           Version 1.0
 * @filesource
 */

// ------------------------------------------------------------------------

/**
 * Sell_demands_model CLASS
 *
 * 󹺡࣬ṩ󹺡Ϣķ(鿴ƥ䡢ɾȲ)
 *
 * @package         zsb
 * @subpackage      Models
 * @category        Models
 * @author          xz     
 */
class house_demands_base_model extends MY_Model{
   
    /**
    * ûID
    *
    * @access private
    * @var integer
    */
    private $_uid    = 0;
    
    /**
    * 󹺡Ϣ
    *
    * @access private
    * @var integer
    */
    private $_id    = 0;

    /**
    * ûڵĳ
    *
    * @access private
    * @var string
    */
    private $_city = NULL;

    /**
    * ַⷿԴ
    *
    * @access private
    * @var string
    */
    private  $_tbl_house = NULL;
    
    /**
    * 󹺡Ϣ
    *
    * @access private
    * @var string
    */
    private  $_tbl_demand = NULL;
    
    /**
    * ƥ䷿ԴϢ
    *
    * @access private
    * @var string
    */
    private $_tbl_match = NULL;

    /**
    * Դѯֶ
    *
    * @access private
    * @var array
    */
    private $_house_fields = array();
    
    /**
    * ѯֶ
    *
    * @access private
    * @var array
    */
    private $_demand_fields = array();
    
    
    /**
    * Constructor
    */
    public function __construct() 
    {
        parent::__construct(1,1,1);
    }
    
    
    /**
    * ʼϢ
    *
    * @access	public
    * @param	int $id ˺ű
    * @return	void
    */
    public function set_id( $id )
    {
        $this->_id = intval( $id );
    }
    
    
    /**
    * ȡϢ
    *
    * @access	public
    * @param	void
    * @return	int Ϣ
    */
    public function get_id( )
    {
        return $this->_id;
    }
    
    /**
    * ʼuid
    *
    * @access	public
    * @param	int $uid ˺ű
    * @return	void
    */
    public function set_uid( $uid )
    {
        $this->_uid = intval( $uid );
    }
    
    
    /**
    * ȡ˺ű
    *
    * @access	public
    * @param	void
    * @return	int ˺ű
    */
    public function get_uid( )
    {
        return $this->_uid;
    }
    
    
    /**
    * ÷Դ
    *
    * @access	public
    * @param	string $tbl_name 
    * @return	void
    */
    public function set_tbl_house( $tbl_name )
    {
        $this->_tbl_house = strip_tags( $tbl_name );
    }
    
    
    /**
    * ȡԴ
    *
    * @access	public
    * @param	void
    * @return	string Դ
    */
    public function get_tbl_house( )
    {
        return $this->_tbl_house;
    }
    
    
    /**
    * 󹺡Ϣ
    *
    * @access	public
    * @param	string $tbl_name 
    * @return	void
    */
    public function set_tbl_demand( $tbl_name )
    {
        $this->_tbl_demand = strip_tags( $tbl_name );
    }
    
    
    /**
    * ȡϢ
    *
    * @access	public
    * @param	void
    * @return	string Ϣ
    */
    public function get_tbl_demand( )
    {
        return $this->_tbl_demand;
    }
    
    
    /**
    * 󹺡ƥ
    *
    * @access	public
    * @param	string $tbl_name 
    * @return	void
    */
    public function set_tbl_match( $tbl_name )
    {
        $this->_tbl_match = strip_tags( $tbl_name );
    }
    
    
    /**
    * ȡ󹺡ƥ
    *
    * @access	public
    * @param	void
    * @return	string 󹺡ƥ
    */
    public function get_tbl_match( )
    {
        return $this->_tbl_match;
    }
    
    
    /**
    * ÷ԴҪѯķԴֶ
    *
    * @access	public
    * @param	array  $arr_fields ԴϢֶ
    * @return	void
    */
    public function set_house_fields( $arr_fields )
    {
        $this->_house_fields = $arr_fields;
    }
    
    
    /**
    * ȡԴҪѯķԴֶ
    *
    * @access	public
    * @param	void
    * @return	array  $house_fields ԴϢֶ
    */
    public function get_house_fields()
    {
        return $this->_house_fields;
    }
    
    
    /**
    * õķԴϢҪѯֶ
    *
    * @access	public
    * @param	array  $arr_fields ԴϢֶ
    * @return	void
    */
    public function set_demand_fields( $arr_fields )
    {
        $this->_demand_fields = $arr_fields;
    }
    
    
    /**
    * ȡõķԴϢҪѯֶ
    *
    * @access	public
    * @param	void
    * @return	array  ԴϢҪѯֶ
    */
    public function get_demand_fields()
    {
        return $this->_demand_fields;
    }
    
    
    /**
    * ȡϢ
    *
    * @access	protected
    * @param	string  $cond_where ѯ
    * @return	int   Ϣ
    */
    protected function get_demands_num( $cond_where = '' )
    {
        $demands_num = 0;
        
        //ԴϢ
        $tbl_demand = $this->get_tbl_demand();
        
        //û򷵻0
        if( !in_array( $tbl_demand , array( 'buy' , 'rentwanted' ) ) )
        {
           return $demands_num ;
        }
        
        //ѯ
        if( $cond_where != '')
        {
            $this->dbback->where( $cond_where );
        }

        $demands_num = $this->dbback->get( $tbl_demand )->num_rows();
		//echo $this->dbback->last_query().'<br>';

        return  intval( $demands_num );
    }
    
    
    /**
    * ȡϢб
    *
    * @access	protected
    * @param	string  $cond_where ѯ
    * @param	int     $offset ƫ,ĬֵΪ0
    * @param	int     $pagesize ÿȡĬֵΪ10
    * @param	string  $order_key ֶΣĬֵ
    * @param	string  $order_by  򡢽ĬϽ
    * @return	array   Ϣб
    */
    protected function get_demands_list( $cond_where , $offset = 0 , $limit = 10 , $order_key = 'creattime' , $order_by = 'DESC' )
    {   
        //ԴϢ
        $tbl_demand = $this->get_tbl_demand();
        
        //ҪѯķԴϢֶ
        $select_fields = $this->get_demand_fields();
        
        if( isset( $select_fields ) && !empty( $select_fields ) )
        {   
            //ѯֶ
            $select_fields_str = implode( ',' , $select_fields ) ;
            $this->dbback->select( $select_fields_str );
        }
        
        //ѯ
        if( $cond_where != '')
        {
            $this->dbback->where( $cond_where );
        }

        //
        $this->dbback->order_by( $order_key , $order_by );

        //ѯ
        $arr_data = $this->dbback->get( $tbl_demand , $limit , $offset )->result_array();
		//echo $this->dbback->last_query().'<br>';

        return  $arr_data;
    }
    
    
    /**
    * ȡƥϢ
    *
    * @access	protected
    * @param	string  $cond_where ѯ
    * @return	int   Ϣ
    */
    protected function get_matched_num ( $cond_where = '' )
    {
        $matched_num = 0;
        
        //Դƥ
        $tbl_match = $this->get_tbl_match();
        
        //û򷵻0
        if( !in_array( $tbl_match , array( 'buy_match' , 'rentwanted_match' ) ) )
        {
           return $matched_num ;
        }
        
        //ѯ
        if( $cond_where != '')
        {
            $this->dbback->where( $cond_where );
        }
        
        $matched_num = $this->dbback->get( $tbl_match )->num_rows();

        return  intval( $matched_num );
    }
    
    
    /**
    * ݲѯȡ˺ƥϢ
    *
    * @access	protected
    * @param	string  $cond_where ѯ
    * @param	string  $order_key ֶΣĬֵ
    * @param	string  $order_by  򡢽ĬϽ
    * @return	array   ˺ƥϢ
    */
    protected function get_matched_ids( $cond_where = '' , $order_key = 'creattime' , $order_by = 'DESC')
    {   
        $arr_ids = array();
        
        //ƥ
        $tbl_match = $this->get_tbl_match();
        
        if( $tbl_match == '')
        {
            return $arr_ids;
        }

        //ѯֶ
        $this->dbback->select( 'want_id' );
        $this->dbback->distinct();
        
        //ѯ
        if( $cond_where != '')
        {
            $this->dbback->where( $cond_where );
        }

        //
        $this->dbback->order_by( $order_key , $order_by );

        //ѯ
        $arr_ids = $this->dbback->get( $tbl_match )->result_array();
        //echo $this->dbback->last_query();
        
        return $arr_ids;
    }
    
    
    /**
    * ȡ󹺡б
    *
    * @access	protected
    * @param	string  $cond_where ѯ
    * @param	int     $offset ƫ,ĬֵΪ0
    * @param	int     $pagesize ÿȡĬֵΪ10
    * @param	string  $order_key ֶΣĬֵ
    * @param	string  $order_by  򡢽ĬϽ
    * @return	array   Ϣб
    */
    protected function get_matched_list( $cond_where , $offset = 0 , $limit = 10 , $order_key = 'creattime' , $order_by = 'DESC' )
    {   
        $arr_data = array();
        
        //󹺡Ϣ
        $tbl_demand = $this->get_tbl_demand();
        
        //Ҫѯ󹺡Ϣֶ
        $select_fields = $this->get_demand_fields();
        if( isset( $select_fields ) && !empty( $select_fields ) )
        {   
            $select_fields_str = implode( ',' , $select_fields ) ;
            $this->dbback->select( $select_fields_str );
        }
        
        //ѯ
        if( $cond_where != '')
        {
            $this->dbback->where( $cond_where );
        }

        //
        $this->dbback->order_by( $order_key , $order );

        //ѯ
        $arr_data = $this->dbback->get( $tbl_demand , $limit , $offset )->result_array();

        return  $arr_data;
    }
    
    
    /**
    * ѯĳԴƥ
    *
    * @access	public
    * @param	string  $cond_where ѯ
    * @return	int ĳԴƥ
    */
    public function get_matched_num_by_id( $infofrom = '' , $match_time = '' ,$esta = 0 , $isread = '' )
    {   
        $matched_num = 0;
        
        $id = $this->get_id();

        //Դ
        $cond_where = 'id = '.$id;
        
        //ƥԴ
        if( $infofrom > 0)
        {
            $cond_where .= ' AND infofrom = '.$infofrom;
        }
        
        //ƥʱ
        if( $match_time > 0)
        {
            $cond_where .= ' AND creattime >= '.$match_time;
        }
        
        //ƥϢ״̬
        $cond_where .= ' AND esta = '.$esta;
        
        //ƥϢǷѾ鿴
        if( $isread > 0)
        {
            $cond_where .= ' AND isread = '.$isread;
        }
        
        $matched_num = $this->get_matched_num( $cond_where );
        
        return $matched_num;
    }
    /**
    * ƥ䷿Դ
    *
    * @access	public
    * @param	array  $match_info ƥϢ
    * @return	boolean ƥϢǷύɹ
    */
    public function match_house( $match_info )
    {
        $tbl_match = $this->get_tbl_match();
        
        $this->db->insert( $tbl_match , $match_info );
        
        return ( $this->db->affected_rows() == 1 ) ? $this->db->insert_id() : FALSE;
    }   
}
/* End of file house_demands_model.php */
/* Location: ./zsb/model/house_demands_model.php */