<?php
/*
 * ݴ Dao
 * Fisher 2013-5-27
*/
class Dao
{
	public	$db;
	public	$dbback;

	public	$mc;

	private $db_type;
	private $debug;

	public function __construct($db_type = "mysql")
	{
		$this->db_type = $db_type;
		$this->setDebug();
	}
	
	//Debug
	public function setDebug($debug = false)
	{
		$this->debug = $debug;
	}
	
	//ʼݿ
	public function initDb($db_class_path = "", $db_conf = array(), $dbback_conf = array())
	{
		if(!is_object($this->db) && !is_object($this->dbback))
		{
			if($db_class_path != "")
			{
				$this->_autoLoad($db_class_path);
				
				if(class_exists("TINY_ADODB"))
				{
					if(is_array($db_conf) && !empty($db_conf))
					{
						$this->db = $this->_initDb($db_conf);

						if(is_array($dbback_conf) && !empty($dbback_conf))
						{
							$this->dbback = $this->_initDb($dbback_conf);
						}
						else
						{
							$this->dbback = $this->db;
						}
					}
					else
					{
						$this->_showError("ñ!");
					}
				}
				else
				{
					$this->_showError("DB಻!");
				}
			}
			else
			{
				$this->_showError("DB·!");
			}
		}
	}

	//ʼMC
	public function initMc($localhost = "", $port = "")
	{
		if(!is_object($this->mc) && $localhost != "" && $port != "")
		{
			$this->mc = new Memcache;
			$this->mc->connect($localhost, $port) or $this->_showError("Memcacheʼʧ!");
		}
	}
	
	//ʵݿ󣬲ͬݿඨ岻ͬinit
	private function _initDb($db_conf)
	{
		$dbobj = new TINY_ADODB($db_conf['conf_db_type'],$db_conf['conf_db_host'],$db_conf['conf_db_user'],$db_conf['conf_db_password'],$db_conf['conf_db_name'],$db_conf['conf_db_charset'],$db_conf['conf_db_debug'],$db_conf['conf_db_connect']);
		return $dbobj;
	}

	//ļ
	private function _autoLoad($file_path)
	{
		if($file_path != "")
		{
			include_once($file_path);
		}
		else
		{
			$this->_showError("DB·!");
		}
	}
	
	//Ϣ
	private function _showError($errormsg)
	{
		if($this->debug)
		{
			die($errormsg);
		}
		else
		{
			header('HTTP/1.1 404 Not Found');
			header("status: 404 Not Found");
			exit;
		}
		
	}
	
	//ѯ¼
	public function getAll($tablename, $sswhere = "", $params = " * ", $memkey = "", $memsec = 0, $delcache = false)
	{
		return $this->_selectDb("assoc", $tablename, $sswhere, $params, $memkey, $memsec, $delcache);
	}
	
	//ѯһ¼
	public function getRow($tablename, $sswhere = "", $params = " * ", $memkey = "", $memsec = 0, $delcache = false)
	{
		return $this->_selectDb("row", $tablename, $sswhere, $params, $memkey, $memsec, $delcache);
	}

	//ѯһֵ
	public function getOne($tablename, $sswhere = "", $params = " * ", $memkey = "", $memsec = 0, $delcache = false)
	{
		return $this->_selectDb("one", $tablename, $sswhere, $params, $memkey, $memsec, $delcache);
	}

	//ѯ
	private function _selectDb($type, $tablename, $sswhere, $params, $memkey, $memsec, $delcache)
	{
		if(is_object($this->dbback))
		{
			$data = array();
			$need_mc = $memkey != "" && $memsec > 0 && is_object($this->mc) ? true : false;
			
			if($delcache && $need_mc)
			{
				$this->mc->delete($memkey);
			}

			$cache = $need_mc ? $this->mc->get($memkey) : array();
			if($cache['isok'] == 1)
			{
				$data = $cache['data'];
			}
			else
			{
				$sql  = $this->selectSql($tablename, $sswhere, $params);

				switch($type)
				{
					case "assoc" :	$data = $this->dbback->GetAssoc($sql);
									$data = is_array($data) ? $data : array();
									break;
					case "row" :	$data = $this->dbback->GetRow($sql);
									$data = is_array($data) ? $data : array();
									break;
					case "one" :	$data = $this->dbback->GetOne($sql);
									break;
					default :		$data = array();
									break;
				}

				if($need_mc)
				{
					$this->mc->add($memkey, array("isok"=>1, "data"=>$data), false, $memsec);
				}
			}

			return $data;
		}
		else
		{
			$this->_showError("ûгʼݿ!");
		}
	}
	
	//ѯSQL
	public function selectSql($tablename, $sswhere = "", $params = " * ")
	{
		if($tablename == "")
		{
			$this->_showError("ѯSQL!");
		}
		else
		{
			$wheresql = $sswhere != "" ? " WHERE ".$sswhere : $sswhere;
			$sql = "SELECT ".$params." FROM `".$tablename."`".$wheresql;
		}

		return $sql;
	}

	//²
	public function update($tablename, $field, $sswhere)
	{
		if(is_object($this->db))
		{
			$sql = $this->updateSql($tablename, $field, $sswhere);
			return $this->db->Execute($sql);
		}
		else
		{
			$this->_showError("ûгʼݿ!");
		}
	}
	
	//SQL
	public function updateSql($tablename, $field, $sswhere)
	{
		if($tablename == "" || !is_array($field) || empty($field) || $sswhere == "")
		{
			$this->_showError("SQL!");
		}
		else
		{
			for($i=1; $i<=count($field); $i++)
			{
				if($i == 1)
				{
					$ss =" ".key($field)."='".$this->qstr($field[key($field)],$this->db_type)."' ";
				}
				else
				{
					$ss.=",".key($field)."='".$this->qstr($field[key($field)],$this->db_type)."' ";
				}
				next($field);
			}

			$wheresql = $sswhere != "" ? " WHERE ".$sswhere : $sswhere;
			$sql  = "UPDATE `".$tablename."` set ".$ss.$wheresql;

			return $sql;
		}
	}
	
	//
	public function insert($tablename, $field)
	{
		if(is_object($this->db))
		{
			$sql = $this->insertSql($tablename, $field);
			$this->db->Execute($sql);
			return $this->db->Insert_ID();
		}
		else
		{
			$this->_showError("ûгʼݿ!");
		}
	}

	//SQL
	public function insertSql($tablename, $field)
	{
		if($tablename == "" || !is_array($field) || empty($field))
		{
			$this->_showError("SQL!");
		}
		else
		{
			for($i=1; $i<=count($field); $i++)
			{
				if($i == 1)
				{
					$ss1 = key($field);
				}
				else
				{
					$ss1.=",".key($field);
				}

				if($i == 1)
				{
					$ss2 =" '".$this->qstr($field[key($field)],$this->db_type)."'";
				}
				else
				{
					$ss2.=",'".$this->qstr($field[key($field)],$this->db_type)."'";
				}
				next($field);
			}

			$sql = "INSERT INTO `".$tablename."` ( ".$ss1." ) VALUES ( ".$ss2." ) ";
			return $sql;
		}
	}
	
	//ɾ
	public function delete($tablename,$sswhere)
	{
		if(is_object($this->db))
		{
			$sql = $this->deleteSql($tablename,$sswhere);
			return $this->db->Execute($sql);
		}
		else
		{
			$this->_showError("ûгʼݿ!");
		}
	}

	//ɾSQL
	public function deleteSql($tablename,$sswhere)
	{
		if($tablename == "" || $sswhere == "")
		{
			$this->_showError("ɾSQL!");
		}
		else
		{
			$sql = "delete from `$tablename` WHERE ".$sswhere;
			return $sql;
		}
	}

	//
	public function replace($tablename, $field)
	{
		if(is_object($this->db))
		{
			$sql = $this->replaceSql($tablename, $field);
			$this->db->Execute($sql);
			return $this->db->Insert_ID();
		}
		else
		{
			$this->_showError("ûгʼݿ!");
		}
	}
	
	//SQL
	public function replaceSql($tablename, $field)
	{
		if($tablename == "" || !is_array($field) || empty($field))
		{
			$this->_showError("SQL!");
		}
		else
		{
			for ($i=1; $i<=count($field); $i++)
			{
				if ($i == 1)
				{
					$ss1 =key($field);
				}
				else
				{
					$ss1.=",".key($field);
				}

				if($i == 1)
				{
					$ss2 =" '".$this->qstr($field[key($field)],$this->db_type)."'";
				}
				else
				{
					$ss2.=",'".$this->qstr($field[key($field)],$this->db_type)."'";
				}

				next($field);
			}

			$sql = "REPLACE `".$tablename."` ( ".$ss1." ) VALUES ( ".$ss2." ) ";
			return $sql;
		}
	}

	private function qstr($ss,$slash_flag=true)
	{
		/*
		stripslashesȥslashformύʱģǲܴݿ)
		ݿ⣬ȥݶûslashġ abc'def"fff\hhh
		ѯΪ'
		mssqlѯҪдselect * from test where  col_1 like '%''%'
		mysqlѯҪдselect * from test where  col_1 like '%\'%'
		ѯΪ"
		mssqlѯҪдselect * from test where  col_1 like '%"%'
		mysqlѯҪдselect * from test where  col_1 like '%\"%'

		Ҳ˵mysqlѯʱҪaddslashesmssqlҪ'תΪ''
		  postݣԶslashmssqlmysqlҪstripslashes
		postݣslash  stripslashes
		Ҳ$slash_flagص;:post$slashes_flag=true,=false
		(mysqladdslashesmssql''Ϊ˲ѯ)

		2001.8.1
		slash_flagѾȥbecause of stripslash_vars()
		stripslash_vars()post,getıstripslashesԴ˴strip
		*/
		$replaceQuote["mssql"]	="''";
		$replaceQuote["ibase"]	="\'";
		$replaceQuote["sybase"]	="''";
		$replaceQuote["vfp"]	="'+chr(39)+'";
		$replaceQuote["oracle"]	="\'";

		if ($this->db_type=="mssql")
		return str_replace("'",$replaceQuote[$this->db_type],$ss);

		if ($this->db_type=="mysql") //mysqlݿ⣬addslashessqlѯ൱replaceQuoteĲ
		return addslashes($ss);

	}

	public function __destruct()
	{
		if(is_object($this->db))
		{
			//$this->db->close();
		}
		if(is_object($this->dbback))
		{
			//$this->dbback->close();
		}
		if(is_object($this->mc))
		{
			$this->mc->close();
		}
	}
}
?>