<?php
/**
 * ɳֵײ͵Ĺϵ
 *
 * @author sun
 */
class GrowthExpControllPackage {
    /**
     * ݿ
     */
    private $db;

    /**
     * ݿ
     */
    private $dbback;

    /**
     * 
     */
    private $mc;
    
    /**
     * 
     * @var string
     */
    private $table;
    
    /**
     * ֶ
     * @var array
     */
    private static $fields = array('id','way_alias','package_id','score');
    
    public function __construct() {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->table = 'growth_exp_controll_package';
    }
    
    /**
     * ײ
     * @return array
     */
    public function findAllData() {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields);
        return $this->dbback->getAll($sql);
    }
    
    /**
     * ݻȡ;ɺײͻȡ
     * @param string $wayAlias ;ɱ
     * @param int $packageId ײͱ
     * @return array
     */
    public function findOneByWayAliasAndPackageId($wayAlias, $packageId) {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields, 
                "way_alias = '$wayAlias' AND package_id = $packageId");
        return $this->dbback->getRow($sql);
    }
    
    /**
     * ݻȡ;ɺײͻطֵ
     * @param string $wayAlias ;ɱ
     * @param type $packageId ײͱ
     * @return int
     */
    public function findScoreByWayAliasAndPackageId($wayAlias, $packageId) {
        $arrRow = $this->findOneByWayAliasAndPackageId($wayAlias, $packageId);
        return $arrRow['score'] == '' ? 0 : $arrRow['score'];
    }
    
    /**
     * 
     * @param string $way_alias ;ɱ
     * @param int $package_id ײͱ
     * @param int $score ֵ
     * @return boolean
     */
    public function insertData($way_alias, $package_id, $score) {
        $arrFieldsValue = array();
        $arrFieldsValue['way_alias'] = $way_alias;
        $arrFieldsValue['package_id'] = $package_id;
        $arrFieldsValue['score'] = $score;
        $sql = SqlCombinHelper::insert_sql($this->table, $arrFieldsValue);
        return $this->db->execute($sql);
    }
    
    /**
     * ;ɱɾ
     * @param string $wayAlias ;ɱ
     * @return boolean
     */
    public function delDataByWayAlias($wayAlias) {
        $sql = SqlCombinHelper::delete_sql($this->table, 
                "way_alias = '$wayAlias'");
        return $this->db->execute($sql);
    }
    
    /**
     * ;ɱźײͱɾ
     * @param string $wayAlias ;ɱ
     * @param type $packageId ײͱ
     * @return boolean
     */
    public function delDataByWayAliasAndPackageId($wayAlias, $packageId) {
        $sql = SqlCombinHelper::delete_sql($this->table, "way_alias = "
                . "'$wayAlias'" . "AND package_id = $packageId");
        return $this->db->execute($sql);
    }
    
    /**
     * 
     * @param array $fields ݽṹ
     * @return boolean
     */
    public function saveData($fields) {
        $sql = SqlCombinHelper::replace_sql($this->table, $fields);
        return $this->db->execute($sql);
    }
    
    /**
     * ͨײidȡֵ
     * @param type $wayAlias
     * @param type $packageId
     * @return type
     */
    public function findScoreByWayAliasPackageId($wayAlias, $packageId) {
        $sql = SqlCombinHelper::select_sql($this->table, 'score', "way_alias = "
                . "'$wayAlias' AND package_id = $packageId");
        return $this->dbback->getOne($sql);
    }
}
