<?php

/**
 * core\lib\growth\GrowthBidPeriods.php
 */

/**
 * Ͷڴ
 *
 * @author Administrator
 */
class GrowthBidPeriods {
    
    const BID_PERIODS_STATUS_ON = 1;//
    const BID_PERIODS_STATUS_NOT_START = 2;//δʼ
    const BID_PERIODS_STATUS_FINISH = 3;//ѽ

    /**
     *
     * @var TINY_ADODB ݿ
     */
    private $db;
    /**
     *
     * @var TINY_ADODB ݿ
     */
    private $dbback;
    /**
     *
     * @var MCache 
     */
    private $mc;
    /**
     *
     * @var string 
     */
    private $table;
    /**
     *
     * @var ֶ 
     */
    private $fields;
    
    /**
     * Ͷ
     * @var type 
     */
    private static $bidType = array(
        'blockexpert' => 1, 'house' => 2 
    );
    
    /**
     * ʼ
     * @param string $table ĬΪgrowth_bid_periods
     */
    public function __construct($table = 'growth_bid_periods') {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->table = $table;
        $this->mc = $container->get('mc');
        $sqlfield = "DESC $this->table";
        $fieldsMKey = $sqlfield;
        $this->fields = $this->mc->get($fieldsMKey);
        if($this->fields === false) {
            $fields = $this->dbback->getAll($sqlfield);
            foreach ($fields as $field) {
                $this->fields[] = $field['Field'];
            }
            $this->mc->set($fieldsMKey, $this->fields, 3600);
        }
    }
    
    /**
     * idҾͶڴϢ
     * @param int $id ڴid
     * @return array ڴݣʼʱ䣬ʱ
     */
    public function findById($id) {
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields,"id='$id'");
        return $this->dbback->getRow($sql);
    }
    
    /**
     * ָ
     * @param string $conf 
     * @return type
     */
    public function findBy($conf='',$order = '',$limit = '') {
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields,$conf);
        if($order) {
            $sql .= " order by $order";
        }
        if($limit) {
            $sql .= " limit $limit";
        }
        return $this->dbback->getAll($sql);
    }
    
    public function findAll($conf='') {
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields,$conf);
        return $this->dbback->GetAssoc($sql);
    }

    /**
     * $fieldData뵽
     * @param array $fieldData
     * @return boolean ɹزidʧܷfalse
     */
    public function insert($fieldData) {
        
        if($this->checkField($fieldData)){
            $sql = SqlCombinHelper::insert_sql($this->table, $fieldData);
            $this->db->execute($sql);
            return $this->db->Insert_ID();
        } else {
            return false;
        }

    }
    
    /**
     * Ƿȷ
     * @param array $fields Ҫ
     * @return boolean ȷtrueʧܷfalse
     */
    public function checkField($fieldData) {
        $fields = array_keys($fieldData);
        if(array_intersect($fields, $this->fields)==$fields){
            return true;
        } else {
            return false;
        }
    }
    
    public static function formatTime($startTime,$endTime,$format="Y.m.d") {
        $stime = strtotime($startTime);
        $etime = strtotime($endTime);
        return date($format,$stime)."-".date($format,$etime);
    }

    /**
     * ȡСĳһ֮ǰһid
     * @param type $type
     * @param type $periodsId
     */
    public function upBidPeriods($type = 1, $periodsId) {
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, 
                "id < $periodsId AND type = $type ORDER BY id DESC");
        return $this->dbback->getRow($sql);
    }
    
    public function currentBidPeriods($type = 1) {
        //һڵid
        $confgbp = "type=$type";
        $order = "ctime desc";
        $limit = "0,1";
        $bidp = $this->findBy($confgbp, $order, $limit);
        if($bidp&&$bidp[0]) {
            $bidp= $bidp[0];
        } else {
            return false;
        }
        //$bidpid = $bidp['id'];
        //жϱڵ״̬
        $time = time();
        $start_time = strtotime($bidp['start_time']);
        $end_time = strtotime($bidp['end_time']);
        if($time>=$start_time&&$time<$end_time) {//
            $bidp['status'] = '1';
        } else if($time<$start_time){
            $bidp['status'] = '2';//δʼ
        } elseif($time>=$end_time) {
            $bidp['status'] = '3';//Ͷ
        }
        return $bidp;
    }
    
    /**
     * жڴǷھͶ
     * @param array $bidp ڴ
     * @return boolean true ʾھͶУfalse ʾھͶ
     */
    public static function isBidOn($bidp) {
        $time = time();
        $start_time = strtotime($bidp['start_time']);
        $end_time = strtotime($bidp['end_time']);
        if($time>=$start_time&&$time<$end_time) {//
            return true;
        } else{
            return false;//δʼ
        } 
    }
}

?>
