<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * ҳ 
 *
 * @package         zsb
 * @subpackage      Models
 * @category        Models
 * 
 */
class Question_answer_model extends MY_Model{
    private $tbl_question = '';
    private $tbl_answer = '';
    private $tbl = '';

	/**
    * KEY
    *
    * @access private
    * @var string
    */
    private $_mem_key = 'qusetion_answer_model';
    
    /**ѯֶ
     * @var string
     */
    protected $select_fields = '';
    
    /**
     * ѯ
     * @var array
     */
    protected $join_arr = array();
    
    /**
     * 
     * @var string
     */
    protected $join_type = '';
    
    public function __construct() {
        parent::__construct(1,1,3);
       
        $this->tbl_question = "qa_question";
        $this->tbl_answer = "qa_answer";       
       
       
   }
   
   
   /**
     * Ҫѯֶ
     * @param array $select_fields
     */
    public function set_select_fields($select_fields)
    {
        $select_fields_str = '';
        if(isset( $select_fields ) && !empty($select_fields))
        {   
            $select_fields_str = implode( ',', $select_fields) ;
        }
        $this->select_fields = $select_fields;
    }
    
    
    /**
     * ȡҪѯֶ
     * @return type
     */
    public function get_select_fields()
    {
        return $this->select_fields;
    }
    
    /**
     * ϲѯ
     */
    public function set_join_table($join_arr,$join_type){
        $this->join_arr = $join_arr;
        $this->join_type = $join_type;
    }
    
    /**
     * ϲѯ
     */
    public function clear_join_table(){
        $this->join_arr = '';
        $this->join_type = '';
    }
    
    /**
     * ȡϲѯ
     */
    public function get_join_table(){
        return $this->join_arr;
    }
   
    /**
     * òѯݵı
     * @param string $tbl
     */
    public function set_tbl($tbl) 
    {
        $this->tbl = $tbl;
    }
    
    /**
     * ȡѯݵı
    * @return string $tbl 
    */
   public function get_tbl() {
           return $this->tbl;
   }
   
   /**
     * ȡбҳ
     * @param string $where ѯ
     * @param int $start ѯʼ
     * @param int $limit ƫ
     * @param int $order_key ֶ
     * @param string $order_by 򡢽ĬϽ
     * @return array Ϣ
     */
    public function find_all_by($where, $start = 0, $limit = 20, 
            $order_key = 'id' , $order_by = 'DESC') 
    {
        
        //ѯֶ
        if ($this->select_fields)
        {
            $this->dbback->select($this->select_fields);
        }       
		//ѯ
		$this->dbback->where($where);
		//
        
		$this->dbback->order_by($order_key, $order_by);

		if ( $start >= 0 && $limit > 0 )
		{
			$this->dbback->limit($limit, $start);
		}      
		if(is_array($this->join_arr)&&!empty($this->join_arr))
		{
			foreach ($this->join_arr as $key=>$value)
			{
				$this->dbback->join($key,$value,$this->join_type);
			}            
		}
		
		$result_array = $this->dbback->get($this->tbl)->result_array();      
        
        return $result_array;
    }

	 /**
     * ȡбҳ
     * @param string $where ѯ
     * @param int $start ѯʼ
     * @param int $limit ƫ
     * @param int $order_key ֶ
     * @param string $order_by 򡢽ĬϽ
     * @return array Ϣ
     */
    public function find_all_by_master($where, $start = 0, $limit = 20, 
            $order_key = 'id' , $order_by = 'DESC') 
    {
        
        //ѯֶ
        if ($this->select_fields)
        {
            $this->dbback->select($this->select_fields);
        }       
		//ѯ
		$this->dbback->where($where);
		//
        
		$this->dbback->order_by($order_key, $order_by);

		if ( $start >= 0 && $limit > 0 )
		{
			$this->dbback->limit($limit, $start);
		}      
		if(is_array($this->join_arr)&&!empty($this->join_arr))
		{
			foreach ($this->join_arr as $key=>$value)
			{
				$this->dbback->join($key,$value,$this->join_type);
			}            
		}
		
		$result_array = $this->dbback->get($this->tbl)->result_array();      
        
        return $result_array;
    }
    
    
    
    /**
     * ȡѯͳ
     * @param string $where ѯ
     * @return int 
     */
    public function find_count_by($where)
    {          
            $this->dbback->where($where);
            $this->dbback->from($this->tbl);            
            if(is_array($this->join_arr)&&!empty($this->join_arr))
           {
                foreach ($this->join_arr as $key=>$value)
                {
                    $this->dbback->join($key,$value,$this->join_type);
                }            
            }        
            $count = $this->dbback->count_all_results();
          //  echo $this->dbback->last_query();          
            return $count;
    }
    
    
    /**
     * ݲѯһļ¼
     * @param string $where ѯ
     * @return array һһάϢ¼
     */
    public function find_one_by($where = '')
    {
        //ѯֶ
        if ($this->select_fields)
        {
            $this->dbback->select($this->select_fields);
        }
        //ѯ
        $this->dbback->where($where);       
        if(is_array($this->join_arr)&&!empty($this->join_arr)){
            foreach ($this->join_arr as $key=>$value){
                $this->dbback->join($key,$value,$this->join_type);
            }            
        }
        return $this->dbback->get($this->get_tbl())->row_array();
    }
    
    
    
     /**
     * 
     * insert_answer
     * @param int id id
     * @param string  $answertext ش   
     * @param int $uid ûid 
     * @param int׷id
     * @param int ش
     */    
    public function insert_answer($id,$answertext,$uid,$reqid=0,$type=0,$expScore=0,$diffFlag=0){  
        $data_array['a_qid']	  = $id;
		$data_array['a_message']  = csubstr(strip_tags($answertext), 2000);
        $data_array['a_userid']	  = $uid;
        $data_array['a_dateline'] = time();
        $data_array['a_user_type']= 1;
        $data_array['a_ip']		  = get_ip();
        $data_array['a_num']	  = 0;
        $data_array['a_type']	  = $type;
        $data_array['a_best']	  = 0;
        $data_array['a_req_id']	  = $reqid;
        $data_array['a_score']    = $expScore;
        $data_array['a_diff']     = $diffFlag;
        $return = $this->db->insert($this->tbl_answer, $data_array);
        return $this->db->insert_id();
      
    }
    
    
    /**
     * »ظ
     * updateReplyNum
     */
    public function updateReplyNum($id){
        //$this->db->where("q_id = $id");
        //$this->db->update($this->tbl_question,array('q_anum'=>'q_anum+1'));

		$sql = "UPDATE $this->tbl_question set q_anum=q_anum+1 WHERE `q_id` = '".$id."'";
		return $result = $this->db->query($sql);
		 //echo $this->db->last_query();  
    }
    
    
    /**
     * ͬδظ
     * syncNoReadReply
     */   
    public function syncNoReadReply($id){        
        //ѯֶ
        $this->dbback->select("q_id");
        //ѯ
        $this->dbback->where("q_id = $id");
        //ѯ
        $arr_data = $this->dbback->get('qa_question_sub')->row_array();
        
        if($arr_data['q_id']){
            $this->updateReplyNumLog($id);
        }else{
            $this->addReplyNumLog($id);
        }  
        
    }
    
    /**
     * ش¼
     * addReplyNumLog
     * @param int $id
     */
    
    private function addReplyNumLog($id){
        $data = array('q_id' => $id, 'q_anum' => 1);
        $this->db->replace('qa_question_sub',$data);
    } 
    
    
    /**
     * ޸ش
     * updateReplyNumLog
     * @param int  $id
     */
    private function updateReplyNumLog($id){
       // $this->db->where("q_id = $id");
        //$this->db->update('qa_question_sub',array('q_anum'=>'q_anum+1'));

		$sql = "UPDATE qa_question_sub set q_anum=q_anum+1 WHERE `q_id` = '".$id."'";
		return $result = $this->db->query($sql);
        
    }
    
    /**
     * ݾiduid鿴شID
     * getAidContentByUidQid
     * @param int $uid 
     * @param int $qid 
     * @return array
     */
    public function getAidContentByUidQid($uid,$qid){        
        //ѯֶ
        $this->dbback->select("a_id,a_message");
        //ѯ
        $this->dbback->where("a_qid = $qid and a_type = 0 AND a_userid = $uid AND a_user_type = 1");
        //ѯ
        $arr_data = $this->dbback->limit(1)->get($this->tbl_answer)->row_array();
        return $arr_data;
    }
    
    /**
     * 鿴׷
     * getReQuestion
     * @param int $id id
     * @return array 
     */
    public function getReQuestion($id){
        if(!$id) {
            return FALSE;            
        }     
        $cond_where = "a_req_id = $id";
        $this->dbback->where($cond_where);        
        $arr_data = $this->dbback->order_by("a_id", "asc")->limit(10)->get($this->tbl_answer)->result_array(); 
        return $arr_data;
    }
    
    /**
     * Ƿܻش
     * allowToAnsewer
     * @param time $q_expiredate ʱ
     * @param int $q_answer_type 
     * @return Boolean 
     */
    public function allowToAnsewer($q_expiredate,$q_answer_type){
        $nowtime = time();
        $allowtoanswer = $q_expiredate >= $nowtime && $q_answer_type == 0 ? true : false;
        return $allowtoanswer;
    }
    
    /**
     * Գ̶жϣݻشĿûشѵģ
     * questionDiff
     * @param int $qid id 
     */
    public function questionDiff($qid){
        //ѯֶ
        $this->dbback->select("q_anum");
        //ѯ
        $this->dbback->where("q_id = $qid");
        //ѯ
        $arr_data = $this->dbback->get($this->tbl_question)->row_array();    
		 
        return $arr_data['q_anum'];
    }

    /**
     * лش
     * @param int $id ID
     * @return int ͳ
     */
    public function answerCountByAid($id){
		$mem_key = $this->_mem_key.'answer_Count_By_Aid_2014_10_24'.$id;     
		$cache = $this->mc->get($mem_key);        
        if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
        {
            $count_num = $cache['data'];
        }
        else
        {
			$cond_where = "a_qid = $id  AND  a_type = 0 ";
			$this->dbback->where( $cond_where );
			$count_num = $this->dbback->from($this->tbl_answer)->count_all_results(); 
			$this->mc->add($mem_key , array('is_ok'=>1 , 'data'=>$count_num) , 10);
		}
        return $count_num;
    }
    
    /**
     * ȡ
     * getClass
     */
    public function getClass(){
		$mem_key = $this->_mem_key.'ask_get_Class_2014_10_23';     
		$cache = $this->mc->get($mem_key);        
        if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
        {
            $arr_data = $cache['data'];
        }
        else
        {
			$this->dbback->select(" t_id,t_name");
			$cond_where = "t_level = 0";
			$this->dbback->where($cond_where);
			$arr_data = $this->dbback->get("qa_type")->result_array();  
			$this->mc->add($mem_key , array('is_ok'=>1 , 'data'=>$arr_data) ,  86400);
		}
		return $arr_data;
    }
    
   /**
    * ȡ
    * getSubClass
    * @param int $id   һid
    * @return array
    */
    public function getSubClass($id){    
		$mem_key = $this->_mem_key.'ask_get_Sub_Class_2014_10_15_'.$id;     
		$cache = $this->mc->get($mem_key);        
        if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
        {
            $arr_data = $cache['data'];
        }
        else
        {
			$this->dbback->select(" t_id,t_name");
			$cond_where = "t_fid = $id";
			$this->dbback->where($cond_where);
			$arr_data = $this->dbback->get("qa_type")->result_array(); 
			$this->mc->add($mem_key , array('is_ok'=>1 , 'data'=>$arr_data) ,  86400);

		}
      
        return $arr_data;        
    }
    
    
    /** Get_IsforbiddenByuid($uid,$usertype,$day)
	* @ ȡûǷ񱻽
	* @param  int $uid		user
	* @param  string $day	user 1 ˣ2
	* @return boolean $is_forbidden Ƿ񱻽
	**/
	public function getIsforbiddenByuid($uid,$usertype,$day=3){	
		$is_forbidden = false;		
        $mem_key = $this->_mem_key.'ask_user_IsforbiddenByuid_2014_10_15_'.$uid.'_'.$usertype."_".$day;       
		$result_t = $this->mc->get($mem_key);
		if($result_t){
			$result = $result_t;
		}else{
			$day = $day >0 ? $day :3;
			$nowtime	= time();
			$starttime	= $nowtime - $day*86400;
            $this->set_tbl('qa_forbid');
            $cond_where = "f_uid = '".intval($uid)."' AND f_userType = '".intval($usertype)."' AND f_esta = 1 AND dateline BETWEEN ".$starttime."  AND ".$nowtime."  ";
            $result = $this->find_count_by($cond_where);			
			
			$this->mc->add($mem_key,$result,false,600);
		}
		
		$is_forbidden = $result > 0 ?  true : false;

		return $is_forbidden;
	}
    
    
    
    
    
    
   
   
  
   
  
   
   
    
}




