<?php !defined('APP_DIR') ? die('acceess not defined') : '';
/**
 * ʱת
 * 
 * @author gehaifeng
 *
 */
class timezone{
    static protected $default_timezone = 8;
    static $timezones = array(
        '-1' => 'һ',    '-2' => '',    '-3' => '',    '-4' => '',
        '-5' => '',    '-6' => '',    '-7' => '',    '-8' => '',
        '-9' => '',    '-10' => 'ʮ',   '-11' => 'ʮһ', '-12' => 'ʮ',
        '0' => 'ʱ',
        '1' => 'һ',     '2' => '',     '3' => '',     '4' => '',
        '5' => '',     '6' => '',     '7' => '',     '8' => '',
        '9' => '',     '10' => 'ʮ',    '11' => 'ʮһ',   '12' => 'ʮ',
    );
    static $timezone_identifier = array(
        '-12' => 'Kwajalein',
        '-11' => 'Pacific/Midway',
        '-10' => 'Pacific/Honolulu',
        '-9'  => 'America/Anchorage',
        '-8'  => 'America/Los_Angeles',
        '-7'  => 'America/Denver',
        '-6'  => 'America/Tegucigalpa',
        '-5'  => 'America/New_York',
        '-4'  => 'America/Halifax',
        '-3'  => 'America/Sao_Paulo',
        '-2'  => 'Atlantic/South_Georgia',
        '-1'  =>  'Atlantic/Azores',
        '0'   => 'Europe/Dublin',
        '1'   => 'Europe/Belgrade',
        '2'   => 'Europe/Minsk',
        '3'   => 'Asia/Kuwait',
        '4'   => 'Asia/Muscat',
        '5'   => 'Asia/Yekaterinburg',
        '6'   => 'Asia/Dhaka',
        '7'   => 'Asia/Krasnoyarsk',
        '8'   => 'Asia/Brunei',
        '9'   => 'Asia/Seoul',
        '10'  => 'Australia/Canberra',
        '11'  => 'Asia/Magadan',
        '12'  => 'Pacific/Fiji',
        '13'  => 'Pacific/Tongatapu',
    );
    /**
     * ȡʱHTML
     *
     */
    public function timezone_select_html(){
        $tz = self::user_timezone();
        $html = '';
        $timezones = self::$timezones;
        foreach ($timezones as $key => $value){
            $html.= "<option value='{$key}'".($key == $tz ? ' selected' : '').">{$value}</option>";
        }
        return $html;
    }
    
    /**
     * ûõʱʱת
     *
     * @param string $date
     * @return string
     */
    public function user_timezone_date($date){
        $time = strtotime($date);
        $timezone = self::user_timezone();
        
        $timezone_now = new DateTimeZone(date_default_timezone_get());
        $timezone_set = new DateTimeZone(self::$timezone_identifier[$timezone]);
        
        $date_time_set = new DateTime('now', $timezone_set);
        $time_offset = $timezone_now->getOffset($date_time_set);
        $time = $time+$time_offset;
        
        date_default_timezone_set(self::$timezone_identifier[$timezone]);
        return date('Y-m-d H:i', $time);
    }
    
    /**
     * ȡûõʱ
     *
     * @return int
     */
    public function user_timezone(){
        $timezone = cookie::get('time_zone_cootkie', self::$default_timezone);
        return $timezone;
    }
    
    /**
     * ûѡʱ
     *
     * @param int $time_zone
     */
    public function set_timezone($time_zone){
        cookie::set('time_zone_cootkie',$time_zone);
    }
}
?>