<?php
/**
 * core\lib\growth\GrowthExpDayCount.php
 */

/**
 * ÿճɳֵͳƲ
 *
 * @author sun
 */
class GrowthExpDayCount {
    /**
     * ݿ
     */
    private $db;

    /**
     * ݿ
     */
    private $dbback;

    /**
     * 
     */
    private $mc;
    
    /**
     * ı
     * @var string
     */
    private $table;
    
    /**
     * аֶ
     * @var array
     */
    private static $fields = array('id','ctime','way_alias',
        'broker_id','day_exp');
    
    public function __construct() {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->mc = $container->get('mc');
        //print_r($this->mc);
        $this->table = 'growth_exp_day_count';
    }
    
    /**
     * idŲһ¼
     * @param int $id 
     * @return array һ¼
     */
    public function findOneById($id) {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields,
                'id ='.$id);
        return $this->dbback->getRow($sql);
    }
    
    /**
     * ݷʽȡؼ¼
     * @param string $wayAlias ʽ
     * @return array
     */
    public function findAllByWayAlias($wayAlias) {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields, 
                "way_alias = '$wayAlias'");
        return $this->dbback->getAll($sql);
    }
    
    /**
     * ݷʽ;˱Żȡؼ¼
     * @param type $wayAlias ʽ
     * @param type $brokerId ˱
     * @return array
     */
    public function findAllByWayAliasAndBrokerId($wayAlias, $brokerId) {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields, 
                "way_alias = $wayAlias AND broker_id = $brokerId");
        return $this->dbback->getAll($sql);
    }
    
    /**
     * ݷʽͳʱȡز
     * @param type $wayAlias ʽ
     * @param type $ctime ͳʱ
     * @return array
     */
    public function findAllByWayAliasAndCtime($wayAlias, $ctime) {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields, 
                "way_alias = $wayAlias AND ctime = $ctime");
        return $this->dbback->getAll($sql);
    }
    
    /**
     * ݾ˱Żȡز
     * @param type $brokerId ˱
     * @return array
     */
    public function findAllByBrokerId($brokerId) {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields, 
                "broker_id = $brokerId");
        return $this->dbback->getAll($sql);
    }
    
    /**
     * ͳʱȡز
     * @param type $ctime
     * @return array
     */
    public function findAllByCtime($ctime) {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields, 
                "ctime = $ctime");
        return $this->dbback->getAll($sql);
    }
    
    /**
     * ݾ˱źͳʱȡز
     * @param type $brokerId ˱
     * @param type $ctime ͳʱ
     * @return array
     */
    public function findOneByBrokerIdAndCtime($brokerId, $ctime) {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields, 
                "broker_id = $brokerId AND ctime = $ctime");
        return $this->dbback->getAll($sql);
    }
    
    /**
     * ݾ˱šʽͳʱȡز
     * @param date $ctime ͳʱ
     * @param string $wayAlias ʽ
     * @param int $brokerId ˱
     * @return array һ¼
     */
    public function findOneByUniqueIndex($ctime,$wayAlias,$brokerId) {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields, 
                "ctime = '$ctime' AND way_alias='$wayAlias'"
                . " AND broker_id=$brokerId");
        return $this->db->getRow($sql);
    }
    
   /**
    * 
    * @param date $ctime ͳʱ
    * @param string $wayAlias ȡʽ
    * @param int $brokerId ˱
    * @param int $dayExp ɳֵ
    * @return boolean trueسɹfalseʧ
    */
    public function insertData($ctime,$wayAlias,$brokerId,$dayExp) {
        $arrFieldsValue = array();
        $arrFieldsValue['broker_id'] = $brokerId;
        $arrFieldsValue['way_alias'] = $wayAlias;
        $arrFieldsValue['day_exp'] = $dayExp;
        $arrFieldsValue['ctime'] = $ctime;
        $sql = SqlCombinHelper::insert_sql($this->table, $arrFieldsValue);
        return $this->db->execute($sql);
    }
    
    /**
     * ݾ˱šʽͳʱӻ߼ٳɳֵ
     * @param string $ctime ͳʱ
     * @param string $wayAlias ȡʽ
     * @param int $brokerId ˱
     * @param int $score ɳֵ
     * @return boolean trueسɹfalseʧ
     */
    public function addScoreToOneByUniqueIndex($ctime,$wayAlias,$brokerId, $score) {
        $score = $score > 0 ? '+' . $score : $score;
        $arrField['day_exp'] = $score;
        $sql = SqlCombinHelper::updateSelf_sql($this->table, $arrField, 
                "ctime = '$ctime' AND way_alias='$wayAlias'"
                . " AND broker_id=$brokerId");
        return $this->db->execute($sql);
    }

    /**
     * ÿӳɳֵ¼
     * @param string $ctime ͳʱ
     * @param string $wayAlias ȡʽ
     * @param int $brokerId ˱
     * @param int $score ɳֵ
     * @return boolean trueسɹfalseʧ
     */
    public function increase($ctime,$wayAlias,$brokerId,$score) {
        $score = abs($score);
        $arrRow = $this->findOneByUniqueIndex($ctime, $wayAlias, $brokerId);
        if (count($arrRow) == 0) {
            $status = $this->insertData($ctime, $wayAlias, $brokerId, $score);
        } else {
            $status = $this->addScoreToOneByUniqueIndex($ctime, $wayAlias, 
                    $brokerId, $score);
        }
        return $status;
    }
    
    /**
     * ÿٳɳֵ¼
     * @param string $ctime ͳʱ
     * @param string $wayAlias ȡʽ
     * @param int $brokerId ˱
     * @param int $score ɳֵ
     * @return boolean trueسɹfalseʧ
     */
    public function reduce($ctime,$wayAlias,$brokerId,$score) {
        $score = '-' . abs($score);
        $arrRow = $this->findOneByUniqueIndex($ctime, $wayAlias, $brokerId);
        if (count($arrRow) == 0) {
            $status = $this->insertData($ctime, $wayAlias, $brokerId, $score);
        } else {
            $status = $this->addScoreToOneByUniqueIndex($ctime, $wayAlias, 
                    $brokerId, $score);
        }
        return $status;
    }
    
    /**
     * һóɳֵܺ
     * @param type $day
     * @param type $brokerId
     * @return type
     */
    public function findCountExpByDay($day, $brokerId) {
        $sql = SqlCombinHelper::select_sql($this->table, 'SUM(day_exp)', 
                "ctime = '$day' AND broker_id = $brokerId");
        return $this->dbback->getOne($sql);
    }

        
    /**
     * һóɳֵĳָĿܺ
     * @param type $day
     * @param type $brokerId
     * @param type $wayArr
     * @return type
     */
    public function findCountExpByDayExOther($day, $brokerId,$wayArr) {
        $way = '';
        for($i=0;$i<$j=count($wayArr);$i++){
            $way .= $i == $j-1 ?  "'".$wayArr[$i]."'" :  "'".$wayArr[$i]."',";
        }
        $sql = SqlCombinHelper::select_sql($this->table, 'SUM(day_exp)', 
                "ctime = '$day' AND broker_id = $brokerId AND way_alias NOT IN ($way)");
        return $this->dbback->getOne($sql);
    }

   
    
	/**
     * ʱ䣬ȡʽid;idÿճɳֵ
     * @param string $ctime ڣʽ磺2014-02-20
     * @param array $wayAliasArr ȡʽ
     * @param int $brokerId id
     * @return int ܵĳɳֵ
     */
    public function findArrayByTimeWayAliasBrokerId($ctime,$wayAliasArr,$brokerId) {
        $wayAlias = '';
        if (is_array($wayAliasArr)) {
            for($i=0;$i<$j=count($wayAliasArr);$i++){
                $i == $j-1 ? $wayAlias .="'".$wayAliasArr[$i]."'" : $wayAlias .="'".$wayAliasArr[$i]."',";			
            }
        } else {
            $wayAlias = "'" . $wayAliasArr . "'";
        }
        $sql = SqlCombinHelper::select_sql($this->table, "sum(day_exp) as sum_exp", "ctime ='".$ctime."' and way_alias in (".$wayAlias.") and broker_id=$brokerId");       
       return $this->dbback->getOne($sql);
    }

    /**
     * ʱ䣬ȡʽÿճɳֵܺ
     * @param string $ctime ڣʽ磺2014-02-20   
     * @param int $brokerId id
     * @return int ܵĳɳֵ
     */
    public function findExpSumByTimeBrokerId($ctime,$brokerId) {		
        $sql = SqlCombinHelper::select_sql($this->table, "sum(day_exp) as sum_credit", "ctime ='".$ctime."' and broker_id=$brokerId");
        $allBrokerExpNum = $this->mc->get($sql);
        if ($allBrokerExpNum === false) {
            $allBrokerExpNum = $this->dbback->getOne($sql);
            $this->mc->set($sql, $allBrokerExpNum,300); 
        }
        return $allBrokerExpNum;
        //return $this->dbback->getOne($sql);
    }


	/**
     * ǰСƻȡֵֵ
     * @param type $brokerId  id
     * @param type $wayAliasArr ȡ; 
     */
    public function getImproveExpCountByUid($brokerId,$wayAliasArr) {
        $wayAlias = '';
        if (is_array($wayAliasArr)) {
            for($i=0;$i<$j=count($wayAliasArr);$i++){
                $i == $j-1 ? $wayAlias .="'".$wayAliasArr[$i]."'" : $wayAlias .="'".$wayAliasArr[$i]."',";			
            }
        } else {
            $wayAlias = "'" . $wayAliasArr . "'";
        }
        $sql = SqlCombinHelper::select_sql($this->table,'sum(day_exp) as num', "broker_id='$brokerId'   and way_alias in (".$wayAlias.")");

        return $this->dbback->getOne($sql); 
    }

   /**
	**ȡСƵȡֵ
	**@param string $ctime  ʱʽ磺2014-02-23
	**@return int 
	**
	**/
	public function findBrokerImproveNumber($ctime,$wayAliasArr){
        $wayAlias = '';
        if (is_array($wayAliasArr)) {
            for($i=0;$i<$j=count($wayAliasArr);$i++){
                $i == $j-1 ? $wayAlias .="'".$wayAliasArr[$i]."'" : $wayAlias .="'".$wayAliasArr[$i]."',";			
            }
        } else {
            $wayAlias = "'" . $wayAliasArr . "'";
        }
		$sql = SqlCombinHelper::select_sql($this->table, "count(DISTINCT(broker_id)) as num", "ctime ='".$ctime."' and way_alias in (".$wayAlias.") ");
        return $this->dbback->getOne($sql);
	}

   /**
	**ȡСƵȡֱٵľ˸
	**@param string $ctime  ʱʽ磺2014-02-23  
	**@param array    $wayAliasArr ȡ; 
	**@param int   $myCredit һȡĻ
	**return  int  
	**/
	public function findImproveBelowExpBroker($ctime,$wayAliasArr,$myCredit){
        $wayAlias = '';
        if (is_array($wayAliasArr)) {
            for($i=0;$i<$j=count($wayAliasArr);$i++){
                $i == $j-1 ? $wayAlias .="'".$wayAliasArr[$i]."'" : $wayAlias .="'".$wayAliasArr[$i]."',";			
            }
        } else {
            $wayAlias = "'" . $wayAliasArr . "'";
        }
	   $sql = SqlCombinHelper::select_sql($this->table, "count(id) as num", "ctime = '$ctime' and way_alias in (".$wayAlias.") GROUP BY broker_id HAVING SUM(day_credit) < $myCredit");
	   $brokerArr = $this->dbback->getAll($sql);
       $result = count($brokerArr);
       return $result;
	}
    
	/**
     * ʱͱȡǰɳֵ
     * @param type $brokerId  id
     * @param string $ctime  ʱʽ磺2014-02-23
     * @param type $wayAliasArr ȡ; 
     */
    public function getExpAndRank($brokerId, $wayAliasArr, $ctime = null) {
        if ($ctime == null) {
            $ctime = date('Y-m-d');
        }
        if (is_array($wayAliasArr)) {
            $key = md5(serialize($wayAliasArr) . $brokerId . $ctime);
        } else {
            $key = md5($wayAliasArr . $brokerId . $ctime);
        }
        //$this->mc->delete($key);
        $result = $this->mc->get($key);
        //ղȡĳɳֵ
        $publishHouseDayExp = $this->findArrayByTimeWayAliasBrokerId($ctime, $wayAliasArr, $brokerId);
        $publishHouseDayExp = $publishHouseDayExp == '' ? 0 : $publishHouseDayExp;
        if ($result === false) {
            //ܵľ
            $growthExp = new GrowthExp();
            $allBrokerExpNum = $growthExp->findCountBrokerAndExpInfo();
            //$allBrokerExpNum = count($allBrokerExpInfo);

            //ȡȫжپ - μӻȡ;ľ = õûвμӵľ
            //õûвμӵľ + 췢ڱ˵ = õ

            //μӷԴľ
            $dayPublishBrokerNum = $this->findBrokerImproveNumber($ctime, $wayAliasArr);

            //췢ڱ˵
            //$dayPublishBelowBrokerNum = $this->findImproveBelowExpBroker($ctime,$wayAliasArr,$publishHouseDayExp) - 1;

            //ǰ
            $rank = $allBrokerExpNum - $dayPublishBrokerNum;
            if ($allBrokerExpNum == 0) {
                $brokerExpPlot = 100;
            } else {
                //˶پ
                $brokerExpPlot = ceil((($rank) / $allBrokerExpNum)*100);
            }
            if($brokerExpPlot >= 100){
               $brokerExpPlot = 99;
            }
            $result = array( 'rank' => $rank, 'rate' => $brokerExpPlot);
            $this->mc->set($key, $result, false, 3600);
        }
        $result['exp'] = $publishHouseDayExp;
        //print_r($result);
        return $result;
    }
}
