<?php

/**
 * core\lib\growth\GrowthCredit.php
 */

/**
 * ˻
 *
 * @author wxj
 */
class GrowthCredit {
    /**
     *
     * @var TINY_ADODB ݿ 
     */    
    private $db;
    
    /**
     *
     * @var type ݿ
     */
    private $dbback;
    
    /**
     *
     * @var type 
     */
    private $mc;

    /**
     *
     * @var String ı 
     */
    private $table;

    /**
     *
     * @var array   аֶ 
     */
    private $fields = array('id','broker_id','credit','frozen','status');


    /**
     * 캯ʼdb memcache ȡ
     * @param string $table ʹĬֵ
     */
    public function __construct($table = null) {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->table = 'growth_credit';
        $this->mc = $container->get('mc');
        $sqlfield = "DESC $this->table";
        $fieldsMKey = $sqlfield;
        $this->fields = $this->mc->get($fieldsMKey);
        //modified by bianshiwu 20141218 empty($this->fields) á===Ϊֹ$this->fieldsΪյ
        if(empty($this->fields)) {
            $fields = $this->dbback->getAll($sqlfield);
            foreach ($fields as $field) {
                $this->fields[] = $field['Field'];
            }
            $this->mc->set($fieldsMKey, $this->fields, 3600);
        }
    }
    
    /**
     * ͨidһ
     * @param type $id ֱеId
     * @return array һһݵ 
     */
    public function findOne($id) {
        //$sql = "select id,broker_id,credit,status from $this->table where id = $id";
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, "id = '$id'");
        return $this->dbback->getRow($sql);
    }

    /**
     * ͨidһݣfindOneı
     * @param type $id ֱеId
     * @return type һһݵ 
     */
    public function findById($id) {
        return $this->findOne($id);
    }
    
    /**
     * ݾidҾ˻
     * @param type $brokerId id
     * @return array һһݵ 
     */
    public function findByBrokerId($brokerId) {
        //$sql = "select id,broker_id,credit,status from $this->table where id = $brokerId";
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, "broker_id = '$brokerId'");
        return $this->db->getRow($sql);
    }
    
    /**
     * ݾIdӻֻٻ
     * @param type $brokerId Id
     * @param type $creditValue ӵķֵֵʾ
     * @return boolean ʧܷfalse ɹtrue
     */
    public function addCreditToOne($brokerId,$creditValue) {
        //$sql = "update $this->table set credit = credit+$creditValue where broker_id=$brokerId";
        $creditValue = $creditValue > 0 ? '+' . $creditValue : $creditValue;
        $fieldData['credit'] =   $creditValue;
		
        $sql = SqlCombinHelper::updateSelf_sql($this->table, $fieldData, "broker_id='$brokerId'");

        if($this->db->execute($sql)) {
            return true;
        } else {
            return false;
        }
    }
    
    /**
     * ṩľID ӻٻ
     * @param type $brokerIdArray Idɵ
     * @param type $creditValue ֵ
     * @return boolean ɹtrue ʧܷfalse
     */
    public function addCredit($brokerIdArray,$creditValue) {
        //$sql = "update $this->table set credit = credit+$creditValue where broker_id in ('".  implode("','", $brokerIdArray)."')";
        $strBrokerId = implode("','", $brokerIdArray);
        $creditValue = $creditValue > 0 ? '+' . $creditValue : $creditValue;
        $fieldData['credit'] =   $creditValue;
        $sql = SqlCombinHelper::updateSelf_sql($this->table, $fieldData, "broker_id in ('$strBrokerId')");
        if($this->db->execute($sql)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * ݾidûֵ
     * @param type $brokerId
     * @param type $creditValue
     * @return boolean ʧܷfalse ɹtrue
     */
    public function setCreditToOne($brokerId,$creditValue) {
        //$sql = "update $this->table set credit = $creditValue where broker_id=$brokerId";
        $fieldData = array('credit'=>$creditValue);
        $sql = SqlCombinHelper::update_sql($this->table, $fieldData, "broker_id='$brokerId'");
        if($this->db->execute($sql)) {
            return true;
        } else {
            return false;
        }
    }
    
    /**
     * ṩľID ûֵ
     * @param type $brokerIdArray Idɵ
     * @param type $creditValue ֵ
     * @return boolean
     */
    public function setCredit($brokerIdArray,$creditValue) {
        //$sql = "update $this->table set credit = $creditValue where broker_id in ('".  implode("','", $brokerIdArray)."')";
        $fieldData['credit'] = $creditValue;
        $sql = SqlCombinHelper::update_sql($creditValue, $fieldData, "broker_id in ('".  implode("','", $brokerIdArray)."')");
        if($this->db->execute($sql)) {
            return true;
        } else {
            return false;
        }
    }
    
    /**
     * һּ¼
     * @param type $brokerId id
     * @param type $credit  ֵ
     * @param type $status ״̬Ĭֵ1
     * @return boolean ɹtrueʧܷfalse
     */
    public function insertData($brokerId,$credit,$status=1) {
        //$sql = "insert into $this->table (broker_id,credit,status) value ($brokerId,$credit,$status)";
        $fieldData = array();
        $fieldData['broker_id'] = $brokerId;
        $fieldData['credit'] = $credit;
        $fieldData['status'] = $status;
        $sql = SqlCombinHelper::insert_sql($this->table, $fieldData);
        return $this->db->execute($sql);
    }
    
    /**
     * ӻ
     * @param array $credits 飬broker_id,credit,status
     * @return boolean ɹtrueʧܷfalse
     */
    public function insertMutl(array $credits) {
        /*
        $fields = array('broker_id','credit','status');
        $s = array();
        foreach ($credits as $value) {
            $brokerId = $value['brokerId'];
            $credit = $value['credit'];
            if (array_key_exists('status', $value)) {
                $status = $value['status'];
            } else {
                $status = 1;
            }
            $s[] = "($brokerId,$credit,$status)";
        }
        $sql = "insert into $this->table (broker_id,credit,status) values ".implode(',', $s);
        if($this->db->execute($sql)) {
            return true;
        } else {
            return false;
        }
         * 
         */
        $sql = SqlCombinHelper::insertMutil_sql($this->table, $credits);
        $this->db->execute($sql);
        return $this->db->Affected_Rows();
    }
    
    /**
     * idɾ
     * @param integer $id id
     * @return boolean ɹtrueʧܷfalse
     */
    public function delById($id) {
        $sql = SqlCombinHelper::delete_sql($this->table, "id='$id'");
        return $this->db->execute($sql);
    }
    
    /**
     * ݾidɾ
     * @param integer $brokerId
     * @return boolean ɹtrueʧܷfalse
     */
    public function delByBrokerId($brokerId) {
        $sql = SqlCombinHelper::delete_sql($this->table, "broker_id='$brokerId'");
        return $this->db->execute($sql);
    }
    /**
     * ɾ
     * @param string $field ֶ
     * @param array $fieldData Ҫɾֵ
     */
    public function delMult($field,$fieldData) {
        if(!in_array($field, $this->fields)) {
            return false;
        }
        $strWhere = "$field in ('".  implode("','", $fieldData)."')";
        $sql = SqlCombinHelper::delete_sql($this->table, $strWhere);
    }
    
    /**
     * ݾidɾ
     * @param array $brokerIds id
     * @return type
     */
    public function delMultByBroker($brokerIds) {
        return $this->delMult('broker_id', $brokerIds);
    }
    
    /**
     * ȡֶ
     * @return array    fields
     */
    public function getFields() {
        return $this->fields;
    }
    
    /**
     * 
     * @return string ر
     */
    public function getTable() {
        return $this->table;
    }
    
    /**
     * idΪ$brokerIdľ˵Ŀδ$scoreĻ
     * @param type $brokerId
     * @param type $score
     */
    public function frozen($brokerId,$score) {
        $sql = SqlCombinHelper::updateSelf_sql($this->table, array('frozen'=>$score), "broker_id='$brokerId'");
        $this->db->Execute($sql);
        return $this->db->Affected_Rows();
    }
    
    /**
     * $score С0ʾⶳķ
     * @param int $brokerId
     * @param int $score
     * @return type
     */
    public function unfreeze($brokerId,$score) {
        return $this->frozen($brokerId,$score);
    }
    
    /**
     * ؿû
     */
    public function getValidCredit($brokerId) {
        $res = $this->findByBrokerId($brokerId);
        if($res) {
            return $res['credit']-$res['frozen'];
        } else {
            return 0;
        }
    }
}

?>
