<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Shop extends MY_Controller {
     
    /**
    * ǰûuid
    *
    * @access private
    * @var int
    */
    private  $_uid = 0;

    /**
    * ǰҳ
    *
    * @access private
    * @var string
    */
    private $_current_page = 1;

    /**
    * ÿҳĿ
    *
    * @access private
    * @var int
    */
    private $_limit = 10;

    /**
    * ƫ
    *
    * @access private
    * @var int
    */
    private $_offset = 0;

    /**
    * Ŀ
    *
    * @access private
    * @var int
    */
    private $_total_count = 0;
    
 
    
   
    
    /**
    * 
    *
    * @access public
    * @return void
    */
    public function __construct()
    {
        parent::__construct();
        //ص̹ģ
        $this->load->model('shop_model');
         //˺uid
        $this->_uid = $this->user_arr['uid']; 
        
    }
    public function index(){
        
    }
    
    /**
     * ̹ģ
     */
    public function shop_house_recommend()
	{
        $post_param = array();
        $post_param['page'] = '';
        $post_param = $this->input->get(NULL , TRUE);
     
        $current_page = isset($post_param['page'])  ? intval($post_param['page']) : 1;
      
         /** ҳ */
        $this->_init_pagination($current_page);
        $this->_tbl = $post_param['tbl'];

        $arrModule = array('sell', 'rent');
	    $this->_tbl = in_array($this->_tbl, $arrModule) ? $this->_tbl : $arrModule[0];
        $this->shop_model->set_tbl($this->_tbl);

        //ҳƼ
        $rec_sell_num = $this->shop_model->use_rec_count('sell',  $this->_uid);
        $rec_rent_num = $this->shop_model->use_rec_count('rent',  $this->_uid);
        
        //ѯԴ
        $cond_where = "uid = '".$this->_uid."' AND esta = 1  AND infofrom = '5' ";
        //ύɵĲѯ
        $cond_where_ext = $this->_get_cond_str($post_param);
        $cond_where .= $cond_where_ext;
        
        //
        $this->_total_count = $this->shop_model->find_count_by($cond_where);

        //ҳ
        $pages  = $this->_total_count > 0 ? ceil( $this->_total_count / $this->_limit ) : 0;

        //ȡԴ
        $data_info = $this->shop_model->find_all_by( $cond_where , $this->_offset , $this->_limit );

        if(is_array($data_info) && !empty($data_info) )
        {	
            $row_num = count($data_info);

            if($this->_tbl == 'sell')
            {
                //ضͼ
                $this->load->model('sell_star_model');
            }
            else if($this->_tbl == 'rent')
            {
                //ضͼ
                $this->load->model('rent_star_model');
            }

            for( $i = 0 ; $i < $row_num ; $i ++ )
            {	
                if($this->_tbl == 'sell')
                {
                    //ǷΪͼԴ
                    $this->sell_star_model->set_houseinfo($data_info[$i]);
                    $data_info[$i]['is_star_result'] = $this->sell_star_model->is_star();
                }
                else if($this->_tbl == 'rent')
                {
                    //ǷΪͼԴ
                    $this->rent_star_model->set_houseinfo($data_info[$i]);
                    $data_info[$i]['is_star_result'] = $this->rent_star_model->is_star();
                }
            }
        }

        //Ƿʾҳ
        $pagination = NULL;
        if( $this->_total_count > $this->_limit)
        {
            $pagination = helper_pagination( $current_page , $pages ,$this->_total_count );
        }

        //Դ
        $house = $this->config->item('house');
        $documentation = $this->config->item('documentation');
        
        $tab = $this->_tbl == 'sell'? '' : '';

         /** ҳʼ */
        $data['page_title'] = '̹-̷ԴƼ-'.$tab;
        $data['css'] = load_css('zsb/css/v1.0/public.css,zsb/css/v1.0/style1.css'); //Ҫصcss
        $data['house']  = $house;
        $data['post_param']  = $post_param;
        $data['data_info']  = $data_info;
        $data['page']  = $current_page;
        $data['pagination'] = $pagination;
        $data['tbl'] = $this->_tbl;
        $data['rec_sell_num'] = $rec_sell_num;
        $data['rec_rent_num'] = $rec_rent_num;
        $data['documentation'] = $documentation;  
		$data['uid'] = $this->user_arr['uid']; 
        $data['username'] = $this->user_arr['username'];
        $data['google_analytics'] = get_ga_js_code('/̹/̷ԴƼ/'.$tab.'/'.$current_page.'/');
        //ģ
        $this->view('shop','shop_house_recommend',$data);         
    }
    
    
    /**
     * shop_set_basic
     * ̻ģ
     */
    public function shop_set_basic(){
        $this->load->model('broker_model');
        $data = $this->broker_model->get_broker_shop($this->_uid);
        $data['username'] = $this->user_arr['username'];
        $action = $this->input->post('action',TRUE);
        if($action == 'modify'){
           
            $skin_title = $this->input->post('skin_title',TRUE);
            $announce = $this->input->post('announce',TRUE);
            $skin_color = $this->input->post('skin_color',TRUE);
            $arrData = array(
			'skin_title' => $skin_title,
			'announce'   => $announce,
			'skin_color' => $skin_color == '#00009C' ? '' : $skin_color
	    );
            $this->broker_model->set_broker_info($this->_uid,$arrData);
            $page_text = "̻ñɹ";          
            $this->jump(GB_WO_URL.'/shop/shop_set_basic/', $page_text);
            return;
        }
        $data['css'] = load_css('zsb/css/v1.0/public.css,zsb/css/v1.0/style1.css'); //Ҫصcss
        $data['js'] = load_js('zsb/js/v1.0/js2.js,zsb/js/v1.0/jquery.validate.min.js,zsb/js/v1.0/messages_zh.js');   //Ҫصcss 
  
        $data['page_title'] = '̹-';
		$data['google_analytics'] = get_ga_js_code('/̹/̻/');
        $data['uid'] = $this->_uid;
        $this->view('shop','shop_set_basic',$data);   
        
    }
    
    
    /**
     * Ƽ
     * shop_recommend
     */
    public function shop_recommend()
    {
        $page = $this->input->post('page',TRUE);
        $houseid = $this->input->post('houseid',TRUE);
        $tbl = $this->input->post('tbl',TRUE);
        $top = $this->input->post('istop',TRUE);
        $brokerid = $this->user_arr['uid']; 
        $this->load->model('shop_model');
        $redirectUrl = GB_WO_URL.'/shop/shop_house_recommend/?tbl='.$tbl.'&page='.$page;
        if( $top == 2)
        {
            //ȡ
            $this->shop_model->delete_broker_house($tbl,$houseid);
            $this->shop_model->update_house_istop('del',$houseid,$brokerid,$tbl);
            $this->jump($redirectUrl, "ȡɹ",4000);
            return;
        }else{
			/**
			 * Ϊ6
			 * @author Candison <www.kandisheng.com>
			 * @time   2017-03-01
			 */
			$countSell = $this->shop_model->use_rec_count('sell', $brokerid);
			$countRent = $this->shop_model->use_rec_count('rent', $brokerid);
			if($countSell + $countRent >= 6) {
				$this->jump($redirectUrl, 'Ƽƣ', 4000);
				return;
			}
            //Ƽ       
            $house_info = $this->shop_model->house_recommend_info($houseid,$brokerid,$tbl);
            $this->shop_model->update_house_istop('add',$houseid,$brokerid,$tbl);
            $dateline = time();           
            $house_info['remark'] = addslashes(strip_tags($house_info['remark']));
            $isreach = $house_info['isstar'] == 3 ? 1 : 0;
            $data_arr = array('uid'=>$brokerid,'tbl'=>$tbl,'rowid'=>$houseid,'`district`'=>$house_info['district'],'r_title'=>$house_info['address'],'r_content'=>$house_info['remark'],'`isreach`'=>$isreach,'`dateline`'=>$dateline);
            $this->shop_model->insert_broker_house($data_arr);            
            $this->jump($redirectUrl, "Ƽɹ",4000);
            return;
        }
         
        exit;
    }
    
   /**
    * ʼҳ
    *
    * @access public
    * @param  int  $current_page
    * @param  int  $page_size
    * @return void
    */
    private function _init_pagination($current_page = 1 , $page_size = 0)
    {
        /** ǰҳ */
        $this->_current_page = ( $current_page && is_numeric( $current_page ) ) ? intval( $current_page ) : 1;

        /** ÿҳ */
        $this->_limit = ( $page_size && is_numeric( $page_size ) ) ? intval( $page_size ) : $this->_limit;

        /** ƫ */
        $this->_offset = ( $this->_current_page - 1 ) * $this->_limit;

        if($this->_offset < 0)
        {
            redirect(base_url());
        }
    }
    
    
     /**
     * ݱύȡѯ
     */
    private function _get_cond_str( $form_param )
    {   
        $cond_where = '';
        
        //Դ
        if( isset($form_param['infotype']) && !empty($form_param['infotype']) )
        {
           $cond_where .= " AND infotype = '".intval($form_param['infotype'])."'";
        }
        
        //Դ۸
        if ( isset($form_param["price_sell"]) && !empty($form_param["price_sell"]) ) 
        {   
            switch($form_param["price_sell"])
            {
                case 1:	
                    $cond_where .= " AND price <= '40' ";
                    break;
                case 2:
                    $cond_where .= " AND price > '40' and price <= '60' ";
                    break;
                case 3:
                    $cond_where .= " AND price > '60' and price <= '90' ";
                    break;
                case 4:
                    $cond_where .= " AND price > '90' and price <= '120' ";
                    break;
                case 5:
                    $cond_where .= " AND price > '120' and price <= '150' ";
                    break;
                case 6:
                    $cond_where .= " AND price > '150' and price <= '200' ";
                    break;
                case 7:
                    $cond_where .= " AND price > '200' and price <= '300' ";
                    break;
                case 8:
                    $cond_where .= " AND price > '300' and price <= '500' ";
                    break;
                case 9:
                    $cond_where .= " AND price > '500'";
                    break;
            }       
        }
        
         //Դⷿ
        if ( isset($form_param["price_rent"]) && !empty($form_param["price_rent"]) ) 
        {   
            switch($form_param["price_rent"])
            {
                case 1:	
                    $cond_where .= " AND price <= '800' ";
                    break;
                case 2:
                    $cond_where .= " AND price > '800' and price <= '1200' ";
                    break;
                case 3:
                    $cond_where .= " AND price > '1200' and price <= '2000' ";
                    break;
                case 4:
                    $cond_where .= " AND price > '2000' and price <= '3000' ";
                    break;
                case 5:
                    $cond_where .= " AND price > '3000' and price <= '5000' ";
                    break;
                case 6:
                    $cond_where .= " AND price > '5000' and price <= '1000' ";
                    break;
                case 7:
                    $cond_where .= " AND price > '10000'";
                    break;      
            }       
        }
        
        


        
        //
        if (isset($form_param["buildarea"]) && !empty($form_param["buildarea"])) 
        {
            switch($form_param["buildarea"])
            {
                case 1:	
                    $cond_where .= " AND buildarea <= '40' ";
                    break;
                case 2:
                    $cond_where .= " AND buildarea > '40' AND buildarea <= '60' ";
                    break;
                case 3:
                    $cond_where .= " AND buildarea > '60' AND buildarea <= '80' ";
                    break;
                case 4:
                    $cond_where .= " AND buildarea > '80' AND buildarea <= '100' ";
                    break;
                case 5:
                    $cond_where .= " AND buildarea > '100' AND buildarea <= '120' ";
                    break;
                case 6:
                    $cond_where .= " AND buildarea > '120' AND buildarea <= '144' ";
                    break;
                case 7:
                    $cond_where .= " AND buildarea > '144'  AND  buildarea <= '200' ";
                    break;
                case 8:
                    $cond_where .= " AND buildarea > '200'  AND  buildarea <= '400' ";
                    break;
                case 9:
                    $cond_where .= " AND buildarea > '400' ";
                    break;
            }       
        }
        
        //
        if (isset($form_param['roomtype']) && !empty($form_param['roomtype'])) 
        {
            switch ($form_param['roomtype']) 
            {
              case 1:
                    $cond_where .= " AND  room = '1'";
                    break;
              case 2:
                    $cond_where .= " AND   room = '2'";
                    break;
              case 3:
                    $cond_where .= " AND  room = '3'";
                    break;
              case 4:
                    $cond_where .= " AND  room = '4'";
                    break;
              case 5:
                    $cond_where .= " AND  room >= '5' ";
                    break;
            }
        }
        
        //ؼ
        if (isset($form_param['keywords']) && !empty($form_param['keywords']) && $form_param['k_id']) 
        {
            switch ($form_param['k_id']) 
            {
                case 1:
                    $cond_where .= " AND blockshowname LIKE '%".$form_param['keywords']."%'";
                    break;
                case 2:
                    $cond_where .= " AND id = '".$form_param['keywords']."'";
                    break;
                case 3:
                    $cond_where .= " AND ownid = '".$form_param['keywords']."'";
                    break;
            }
        }

        //ȫԴ
        if ( isset($form_param['roomcategory']) && !empty($form_param['roomcategory']) ) 
        {
            switch ($form_param['roomcategory']) 
            {
                case 1:
                    $cond_where .= ' AND  isstar = 0 ';
                    break;
                case 2:
                    $cond_where .= ' AND  isstar = 3 ';
                    break;
                case 3:
                    $cond_where .= ' AND  istag = 1 ';
                    break;
                case 4:
                    $cond_where .= ' AND  nofee = 1 ';
                    break;
                case 5:
                    $cond_where .= ' AND  certificate = 1 ';
                    break;
                //ͼ
                case 9:
                    $cond_where .= ' AND  isstar = 3 AND grade != 1 ';
                    break;  
                //ʷԴ
                case 10:
                    $cond_where .= ' AND  rade = 1 ';
                    break;    
            }
        }
        
        return $cond_where;
    }
    
}

/* End of file shop.php */
/* Location: ./application/controllers/shop.php */
