<?php

/**
 * ȨУزˮ
 */

/**
 * Ͷ¼
 *
 * @author Administrator
 */
abstract class GrowthBidRecord implements IGrowthBidRecord {
    /**
     *
     * @var TINY_ADODB ݿ
     */
    protected $db;
    /**
     *
     * @var TINY_ADODB ݿ
     */
    protected $dbback;
    /**
     *
     * @var Memcache 
     */
    protected $mc;
    /**
     *
     * @var string 
     */
    protected $table;
    /**
     *
     * @var ֶ 
     */
    protected $fields;
    
    /**
     * ʼ
     * @param string $table ĬΪgrowth_bid_periods
     */
    public function __construct($table = 'growth_bid_block_expert_record_on') {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->table = $table;
        $this->mc = $container->get('mc');
        $sqlfield = "DESC $this->table";
        $fieldsMKey = $sqlfield;
        $this->fields = $this->mc->get($fieldsMKey);
        if($this->fields === false) {
            $fields = $this->dbback->getAll($sqlfield);
            foreach ($fields as $field) {
                $this->fields[] = $field['Field'];
            }
            $this->mc->set($fieldsMKey, $this->fields, 3600);
        }
    }
    
    public function findByBid($bid,$order='',$limit='') {
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, "bid_id='$bid'");
        //$sql = SqlCombinHelper::innerSelect_sql($this->table, 'broker', implode(",", $this->fields).',agentcode' , "$this->table.broker_id=broker.uid", "bid_id='$bid'");
        if($order) {
            $sql .= " ORDER BY $order";
        }
        if($limit) {
            $sql .= " LIMIT $limit";
        }
        return $this->db->GetAll($sql);
    }
    
	public function findCountByPeriodsId($periodsId) {
		$sql = SqlCombinHelper::count_sql($this->table, "bid_periods_id='$periodsId'");
        return $this->dbback->getOne($sql);
	}
    
    public function findNumberByBid($bid) {
        $sql = SqlCombinHelper::count_sql($this->table, "bid_id='$bid'");
        return $this->dbback->getOne($sql);
    }

    public function findNumberBy($conf) {
        $sql = SqlCombinHelper::count_sql($this->table, $conf);
        return $this->dbback->getOne($sql);
    }

    public function findByBrokerId($brokerId,$order = '',$limit ='') {
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields,"broker_id='$brokerId'");
        if($order) {
            $sql .= " ORDER BY ".$order;
        }
        if($limit) {
            $sql .= " LIMIT $limit";
        }
        return $this->dbback->GetAll($sql);
    }
    
    public function findByHouseId($houseId) {
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields,"house_id='$houseId'");
        return $this->dbback->GetAll($sql);
    }
    
    public function findBy($conf,$order='',$limit='') {
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields,$conf);
        //$sql = SqlCombinHelper::innerSelect_sql($this->table, 'broker', implode(",", $this->fields).',agentcode' , "$this->table.broker_id=broker.uid", $conf);
        if($order) {
            $sql .= " ORDER BY $order";
        }
        if($limit!=='') {
            $sql .= " LIMIT $limit";
        }

        return $this->db->GetAll($sql);
    }
    
    /**
     * ڴid;idȡͶһڵ
     * @param type $periodsId
     * @param type $brokerId
     * @return type
     */
    public function findByPeriodsIdAndBrokerId($periodsId, $brokerId) {
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, 
                "bid_periods_id = $periodsId AND broker_id = $brokerId "
                . "ORDER BY utime DESC");
        return $this->dbback->getAll($sql);
    }
    
    
    /**
     * ݾͶŻȡ߷ֺͷ
     * @param type $bid
     * @return type
     */
    public function findMaxMinScoreByBid($bid) {
        $sql = SqlCombinHelper::select_sql($this->table, 'MAX(score) as max,'
                . 'MIN(score) as min', "bid_id = $bid");
        return $this->dbback->GetRow($sql);
    }
    
    public function findOneBy($brokerId,$bidId,$houseId = '') {
        $where = "broker_id='$brokerId' and bid_id='$bidId'";
        if($houseId) {
            $where .= " and house_id='$houseId'";
        }
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields,$where);
        return $this->dbback->getRow($sql);
    }
    
    public function insert($fieldData) {
        if($this->checkField($fieldData)){
            $sql = SqlCombinHelper::insert_sql($this->table, $fieldData);
            $this->db->execute($sql);
            return $this->db->Insert_ID();
        } else {
            return false;
        }
    }
    
    abstract public function save($fieldData) ;

    /**
     * 
     * @param array $fieldData
     * @param string $conf
     * @return boolean
     */
    public function update($fieldData,$conf) {
        if($this->checkField($fieldData)){
            $sql = SqlCombinHelper::update_sql($this->table, $fieldData, $conf);
            $this->db->Execute($sql);
            return $this->db->Affected_Rows();
        } else {
            return false;
        }
    }

    /**
     * ׷ͶĻ
     * @param array $fieldData
     * @param string $conf
     */
    public function add($fieldData,$conf) {
        if($this->checkField($fieldData)){
            $sql = SqlCombinHelper::updateSelf_sql($this->table, $fieldData, $conf);
            $this->db->Execute($sql);
            return $this->db->Affected_Rows();
        } else {
            return false;
        }
    }
    /**
     * Ƿȷ
     * @param array $fields Ҫ
     * @return boolean ȷtrueʧܷfalse
     */
    public function checkField($fieldData) {
        $fields = array_keys($fieldData);
        if(array_intersect($fields, $this->fields)==$fields){
            return true;
        } else {
            return false;
        }
    }
    
    public function findRankBy($score,$recordId,$bidId) {
        $field = "count(id)";
        $strWhere = "bid_id = '$bidId' and score>=$score and id<$recordId";
        $sql = SqlCombinHelper::select_sql($this->table, $field, $strWhere);
        return $this->dbback->GetOne($sql);
    }
    
    public function getTable() {
        return $this->table;
    }
    

    /**
     * ڴid;idȡͶһڵ
     * @param type $periodsId
     * @param type $brokerId
     * @return type
     */
    public function findByPidAndBrokerId($periodsId, $brokerId, $limit = '') {
        if ($limit) {$limit = " LIMIT $limit";}
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, 
                "bid_periods_id = $periodsId AND broker_id = $brokerId "
                . "ORDER BY utime DESC $limit");
        return $this->dbback->getAll($sql);
    }

    /**
     * ڴαźͷԴȡ뾺ͶСʺѴ
     * @param type $periodsId
     * @param type $houseId
     * @return type
     */
    public function findByPidAndHouseId($periodsId, $houseId) {
		//Ƹٲѯ
		$baseNum = 2;
        if (is_array($houseId)) {
			$limit = count($houseId) * $baseNum;
            $houseIds = implode(',', $houseId);
            $houseIdWhere = "house_id IN($houseIds)";
			$limit = ' LIMIT ' . $limit;
        } else {
            $houseIdWhere = "house_id = $houseId";
			$limit = ' LIMIT ' . $baseNum;
        }
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields,
                "bid_periods_id = $periodsId  AND $houseIdWhere "
                . "ORDER BY type DESC $limit");
        return $this->dbback->getAll($sql);
    }
    
    /**
     * ȡĳԴ뾺Ͷ
     * @param type $bid
     * @param type $houseId
     * @return type
     */
    public function findByBidAndHouseId($bid, $houseId) {
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields,
                "bid_id = $bid  AND house_id = $houseId ");
        return $this->dbback->getRow($sql);
    }
    
    public function getFields() {
        return $this->fields;
    }
    /**
     * ձ
     */
    public function emptyAll() {
        $sql = "DELETE FROM $this->table";
        return $this->db->Execute($sql);
    }
    
    public function insertMutl(array $filedData) {
        $sql = SqlCombinHelper::insertMutil_sql($this->table, $filedData);
        $this->db->execute($sql);
        return $this->db->Affected_Rows();
    }
}

?>
