<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * zsb
 *
 * 
 *
 * @package         zsb
 * @author          EllisLab Dev Team
 * @copyright      Copyright (c) 2006 - 2014, HOUSE365, Inc.
 * @link            http://nj.sell.house.com
 * @since           Version 1.0
 */

// ------------------------------------------------------------------------

/**
 * Rent_reduce_base_model CLASS
 *
 * ǩ
 *
 * @package         zsb
 * @subpackage      Models
 * @category        Models
 * @author          xz
 */
//ظ
load_m("rent_attr_model");

class Rent_reduce_base_model extends Rent_attr_model {
    
    /**
     * ԴʶӦֵ
     * @var const
     */
    const  ISREAL_VALUE = 1;
    
    
    /**
     * ʼ
     */
    public function __construct() 
    {
        parent::__construct();
    }
    
    
    /**
     * жϷԴǷΪԴ
     *
     * @access	public
     * @return	boolean  ǷΪԴ
     */
    public function is_reduce()
    {
        $is_reduce = FALSE;
        
        $house_info = $this->init_houseinfo();
        
        if( is_array( $house_info ) && !empty( $house_info ) )
        {
            $is_reduce = self::ISREAL_VALUE == $house_info['isreal'] 
                    ? TRUE : FALSE;
        }
        
        return $is_reduce;
    }
    
    
    /**
     * Դ
     *
     * @access  public
     * @return  boolean  Ƿóɹ
     */
    public function set_reduce()
    {   
        $result = FALSE;
        
        $house_info = $this->init_houseinfo();
        $rowid = intval($house_info['id']);

        if( $rowid > 0)
        {
            $update_info = array();

            //ҪõķԴֵ
            $update_info['isreal'] = self::ISREAL_VALUE;

            //öͼԴ
            $result = $this->update_house_atrr_val( $update_info , $rowid );
        }
        
        return $result;
    }
    
    
    /**
     * ȡǩ
     *
     * @access  protected
     * @return  boolean  ȡǩǷɹ
     */
    public function remove_reduce()
    {   
        $result = FALSE;
        
        $house_info = $this->init_houseinfo();
        $rowid = intval($house_info['id']);
        
        if( $rowid > 0 )
        {   
            $update_info = array();
            
            //ҪõķԴֵ
            $update_info['isreal'] = 0;
            
            //ȡReal
            $result = $this->update_house_atrr_val( $update_info , $rowid );
        }
        
        return $result;
    }
    
    
    /**
     * ⷿԴǷԴı׼
     *
     * @access  public
     * @return  boolean  ǷԴı׼
     */
    public function check_real_standard()
    {   
        //ԴϢ
        $houseinfo = $this->init_houseinfo();
        $result = array();
        $uid = intval($houseinfo['uid']);
        
        $this->load->model('broker_model');
        $this->broker_model->set_uid($uid);
        $broker_info = $this->broker_model->get_broker_info();
        
        //ǷѾԴ
        $is_reduce = $this->is_reduce();
        if($is_reduce)
        {
            //״̬
            $result['is_ok'] = 0;
            $result['msg'] = '÷Դǩ';
            return  $result;
        }
        
        /*** ˲ٺ ***/
        if( is_array( $broker_info ) && !empty( $broker_info ) )
        {   
            if(isset($broker_info['festa']) && $broker_info['festa'] == 1 )
            {
                //״̬
                $result['is_ok'] = 0;
                $result['msg'] = 'ںУ޷ǩ';
                return  $result;
            }
        }
        else
        {
            //ϢΪ
            $result['is_ok'] = 0;
            $result['msg'] = 'ϢΪ';
            return  $result;
        }
        
        //ⷿ
        $favtag_num_limit = intval($broker_info['favtag_num']);
        
        //ǰǩԴ
        $favtag_num = $this->get_reduce_num_by_uid($uid);
        if( $favtag_num >= $favtag_num_limit)
        {
            $result['is_ok'] = 0;
            $result['msg'] = 'ǩ';
            return  $result;
        }
        
        /*** ǶͼԴǩ ***/
        $this->load->model('sell_star_base_model');
        $isstar_value = $this->sell_star_base_model->get_isstar_value();
        if( $houseinfo['isstar'] != $isstar_value )
        {
            $result['is_ok'] = 0;
            $result['msg'] = 'ǶͼԴǩ';
            return  $result;
        }
        
        //Ч״̬
        if( $houseinfo['esta'] != 1 )
        {
            $result['is_ok'] = 0;
            $result['msg'] = 'ԴǼ״̬޷ǩ';
            return  $result;
        }
        
        $result['is_ok'] = 1;
        $result['msg'] = 'ǩ';
        
        return $result;
    }
    
    
    /**
     * 鵽Real¼
     *
     * @access  protected
     * @param   string $cond_where ѯ
     * @return  boolean  ǷRealԴı׼
     */
    public function get_real_num_by_cond($cond_where)
    {
        $real_num = 0;
       
        if( $cond_where != '')
        {
            $this->dbback->where($cond_where);
            $real_num = $this->dbback->count_all_results(self::REAL_TBL);
        }
        
        return $real_num;
    }
    
    
    /**
     * UIDѯ˺ͨ˵Դ
     *
     * @access  public
     * @param   int  $uid ˱
     * @return  int  Դ
     */
    public function get_reduce_num_by_uid( $uid )
    {   
        $real_num = 0;
        
        if( $uid > 0)
        {   
            $this->load->model('rent_base_model');
            $cond_where = "uid = $uid AND esta = 1 AND infofrom = '5' AND isreal = 1 ";
            $real_num = $this->rent_base_model->find_count_by($cond_where);
        }
        
        return $real_num;
    }
}
/* End of file rent_favtag_base_model.php */
/* Location: ./applications/models/rent_favtag_base_model.php */