<?php !defined('APP_DIR') ? die('acceess not defined') : '';
class cache{
    /**
     * memcache ĬϷļ
     *
     * @var bool
     */
	private $_file = false;
    /**
     * memcache ĬϷ
     *
     * @var unknown_type
     */
    private $_city = 'local';
    
    /**
     * memcache
     *
     * @var memcache
     */
    private $_memcache = null;
    
    /**
     * memcache ӳ
     *
     * @var unknown_type
     */
    static public $instances = array();
    
    /**
     * 洢memcacheмֵļֵ
     *
     * @var string
     */
    private $_key_array_name = '365_memcache_all_using_keys_array';
    
    /**
     * ʼmemcache
     *
     * @param string $city
     */
    public function __construct($city='',$file=false){
        if($city){
            $this->_city = $city;
        }
        if ($file) {
        	$this->_file = true;
        } else {
	        $mem_server = tool::config('memcache.'.$this->_city);
	        $this->_memcache = new Memcache;
	        $this->_memcache->connect($mem_server['host'],$mem_server['port']);        	
        }
    }
    
    /**
     * memcacheӺ
     *
     * @param string $city
     * @return obj
     */
    static public function instance($city='',$file=false){
        $_city = $city ? $city : 'local';
        if( isset(self::$instances[$_city]) ){
            return self::$instances[$_city];
        }
        self::$instances[$_city] = new cache($_city,$file);
        return self::$instances[$_city];
    }
    
    /**
     * memcacheֵ
     *
     * @param string $key
     * @param mixed $value
     * @param int $expire
     */
    public function set($key, $value, $expire=3600){
    	if ($this->_file) {
    		$this->setfile($key, $value, $expire);
    	} else {
    		$this->_memcache->set($key,$value,false,$expire);	
    	}
    }
    
    /**
     * ȡmemcacheֵ
     *
     * @param string $key
     * @return mixed
     */
    public function get($key){
    	if ($this->_file) {
    		return $this->getfile($key);
    	} else {
    		return $this->_memcache->get($key);	
    	}
    }
    
    /**
     * ɾmemcacheֵ
     *
     * @param string $key
     */
    public function delete($key){
    	if ($this->_file) {
    		$this->deletefile($key);
    	} else {
    		$this->_memcache->delete($key);	
    	}
    }
    
    public function setfile($key, $value, $expire=3600){
    	$filename = tool::config('memcache.local.cache_path').$this->_city.'_'.$key.'.php';
		$value=array('var'=>$value,'s'=>$expire);
		$content=serialize($value);
		$content='<?php exit;?>'.$content;
		fclose(fopen($filename,'w'));
		if(file_put_contents($filename,$content)){ 
			return true;
		}else{ 
			return false;
		}
    }
    
    public function getfile($key){
    	$filename = tool::config('memcache.local.cache_path').$this->_city.'_'.$key.'.php';
    	if (!file_exists($filename)) { 
    		return false;
    	}
		$content=@file_get_contents($filename);
		$var=unserialize(str_replace('<?php exit;?>','',$content));
		$mtime=filemtime($filename);
		if(time()-$mtime>=$var['s']){
			@unlink($filename);
			return false;
		}else{
			return $var['var']; 
		}
    }
    
    public function deletefile($key) {
    	$filename = tool::config('memcache.cache_path').$this->_city.'_'.$key.'.php';
		$value=array('var'=>$value,'s'=>$expire);
		$content=serialize(array()); // 
		$content='<?php exit;?>'.$content;
		fclose(fopen($filename,'w'));
		if(file_put_contents($filename,$content)){
			return true;
		}else{
			return false;
		}
    }
}
?>