<?php

/*
 * ȨУزˮ
 */

/**
 * Description of GrowthBrokerBid
 *
 * @author Administrator
 */
class GrowthBrokerBidBlockExpert {
    
    const HOUSE_NUMBER_LIMIT = 0;
    const BID_ERROR_AUTH_IS_PAY = 1;//ʾǸѾ
    const BID_ERROR_AUTH_CREDIT = 2;//ʾֲ
    const BID_ERROR_AUTH_HOUSE=3;//ʾڸСķԴ
    const BID_ERROR_AUTH_LEVEL=4;//ʾ˵ȼ
    const BID_ERROR_AUTH_SCORE = 5;//ʾͶĻֲ
    const BID_ERROR_SYS_DB = 10;//ݿ
    const BID_ERROR_FINISH = 100;//ͶύͶ
    const BID_ERROR_MIN_TIME = 200;//ʱ䲻

    const BID_NEED_SCORE_TYPE_WIN = 2;//Ͷ
    const BID_NEED_SCORE_TYPE_NOT_WIN_1 = 1;//δͶ,Ͷ>=4
    const BID_NEED_SCORE_TYPE_NOT_WIN_0 = 0;//δͶ,Ͷ<4

    const BID_MIN_TIME = 2;//ͶСʱ,λ
    /**
     * 1,ɹ 2,ʧ,3,δͶ,4,δͶ,5,Ͷ
     * @var type 
     */
    public static $bidBehavior = array(
        'success' => 1, 'failure' => 2, 'noPut' => 3, 
        'noHit' => 4, 'on' => 5, 'tempHit' => 6
    );
    
    public static $bidProjectName = 'Сר';
    
    private $broker;
    /**
     *
     * @var GrowthBid 
     */
    private $growthBid;
    /**
     *
     * @var GrowthBidRecordOn 
     */
    private $growthBidRecord;
    /**
     *
     * @var GrowthBidRecordHistory 
     */
    private $growthBidRecordHistory;
    
    /**
     *
     * @var GrowthBrokerCredit 
     */
    private $growthBrokerCredit;
    
    /**
     *
     * @var Adodb 
     */
    private $dbback;
    
    private $brokerBlock;
    /**
     *
     * @var Ͷ 
     */
    private $blockExpertBidsNew;
    /**
     *
     * @var array 
     */
    private $bidError;
    
    private $growthBidPeriods;


    /**
     * 
     * @param array $broker array("id"=>'','agentcode'=>'','agentname'=>'','level'=>'','is_pay'=>'')
     */
    public function __construct($broker,$growthBrokerCredit) {
        $this->dbback = Container::getInstance()->get('dbback');
        $this->broker= $broker;
        $this->growthBid = new GrowthBidBlockExpert();
        $this->growthBidRecord = new GrowthBidBlockExpertRecordOn();
        $this->growthBidRecordHistory = new GrowthBidBlockExpertRecordHistory();
        $this->growthBrokerCredit = $growthBrokerCredit;
        $this->growthBidPeriods = new GrowthBidPeriods();
    }
    
    public function bid($bidId,$score) {
        //var_dump($this->controlTime());exit;
        if($this->controlTime()==false) {
            $this->bidError['errorCode'] = self::BID_ERROR_MIN_TIME;
            return false;
        }
        $brokerId = $this->broker['id'];
        $bid = $this->growthBid->findById($bidId);
        if(!$bid) {
            return false;
        }
        $bidPeriodsId = $bid['bid_periods_id'];
        $blockId = $bid['block_id'];
        $blockMg = new Block();
        $block = $blockMg->findOneBy($blockId);//С
        //ҵľͶ¼
        $myRecord = $this->growthBidRecord->findOneBy($brokerId, $bidId);
        //Ͷļ¼
        $winnerRecord = $this->findTempWinnerRecord($bidId);
        $x = $this->checkByRecord($bid,$score,$winnerRecord,$myRecord);
        if($x) {
            //ԾͶ
            //жϵǰ־Ͷ״̬-1δͶ0δͶУ1234Ͷ˵ǰ׷
            $winFlag = $this->checkWinBid($winnerRecord, $myRecord);
            switch ($winFlag) {
                case '-1'://δͶ
                    //״--ӾͶ¼statua=1μӾͶnumber=number+1score
                    $fieldData = array('broker_id'=>$brokerId,
                        'bid_id'=>$bidId,
                        'score'=>$score,
                        'block_id'=>$blockId,
                        'block_name'=>$block['blockname'],
                        'bid_periods_id'=>$bidPeriodsId);
                    $recordId = $this->growthBidRecord->insert($fieldData);
                    
                    if($recordId) {
                        //
                        $this->growthBid->addJoinNumber($bidId);
                        //
                        $this->growthBrokerCredit->frozenCredit($score);
                        //˷
                        $this->complete($bidId);
                        //ͳжʹ
                        $growthBidUserBroker = new GrowthBidUserBroker();
                        $growthBidUserBroker->addJoinBidBlockExpertRecord($brokerId);
                        
                        //ͬʱע
                        if(!$this->hasAttention($bidId)) {//ûע
                            $attentionNumber = GrowthBidAttentionHelper::totalNumber($this->broker);
                            if($attentionNumber<GrowthBidAttentionHelper::ATTENTION_MAX_NUMBER) {
                                $this->attent($bidId,$bidPeriodsId);
                            }
                        }
                        
                    } else {
                        $this->bidError['errorCode'] = self::BID_ERROR_SYS_DB;
                        //¼־
                    }
                    break;
                case '0'://ͶδͶ
                    $fieldData = array('score'=>$score,'status'=>'1');
                    $conf = "broker_id='$brokerId' and bid_id='$bidId'";
                    $affectRows = $this->growthBidRecord->update($fieldData, $conf);
                    if($affectRows) {
                        $this->growthBrokerCredit->frozenCredit($score);
                        //֣ľˣbid=$bidand ֡score and status = 1
                        //ּ¼ ⶳ֣frozen= frozen-scoreע֪ͨ
                        $this->complete($bidId);
                    } else {
                        
                    }
                    
                    break;
                case '1'://׷
                case '2':
                case '3':
                case '4':
                    $fieldData = array('score'=>$score);
                    $conf = "broker_id='$brokerId' and bid_id='$bidId'";
                    $affectRows = $this->growthBidRecord->add($fieldData, $conf);
                    if($affectRows) {
                        $this->growthBrokerCredit->frozenCredit($score);
                    } else {
                        
                    }
                    break;
                default:
                    break;
            }
            //ھ͸£ھͲ(Ͷ״Ͷ֣Ǻӷ)X
            
            
            //ӷ--¼¼status=1scoreX
            
            //ּ¼
            return true;
        } else {
            return false;
        }
    }
    
    public function complete($bidId) {
        //֣ľˣbid=$bidand ֡score and status = 1
        //ּ¼ ⶳ֣frozen= frozen-scoreע֪ͨ
        $refundRecord = $this->findRecordForRefund($bidId);
        if($refundRecord) {
            //ЩΪʧ
            $ids = array();
            $refundBroker = array();
            foreach ($refundRecord as $value) {
                $ids[] = $value['id'];
                $temp = array();
                $temp['broker_id'] = $value['broker_id'];
                $temp['score'] = "-".$value['score'];
                $refundBroker[] = $temp;
            }
            //statusΪʧ
            $this->growthBidRecord->update(array('status'=>0), "id in ('".  implode("','", $ids)."')");
            //ⶳ
            if($refundBroker) {
                $growthCredit = $this->growthBrokerCredit->getGrowthCredit();
                foreach ($refundBroker as $value) {
                    $growthCredit->unfreeze($value['broker_id'],$value['score']);
                }
            }
            
        }
        
    }

    public function getBidError() {
        return $this->bidError;
    }

    /**
     * ǷԾͶ3
     * @param int $bidId
     * @return boolean
     */
    public function check($bid,$score) {
        return false;
        if($this->checkBroker()&&$this->checkCredit($score)) {
            //$bid = $this->growthBid->findByBidId($bidId);
            if($bid) {
                //ͶķǷڱξͶǰҪͷ
                $this->getNeedScore($bid,$winnerRecord,$myRecord);
                $blockId = $bid['broker_id'];
                $bidBrokerLevel = $bid['broker_level'];//ԾͶĵȼ
                return $this->checkHouseNumber($blockId)&&$this->checkBrokerLevel($bidBrokerLevel);
            } else {
                return false;
            }
        } else {
            return false;
        }
    }
    
    /**
     * ṩľͶ;Ͷ¼жǷԾͶ
     * @param array $bid
     * @param int $score
     * @param array $winnerRecord
     * @param array $myRecord
     * @return boolean
     */
    public function checkByRecord($bid,$score,$winnerRecord,$myRecord) {
        //ʱ
        //$bidڵڴ
        $bidPeriodsId = $bid['bid_periods_id'];
        $bidPeriods = $this->growthBidPeriods->findById($bidPeriodsId);
        if(!GrowthBidPeriods::isBidOn($bidPeriods)) {
            //Ͷ
            $this->bidError['errorCode']= self::BID_ERROR_FINISH;
            return false;
        }
        if($this->checkBroker()&&$this->checkCredit($score)) {
            //$bid = $this->growthBid->findByBidId($bidId);
            if($bid) {
                //ͶķǷڱξͶǰҪͷ
                $needScore = $this->getNeedScore($bid,$winnerRecord,$myRecord);
                
                if($this->checkScore($score, $needScore)) {
                    $blockId = $bid['broker_id'];
                    $bidBrokerLevel = $bid['broker_level'];//ԾͶĵȼ
                    return $this->checkHouseNumber($blockId)&&$this->checkBrokerLevel($bidBrokerLevel);
                } else {
                    return false;
                }
                
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    /**
     * ͶĻǷС
     * @param int $score
     * @param array $needScore $this->getNeedScore($bid,$winnerRecord,$myRecord)ֵ
     */
    public function checkScore($score,$needScore) {
        $type = $needScore['type'];
        $flag = $score>=$needScore['score'];
        if(!$flag) {
            $this->bidError['errorCode']= self::BID_ERROR_AUTH_SCORE;
            return false;
        }
        return true;
    }


    /**
     * ֹ
     * @param int $score
     * @return boolean
     */
    public function checkCredit($score) {
        $myCredit = $this->broker['credit'];
        if($myCredit<$score) {
            $this->bidError['errorCode']= self::BID_ERROR_AUTH_CREDIT;
            return false;
        }
        return true;
    }

    /**
     * 龭ǷǸѾˣ
     * 
     */
    public function checkBroker() {
        if($this->broker['is_pay']==0){
            return true;
        } else {
            $this->bidError['errorCode']= self::BID_ERROR_AUTH_IS_PAY;
            return false;
        }
    }
    //ǷиС3ϷԴ,
    public function checkHouseNumber($blockId) {
        $brokerid = $this->broker['id'];
        $sql = "SELECT count(blockid) FROM `sell` WHERE uid = '$brokerid' and blockid='$blockId' and  esta=1 and infofrom=5";
        $houseNumber = $this->dbback->getOne($sql);
        if($houseNumber>=self::HOUSE_NUMBER_LIMIT) {
            return true;
        } else {
            $this->bidError['errorCode']= self::BID_ERROR_AUTH_HOUSE;
            return false;
        }
    }
    //˵ȼǷСȼ
    public function checkBrokerLevel($bidBrokerLevel) {
        $brokerLevel = $this->broker['level'];//˵ȼ
        $arr = explode(",", $bidBrokerLevel);
        if(in_array($brokerLevel, $arr)) {
            return true;
        } else {
            $this->bidError['errorCode']= self::BID_ERROR_AUTH_LEVEL;
            return false;
        }
    }

    /**
     * ҾȫõСרҾͶ
     */
    public function findAllBid($houseNumber) {
        $blockids = $this->findAllBlockHouserNumber($houseNumber);
        $brokerLevel = $this->broker['level'];
        //$bLevelHeat = new BlockLevelHeat();
        $conf = "block_id in ('".implode("','", $blockids)."') and broker_level like '%LV".$brokerLevel."%'";
        $bids = $this->growthBid->findBy($conf);
        //$blockLevel = $bLevelHeat->findBy("block_id,level", "block_id in ('".implode("','", $blockids)."')", 0);
        //print_r($bids);
        return $bids;
    }
    
    /**
     * Ҿ˵ķԴڵ$houseNumberԴС
     * @param int $houseNumber Դ
     * @return array Сid
     */
    public function findAllBlockHouserNumber($houseNumber=0) {
        $brokerid = $this->broker['id'];
        $sql = "SELECT blockid,count(blockid) FROM `sell` WHERE uid = '$brokerid' and esta=1 and grade=1 and infofrom=5  group by blockid";
        $this->brokerBlock = $this->dbback->getAssoc($sql);
        $temp= array();
        if($this->brokerBlock) {
            foreach ($this->brokerBlock as $key=>$value) {
                if($value>=$houseNumber) {
                    $temp[] = $key;
                }
            }
        }
        return $temp;
        //return $this->brokerBlock;
    }
    
    public function findAllBlock($blockids) {
        ///
    }
    
    public function hasAttention($bidId) {
        //Ƿע
        $growthAttention = new GrowthBidAttention();
        $brokerId = $this->broker['id'];
        $conf = "broker_id='$brokerId' and type=1 and target_id='$bidId'";
        $number = $growthAttention->findNumberBy($conf);
        if($number==1) {
            return true;
        } else {
            return false;
        }
    }
    
    /**
     * ǷԹע
     * @param int $bidid Ͷid
     */
    public function checkAttention($bidId) {
        if($this->hasAttention($bidId)) {
            return false;
        }
        if($this->checkBroker()) {
            $bid = $this->growthBid->findById($bidId);
            if($bid) {
                $blockId = $bid['broker_id'];
                $bidBrokerLevel = $bid['broker_level'];//ԾͶĵȼ
                return $this->checkHouseNumber($blockId)&&$this->checkBrokerLevel($bidBrokerLevel);
            } else {
                return false;
            }
        } else {
            return false;
        }
    }
    
    public function findAttention($bidPeriodsId) {
        $brokerId = $this->broker['id'];
        $growthAttention = new GrowthBidAttention();
        return $growthAttention->findBy("broker_id='$brokerId' and bid_periods_id='$bidPeriodsId' and type=1");
    }
    
    public function attent($bidId,$cBidPeriods) {
        $fieldData = array();
        $fieldData['broker_id'] = $this->broker['id'];
        $fieldData['type'] = 1;
        $fieldData['target_id'] = $bidId;
        $fieldData['bid_periods_id'] = $cBidPeriods;
        $growthAttention = new GrowthBidAttention();
        return $growthAttention->insert($fieldData);
        
    }
    
    public function cancelAttent($attentionId) {
        $growthAttention = new GrowthBidAttention();
        $brokerId = $this->broker['id'];
        $conf = "id='$attentionId' and broker_id='$brokerId'";
        return $growthAttention->delBy($conf);;
    }
    
    /**
     * ڴidұڲľͶ¼
     * @param int $bidPeriodsId
     * @return array Ͷ¼
     */
    public function findBidRecord($bidPeriodsId=0) {
        $brokerId = $this->broker['id'];
        if($bidPeriodsId) {
            $conf = "broker_id='$brokerId' and bid_periods_id='$bidPeriodsId'";
            return $this->growthBidRecord->findBy($conf);
        } else {
            return $this->growthBidRecord->findByBrokerId($brokerId);
        }
    }
    
    /**
     * Ҿ˵ľͶʷ¼
     * @param int $bidPeriodsId
     * @param string $order
     * @param string $limit
     * @return array
     */
    public function findBidHistoryRecord($bidPeriodsId=0,$blockName='',$order='',$limit='') {
        $brokerId = $this->broker['id'];
        $conf = "broker_id='$brokerId'";
        if($bidPeriodsId) {
            $conf .= " and bid_periods_id='$bidPeriodsId'";
        } 
        if($blockName) {
            $conf .= " and block_name like '%$blockName%' ";
        }
        return $this->growthBidRecordHistory->findBy($conf,$order,$limit);
    }

    public function findBidHistoryRecordNumber($bidPeriodsId=0,$blockName='') {
        $brokerId = $this->broker['id'];
        $conf = "broker_id='$brokerId'";
        if($bidPeriodsId) {
            $conf .= " and bid_periods_id='$bidPeriodsId'";
        } 
        if($blockName) {
            $conf .=" and block_name like '%$blockName%'";
        }
        return $this->growthBidRecordHistory->findNumberBy($conf);
    }

    /**
     * ҲС
     * @return array С
     */
    public function findBlockBid() {
        $bidRecords = $this->findBidRecord();
        $blocks = array();
        if($bidRecords) {
        foreach($bidRecords as $b) {
            $blocks[$b['block_id']] = $b['block_name'];
        }
        }
        return $blocks;
    }
    
    /**
     * ͶûԼڼλ
     * @param array $winnerRecord
     * @param array $myRecord
     * @return int Σ0ʾδͶУ1234ʾڼλ -1,ʾûͶ
     */
    public function checkWinBid($winnerRecord,$myRecord) {
        $number = 0;
        if($myRecord&&$winnerRecord) {
            $myRecordId = $myRecord['id'];
            $i = 0;
            foreach ($winnerRecord as $value) {
                $i++;
                if($value['id']==$myRecordId) {
                    $number = $i;
                    break;
                }
            }
        } else {
            $number = '-1';
        }
        return $number;
    }
    
    /**
     * ӮþͶļ¼statusж
     * @param type $bidId
     */
    public function findWinner($bidId) {
        
    }

    /**
     * ʱӮþͶ˵ľͶ¼
     * @param int $bidId Ͷid
     * @return array Ͷļ¼
     */
    public function findTempWinnerRecord($bidId) {
        return $this->growthBidRecord->findByBid($bidId, "score desc, utime asc", "0,4");
    }
    
     /**
     * ӮþͶ˵ľͶ¼
     * @param int $bidId Ͷid
     * @return array Ͷļ¼
     */
    public function findWinnerRecord($bidId) {
        return $this->growthBidRecordHistory->findBy("bid_id='$bidId' and status=1", "score desc, utime asc", "0,4");
    }
    /**
     * 
     * @param int $bidId
     * @return array
     */
    public function findRecordForRefund($bidId) {
        $res = $this->growthBidRecord->findBy("bid_id='$bidId' and status=1", "score desc, utime asc", "4,10");
        if($res) {
            return $res;
        } else {
            return array();
        }
    }
    
    public function isWinBid($bidId) {
        
    }
    
    /**
     * ؾͶҪͶͻ
     * @return array $result = array('type'=>'','score'=>'');typeʾǷģ0ķ,1,ķ֣2,׷ӷ
     */
    public function getNeedScore($bid,$winnerRecord,$myRecord) {
        //Ͷû
        $score = 0;
        $result = array('type'=>'','score'=>'');
        if($this->checkWinBid($winnerRecord, $myRecord)>0) {//Ͷ
                $result['type'] = self::BID_NEED_SCORE_TYPE_WIN;
                $result['score'] = 1;
        } else {//δͶ
            if(count($winnerRecord)==4) {
                $result['type'] = self::BID_NEED_SCORE_TYPE_NOT_WIN_1;
                $result['score'] = $winnerRecord[3]['score']+1;
            } else {
                $result['type'] = self::BID_NEED_SCORE_TYPE_NOT_WIN_0;
                $result['score'] = $bid['min_score'];
            }
        }
        return $result;
    }
    
    /**
     * һͶķ
     * @param array $bid
     */
    public function lastBidScore($myRecord) {
        if($myRecord) {
            return  $myRecord['score'];
        } else {
            return 0;
        }
        
    }
    
    /**
     * ؾͶϵʾֹʾ
     * @param int $myCredit ҵĻ
     * @param array $needScore ͶҪĻ ͨ getNeedScore($bid,$winnerRecord,$myRecord)
     * @return string ʾַ
     */
    public function tipOnPanel($myCredit,$needScore) {
        //$needScore = $this->getNeedScore($bid,$winnerRecord,$myRecord);
        $tip = "";
        if($needScore) {
            $type = $needScore['type'];
            $minScore = $needScore['score'];
            if($type == 0) {
                $tip = $myCredit<$minScore?"ֲŶ ".'<a target="_blank" href="./my_growth.php">ȥ׬&gt;&gt;</a>':"";
            }
            if($type == 1) {
                $tip = $myCredit<$minScore?"ֲŶ ".'<a target="_blank" href="./my_growth.php">ȥ׬&gt;&gt;</a>':"";
            }
            if($type == 2) {
                $tip = $myCredit<1?"ֲŶ ".'<a target="_blank" href="./my_growth.php">ȥ׬&gt;&gt;</a>':"";
            }
        }
        return $tip;
    }
    
    /**
     * Ͷɹʧܵʾ
     * @param array $myRecord
     * @param int $winFlag
     * @return string
     */
    public function tip1OnPanel($myRecord,$winFlag) {
        $myScore = $this->lastBidScore($myRecord);
        if($winFlag=='-1') {
            $tip2 = "";
        } elseif($winFlag==0) {
            $tip2 = "Ͷ".$myScore.",δǰ4˻";
        } else {
            $tip2 = "Ͷ".$myScore."";
        }
        return $tip2;
    }
    
    /**
     * Ͷ
     * @param array $needScore
     * @return array
     */
    public function scoreInputDefault($needScore,$myScore) {
        $default = array('span'=>'','value'=>'','totalTip'=>'');
        if($needScore) {
            $type = $needScore['type'];
            $minScore = $needScore['score'];
            if($type == 0) {
                $default['value'] = "".$minScore;
                $default['span'] = "ҪͶ";
                $default['totalTip'] = '';
            }
            if($type == 1) {
                $default['value'] = "".$minScore;
                $default['span'] = "ҪͶ";
                $default['totalTip'] = "";
            }
            if($type == 2) {
                $default['value'] = "1";
                $default['span'] = "Ҫ׷";
                $default['totalTip'] = 'Ͷ:<span class="calScore" value="'.$myScore.'" style="width: 21px; color: red;">'.$myScore.'</span>';
            }
        }
        return $default;
    }
    
    /**
     * ɼʱԲ
     * @param string $startTime ͶƱʼʱ
     * @param string $endTime ͶƱʱ
     */
    public function TimeRing($startTime,$endTime) {
        $time = time();
        $stime= strtotime($startTime);
        $etime= strtotime($endTime);
        $hours = ($etime-$stime)/3600;
        $ev = $hours/4;
        if($time>=$stime&&$time<$stime+3600*$ev) {
            return 1;
        } elseif($time>=$stime+3600*$ev&&$time<$stime+3600*$ev*2) {
            return 2;
        } elseif($time>=$stime+3600*$ev*2&&$time<$stime+3600*$ev*4) {
            return 3;
        } else {
            return 4;
        }
    }
    
    /**
     * Ͷб
     */
    public function get_bid_block_expert_list($blocks,$cBidPeriods,$myrecords) {     
        $myCredit = $this->broker['credit'];
            $list = array();
            if($blocks) {//С
                //print_r($cBidPeriods);
                    $blocksNew = SqlCombinHelper::changeToKeyArray($blocks, 'id');
                    $blockids = array_keys($blocksNew);
                    $bidPeriodsStatus = $cBidPeriods['status'];
                    $cBidPeriodsId = $cBidPeriods['id'];
                    $cBidPeriodsTgStartTime = $cBidPeriods['tg_start_time'];//ƹʱ
                    $cBidPeriodsTgEndTime = $cBidPeriods['tg_end_time'];
                    $cBidPeriodsStartTime = $cBidPeriods['start_time'];//Ͷʼʱ
                    $cBidPeriodsendTime = $cBidPeriods['end_time'];//Ͷʱ
                    //СͶ
                        $growthBidBlockExpert = new GrowthBidBlockExpert();
                        $blockExpertBids = $growthBidBlockExpert->findBy("block_id in ('".implode("','", $blockids)."') and bid_periods_id='$cBidPeriodsId'",array("block_level"=>"asc"));
                        $blockExpertBidsNew = SqlCombinHelper::changeToKeyArray($blockExpertBids, 'block_id');
                    //ע¼
                    $attentionList = $this->findAttention($cBidPeriodsId);
                    //Ԥ
                    $attentionListNew = SqlCombinHelper::changeToKeyArray($attentionList, 'target_id');
                    //print_r($attentionListNew);
                    if($bidPeriodsStatus==1) {
                        //ھͶ
                        //ҶӦľͶid
                        foreach($blockExpertBidsNew as $key=>$bid) {
                            $temp = array();
                            $tempBid = $bid;
                            $b = $blocksNew[$tempBid['block_id']];
                            $blockId = $b['id'];
                            $temp['block_id'] = $blockId;
                            $temp['block_name'] = $b['blockname'];
                            $temp['block_image'] = $b['b_img']?$b['b_img']:'./images/no_img_small.gif';
                            $temp['block_heat_level'] = $tempBid['block_level'];//Сȶȵȼ
                            //ͶϢ
                            $temp['bid_id'] = $tempBid['id'];
                            $temp['bid_status'] = $bidPeriodsStatus;
                            $temp['bid_status_str'] = 'Ͷ';
                            $temp['tg_start_time'] = $cBidPeriodsTgStartTime;//ƹʱ
                            $temp['tg_end_time'] = $cBidPeriodsTgEndTime;//ƹʱ
                            $temp['time'] = $cBidPeriodsendTime;//Ͷʱ
                            $temp['timeRing'] = $this->TimeRing($cBidPeriodsStartTime, $cBidPeriodsendTime);
                            $temp['number'] = $tempBid['number'];//μ
                            //Ͷǰ4λ
                            $temp['record'] = $this->findTempWinnerRecord($tempBid['id']);
                            //print_r($tempBid);
                            //print_r($tempRecord);exit;
                            //ע״̬
                            if($attentionListNew[$tempBid['id']]) {
                                $temp['attention_id'] = $attentionListNew[$tempBid['id']];
                            }
                            //ļ¼
                            //echo $tempBid['id'].'x';
                            $temp['my_record'] = $myrecords[$tempBid['id']];//ҵļ¼
                            $temp['my_credit'] = $myCredit;//ҵĿû
                            //ͳ
                            $allBidStat = $this->allPrevBidStat();
                            $temp['all_prev_stat'] = $allBidStat[$blockId];
                            //Ļ
                            //㣬ûͶ
                            //ϴͶĻ
                            $temp['my_score'] = $this->lastBidScore($temp['my_record']);
                            //ͻ֣Ǹ
                            $temp['min_score'] = $this->getNeedScore($tempBid, $temp['record'], $temp['my_record']);
                            //ʾ
                            $temp['tip'] = $this->tipOnPanel($temp['my_credit'], $temp['min_score']);
                            //ǷͶб
                            $winFlag = $this->checkWinBid($temp['record'], $temp['my_record']);
                            $temp['winFlag'] = $winFlag;
                            //ʾ1
                            $temp['tip1'] = $this->tip1OnPanel($temp['my_record'], $winFlag); 
                            //Ĭ
                            $temp['score_input_default'] = $this->scoreInputDefault($temp['min_score'],$temp['my_score']);
                            $list[] = $temp;
                        }  
                    }

                    if($bidPeriodsStatus==2) {//¾Ͷûʼ
                        foreach($blocks as $b) {
                            $temp = array();
                            $blockId = $b['id'];
                            $tempBid = $blockExpertBidsNew[$blockId];
                            $temp['block_id'] = $blockId;
                            $temp['block_name'] = $b['blockname'];
                            $temp['block_image'] = $b['b_img']?$b['b_img']:'./images/no_img_small.gif';
                            $temp['block_heat_level'] = $tempBid['block_level'];//Сȶȵȼ
                            //ͶϢ
                            $temp['bid_id'] = $tempBid['id'];
                            $temp['bid_status'] = $bidPeriodsStatus;
                            $temp['bid_status_str'] = 'ھͶ';//'ھͶ';
                            $temp['tg_start_time'] = $cBidPeriodsTgStartTime;//ƹʱ
                            $temp['tg_end_time'] = $cBidPeriodsTgEndTime;//ƹʱ
                            $temp['start_time'] = $cBidPeriodsStartTime;//Ͷʼʱ
                            $temp['time'] = $cBidPeriodsendTime;//Ͷʱ
                            $temp['timeRing'] = $this->TimeRing($cBidPeriodsStartTime, $cBidPeriodsendTime);
                            $temp['number'] = $tempBid['number'];//μ
                            $temp['my_credit'] = $myCredit;//ҵĿû
                            $temp['min_score'] = $this->getNeedScore($tempBid, array(), array());
                            $temp['score_input_default'] = $this->scoreInputDefault($temp['min_score'],0);
                            //ڣСͶʷ
                            //$prevRecord =$this->growthBidRecordHistory->findBy("block_id='$blockId' and status=1", "score desc, utime asc", "0,4");
                            //$template = '<div style="float: left; width: 120px;margin-bottom: 2px;"><span class="m_l_33 blod">NO.%s</span><span style="border-right-width: 0px; margin-right: 5px;" class="rank %s">%s</span></div>';
                            //$temp['record_list'] = $this->rankList($prevRecord,  GrowthBidPeriods::BID_PERIODS_STATUS_FINISH,$template,null);
                            //print_r($tempBid);
                            //print_r($tempRecord);exit;
                            //ͳ
                            $allBidStat = $this->allPrevBidStat();
                            $temp['all_prev_stat'] = $allBidStat[$blockId];
                            //ע״̬
                            if($attentionListNew[$tempBid['id']]) {
                                //$temp['attention_id'] = $attentionListNew[$tempBid['id']];
                            }
                            $list[] = $temp;
                        }  
                    }
                    
                    if($bidPeriodsStatus==3) {
                        foreach($blockExpertBidsNew as $key=>$bid) {
                            $temp = array();
                            $tempBid = $bid;
                            $b = $blocksNew[$tempBid['block_id']];
                            $blockId = $b['id'];
                            $temp['block_id'] = $blockId;
                            $temp['block_name'] = $b['blockname'];
                            $temp['block_image'] = $b['b_img']?$b['b_img']:'./images/no_img_small.gif';
                            $temp['block_heat_level'] = $tempBid['block_level'];//Сȶȵȼ
                            //ͶϢ
                            $temp['bid_id'] = $tempBid['id'];
                            $temp['bid_status'] = $bidPeriodsStatus;
                            $temp['bid_status_str'] = 'Ͷ';
                            $temp['tg_start_time'] = $cBidPeriodsTgStartTime;//ƹʱ
                            $temp['tg_end_time'] = $cBidPeriodsTgEndTime;//ƹʱ
                            $temp['time'] = $cBidPeriodsendTime;//Ͷʱ
                            $temp['timeRing'] = $this->TimeRing($cBidPeriodsStartTime, $cBidPeriodsendTime);
                            $temp['number'] = $tempBid['number'];//μ
                            //Ͷǰ4λ
                            $temp['record'] = $this->findTempWinnerRecord($tempBid['id']);
                            //print_r($tempBid);
                            //print_r($tempRecord);exit;
                            //ͳ
                            $allBidStat = $this->allPrevBidStat();
                            $temp['all_prev_stat'] = $allBidStat[$blockId];
                            //ע״̬
                            if($attentionListNew[$tempBid['id']]) {
                                $temp['attention_id'] = $attentionListNew[$tempBid['id']];
                            }
                            //ļ¼
                            //echo $tempBid['id'].'x';
                            $temp['my_record'] = $myrecords[$tempBid['id']];//ҵļ¼
                            $temp['my_credit'] = $myCredit;//ҵĿû
                            //Ļ
                            //㣬ûͶ
                            //ϴͶĻ
                            $temp['my_score'] = $this->lastBidScore($temp['my_record']);
                            //ͻ֣Ǹ
                            $temp['min_score'] = $this->getNeedScore($tempBid, $temp['record'], $temp['my_record']);
                            //ʾ
                            $temp['tip'] = $this->tipOnPanel($temp['my_credit'], $temp['min_score']);
                            //ǷͶб
                            $winFlag = $this->checkWinBid($temp['record'], $temp['my_record']);
                            $temp['winFlag'] = $winFlag;
                            //ʾ1
                            $temp['tip1'] = $this->tip1OnPanel($temp['my_record'], $winFlag); 
                            //Ĭ
                            $temp['score_input_default'] = $this->scoreInputDefault($temp['min_score'],$temp['my_score']);
                            $list[] = $temp;
                        }  
                    }
            }
            //print_r($list);exit;
            return $list;
        }

    public function getAttentionList($cBidPeriods) {
        $bidPeriodsId = $cBidPeriods['id'];
        $attentionList = $this->findAttention($bidPeriodsId);
        //print_r($attentionList);
        if(!$attentionList) {//ûйעؿ
            return array();
        }

        $bidIds = array();
        foreach ($attentionList as $value) {
            $bidIds[] = $value["target_id"];
        }
        //龺Ͷ
        $conf = "id in ('".  implode("','", $bidIds)."')";
        $bids = $this->growthBid->findBy($conf);
        $bids = SqlCombinHelper::changeToKeyArray($bids, "block_id");
        //print_r($bids);
        $blockIds = array_keys($bids);
        $blockMg = new Block();
        $blocks = $blockMg->findAllBy("id in ('".implode("','", $blockIds)."')");
        //print_r($blocks);
        //ҵļ¼
        $myrecords = $this->findBidRecord($bidPeriodsId);
        $myrecords = SqlCombinHelper::changeToKeyArray($myrecords, 'bid_id');

        $attentionBidList = array();

        $attentionList = $this->get_bid_block_expert_list($blocks, $cBidPeriods, $myrecords);
        //print_r($attentionList);
        return $attentionList;
    }

    /**
     * б
     * @param array $records ¼
     * @param string $tType  Ͷ״̬GrowthBidPeriods::BID_PERIODS_STATUS_ON;
                                     GrowthBidPeriods::BID_PERIODS_STATUS_NOT_START;
                                     GrowthBidPeriods::BID_PERIODS_STATUS_FINISH//ַonhistory,Ĭon
     * @param type $template
     * @param type $myrecord
     * @return type
     */
    public function rankList($records, $tType = GrowthBidPeriods::BID_PERIODS_STATUS_ON, $template=null, $myrecord = null) {
        if(!$records) {$records = array();}
        $records = array_pad($records, 4, array());
        $html = "";
        foreach($records as $k=>$r) {
            //$funcName = "renderRank".ucfirst($tType);
            if($tType==GrowthBidPeriods::BID_PERIODS_STATUS_ON) {
                $html .= $this->renderRankHasScore($k,$r,$myrecord,$template);
            } else {
                $html .= $this->renderRankNoScore($k,$r,$myrecord,$template);
            }
        } 
        return $html;
    }

    /**
     * Ͷеʾ
     * @param type $k
     * @param type $r
     * @param type $myrecord
     * @param type $template
     * @return string
     */
    private function renderRankHasScore($k,$r,$myrecord=null,$template=null) {
        $no = $k+1;
        $rank02 = 'rank02';
        if(!empty($r)) {
            if($myrecord&&$myrecord['id']==$r['id']) {//жǲԼ
                $rank02 = '';
                $score = '<strong class="num">'.$r['score'].'</strong>';
            } else {
                $score = '<strong class="num">ѱռ</strong>';
            }
        } else {
                $score = '<strong class="num">ȱϯ</strong>';
        }

        if($template) {
            $html = sprintf($template,$no,$rank02,$score);
        } else {
            $html = '<div class="fraction_rank radius3" style="margin: 5px;"><span class="rank '.$rank02.'">NO.'.$no.'</span><span class="fraction">'.$score.'</span></div>';
        }
        return $html;
    }
    /**
     * Ͷʾ
     * @param type $k
     * @param type $r
     * @param type $myrecord
     * @param type $template
     * @return string
     */
    private function renderRankNoScore($k,$r,$myrecord=null,$template=null) {
        $no = $k+1;
        //$rank02 = $no>2?'rank02':'';
        $score = $r['score']?$r['score']:' ';
        $rank02 = 'rank02';
        if($myrecord) {//жǲԼ
                //echo 'xxx';
                //echo "#".$r['id']."--#".$myrecord['id'];
            if($r['id']==$myrecord['id']) {
                $rank02 = '';
            }
        }
        if($template) {
            $html = sprintf($template,$no,$rank02,$score);
        } else {
            $html = '<div class="fraction_rank radius3"  style="margin: 5px;"><span class="rank '.$rank02.'">NO.'.$no.'</span><span class="fraction"><strong class="num">'.$score.'</strong></span></div>';
        }
        return $html;
    }
    /**
     * 鿴Ȩ
     * @param int $bid
     */
    public function checkViewAuth($cBidPeriodsId,$bid) {
        $blockId = $bid['block_id'];
        $blocks = $this->get_valid_bid_block($cBidPeriodsId,array(), '');
        $blocks = SqlCombinHelper::changeToKeyArray($blocks, "id");
        if(in_array($blockId, array_keys($blocks))) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * пԲ뾺ͶСid
     * @param type $cBidPeriodsId
     */
    public function get_valid_bid_block_id($cBidPeriodsId) {
        $blockids = $this->findAllBlockHouserNumber(GrowthBrokerBidBlockExpert::HOUSE_NUMBER_LIMIT);
        //ˣоͶҾ˵ȼ
        //СͶ
        $growthBidBlockExpert = new GrowthBidBlockExpert();
        $blockExpertBids = $growthBidBlockExpert->findBy("block_id in ('".implode("','", $blockids)."') and bid_periods_id='$cBidPeriodsId'");
        $blockExpertBidsNew = SqlCombinHelper::changeToKeyArray($blockExpertBids, 'block_id');
        $this->blockExpertBidsNew = $blockExpertBidsNew;
        $blockids = array();
        //print_r($blockExpertBidsNew);
        foreach ($blockExpertBidsNew as $value) {
            if($this->checkBrokerLevel($value['broker_level'])) {
                $blockids[] = $value['block_id'];
            }
        }
        return $blockids;
    }
    /**
     * ԵСרҾͶС
     * @param type $growthBrokerBidBlockExpert
     * @param array $myrecords ҵľͶ¼
     * @param string $action Ļеı
     * @return array С
     */
    public function get_valid_bid_block ($cBidPeriodsId,$myrecords,$action,$blockName='') {
        $blockids = $this->findAllBlockHouserNumber(GrowthBrokerBidBlockExpert::HOUSE_NUMBER_LIMIT);
        //ˣоͶҾ˵ȼ
        //СͶ
        $growthBidBlockExpert = new GrowthBidBlockExpert();
        $blockExpertBids = $growthBidBlockExpert->findBy("block_id in ('".implode("','", $blockids)."') and bid_periods_id='$cBidPeriodsId'");
        $blockExpertBidsNew = SqlCombinHelper::changeToKeyArray($blockExpertBids, 'block_id');
        $this->blockExpertBidsNew = $blockExpertBidsNew;
        $blockids = array();
        //print_r($blockExpertBidsNew);
        foreach ($blockExpertBidsNew as $value) {
            if($this->checkBrokerLevel($value['broker_level'])) {
                $blockids[] = $value['block_id'];
            }
        }
        $block = new Block();
        if($blockName) {
            $blocks = $block->findAllBy("id in ('".  implode("','", $blockids)."') and blockName like '%$blockName%'");
        } else {
            $blocks = $block->findAllBy("id in ('".  implode("','", $blockids)."')");
        }
        if(!$blocks) {
            $blocks = array();
        }
        if($action=='on') {
            $blocksOn = array();//$growthBrokerBidBlockExpert->findBlockBid();
            foreach($myrecords as $mr) {
                $blocksOn[$mr['block_id']] = $mr['block_name'];
            }
            $blockIdsOn = array_keys($blocksOn);
            if($blocks) {//δС
                foreach($blocks as $k=>$v) {
                    if(!in_array($v['id'],$blockIdsOn)) {
                        unset($blocks[$k]);
                    }
                }
            } 
        }
        $levels = array();//Сȼ
        foreach ($blocks as $key=>$v) {
            $levels[$key] = $blockExpertBidsNew[$v['id']]['block_level'];
            $blocks[$key]['block_level'] = $levels[$key];
        }
        array_multisort($levels, SORT_ASC, $blocks);
        //print_r($blocks);
        return $blocks;
    }

    /**
     * ؾͶʷб
     * @param array $myrecords ҵľͶ¼
     * @return array ʷб
     */
    public function get_bid_block_expert_history_list($myrecords) {
        if(!$myrecords) {
            return array();
        }
        $mc = Container::getInstance()->get('mc');
        //ڴbid_periods
        $bidPeriodsIds = array();
        $bidIds = array();
        $historyList = array();
        foreach ($myrecords as $value) {
            $bidPeriodsIds[] = $value['bid_periods_id'];
            $bidIds[] = $value['bid_id'];
        }
        $bidPeriodsIds = array_unique($bidPeriodsIds);
        $growthBidPeriods = new GrowthBidPeriods();
        $bidPeriodsMKey = array( $bidPeriodsIds);
        $bidPs = $mc->get($bidPeriodsMKey);
        if($bidPs === false) {
            $bidPs = $growthBidPeriods->findBy("id in ('".  implode("','", $bidPeriodsIds)."')");
            $mc->set($bidPeriodsMKey,$bidPs,3600);
        }
        
        $bidPs = SqlCombinHelper::changeToKeyArray($bidPs, 'id');
        //龺Ͷbid
        $bids = $this->growthBid->findBy("id in ('".  implode("','", $bidIds)."')");
        $bids = SqlCombinHelper::changeToKeyArray($bids, 'id');
        //print_r($bids);exit;
        //ʤļ¼
        foreach ($myrecords as &$value) {
            $temp = array();
            $temp['block_name'] = $value['block_name'];
            $bidP = $bidPs[$value['bid_periods_id']];
            $temp['tg_start_time'] = $bidP['tg_start_time'];
            $temp['tg_end_time'] = $bidP['tg_end_time'];
            $temp['number'] = $bids[$value['bid_id']]['number'];
            $temp['bid_status'] = "ѽ";
            if($value['status'] == 1) {
                $temp['my_result'] = '<span class="s_color ">Ͷɹ</span>';
                $temp['my_result_tip'] = '';
            } else {
                $temp['my_result'] = '<span class="f_color ">Ͷʧ</span>';
                $temp['my_result_tip'] = ' ˻';
            }
            $temp['my_score'] = $value['score'];
            $recordsMKey = array($value['bid_id'], "score desc, utime asc", "0,4");
            $records = $mc->get($recordsMKey);
            if($records === false){
                $records = $this->growthBidRecordHistory->findByBid($value['bid_id'], "score desc, utime asc", "0,4");
                $mc->set($recordsMKey,$records,3600);
            }
            
            $template = '<div style="float: left; width: 120px;margin-bottom: 2px;"><span class="m_l_33 blod">NO.%s</span><span style="border-right-width: 0px; margin-right: 5px;" class="rank %s">%s</span></div>';
            $temp['record_list'] = $this->rankList($records,  GrowthBidPeriods::BID_PERIODS_STATUS_FINISH,$template,$value);
            $historyList[] = $temp;
        }
        //print_r($historyList);exit;
        return $historyList;
    }
    
    /**
     * ȡһڵľͶ¼,Ӫҳ
     * @return type
     */
    public function findNewBidRecord($cPeriods) {
        $brokerId = $this->getBrokerId();
		$cPeriodsStatus = $cPeriods['status'];
        if ($cPeriods['status'] == 1 || $cPeriods['status'] == 3) {
            $growthBidRecord = $this->growthBidRecord;
        } else {
            //һ
            $growBidPeriods = new GrowthBidPeriods();
            $cPeriods = $growBidPeriods->upBidPeriods(1, $cPeriods['id']);
            $growthBidRecord = $this->growthBidRecordHistory;
        }
        $periodsId = $cPeriods['id'];
        $bidAllRecord = $growthBidRecord->findByPidAndBrokerId($periodsId, $brokerId, 10);
        if (!CommonBase::isFullArray($bidAllRecord)) {return array();}
        $arrBidRecord = array();
        foreach($bidAllRecord as $k => $v) {
            $bidMaxMinScore = $growthBidRecord->findMaxMinScoreByBid($v['bid_id']);
 			if ($cPeriods['status'] == 1 || $cPeriods['status'] == 3) {
				$bidRecord = $this->findTempWinnerRecord($v['bid_id']);
			} else {
				$bidRecord = $this->findWinnerRecord($v['bid_id']);
			}
            $myRecord = $growthBidRecord->findOneBy($brokerId,$v['bid_id']);//$growthBidRecord->findBidRecordByBidAndHouseId($v['bid_id'], $v['house_id']);
            //print_r($myRecord);
            $bidRank = $this->checkWinBid($bidRecord, $myRecord);
            if ($cPeriods['status'] == 1) {
                if ($bidRank > 0) {
                    $intBehavior = self::$bidBehavior['tempHit'];
                    $arrBidRecord[$k]['rank'] = $bidRank;
                } else {
                    $intBehavior = self::$bidBehavior['noHit'];
                }
            } else {
                $intBehavior = $bidRank > 0 ? self::$bidBehavior['success'] 
                        : self::$bidBehavior['failure'];
            }
            if ($cPeriodsStatus == 2) {
                $bidRankUrl = 'market_bid_block_expert_history.php';
            } else {
                $bidRankUrl = 'market_bid_block_expert.php?tab=on';
            }
            $content = $v['block_name'];
            $tgStartTime = $cPeriods['tg_start_time'];
            $tgEndTime = $cPeriods['tg_end_time'];
            $arrBidRecord[$k]['projectname'] = self::$bidProjectName;
            $arrBidRecord[$k]['tg_start_time'] = date('m.d', strtotime($tgStartTime));
            $arrBidRecord[$k]['tg_end_time'] = date('m.d', strtotime($tgEndTime));
            $arrBidRecord[$k]['content'] = $content;
            $arrBidRecord[$k]['score'] = $v['score'];
            $arrBidRecord[$k]['utime'] = $v['utime'];
            $arrBidRecord[$k]['behavior'] = $intBehavior;
            $arrBidRecord[$k]['max_score'] = $cPeriods['status']==  GrowthBidPeriods::BID_PERIODS_STATUS_ON?'':$bidMaxMinScore['max'];
            $arrBidRecord[$k]['min_score'] = $bidMaxMinScore['min'];
            $arrBidRecord[$k]['operate'] = $bidRankUrl;
            $arrBidRecord[$k]['esta'] = 1;
        }
        return $arrBidRecord;
    }
    
    public function getBrokerId() {
        return $this->broker['id'];
    }
    
        /**
     * ƿԲ뾺Ͷʱ
     */
    public function  controlTime() {
        if(isset($_SESSION['last_bid_time'])) {
            $lastTime = $_SESSION['last_bid_time'];
            if($lastTime>time()) {
                return false;
            } else {
                $_SESSION['last_bid_time'] = time()+GrowthBrokerBidBlockExpert::BID_MIN_TIME;
                return true;
            }
        } else {
            $_SESSION['last_bid_time'] = time()+GrowthBrokerBidBlockExpert::BID_MIN_TIME;
            return true;
        }
        
        
    }
    
    /**
     * ھͶͳƣܹжӣ
     * ͶɹͶ߻ֵͻֵ
     * @return array 
     */
    public function allPrevBidStat() {
        $mc = Container::getInstance()->get('mc');
        $sql = "SELECT block_id,MAX(score) as max,MIN(score) as min FROM growth_bid_block_expert_record_history WHERE `status`=1 GROUP BY block_id";
        $sql1 = "SELECT block_id, count(id) as number FROM growth_bid_block_expert_record_history  GROUP BY block_id";
        $recordsMKey = array($sql, $sql1);
        $data = $mc->get($recordsMKey);
        if($data === false){
            $creditData = $this->dbback->getAll($sql);
            $data = SqlCombinHelper::changeToKeyArray($creditData, 'block_id');
            $numberData = $this->dbback->getAll($sql1);
            foreach ($numberData as $value) {
                $blockId = $value['block_id'];
                $data[$blockId]['number'] = $value['number'];
            }
             $mc->set($recordsMKey,$data,3600);
        }
        return $data;
    }
}

?>
