<?php
/**
 * ɳֵȡʽʽײ֮Ĺ
 *
 * @author sun
 */
class GrowthExpWayPackage {
    
    /**
     * ݿ
     */
    private $db;

    /**
     * ݿ
     */
    private $dbback;

    /**
     * 
     */
    private $mc;
    
    /**
     * ı
     * @var string
     */
    private $table;
    
    /**
     * аֶ
     * @var array
     */
    private static $fields = array('id','way_alias','package_id','score');

    public function __construct() {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->mc = $container->get('mc');
        $this->table = 'growth_exp_way_package';
    }
    
    /**
     * ײͺͻȡɳֵ
     * @return array
     */
    public function findAllData() {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields);
        return $this->dbback->getAll($sql);
    }
    
    /**
     * ݻȡʽײͻȡ
     * @param string $wayAlias ʽ
     * @param int $packageId ײͱ
     * @return array
     */
    public function findDataByWayAliasAndPackageId($wayAlias, $packageId) {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields, 
                "way_alias = '$wayAlias' AND package_id = $packageId");
        return $this->dbback->getRow($sql);
    }
    
    /**
     * ݻȡʽײͻطֵ
     * @param string $wayAlias ʽ
     * @param type $packageId ײͱ
     * @return int
     */
    public function findScoreByWayAliasAndPackageId($wayAlias, $packageId) {
        $arrRow = $this->findDataByWayAliasAndPackageId($wayAlias, $packageId);
        return $arrRow['score'] == '' ? 0 : $arrRow['score'];
    }
    
    /**
     * 
     * @param string $way_alias ʽ
     * @param int $package_id ײͱ
     * @param int $score ֵ
     * @return boolean
     */
    public function insertData($way_alias, $package_id, $score) {
        $arrFieldsValue = array();
        $arrFieldsValue['way_alias'] = $way_alias;
        $arrFieldsValue['package_id'] = $package_id;
        $arrFieldsValue['score'] = $score;
        $sql = SqlCombinHelper::insert_sql($this->table, $arrFieldsValue);
        return $this->db->execute($sql);
    }
    
    /**
     * ײͱɾ
     * @param int $packageId ײͱ
     * @return boolean
     */
    public function delDataByPackageId($packageId) {
        $sql = SqlCombinHelper::delete_sql($this->table, "package_id = "
                . "$packageId");
        return $this->db->execute($sql);
    }
    
    /**
     * ݷʽɾ
     * @param string $wayAlias ʽ
     * @return boolean
     */
    public function delDataByWayAlias($wayAlias) {
        $sql = SqlCombinHelper::delete_sql($this->table, 
                "way_alias = '$wayAlias'");
        return $this->db->execute($sql);
    }
    
    /**
     * ݷʽźײͱɾ
     * @param string $wayAlias ʽ
     * @param type $packageId ײͱ
     * @return boolean
     */
    public function delDataByWayAliasAndPackageId($wayAlias, $packageId) {
        $sql = SqlCombinHelper::delete_sql($this->table, "way_alias = "
                . "'$wayAlias'" . "AND package_id = $packageId");
        return $this->db->execute($sql);
    }
    
    /**
     * 
     * @param array $fields ݽṹ
     * @return boolean
     */
    public function saveData($fields) {
        $sql = SqlCombinHelper::replace_sql($this->table, $fields);
        return $this->db->execute($sql);
    }
}
