<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Rent Class
 *
 * ۱ⷿģ
 *
 * @package     zsb
 * @subpackage      Controllers
 * @category        Controllers
 * @author      liuhu
 */
class Rent_test extends MY_Controller {
    
    /**
    * в
    *
    * @access private
    * @var string
    */
    protected  $_city = 'nj';
    
    /**
     * Դģģ
     * @var type 
     */
    private $_house_template_module = 'rent';

    /**
    * ǰûuid
    *
    * @access private
    * @var int
    */
    private  $_uid = 0;

    /**
    * ǰҳ
    *
    * @access private
    * @var string
    */
    private $_current_page = 1;

    /**
    * ÿҳĿ
    *
    * @access private
    * @var int
    */
    private $_limit = 20;

    /**
    * ƫ
    *
    * @access private
    * @var int
    */
    private $_offset = 0;

    /**
    * Ŀ
    *
    * @access private
    * @var int
    */
    private $_total_count = 0;
    
    
    /**
    * 
    *
    * @access public
    * @return void
    */
    public function __construct()
    {     
        parent::__construct();
        //طԴģ
        $this->load->model('rent_model');
        $this->load->helper('common_house_helper');
        //ɷۺͳȨ @todo
        $is_permission = $this->rent_model->get_public_permission($this->user_arr['package_id']);
        if ($is_permission === false) 
        {
            $this->jump(GB_WO_URL);
            exit;
        }
    }
    
    
    /**
    * ʼҳ
    *
    * @access public
    * @param  int  $current_page
    * @param  int  $page_size
    * @return void
    */
    private function _init_pagination($current_page = 1 , $page_size = 0)
    {
        /** ǰҳ */
        $this->_current_page = ( $current_page && is_numeric( $current_page ) ) ?
                intval( $current_page ) : 1;

        /** ÿҳ */
        $this->_limit = ( $page_size && is_numeric( $page_size ) ) ?
                intval( $page_size ) : $this->_limit;

        /** ƫ */
        $this->_offset = ( $this->_current_page - 1 ) * $this->_limit;

        if($this->_offset < 0)
        {
            redirect(base_url());
        }
    }
    
    /**
     * ȾԴϢ
     * @param type $data_page
     */
    private function render_publish($data_page = array())
    {   
        //ҳҪ
        $data_page['page_js'] = load_js('common/js/swf/swfupload.js,'
                . 'zsb/js/v1.0/uploadpic.js,common/js/jquery.validate.min.js,'
                . 'common/js/jquery_ui_autocomplete/ui/jquery.ui.core.js,'
                . 'common/js/jquery_ui_autocomplete/ui/jquery.ui.position.js,'
                . 'common/js/jquery_ui_autocomplete/ui/jquery.ui.widget.js,'
                . 'common/js/jquery_ui_autocomplete/ui/jquery.ui.autocomplete.js,'
                . 'common/js/jquery.ui.mouse.min.js,'
                . 'common/js/jquery.ui.sortable.min.js,'
                . 'zsb/js/v1.0/house.js');
        $data_page['css'] = load_css('zsb/css/v1.0/style1.css,zsb/css/v1.0/autocomlete.css');
        $data_page['house'] = $this->config->item('house');
        $data_page['upload_pic_url'] = $this->config->item('base_url') . 'pic/house/';
        $this->view('house_manage', 'rent_modify', $data_page);
    }
    
    /**
     * Ĭҳ
     */
    public function index()
    {
        $this->manage();
    }
    
    /**
     * Դҳ
     */
    public function add() 
    { 
        $uid = $this->user_arr['uid'];
        $package_id = $this->user_arr['package_id'];
        //ɷۺͳȨ ӵ__construct
        //жϿǷ Դбҳַת
        $url_manage = $this->rent_model->find_func_url();
        $this->load->model('broker_model');
        $this->load->model('package_model');
        $package = $this->package_model->find_by_id($package_id);
        //жϿײͿ
        $stock_house_num = $this->broker_model->stock_house_num();
        if ($stock_house_num >= $package["package_stock_num"])
        {
            $this->jump($url_manage, "Բ,ѳʺŷԴ("
                    . "{$package['package_stock_num']},$stock_house_num) 
                        뵽ķԴɾڷԴ!");
            return;
        }
        $data_page = array();
        //ȡԴģϢ
        $template_module = $this->_house_template_module;
        $this->load->model('house_template_model');
        //Դģ
        $data_page['template_num'] = $this->house_template_model->
                find_count_by_module($template_module, $uid);
        //ģ > 0 תбתҳ
        if ($data_page['template_num'] > 0)
        {
            //ɱģ
            $data_page['remain_num'] = $this->house_template_model->template_num 
                    - $data_page['template_num'];
            //ģб
            $data_page['template_list'] = $this->house_template_model->
                    find_by_module($template_module, $uid);
            $data_page['url_template_manage'] = $this->house_template_model->
                    find_func_url('manage') . $template_module . '/';
        }
        else
        {
            //ģ
            $data_page['url_template_manage'] = $this->house_template_model->
                    find_func_url('add') . $template_module . '/';
        }
        $data_page['url_template_add'] = $this->house_template_model->
                 find_func_url('add') . $template_module . '/'; 
        //ȡԴʷСϢ
        $this->rent_model->set_select_fields(array('blockid', 'blockshowname'));
        $data_page['publish_block'] = $this->rent_model->find_publish_block($uid);
        //ͼͨԴӳɳֵķֵ
        $gcep = new GrowthExpWayPackage();
        $starScore = $gcep->findScoreByWayAliasAndPackageId('pStarHouse', $package_id);
        $noStarScore = $gcep->findScoreByWayAliasAndPackageId('pNoStarHouse', $package_id);
        $data_page['star_score'] = $starScore;
        $data_page['no_star_score'] = $noStarScore;
        //ķԴ
        $data_page['allow_publish_infotype'] = $this->rent_model->
                get_public_infotype_permission($package_id);
        //췢öٳɳֵ
        $growthExpDayCount = new GrowthExpDayCount();
        $publishEventArray = array('pQualityHouse','pStarHouse','pNoStarHouse');
        $exp_rank_day = $growthExpDayCount->getExpAndRank($uid, $publishEventArray);
        $data_page['growthDaySum'] = $exp_rank_day['exp'];
        //ǰõΰٷֱ
        $data_page['rankRate'] = $exp_rank_day['rate'];
        //ҳ
        $data_page['method'] = 'add';
        $data_page['url_house_submit'] = $this->rent_model->find_func_url('insert');
        //ĵ
        $data_page['documentation'] = $this->config->item('documentation');
        //ͳƴ
        $data_page['page_title'] = 'Դ-';
		$data_page['google_analytics'] = get_ga_js_code('/Դ//');
        //ģ
        $this->render_publish($data_page);
    }
    
    /**
     * 뷿Դ model
     */
    public function insert() 
    {      
        //һȡUID
		$this->load->model('broker_model');
		$session_info = $this->broker_model->get_user_session();	
        $uid = $this->user_arr['uid'];
        $package_id = $this->user_arr['package_id'];
        $companycode = $this->user_arr['agentcode'];
        $tbl = $this->rent_model->get_tbl();
        $nowtime = time();
        //Ȩ
        //Դбҳַת
        $url_manage = $this->rent_model->find_func_url();
        //ƷԴʱ
        $session_key = $uid . '_last_rent_add_time';
        $session_value = $this->session->userdata($session_key);
        if ($session_value > 0 && $nowtime - $session_value <= 5) {
            $this->session->set_userdata(array($session_key => $nowtime));
            $this->jump($url_manage, "æԺ");
            return;
        } else {
            $this->session->set_userdata(array($session_key => $nowtime));
        }
        $this->load->model('broker_model');
        $this->load->model('package_model');
        $package = $this->package_model->find_by_id($package_id);
        //ġжԴԴǷз񳬹
        $valid_house_num = $this->broker_model->valid_house_num();
        $esta = $valid_house_num >= $package["package_valid_num"] ? 2 : 1;
        if ($esta == 1) //ԴжǷˢ³
        {
            $this->load->model('log_refresh');
            $total_refresh_num = $this->log_refresh->findTodayNumberByBrokerId($uid);
            $esta = $total_refresh_num >= $package["package_refresh_num"] ? 2 : 1;
        }
        if ($esta == 2) //ʧЧԴжϿײͿ
        {
            $stock_house_num = $this->broker_model->stock_house_num();
            if ($stock_house_num >= $package["package_stock_num"])
            {
                $this->jump($url_manage, "Բ,ѳʺŷԴ("
                        . "{$package['package_stock_num']},$stock_house_num) 
                            뵽ķԴɾڷԴ!");
                return;
            }
        }
        //塢뷿ԴϢ
        //˷ԴĬagentcode
        $agentcode = 'B000';
        $this->load->helper('common_string_helper');
        //Դ
        $fields_values = array();
        /* ǰ̨ͻ֤СıдǷЧСֵ
        * ȡСϢͨpostʽύ
        */
        $blockshowname = trim($this->input->post('blockshowname', true));
        if($blockshowname != '')
        {
            $this->load->model('block_model');
            $this->block_model->set_select_fields(array('id','blockname','district','streetid'));
            $block = $this->block_model->find_by_blockname($blockshowname);

            if( !empty($block)) {
                $blockid = $block['id'];
                $district = $block['district'];
                $streetid = $block['streetid'];
                $blockshowname = $block['blockname'];
            }else{
                echo "<script>alert('СڣСƻССбѡ');history.go(-1);</script>";
                exit;
            }
        }
        else
        {
            echo "<script>alert('дС');history.go(-1);</script>";
            exit;
        }
        /*******************Ϣʼ***************************/
        $fields_values['infotype'] = intval($this->input->post('infotype', true));
        $fields_values['agentcode'] = $agentcode;
        $fields_values['infofrom'] = get_infofrom_by_agentocde($agentcode);
        $fields_values['uid'] = $uid;
        $fields_values['esta'] = $esta;
        $fields_values['district'] = str_replace('"','',$district);
        $fields_values['streetid'] = $streetid;
        $fields_values['blockid'] = $blockid;
        $fields_values['blockshowname'] = csubstr($this->input->post('blockshowname', true), 20);
        $fields_values['price'] = $this->input->post('price', true);
        $fields_values['priceunit'] = $this->input->post('priceunit', true);
        $fields_values['renttype'] = $this->input->post('renttype', true);
        if ($fields_values['renttype'] == '')
        {
            $fields_values['rentremark'] = $this->input->post('rentremark', true);
            $fields_values['rentroom'] = $this->input->post('rentroom', true);
        } 
        $fields_values['payment'] = $this->input->post('payment', true);
        $fields_values['buildarea'] = $this->input->post('buildarea', true);
        //ֻҵ סլ  ҡȲ
        if ($fields_values['infotype'] == 1 || $fields_values['infotype'] == 2) 
        {
            $fields_values['room'] = $this->input->post('room', true);
            $fields_values['hall'] = $this->input->post('hall', true);
            $fields_values['toilet'] = $this->input->post('toilet', true);
            $fields_values['kitchen'] = $this->input->post('kitchen', true);
            $fields_values['balcony'] = $this->input->post('balcony', true);
        }       
        else
        {
            //ǿΪ0
            $fields_values['room'] = '';
            $fields_values['hall'] = '';
            $fields_values['toilet'] = '';
            $fields_values['kitchen'] = '';
            $fields_values['balcony'] = '';
        }
        //ҵΪ⳵λû¥
        if ($fields_values['infotype'] == 6)
        {
            $fields_values['subfloor'] = '';
            $fields_values['floor'] = '';
            $fields_values['totalfloor'] = '';
            $fields_values['fitment'] = '';
            $fields_values['forward'] = '';
        }
        else
        {
            //¥ж
            $lctype = $this->input->post('lctype', true);
            if ($lctype == 1) //
            { 
                $floor = $this->input->post('floor', true);
                $totalfloor = $this->input->post('totalfloor', true);
                if ($floor > $totalfloor) 
                {
                    //תҳ
                    echo "<script>alert('¥㲻Сڵǰ¥!');history.go(-1);</script>";
                    return;
                }
                $fields_values['subfloor'] = 0;
                $fields_values['floor'] = $floor;
                $fields_values['totalfloor'] = $totalfloor;
            }   
            if ($lctype == 2) //Ծ
            { 
                $subfloor = $this->input->post('subfloor', true);
                $floor2 = $this->input->post('floor2', true);
                $totalfloor2 = $this->input->post('totalfloor2', true);
                if ($subfloor > $totalfloor2 || $floor2 > $totalfloor2) 
                {
                    echo "<script>alert('¥㲻Сڵǰ¥!');history.go(-1);</script>";
                    return;
                }
                $fields_values['subfloor'] = $subfloor;
                $fields_values['floor'] = $floor2;
                $fields_values['totalfloor'] = $totalfloor2;
            }
            $fields_values['fitment'] = $this->input->post('fitment', true);
            $fields_values['forward'] = $this->input->post('forward', true);
        }
        $fields_values['contactor'] = $this->user_arr['truename'];
        $fields_values['telno'] = $session_info['telno'];
        $fields_values['creattime'] = time();
        if ($fields_values['infotype'] == 1)
        {
            $fields_values['expiretime'] = strtotime("+30 days");
        }
        else
        {
            $fields_values['expiretime'] = strtotime("+90 days");
        }
        $fields_values['updatetime'] = time();
        $fields_values['lucupdatetime'] = $fields_values['updatetime'];
        $fields_values['ip'] = get_ip();
        /*******************Ϣ***************************/
        
        //ʱ¼־
		$msg = date('y-m-d H:i:s')."::".print_r($_POST,true)." \n";
		$log = './applications/zsb/logs/rent'."_".date('y-m-d');
		file_put_contents($log,$msg,FILE_APPEND );

        /*******************Ϣʼ***************************/
        $housekind = $this->input->post('housekind', true);
        if (isset($housekind) && $housekind != '')
        {
            //ҵ λ
            //ҵ ҵʹ
            $fields_values['housekind'] = $housekind;
        }
        //ҵ
        $tradeclass = $this->input->post('tradeclass', true);
        if (isset($tradeclass) && $tradeclass != '')
        {
            $fields_values['tradeclass'] = $tradeclass;
        }
        //ҵ
        $fee = $this->input->post('fee', true);
        if (isset($fee) && $fee != '')
        {
            $fields_values['strata_fee'] = $fee;
        }
        //豸
        $equipment = $this->input->post('equipment', true);
        if ($equipment)
        {
            $fields_values['equipment'] = implode(",", $equipment);
        }
        $fields_values['ownid'] = trim($this->input->post('ownid', true));
        /*******************Ϣ***************************/
        
        /*******************ϸϢʼ***************************/
        $fields_values['address'] = htmlspecialchars(csubstr(trim(
                filterSpace($this->input->post('address', true))),60));
        $fields_values['remark'] = $this->input->post('remark');
       /*******************ϸϢ***************************/
        //뷿ԴϢطԴ
        $house_id = $this->rent_model->insert($fields_values);
        if ($house_id)
        {
            //Դͼ
            $pic1 = $this->input->post('pic1', true);
            if($pic1 == '')
            {
                $pic1 = '';
            }
            else
            {
                $pic1 = preg_match("#\?#", $pic1) ? substr($pic1, 0, strpos($pic1, '?')) : $pic1;
            }
            //ġԴͼƬ
            $this->load->model('admin_check');
            $pics = array();
            $pfile_name = $this->input->post('p_filename', true);
            if (isset($pfile_name) && $pfile_name != '') 
            {
                $pics = array(
                    'p_filename' => $pfile_name,
                    'p_sort' => $this->input->post('p_sort', true),
                    'p_title' => $this->input->post('p_title', true),
                    'infotype' => $fields_values['infotype']
                );
                $pic_check = $this->rent_model->insert_house_pic($pics,
                $tbl, $house_id, $pic1, $blockid);
                $pic_check_arr = $pic_check['pic_check'];
                //·ͼ
                $this->rent_model->update(array('pic1' => $pic_check['indexpic']), $house_id);
                //ͼƬ
                /***
                if(isset($pic_check_arr) && is_array($pic_check_arr) 
                        && !empty($pic_check_arr) && $uid > 0)
                {
                    foreach($pic_check_arr as $key => $val)
                    {
                        $infotype = $fields_values['infotype'];
                        $fitment = $fields_values['fitment'];
                        $pic_check_arr[$key]['uid'] = $uid;
                        $pic_check_arr[$key]['housetbl'] = $tbl;
                        $pic_check_arr[$key]['houseid'] = $house_id;
                        $pic_check_arr[$key]['fitment'] = $fitment == "װ" ? 2 : ($fitment == "ë" ? 3 : 1);
                        $pic_check_arr[$key]['infotype'] = $infotype == 3 ? 4 : ($infotype == 4 ? 3 : $infotype);//̡д¥
                        $pic_check_arr[$key]['dateline'] = $nowtime;
                        //˸ҹJOB
                        $this->admin_check->insert_check_pic_sub($pic_check_arr[$key]);
                        //豸ͼƬֻ˿⡢˿
                        if($pic_check_arr[$key]['surface'] == 0 && $pic_check_arr[$key]['from_device'] == 1)
                        {
                            unset($pic_check_arr[$key]);
                        }
                        unset($pic_check_arr[$key]['from_device']);
                        //ͼ˱
                        if($pic_check_arr[$key]['surface'] == 1)
                        {
                            $this->admin_check->insert_check_pic($pic_check_arr[$key]);
                        }
                    }
                }***/
            }
            //˷Դ
            /***
            $remark = $fields_values['remark'];
            $check_remark = preg_replace("/[\s*\t\n\r&nbsp;]/", "", strip_tags($remark));
            if($check_remark != '')
            {
                $remark_check_arr['uid'] = $uid;
                $remark_check_arr['housetbl'] = $tbl;
                $remark_check_arr['houseid'] = $house_id;
                $remark_check_arr['blockname'] = $blockshowname;
                $remark_check_arr['remark'] = $check_remark;
                $remark_check_arr['dateline'] = $nowtime;
                $remark_check_arr['file_md5'] = md5($check_remark);
                $this->admin_check->insert_check_remark_sub($remark_check_arr);
            }***/
            /**
             * ԷɳֵĲ
             * ÿɳֵޣɳֵԴ
             */
            /***
            $startTime = strtotime(date('Y-m-d',time()));//ʱ
            $growthHouseLog = new GrowthHouseLog();
            $publishHouseNum = $growthHouseLog->findCountBy($uid, $startTime);
            $expControllPackage = new GrowthExpControllPackage();                 
            $upperLimitNum = $expControllPackage->findScoreByWayAliasPackageId(
               'dayHouseNum', $package_id);
            $upperFlag = $publishHouseNum < $upperLimitNum ? 1 : 0;**/
            $gbe  = new GrowthBrokerExp(array('id' => $uid, 'groupid' => $package_id));			
            $gewp = new GrowthExpWayPackage();
            $ghl  = new GrowthHouseLog();
            //жʣͼ жͼ
            $fields_values['id'] = $house_id;
            $this->load->model('rent_star_model');
            $this->rent_star_model->set_houseinfo($fields_values);
            //$this->sell_star_model->set_rowid($house_id);
            $is_star_house = $this->rent_star_model->check_star_standard();
            //־¼Դ״̬
            $logesta = $fields_values['esta'];
            if ($is_star_house)
            {
                $exp = $gewp->findScoreByWayAliasAndPackageId('pStarHouse', $package_id);					 
                $inExpStatus = $gbe->increase('pStarHouse','ͼԴ',$exp);
                $ghl->insertHouseGradeLog($house_id, $tbl, 2, $uid);
                $logesta = $fields_values['esta'] == 1 ? 5 : 6;
                //÷ԴΪͼ@todo
                $this->rent_star_model->set_star();
            } 
            else 
            {
                //ͨԴ
                $exp = $gewp->findScoreByWayAliasAndPackageId('pNoStarHouse', $package_id);					 
                $inExpStatus = $gbe->increase('pNoStarHouse','ǶͼԴ',$exp); 
                $ghl->insertHouseGradeLog($house_id, $tbl, 1, $uid);
            }
            $growthMessage = '';
            if($inExpStatus['status'] == 2 ){
                $growthMessage = "ĳɳֵѴֵ";
            } elseif($inExpStatus['status'] == 1){
                $growthMessage = "ɳֵ+" . $exp;
            }
            //¼ûΪ
            $this->rent_model->action_log($companycode, $uid, $tbl, $house_id, $logesta);
            if ($fields_values['esta'] == 1) {
                //ˢ·Դ
                refresh_house($uid, $tbl, $house_id);
                $this->rent_model->action_log($companycode, $uid, $tbl, $house_id, 7);
            }
            //мύӿ
            $this->load->library('statistics');

            //ŵ
            $this->load->model('agency_model');
            $relation_info = array();
            $relation_info = $this->agency_model->get_relation_by_agentcode($companycode);
            $domain = isset($relation_info['cat_id']) ? $relation_info['cat_id'] : 0;
            $parentcode = '';
            if( is_array($relation_info) && !empty($relation_info))
            {	 
                $parentcode = isset($relation_info['parentcode']) ? $relation_info['parentcode'] : '';
            }
            else
            {	
                $parentinfo = array();
                $select_array = array('parentcode');
                $this->agency_model->set_select_fields($select_array);
                $parentinfo = $this->agency_model->get_company_info_by_code($companycode);
                $parentcode = isset($parentinfo['parentcode']) ? $parentinfo['parentcode'] : '';
            }
            $this->statistics->sub_operatecount($uid,$companycode,1,$house_id,
                    '', $tbl, $domain, $parentcode);
            $page_text = "Դɹ!" . $growthMessage;
        }
        else
        {
            $page_text = "ǸԴʧ!";
        }
        $this->jump($this->rent_model->find_func_url(), $page_text, 3000);
    }
    
    /**
     * չʾԴ޸ҳ
     */
    public function modify($id, $tab = '') 
    {
        $uid = $this->user_arr['uid'];
        $package_id = $this->user_arr['package_id'];
        $tbl = $this->rent_model->get_tbl();
        //Դбҳַ
        $url_manage_module = $this->rent_model->find_func_url();
        if (!$id)
        {
            $this->jump($url_manage_module, 'Ϸ');
            return;
        }
        //޴˷Դ¼ûתбҳ
        $house_detail = $this->rent_model->find_by_uid_id($uid, $id);
        if (!$house_detail)
        {
            $this->jump($url_manage_module, 'ûзѯļ¼');
            return;
        }
        $data_page = array();
        $this->load->model('block_model');
        //ҷԴİơҷԴСַ
        $block = $this->block_model->base_info_by_id($house_detail['blockid']);
        if ($block)
        {
            $house_detail['streetname'] = $block['streetname'];
            $house_detail['blockaddress'] = $block['address'];
        }
        //ԴͼƬ
        $this->load->model('pic_model');
        //ͼ 2
        $house_detail['house_pic2'] = $this->pic_model->find_house_pic_by($tbl, $id, 2);
        //⾰ͼ 1
        $house_detail['house_pic1'] = $this->pic_model->find_house_pic_by($tbl, $id, 1);
        //ͼ 0
        $house_detail['house_pic0'] = $this->pic_model->find_house_pic_by($tbl, $id, 0);
        $data_page['house_detail'] = $house_detail;
        //Դģ
        $this->load->model('house_template_model');
        $data_page['url_template_add'] = $this->house_template_model->
                 find_func_url('add') . $this->_house_template_module . '/';
        //ͼͨԴӳɳֵķֵ
        $gcep = new GrowthExpWayPackage();
        $starScore = $gcep->findScoreByWayAliasAndPackageId('pStarHouse', $package_id);
        $noStarScore = $gcep->findScoreByWayAliasAndPackageId('pNoStarHouse', $package_id);
        $data_page['star_score'] = $starScore;
        $data_page['no_star_score'] = $noStarScore;
        //췢öٳɳֵ
        $growthExpDayCount = new GrowthExpDayCount();
        $publishEventArray = array('pQualityHouse','pStarHouse','pNoStarHouse');
        $exp_rank_day = $growthExpDayCount->getExpAndRank($uid, $publishEventArray);
        $data_page['growthDaySum'] = $exp_rank_day['exp'];
        //ǰõΰٷֱ
        $data_page['rankRate'] = $exp_rank_day['rate'];
        
        //ķԴ
        $data_page['allow_publish_infotype'] = $this->rent_model->
                get_public_infotype_permission($package_id);
        //ĵ
        $data_page['documentation'] = $this->config->item('documentation');
        $data_page['method'] = 'modify';
        $data_page['url_house_submit'] = $this->rent_model->find_func_url('update');
        $data_page['tab'] = $tab;
        $data_page['page_title'] = 'Դ-޸ĳ';
		$data_page['google_analytics'] = get_ga_js_code('/Դ/޸ĳ/');
        //Ⱦҳ
        $this->render_publish($data_page);
    }
    
    /**
     * ޸ķԴ model
     */
    public function update()
    {
        //һȡUID
		$this->load->model('broker_model');
		$session_info = $this->broker_model->get_user_session();
        $uid = $this->user_arr['uid'];
        $tbl = $this->rent_model->get_tbl();
        $package_id = $this->user_arr['package_id'];    //ײ
        $house_id = $this->input->post('id', true);
        //ѯԴû޸֮ǰϢ
        $this->rent_model->set_select_fields(array('isstar', 'esta'));
        $before_info = $this->rent_model->find_by_id($house_id);
        //᷿Դ޸
        if ($before_info['esta'] == 5) 
        {
            echo "<script>alert('᷿Դ޸!');history.go(-1);</script>";
            return;
        }
        //·ԴϢ
        $this->load->helper('common_string_helper');
        //Դ
        $fields_values = array();
        /*******************Ϣʼ***************************/
        $fields_values['infotype'] = intval($this->input->post('infotype', true));
        /***
        $fields_values['district'] = str_replace('"','',$district);
        $fields_values['streetid'] = $streetid;
        $fields_values['blockid'] = $blockid;
        $fields_values['blockshowname'] = csubstr($this->input->post('blockshowname'), 20);***/
        $fields_values['price'] = $this->input->post('price', true);
        $fields_values['priceunit'] = $this->input->post('priceunit', true);
        $fields_values['priceterm'] = $this->input->post('priceterm', true);
        $fields_values['pricetype'] = $this->input->post('pricetype', true);
        $fields_values['buildarea'] = $this->input->post('buildarea', true);
        $fields_values['renttype'] = $this->input->post('renttype', true);
        if ($fields_values['renttype'] == '')
        {
            $fields_values['rentremark'] = $this->input->post('rentremark', true);
            $fields_values['rentroom'] = $this->input->post('rentroom', true);
        } 
        //ֻҵ סլ  ҡȲ
        if ($fields_values['infotype'] == 1 || $fields_values['infotype'] == 2) 
        {
            $fields_values['room'] = $this->input->post('room', true);
            $fields_values['hall'] = $this->input->post('hall', true);
            $fields_values['toilet'] = $this->input->post('toilet', true);
            $fields_values['kitchen'] = $this->input->post('kitchen', true);
            $fields_values['balcony'] = $this->input->post('balcony', true);
        }       
        else
        {
            //ǿΪ0
            $fields_values['room'] = '';
            $fields_values['hall'] = '';
            $fields_values['toilet'] = '';
            $fields_values['kitchen'] = '';
            $fields_values['balcony'] = '';
        }
        //ҵΪ⳵λû¥
        if ($fields_values['infotype'] == 6)
        {
            $fields_values['subfloor'] = '';
            $fields_values['floor'] = '';
            $fields_values['totalfloor'] = '';
            $fields_values['fitment'] = '';
            $fields_values['forward'] = '';
        }
        else
        {
            //¥ж
            $lctype = $this->input->post('lctype', true);
            if ($lctype == 1) //
            { 
                $floor = $this->input->post('floor', true);
                $totalfloor = $this->input->post('totalfloor', true);
                if ($floor > $totalfloor) 
                {
                    //תҳ
                    echo "<script>alert('¥㲻Сڵǰ¥!');history.go(-1);</script>";
                    return;
                }
                $fields_values['subfloor'] = 0;
                $fields_values['floor'] = $floor;
                $fields_values['totalfloor'] = $totalfloor;
            }   
            if ($lctype == 2) //Ծ
            { 
                $subfloor = $this->input->post('subfloor', true);
                $floor2 = $this->input->post('floor2', true);
                $totalfloor2 = $this->input->post('totalfloor2', true);
                if ($subfloor > $totalfloor2 || $floor2 > $totalfloor2) 
                {
                    echo "<script>alert('¥㲻Сڵǰ¥!');history.go(-1);</script>";
                    return;
                }
                $fields_values['subfloor'] = $subfloor;
                $fields_values['floor'] = $floor2;
                $fields_values['totalfloor'] = $totalfloor2;
            }
            $fields_values['fitment'] = $this->input->post('fitment', true);
            $fields_values['forward'] = $this->input->post('forward', true);
        }
        $fields_values['mright'] = $this->input->post('mright', true);
        $fields_values['buildyear'] = $this->input->post('buildyear', true);
        $fields_values['contactor'] = $this->user_arr['truename'];
        $fields_values['telno'] = $session_info['telno'];
        $fields_values['ip'] = get_ip();
        /*******************Ϣ***************************/
        
        //ʱ¼־
		$msg = date('y-m-d H:i:s')."::".print_r($_POST,true)." \n";
		$log = './applications/zsb/logs/rentupdate'."_".date('y-m-d');
		file_put_contents($log,$msg,FILE_APPEND );


        /*******************Ϣʼ***************************/
        $housekind = $this->input->post('housekind', true);
        if (isset($housekind) && $housekind != '')
        {
            //ҵ λ
            //ҵ ҵʹ
            $fields_values['housekind'] = $housekind;
        }
        //ҵ
        $tradeclass = $this->input->post('tradeclass', true);
        if (isset($tradeclass) && $tradeclass != '')
        {
            $fields_values['tradeclass'] = $tradeclass;
        }
        //ҵ
        $fee = $this->input->post('fee', true);
        if (isset($fee) && $fee != '')
        {
            $fields_values['strata_fee'] = $fee;
        }
        //豸
        $equipment = $this->input->post('equipment', true);
        if ($equipment)
        {
            $fields_values['equipment'] = implode(",", $equipment);
        }
        $fields_values['ownid'] = trim($this->input->post('ownid', true));
        /*******************Ϣ***************************/
        
        /*******************ϸϢʼ***************************/
        $fields_values['address'] = htmlspecialchars(csubstr(trim(
                filterSpace($this->input->post('address', true))),60));
        $fields_values['remark'] = $this->input->post('remark');
        //Դͼ
        $pic1 = $this->input->post('pic1', true);
        if($pic1 == '')
        {
            $pic1 = '';
        }
        else
        {
            $pic1 = preg_match("#\?#", $pic1) ? substr($pic1, 0, strpos($pic1, '?')) 
                    : $pic1;
        }
        //ġԴͼƬ
        $pics = array();
        $pfile_name = $this->input->post('p_filename', true);
        if (isset($pfile_name) && $pfile_name != '') 
        {
            $pics = array(
                'p_filename' => $pfile_name,
                'p_sort' => $this->input->post('p_sort', true),
                'p_title' => $this->input->post('p_title', true),
                'infotype' => $fields_values['infotype']
            );
            $pic_check = $this->rent_model->insert_house_pic($pics,
                    $tbl, $house_id, $pic1, $this->input->post('block_id', true), 1);
            $pic_check_arr = $pic_check['pic_check'];
            //·ͼ
            $fields_values['pic1'] = $pic_check['indexpic'];
        }
        //update rent set esta = 5 where id in(33899521, 37700775) and uid = 10000040;
        $affected_rows = $this->rent_model->update($fields_values, $house_id, $uid);
        if ($affected_rows > 0)
        {
            /***
            $this->load->model('admin_check');
            $delpic = $this->input->post('delpic', true);
            //ɾͼƬ˿ɾ
            if($delpic != '')
            {
                $delpicarr = explode(",", $delpic);
                if(is_array($delpicarr) && !empty($delpicarr))
                {
                    foreach($delpicarr as $val)
                    {
                        $val = intval($val);
                        if($val)
                        {
                            //òƲ̫жĸ⣬һɾ
                            $this->admin_check->delete_check_pic($tbl, $house_id, $val);
                            $this->admin_check->delete_check_pic_sub($tbl, $house_id, $val);
                        }
                    }
                }
            }***/
            $nowtime = time();
            //ͼƬ
            /***
            if(isset($pic_check_arr) && is_array($pic_check_arr) 
                    && !empty($pic_check_arr) && $uid > 0)
            {
                $this->load->model('admin_check');
                foreach($pic_check_arr as $key => $val)
                {
                    $infotype = $fields_values['infotype'];
                    $fitment = $fields_values['fitment'];
                    $pic_check_arr[$key]['uid'] = $uid;
                    $pic_check_arr[$key]['housetbl'] = $tbl;
                    $pic_check_arr[$key]['houseid'] = $house_id;
                    $pic_check_arr[$key]['fitment'] = $fitment == "װ" ? 2 : ($fitment == "ë" ? 3 : 1);
                    $pic_check_arr[$key]['infotype'] = $infotype == 3 ? 4 : ($infotype == 4 ? 3 : $infotype);//̡д¥
                    $pic_check_arr[$key]['dateline'] = $nowtime;
                    //˸ҹJOB
                    $this->admin_check->insert_check_pic_sub($pic_check_arr[$key]);
                    //豸ͼƬֻ˿⡢˿
                    if($pic_check_arr[$key]['surface'] == 0 && $pic_check_arr[$key]['from_device'] == 1)
                    {
                        unset($pic_check_arr[$key]);
                    }
                    unset($pic_check_arr[$key]['from_device']);
                    //ͼ˱
                    if($pic_check_arr[$key]['surface'] == 1)
                    {
                        $this->admin_check->insert_check_pic($pic_check_arr[$key]);
                    }
                }
            }***/
            //жʣͼ жͼ
            $this->load->model('rent_star_model');
            $fields_values['id'] = $house_id;
            $fields_values['uid'] =  $this->user_arr['uid'];
            $this->rent_star_model->set_houseinfo($fields_values);
            $is_star_house = $this->rent_star_model->check_star_standard();
            $growthMessage = '';
            if ($is_star_house)
            {
                if ($before_info['isstar'] != 3) {
                    //Դǩļ
                    $gradeLog = $before_info['isstar'] == 3 ? 2 : 1;
                    $ghl  = new GrowthHouseLog();
                    $houseGradeLog = $ghl->findHouseGradeLog($house_id, $tbl, $gradeLog, $uid);
                    if ($houseGradeLog['grade'] == 1 && $before_info['isstar'] != 3) 
                    {
                        $gbe  = new GrowthBrokerExp(array('id' => $uid, 'groupid' => $package_id));			
                        $gewp = new GrowthExpWayPackage();
                        $exp = $gewp->findScoreByWayAliasAndPackageId('pStarHouse', $package_id);					 
                        $inExpStatus = $gbe->increase('pStarHouse','ͼԴ',$exp);
                        $ghl->updateHouseGradeLog($house_id, $tbl, 2, $uid);
                        if($inExpStatus['status'] == 2 ){
                            $growthMessage = "ĳɳֵѴֵ";
                        } elseif($inExpStatus['status'] == 1){
                            $growthMessage = "ɳֵ+" . $exp;
                        }
                    }
                    //жԭǷΪͼ
                    if ($before_info['isstar'] != 3)
                    {
                        $this->rent_star_model->set_star();
                    }
                }
            } 
            else 
            {
                //÷ԴΪͼ
                $this->rent_star_model->remove_star();
                $this->load->model('rent_tag_model');
                $this->rent_tag_model->set_houseinfo($fields_values);
                //2011-11-30 ͬñǩʧЧ
				$this->rent_tag_model->remove_tag();
            }
            $page_text = 'Դ޸ĳɹ!' . $growthMessage;
        }
        else 
        {
            $page_text = 'Ǹ޸ķԴϢʧ!';
        }
        $this->jump($this->rent_model->find_func_url(), $page_text, 3000);
    }

    /**
     * ɾԴķԴ״̬Ϊɾupdate
     */
    public function delete()
    {
        //delete from  rent where id = 33899521 and uid = 10000040;
        $this->rent_model->delete(33899521, 10000040);
    }
    
    
    /**
     * Դбҳ
     *
     * @access public
     * @param  string $esta Դ״ַ̬
	 * @param  int $page תҳ(תʹ)
     * @return void
     */
    public function manage( $house_esta = 'active' , $page = 1)
    {   
        //post
        $post_param = $this->input->post( NULL , TRUE );
        
        /** ҳ */
        $page = isset($post_param['page']) ? intval($post_param['page']) : intval($page);
        $this->_init_pagination($page);
        
        //˺Ϣ
        $uid = $this->user_arr['uid'];  //˺
        $package_id = $this->user_arr['package_id'];    //ײ

        /*** Ϣ ****/
        $broker_info = array();
        $this->load->model('broker_model');
        $this->broker_model->set_uid($uid);
        $broker_info = $this->user_arr;
        
        //Դ
        $house = $this->config->item('house');
        $house['roomcategory'] = array('1' => 'Ƕͼ' , '2' => 'ͼ', '3' => '');

        //طԴ
        $this->load->model('rent_model');
        $esta_arr = array(); //Դ״̬
        $esta_arr = $this->rent_model->get_house_esta();
        /* 'active' => 1 , 'invalid' => 2 , 'delete' => 4 , 'frozen' => 5 */
        $esta = ( isset($house_esta) && isset($esta_arr[$house_esta]) && $house_esta != 'delete' ) ? 
                $esta_arr[$house_esta] : 1 ;
        
        //ѯԴ
        $cond_where = "uid = '".$uid."' AND esta = $esta  AND infofrom = '5' ";
        //ύɵĲѯ
        $cond_where_ext = $this->_get_cond_str($post_param);
        $cond_where .= $cond_where_ext;
        //ֶ
        $roomorder = isset($post_param['roomorder']) ? $post_param['roomorder'] : array();
        $order_arr = $this->_get_orderby_arr($roomorder);

        //
        $this->_total_count = $this->rent_model->find_count_by($cond_where);

        //ҳ
        $pages  = $this->_total_count > 0 ? ceil( $this->_total_count / $this->_limit ) : 0;
        
        //ȡԴ
        $data_info = array ();
        if($this->_total_count > 0 )
        {
            $select_fields = array ('id','ownid','infotype','infofrom','agentcode','uid','esta','district','address',
			'streetid','blockid','isreal','blockshowname','buildyear','buildarea',
			'subfloor','floor','totalfloor','room','hall','toilet','kitchen','balcony',
			'forward','price','priceunit','priceterm','pricetype','fitment','contactor',
			'telno','creattime','updatetime','expiretime','ischarge','istop','isstar','renttype','istag');
            $this->rent_model->set_select_fields($select_fields);
            $data_info = $this->rent_model->find_all_by( $cond_where , $this->_offset ,
                $this->_limit , $order_arr['order_key'] , $order_arr['order_by'] );
        }
        $row_num =  count($data_info);
        
        //·ֱ
        $this->load->model('sell_nofee_model');
        //
        //$this->load->model('rent_reduce_model');
        //ԤԼ
        $reserve_info = array();
        if( $row_num > 0 )
        {   
            //ظ
            $this->load->helper('common_url');
            $this->load->helper('common_house');
			$this->load->helper('common_string');
            
            //
            $yesterday = date( 'Ymd' , time() - 86400 );
            
            //ʵͳ(ԭмṩͳ)
            $this->load->library( 'statistics');
            
            //ضͼ
            $this->load->model('rent_star_model');
            
            if( $house_esta == 'active')
            {   
                //ˢ־
                $this->load->model('log_refresh');
            
                //ؼ
                $this->load->model('rent_tag_model');

                //ԤԼģ
                $this->load->model('reserve_model');
                $this->reserve_model->set_uid($uid);
                
                //Ͷ
                $growthBidPeriods = new GrowthBidPeriods();

                //Сר
                $periodsBlockExpert = $growthBidPeriods->currentBidPeriods(1);

                //ȡһСרҵȼ
                $bidBlockExpertPeriodsId = $periodsBlockExpert['id'];
                $growthBidBlockExpert = new GrowthBidBlockExpert();
            }

			if($house_esta == 'active' || $house_esta == 'invalid')
			{
				//ҷС
				$block_fields = array('blockid','blockshowname');
				$this->rent_model->set_select_fields($block_fields);
				$publish_block = $this->rent_model->find_publish_block($uid , $house_esta);
			}
            
             //᷿Դ
            if( $house_esta == 'frozen')
            {
                $this->load->model('rent_freeze_model');
                $house['freeze_esta'] = $this->rent_freeze_model->get_freeze_esta();
            }
            
            //ԴϢ
            $house_info = array();
            for( $i = 0 ; $i < $row_num ; $i ++ )
            {   
                //Դַ
                $data_info[$i]['info_url'] =  get_rentinfo_url($data_info[$i]['id']);

				//ԴСַ
				$data_info[$i]['block_url'] =  get_blockinfo_url($data_info[$i]['blockid']);

				//Դַ
				$data_info[$i]['address_str'] =  csubstr($data_info[$i]['address'],60);

				//
				$data_info[$i]['buildarea'] =  strip_end_0($data_info[$i]['buildarea']);

				//۸
				$data_info[$i]['price'] =  strip_end_0($data_info[$i]['price']);

				//¥
				if(empty($data_info[$i]['subfloor']))
				{
					$data_info[$i]['floor_str'] = $data_info[$i]['floor'].'/'.$data_info[$i]['totalfloor']; 
				}
				else
				{
					$data_info[$i]['floor_str'] = $data_info[$i]['subfloor'].'-'.$data_info[$i]['floor'].'/'.$data_info[$i]['totalfloor'];
				}
                
                //Դ޸ĵַ
                $data_info[$i]['modify_url'] =  $this->rent_model->get_modify_house_url($data_info[$i]['id']);
                
                //ǷΪͼԴ
                $this->rent_star_model->set_houseinfo($data_info[$i]);
                $data_info[$i]['is_star_result'] = $this->rent_star_model->is_star();
                
                //Դҳ
                if( $house_esta == 'active')
                {
                    //ǷΪƷԴ
                    $this->rent_tag_model->set_houseinfo($data_info[$i]);
                    $data_info[$i]['is_tag_result'] = $this->rent_tag_model->is_tag();
                    //Ʊ׼
                    if($data_info[$i]['is_tag_result'] === FALSE)
                    {
                        $data_info[$i]['tag_standard'] = $this->rent_tag_model->check_tag_standard();
						$data_info[$i]['house_tag_info'] = array();
						$data_info[$i]['tag_exipire_days'] = '';
                    }
					else
					{
						//Ʊǩʣ
						$data_info[$i]['house_tag_info'] = $this->rent_tag_model->get_tag_record() ;
						if(isset($data_info[$i]['house_tag_info']) && !empty($data_info[$i]['house_tag_info']))
						{
							$data_info[$i]['tag_exipire_days'] = 
								$this->rent_tag_model->tag_exipire_days($data_info[$i]['house_tag_info']['expiretime']);
						}
					}

                    //ԤԼ
                    $data_info[$i]['reserve_info'] = $this->reserve_model->get_project_by_tblrowid('rent',$data_info[$i]['id']);

                    //Сרҵȼ
                    /*$memkey = "nj_block_heat_" . $bidBlockExpertPeriodsId . '_' . $data_info[$i]['blockid'];
                    $cache = $this->mc->get($memkey);
                    $blockLevelInfo = array();
                    if ($cache['isok'] == 1 ) 
                    {
                        $blockLevel = $cache['data'];
                    } 
                    else 
                    {
                        $conf = "bid_periods_id = $bidBlockExpertPeriodsId AND block_id=".$data_info[$i]['blockid'];
                        $blockLevelInfo = $growthBidBlockExpert->findOneBy($conf);
                        $blockLevel = isset($blockLevelInfo['broker_level']) ? 
                                $blockLevelInfo['broker_level'] : '';
                       $this->mc->add($memkey, array('isok'=>1,'data'=>$blockLevel),  3600);
                    }
                    if (isset($blockLevel) && $blockLevel != '') 
                    {   
                        $bidBlockLevels = rtrim(str_replace('LV', '', $blockLevel), ',');
                        $minBidBlockLevel = min(explode(',', $bidBlockLevels));
                        $data_info[$i]['block_level'] = $minBidBlockLevel;
                    }
                    else 
                    {
                        $data_info[$i]['block_level'] = '';
                    }*/
                    
                    //ˢ´
                    $data_info[$i]['refresh_num'] = 
                    $this->log_refresh->refresh_num_by_id( $data_info[$i]['id'] , 'rent' , $data_info[$i]['updatetime']);
                } 
                
                //
                $data_info[$i]['exipire_days'] = to_expire_day_new($data_info[$i]['expiretime']);
                
                //յ
                //$data_info[$i]['click_num_y'] = 
                   // $this->statistics->get_fidclickcount( $yesterday , $data_info[$i]['id'] , 'rent');
				//$data_info[$i]['click_num_y'] =0;//xue



				$fid_click_count_key = "nj_statistics_get_fidclickcount_new".$yesterday."_rent_".$data_info[$i]['id'];
				
				$fid_click_count = $this->mc->get($fid_click_count_key);
			
				
				if($fid_click_count === false) {
				   $click_id_arr[$i] = $data_info[$i]['id'];
				   $house_key[$data_info[$i]['id']] = $i;
				   //echo "12312";exit();
					
				}else{
				   $data_info[$i]['click_num_y'] = $fid_click_count;
				}
                
                if( $house_esta == 'frozen')
                {
                    //Ϣ
                    $this->rent_freeze_model->set_select_fields(array('id','esta','rowid','reason','freezetime'));
                    $data_info[$i]['freeze_info'] = $this->rent_freeze_model->get_freeze_by_rowid($data_info[$i]['id']);
                }
                
                $arr_rowid[] = $data_info[$i]['id'];
            }
            
            //ѯԴԤԼ
            if( $house_esta == 'active')
            {
                $reserve_info = $this->reserve_model->get_project_by_rowids('rent' , $arr_rowid);
            }
        }


		//ȡԴյ
		if(is_array($click_id_arr)&&!empty($click_id_arr)){

			foreach($click_id_arr as $key=>$value){
				$fids .= $value.",";
			}
			$fids = rtrim($fids,",");			
			$click_data_str = $this->statistics->getfidsclickcountnew( $yesterday , $fids , 'rent');
			$click_data_str = rtrim($click_data_str,'}');
			$click_data_str = ltrim($click_data_str,'{');
			$click_data_arr = explode(",",$click_data_str);
			
			foreach($click_data_arr as $value){
				$house_click = explode("=",$value);
                $click_house_id= trim($house_click[0]);
				$click_house_num= trim($house_click[1]);
				//Դݵı
                $iid = $house_key[$click_house_id];				
				$data_info[$iid]['click_num_y'] = $click_house_num;
				$fid_click_count_key = "nj_statistics_get_fidclickcount_new".$yesterday."_rent_".$click_house_id;
				//echo $fid_click_count_key;echo "<br/>";
			    $this->mc->set($fid_click_count_key,$click_house_num,6000);	
			}

		}
        
        //Ƿʾҳ
        $pagination = NULL;
        if( $this->_total_count > $this->_limit)
        {
            $pagination = helper_pagination( $this->_current_page , $pages , $this->_total_count );
        }
        
        /*** ˽ʹͳ ***/
        $statistic_data = array();
        $this->load->model('statistics_model' ,'stat');
        $this->load->model('broker_package_model','broker_package');
        
        //ײͷԴ
        $post_limit = intval($this->user_arr['postlimit']);
        //
        $statistic_data['sell_count'] = $this->stat->sellCount($uid);
        //
        $statistic_data['rent_count'] = $this->stat->rentCount($uid);
        $house_count = $statistic_data['sell_count'] + $statistic_data['rent_count'];

		 //ǰЧ
        $statistic_data['sellCountStar'] = $this->stat->sellCountStar($uid);
        $statistic_data['rentCountStar'] = $this->stat->rentCountStar($uid);

        //ʣײ
        $statistic_data['package_valid_num_limit'] = $post_limit > $house_count ? 
        $post_limit - $house_count : 0;
        $package_info = array();
        $package_info = $this->broker_package->find_by_id($package_id);
		$broker_info['package_info'] = $package_info;
        //
        $statistic_data['package_stock_num'] = $package_info['package_stock_num'];
        //ǰ淿Դ
        $statistic_data['stock_house_num'] = $this->broker_model->stock_house_num();
        //ʣ
        $statistic_data['package_stock_num_limit'] = 
                $statistic_data['package_stock_num'] >=  $statistic_data['stock_house_num']?
        $statistic_data['package_stock_num'] - $statistic_data['stock_house_num'] : 0;

		//ˢ
        $statistic_data['refresh_limit'] = $this->stat->refreshNumber($package_id);
        $statistic_data['refresh_today'] = $this->stat->refreshNumberToday($uid);
        
        //ԤԼδִи
        $this->load->model('reserve_model');
        $statistic_data['refresh_not_do'] = $this->reserve_model->get_reserve_remain_num();
        if ($statistic_data['refresh_not_do'] >= $statistic_data['refresh_limit']) 
        {
            $statistic_data['refresh_not_do'] = $statistic_data['refresh_limit'] - $statistic_data['refresh_today'];
        }
        //˴߼ΪԤԼδִִ֮͵ˢ
        $need2reserveRefreshNum = $statistic_data['refresh_limit'] - $statistic_data['refresh_today'];
        $statistic_data['refresh_not_do'] = $statistic_data['refresh_not_do'] >= $need2reserveRefreshNum ? $need2reserveRefreshNum : $statistic_data['refresh_not_do'];
        $statistic_data['refresh_remain'] = $statistic_data['refresh_limit'] - $statistic_data['refresh_today'] - $statistic_data['refresh_not_do'];
        $statistic_data['refresh_remain'] = $statistic_data['refresh_remain'] > 0 ? $statistic_data['refresh_remain'] : 0;

        //Ʊǩʹ
        if($package_info['package_tag_num'] > 0)
        {
            $statistic_data['tag_limit'] = $this->stat->jtLabelNumber($package_id);
            $statistic_data['tag_count_today'] = $this->stat->jtLabelCount($uid);
            $statistic_data['tag_remain'] = $statistic_data['tag_limit'] > $statistic_data['tag_count_today'] ? $statistic_data['tag_limit'] - $statistic_data['tag_count_today'] : 0;
        }
        else
        {
            $statistic_data['tag_limit'] = '--';
            $statistic_data['tag_count_today'] = '--';
            $statistic_data['tag_remain'] = '--';
        }

		//᷿Դ
		$cond_where_forzen = "uid = '".$uid."' AND esta = 5  AND infofrom = '5'";
		$statistic_data['forzen_house_num'] = $this->rent_model->find_count_by($cond_where_forzen);
        /*** ˽ʹͳƽ ***/
        
        //˽ˢ³ɳֵ
        $growthExpDayCount = new GrowthExpDayCount();
        $refreshEventArray = array('refreshHouse');
        $exp_rank_day = $growthExpDayCount->getExpAndRank($uid, $refreshEventArray);
        $statistic_data['growthDaySum'] = $exp_rank_day['exp'];
        //ǰõΰٷֱ
        $statistic_data['rankRate'] = $exp_rank_day['rate'];

        /** ҳʼ */
        $data['page_title'] = 'Դ-';
        $data['css'] = load_css('zsb/css/v1.0/style1.css'); //Ҫصcss
        $data['js'] = load_js('zsb/js/v1.0/js2.js,zsb/js/v1.0/cp.js');   //ҪصJS
        $data['house']  = $house;
        if (isset($publish_block) && $publish_block != '') 
        {
            $data['publish_block']  = $publish_block;
        }
        $data['post_param']  = $post_param;
        $data['data_info']  = $data_info;
        $data['broker_info']  = $broker_info;
        $data['reserve_info']  = $reserve_info;
        $data['statistic_data']  = $statistic_data;//ʹͳ
        $data['upload_pic_url'] = $this->config->item('base_url') . 'pic/common/';
        $data['documentation'] = $this->config->item('documentation');//ĵ
        $data['page']  = $this->_current_page;
        $data['pagination'] = $pagination;
        $data['total_count'] = $this->_total_count;
		switch ($house_esta){
			case 'active' :
				$ga_title = 'Դ';
				break;
			case 'invalid' :
				$ga_title = 'ʧЧԴ';
				break;
			case 'frozen' :
				$ga_title = 'Υ淿Դ';
				break;
		}
		$data['google_analytics'] = get_ga_js_code('/Դ//'.$ga_title.'/');
        //
        $this->load->library('guide');
        $data['guide_show'] = $this->guide->check_guide($uid, 'zsb_refresh');
        
        //ģ
        $template_name = $esta == 1 ? 'rent_manage' : 'rent_manage_'.$house_esta;
        $this->view( 'house_manage' , $template_name , $data);
    }
    
    
     /* бҳԴ
     * @param   string $actiontype 
     * @param   string $rowid_str Դ
     * @param   int $page ҳ
     * @param   string $referer תҳ
    */
    public function do_action()
    {   
        //
        $actiontype = $this->input->post( 'actiontype' , TRUE );
        
        //Դ
        $rowid_str = $this->input->post( 'actionid' , TRUE );
        $rowid = $this->input->post( 'rowid' , TRUE );
        
        //ǰҳ
        $page = $this->input->post( 'pg' , TRUE );
        
        //תַ
        $referer = $this->input->post( 'referer' , TRUE );
        $referer = (isset($referer) && $referer != '')  ? $referer : $_SERVER['HTTP_REFERER'];
        
        //ԴַתΪ
        $arr_id = explode( ',' , $rowid_str );
        
        //˺uid
        $uid = $this->user_arr['uid'];
        //ŵ˺
        $agentcode = $this->user_arr['agentcode'];
        
        //Դ
        $tbl = 'rent';
        
        //ַ
        switch ($actiontype) 
        {
            case 'invalid_house':
                $invalid_num = 0;
                
                //ʼԴ
                $this->load->model('rent_operate_model');
                
                /*** 1ʧЧԴ ***/
                $invalid_num = $this->rent_operate_model->invalid_house($arr_id);
                if( $invalid_num > 0 )
                {   
                    //мͳ
                    $this->load->library('statistics');
                    
                    //طԴ
                    $this->load->model('rent_tag_model');
                    
                    //Real
                    //$this->load->model('rent_reduce_model');
                    
                    //ŵ
                    $this->load->model('agency_model');
                    $relation_info = array();
                    $relation_info = $this->agency_model->get_relation_by_agentcode($agentcode);
                    $domain = isset($relation_info['cat_id']) ? $relation_info['cat_id'] : 0;
                    if( is_array($relation_info) && !empty($relation_info))
                    {	 
                        $parentcode = isset($relation_info['parentcode']) ? $relation_info['parentcode'] : '';
                    }
                    else
                    {	
                        $parentinfo = array();
                        $select_array = array('parentcode');
                        $this->agency_model->set_select_fields($select_array);
                        $parentinfo = $this->agency_model->get_company_info_by_code($agentcode);
                        $parentcode = isset($parentinfo['parentcode']) ? $parentinfo['parentcode'] : '';
                    }
                    
                    foreach( $arr_id as $rowid )
                    {   
                        /*** 2ʧЧǩReal ****/
                        $house_info = array('id'=> $rowid);
                        $this->rent_tag_model->set_houseinfo($house_info);
                        $this->rent_tag_model->remove_tag();
                        //$this->rent_reduce_model->set_houseinfo($house_info);
                        //$this->rent_reduce_model->remove_reduce();
                        
                        /*** 3ȡԤԼˢ ***/
                        $this->load->model('reserve_model');
                        $result = $this->reserve_model->delete_projecthouse($uid , $tbl , $rowid);
                        
                        /*** 4ͨӿύ־мoperatetype 1: 2ˢ 3ɾ 4ʧЧ 5ٷ ***/
                        $msg = 4;
                        $this->statistics->sub_operatecount( $uid , $agentcode , $msg , $rowid , '' , $tbl , $domain , $parentcode );
                        
                        /*** 5ύԴ־MYSQL(־ѯ),[$msg:4-ʧЧԴ] ***/
                        $this->rent_model->action_log( $agentcode , $uid , $tbl , $rowid , $msg);
                    }
                    
                    $page_text = 'ɹʧЧ'.$invalid_num.'Դ';
                }
                else
                {
                    $page_text = 'ʧЧԴʧ';
                }
                break;
            case 'multi_delete_house':
                $delete_num = 0;
                
                //ʼԴ
                $this->load->model('rent_operate_model');
                
                /*** 1ɾԴ ***/
                $delete_num = $this->rent_operate_model->delete_house($arr_id);
                if( $delete_num > 0 )
                {   
                    //мͳ
                    $this->load->library('statistics');
                    
                    //ŵ
                    $this->load->model('agency_model');
                    $relation_info = array();
                    $relation_info = $this->agency_model->get_relation_by_agentcode($agentcode);
                    $domain = isset($relation_info['cat_id']) ? $relation_info['cat_id'] : 0;
                    if( is_array($relation_info) && !empty($relation_info))
                    {	 
                        $parentcode = isset($relation_info['parentcode']) ? $relation_info['parentcode'] : '';
                    }
                    else
                    {	
                        $parentinfo = array();
                        $select_array = array('parentcode');
                        $this->agency_model->set_select_fields($select_array);
                        $parentinfo = $this->agency_model->get_company_info_by_code($agentcode);
                        $parentcode = isset($parentinfo['parentcode']) ? $parentinfo['parentcode'] : '';
                    }
                    
                    foreach( $arr_id as $rowid )
                    {   
                        $tbl = 'sell';
                        /*** 4ͨӿύ־мoperatetype 1: 2ˢ 3ɾ 4ʧЧ 5ٷ ***/
                        $this->statistics->sub_operatecount( $uid , $agentcode , 3 , $rowid , '' , $tbl , $domain , $parentcode );
                        
                        /*** 5ύԴ־MYSQL(־ѯ),[$msg:4-ʧЧԴ] ***/
                        $this->rent_model->action_log( $agentcode , $uid , $tbl , $rowid , 0);
                    }
                    $page_text = 'ɹɾ'.$delete_num.'Դ';
                }
                else
                {
                    $page_text = 'ɾ˷Դʧܡ';
                }
                break;    
            case 'refresh':
                if(is_array($arr_id) && !empty($arr_id) )
                {
                    $errornum = 0;
                    
                    //ˢºļ
                    $this->load->helper('common_house');
                    
                    //ײID
                    $package_id = $this->user_arr['package_id'];
                    
                    //ˢ
                    $package_info = array();
                    $this->load->model('package_base_model');
                    $this->package_base_model->set_select_fields(array('package_refresh_num'));
					$package_info = $this->package_base_model->find_by_id($package_id);
                    $refresh_limit =  intval($package_info['package_refresh_num']);
                    //ˢ
                    $this->load->model("log_refresh");
                    $refreshnum = $this->log_refresh->findTodayNumberByBrokerId($uid);
                    
                    foreach( $arr_id as $key => $value )
                    {
                        $cb = refresh_house( $uid ,$tbl , $value);
                        
                        if( trim($cb) == 'error')
                        {
                            $errornum ++ ;
                            unset( $arr_id[$key] );
                        }
                        else
                        {   
                            $msg = 7;/*** ύԴ־MYSQL(־ѯ),[$msg:7-ˢ·Դ] ***/
                            $this->rent_model->action_log( $agentcode , $uid , $tbl , $value , $msg);
                        }
                    }
                    
                    $errornum = intval($errornum);
                    $sum = count($arr_id);
                    
                    //˳ɳϵ
                    if( $sum > 0 )
                    {   
                        $arrBroker = array(
                            'id' => $uid,
                            'groupid' => $package_id,
                        );
                        
						//ɳֵ
                        $gbe  = new GrowthBrokerExp($arrBroker);		
                        $gewp = new GrowthExpWayPackage();
						$exp = 0;	
                        $exp = $gewp->findScoreByWayAliasAndPackageId('refreshHouse',$package_id);

                        if( $sum > 1)
                        {
                            $log_tip = 'ˢ·Դ';
                            $exp = $exp * $sum;
                        }
                        else
                        {
                            $log_tip = 'ˢµԴ';
                        }
                        $inExpStatus = $gbe->increase('refreshHouse' , $log_tip ,$exp);
                        
                        if($inExpStatus['status'] == 2)
                        {
                            $growthMessage = "<div style='text-align:center;margin:0px 10px;'>"
                                    . "ĳɳֵѴֵ</div>";
                        }
                        else if($inExpStatus['status'] == 1)
                        {
                            $growthMessage = "<div style='text-align:center;margin:0px 10px;'>"
                                    . "ɳֵ+".$exp."</div>";
                        }
                        
                        //ˢ[ãɾ add xz]
                        $this->load->model('log_refresh');
                        $this->log_refresh->findTodayNumberByBrokerId( $uid , 1);
                    }
                    
                    //ʣˢ
                    $refresh_left = 0;
                    $refresh_left = intval($refresh_limit) - intval($refreshnum) - intval($sum) ;
                    if( $sum > 0 && $errornum == 0) 
                    {   
                        $page_text = 'ɹˢ'.$sum.'Դ';
                        $page_text .= "ʣˢ".$refresh_left."Ρ";
                        $page_text .= $growthMessage;
                    }
                    else if($sum > 0 && $errornum > 0)
                    {
                        $page_text = 'ɹˢ'.$sum.'Դ';
                        $page_text .= "ʣˢ".$refresh_left."Ρ";
                        $page_text .= $growthMessage;
                    }
                    else if ($sum == 0 && $errornum > 0 && $refresh_left > 0) 
                    {
                        $page_text = "ԲѡķԴˢ´Ѿﵽޡ";
                    }
                    else if($sum == 0 && $errornum > 0)
                    {
                        $page_text = 'Բˢ³';
                    }
                    else
                    {
                        $page_text = 'ˢʧ';
                    }
                }
                break;
        }
        
       $this->jump( $referer , $page_text , 1000);
    }
    
    
    /**
     * üƷԴ
     */
    public function house_tag_set()
    {   
        //Դ
        $rowid = $this->input->get( 'rowid' , TRUE );
        $secret_key = $this->input->get( 'secret_key' , TRUE );
        $result = array();
        
        //֤Դźύ֤
        if( intval($rowid) > 0 && md5('HOUSE365_TAG_SET_'.$rowid) == $secret_key )
        {
            //˺uid
            $uid = $this->user_arr['uid'];

            //ʼԴ
            $this->load->model('rent_model');
            $houseinfo = array();
            $houseinfo = $this->rent_model->find_by_id($rowid);
            
            if( is_array( $houseinfo ) && !empty($houseinfo)    )
            {
                //طԴ
                $this->load->model('rent_tag_model');
                $this->rent_tag_model->set_houseinfo($houseinfo);

                //˷ԴǷüƷԴı׼
                $result = $this->rent_tag_model->check_tag_standard();

                if( isset($result) && $result['is_ok'] == 1 )
                {
                    $set_result = $this->rent_tag_model->set_tag();
                    
                    if($set_result)
                    {
                        $result['is_ok'] = 1;
                        $result['msg'] = 'ǩóɹ';
                        
                        //ñǩ
                        $this->load->model('statistics_model');
                        $this->statistics_model->jtLabelCount( $uid , 1);
                    }
                    else
                    {
                        $result['is_ok'] = 0;
                        $result['msg'] = 'ǩʧ';
                    }
                }
            }
            else
            {
                $result['is_ok'] = 0;
                $result['msg'] = 'ԴϢ';  
            }
        }
        else
        {
            $result['is_ok'] = 0;
            $result['msg'] = ''; 
        }

        $result['msg'] = iconv( 'gb2312' , 'utf-8',  $result['msg'] ); 
        print_r(json_encode($result));
        exit;
    }
    
    
    /**
     * üƷԴ
     */
    public function house_tag_cancel()
    {
        //Դ
        $rowid = $this->input->get( 'rowid' , TRUE );
        $secret_key = $this->input->get( 'secret_key' , TRUE );
        $result = array();
        //֤Դźύ֤
        if( intval($rowid) > 0  &&  md5('HOUSE365_TAG_SET_'.$rowid) == $secret_key )
        {
            //˺uid
            $uid = $this->user_arr['uid'];

            //ʼԴ
            $this->load->model('rent_model');
            $houseinfo = array();
            $this->rent_model->set_select_fields(array('id','uid','esta','istag'));
            $houseinfo = $this->rent_model->find_by_id($rowid);
            
            if( is_array( $houseinfo ) && !empty($houseinfo)    )
            {
                //طԴ
                $this->load->model('rent_tag_model');
                $this->rent_tag_model->set_houseinfo($houseinfo);
                $set_result = $this->rent_tag_model->remove_tag();
                
                if($set_result)
                {
                    $result['is_ok'] = 1;
                    $result['msg'] = 'ȡǩɹ';
                }
                else
                {
                    $result['is_ok'] = 0;
                    $result['msg'] = 'ȡǩʧ';
                }
            }
            else
            {
                $result['is_ok'] = 0;
                $result['msg'] = 'ԴϢ';  
            }
        }
        else
        {   
            $result['is_ok'] = 0;
            $result['msg'] = ''; 
        }

        $result['msg'] = iconv( 'gb2312' , 'utf-8',  $result['msg'] ); 
        print_r(json_encode($result));
        exit;
    }
    
    
    /**
     * ǩ
     */
    public function house_reduce_set()
    {
        //Դ
        $rowid = $this->input->get( 'rowid' , TRUE );
        $secret_key = $this->input->get( 'secret_key' , TRUE );
        
        $result = array();
        //֤Դźύ֤
        if( intval($rowid) > 0  &&  md5('HOUSE365_REDUCE_SET_'.$rowid) == $secret_key )
        {
            //˺uid
            $uid = $this->user_arr['uid'];

            //ʼԴ
            $this->load->model('rent_model');
            $houseinfo = array();
            $this->rent_model->set_select_fields(array('id','uid','esta','istag'));
            $houseinfo = $this->rent_model->find_by_id($rowid);
            
            if( is_array( $houseinfo ) && !empty($houseinfo)    )
            {
                //طԴREAL
                $this->load->model('rent_reduce_model');
                $this->rent_reduce_model->set_houseinfo($houseinfo);
                $set_result = $this->rent_reduce_model->set_reduce();
                
                if($set_result)
                {
                    $result['is_ok'] = 1;
                    $result['msg'] = 'ǩɹ';
                }
                else
                {
                    $result['is_ok'] = 0;
                    $result['msg'] = 'ǩʧ';
                }
            }
            else
            {
                $result['is_ok'] = 0;
                $result['msg'] = 'ԴϢ';  
            }
        }
        else
        {   
            $result['is_ok'] = 0;
            $result['msg'] = ''; 
        }

        $result['msg'] = iconv( 'gb2312' , 'utf-8',  $result['msg'] ); 
        print_r(json_encode($result));
        exit;
    }
    
    /**
     * ȡǩ
     */
    public function house_reduce_cancel()
    {
        //Դ
        $rowid = $this->input->get( 'rowid' , TRUE );
        $secret_key = $this->input->get( 'secret_key' , TRUE );
        
        $result = array();
        //֤Դźύ֤
        if( intval($rowid) > 0  &&  md5('HOUSE365_REDUCE_SET_'.$rowid) == $secret_key )
        {
            //˺uid
            $uid = $this->user_arr['uid'];

            //ʼԴ
            $this->load->model('rent_model');
            $houseinfo = array();
            $this->rent_model->set_select_fields(array('id','uid','esta','istag'));
            $houseinfo = $this->rent_model->find_by_id($rowid);
            
            if( is_array( $houseinfo ) && !empty($houseinfo)    )
            {
                //طԴREAL
                $this->load->model('rent_reduce_model');
                $this->rent_reduce_model->set_houseinfo($houseinfo);
                $set_result = $this->rent_reduce_model->remove_reduce();
                
                if($set_result)
                {
                    $result['is_ok'] = 1;
                    $result['msg'] = 'ȡǩɹ';
                }
                else
                {
                    $result['is_ok'] = 0;
                    $result['msg'] = 'ȡǩʧ';
                }
            }
            else
            {
                $result['is_ok'] = 0;
                $result['msg'] = 'ԴϢ';  
            }
        }
        else
        {   
            $result['is_ok'] = 0;
            $result['msg'] = ''; 
        }

        $result['msg'] = iconv( 'gb2312' , 'utf-8',  $result['msg'] ); 
        print_r(json_encode($result));
        exit;
    }
    
    
    /**
     * Դ
     */
    public function active_house()
    {
        //Դ
        $rowid = $this->input->get( 'rowid' , TRUE );
        $secret_key = $this->input->get( 'secret_key' , TRUE );
        $result = array();
        //֤Դźύ֤
        if( intval($rowid) > 0  &&  md5('HOUSE365_ACTIVE_HOUSE_'.$rowid) == $secret_key )
        {
            //˺uid
            $uid = $this->user_arr['uid'];
			$agentcode = $this->user_arr['agentcode'];
            $package_id = $this->user_arr['package_id'];
            
            $this->load->model('broker_model');
            $this->load->model('package_model');
            $package = $this->package_model->find_by_id($package_id);
            
            //жԴԴǷз񳬹
            $valid_house_num = $this->broker_model->valid_house_num();
            
            if($valid_house_num < $package["package_valid_num"])
            {
                //ʼԴ
                $this->load->model('rent_model');
                $houseinfo = array();
                $this->rent_model->set_select_fields(array('id','esta'));
                $houseinfo = $this->rent_model->find_by_id($rowid);

                if( is_array( $houseinfo ) && !empty($houseinfo)    )
                {
                    //طԴ
                    $this->load->model('rent_operate_model'); 
                    $set_result = $this->rent_operate_model->active_house($rowid);

                    if($set_result)
                    {	
                        //ŵ
                        $this->load->model('agency_model');
                        $relation_info = array();
                        $relation_info = $this->agency_model->get_relation_by_agentcode($agentcode);
                        $domain = isset($relation_info['cat_id']) ? $relation_info['cat_id'] : 0;
                        $parentcode = '';
                        if( is_array($relation_info) && !empty($relation_info))
                        {	 
                            $parentcode = isset($relation_info['parentcode']) ? $relation_info['parentcode'] : '';
                        }
                        else
                        {	
                            $parentinfo = array();
                            $select_array = array('parentcode');
                            $this->agency_model->set_select_fields($select_array);
                            $parentinfo = $this->agency_model->get_company_info_by_code($agentcode);
                            $parentcode = isset($parentinfo['parentcode']) ? $parentinfo['parentcode'] : '';
                        }
                        $tbl = 'rent';
						/***ύԴ־MYSQL(־ѯ),[$msg:3-Դٷ] ***/
						$this->rent_model->action_log( $agentcode , $uid , $tbl , $rowid , 3);
                        //мͳ
                        $this->load->library('statistics');
                        /***ͨӿύ־мoperatetype 1: 2ˢ 3ɾ 4ʧЧ 5ٷ ***/
                        $this->statistics->sub_operatecount( $uid , $agentcode , 5 , $rowid , '' , $tbl , $domain , $parentcode );

                        $result['is_ok'] = 1;
                        $result['msg'] = 'Դɹ';
                    }
                    else
                    {
                        $result['is_ok'] = 0;
                        $result['msg'] = 'Դʧ';
                    }
                }
                else
                {
                    $result['is_ok'] = 0;
                    $result['msg'] = 'ԴϢ';  
                }
            }
            else
            {
                $result['is_ok'] = 0;
                $result['msg'] = 'Դ';  
            }
        }
        else
        {   
            $result['is_ok'] = 0;
            $result['msg'] = ''; 
        }

        $result['msg'] = iconv( 'gb2312' , 'utf-8',  $result['msg'] ); 
        print_r(json_encode($result));
        exit;
    }
    
    
    /**
     * ɾԴ
     */
    public function delete_house()
    {
        //Դ
        $rowid = $this->input->get( 'rowid' , TRUE );
        $secret_key = $this->input->get( 'secret_key' , TRUE );
        $result = array();
        
        //֤Դźύ֤
        if( intval($rowid) > 0  &&  md5('HOUSE365_DELETE_HOUSE_'.$rowid) == $secret_key )
        {
            //˺uid
            $uid = $this->user_arr['uid'];

			//ŵ˺
			$agentcode = $this->user_arr['agentcode'];

            //ʼԴ
            $this->load->model('rent_model');
            $houseinfo = array();
            $this->rent_model->set_select_fields(array('id','esta'));
            $houseinfo = $this->rent_model->find_by_id($rowid);
            
            if( is_array( $houseinfo ) && !empty($houseinfo)    )
            {
                //طԴ
                $this->load->model('rent_operate_model'); 
                $set_result = $this->rent_operate_model->delete_house($rowid);
                
                if($set_result)
                {	
                    //ŵ
                    $this->load->model('agency_model');
                    $relation_info = array();
                    $relation_info = $this->agency_model->get_relation_by_agentcode($agentcode);
                    $domain = isset($relation_info['cat_id']) ? $relation_info['cat_id'] : 0;
                    if( is_array($relation_info) && !empty($relation_info))
                    {	 
                        $parentcode = isset($relation_info['parentcode']) ? $relation_info['parentcode'] : '';
                    }
                    else
                    {	
                        $parentinfo = array();
                        $select_array = array('parentcode');
                        $this->agency_model->set_select_fields($select_array);
                        $parentinfo = $this->agency_model->get_company_info_by_code($agentcode);
                        $parentcode = isset($parentinfo['parentcode']) ? $parentinfo['parentcode'] : '';
                    }

                    $tbl = 'rent';
                    //мͳ
                    $this->load->library('statistics');
                    /***ͨӿύ־мoperatetype 1: 2ˢ 3ɾ 4ʧЧ 5ٷ ***/
                    $this->statistics->sub_operatecount( $uid , $agentcode , 3 , $rowid , '' , $tbl , $domain , $parentcode );

                    /***ύԴ־MYSQL(־ѯ),[$msg:4-ʧЧԴ] ***/
                    $this->rent_model->action_log( $agentcode , $uid , $tbl , $rowid , 0);

                    $result['is_ok'] = 1;
                    $result['msg'] = 'ɾԴɹ';
                }
                else
                {
                    $result['is_ok'] = 0;
                    $result['msg'] = 'ɾԴʧ';
                }
            }
            else
            {
                $result['is_ok'] = 0;
                $result['msg'] = 'ԴϢ';  
            }
        }
        else
        {   
            $result['is_ok'] = 0;
            $result['msg'] = ''; 
        }

        $result['msg'] = iconv( 'gb2312' , 'utf-8',  $result['msg'] ); 
        print_r(json_encode($result));
        exit;
    }
    
    
    /**
     * Դ
     */
    function house_appeal()
    {   
        //Դ
        $rowid = $this->input->get( 'rowid' , TRUE );
        $reason = $this->input->get( 'reason' , TRUE );
        $secret_key = $this->input->get( 'secret_key' , TRUE );

        $result = array();
        //֤Դźύ֤
        if( intval($rowid) > 0  &&  md5('HOUSE365_SELL_APPEAL_'.$rowid) == $secret_key )
        {
            if ( $reason != "" ) 
            {
                $data_info = array();
                $reason = urldecode($reason);
                $data_info['appeal'] = iconv( "UTF-8" , "GBK" , $reason);
                $data_info['appealtime'] = time();
                $data_info['esta'] = 2;
                $this->load->model('rent_freeze_model');
                $app_result = FALSE;
                $app_result = $this->rent_freeze_model->house_appeal ( $rowid , $data_info);
                if($app_result)
                {
                    $result['is_ok'] = 1;
                    $result['msg'] = 'ύɹԱһʱ䴦';
                }
                else
                {
                    $result['is_ok'] = 0;
                    $result['msg'] = 'ύʧܣµͷ'; 
                }
            }
            else
            {
                $result['is_ok'] = 0;
                $result['msg'] = 'д';
            }
        }
        else
        {
            $result['is_ok'] = 0;
            $result['msg'] = ''; 
        }
        
        $result['msg'] = iconv( 'gb2312' , 'utf-8',  $result['msg'] ); 
        print_r(json_encode($result));
        exit;
    }
    
    
    /**
    * ݱύȡѯ
    */
    private function _get_cond_str( $form_param )
    {   
        $cond_where = '';
        
        //Դ
        if( isset($form_param['infotype']) && !empty($form_param['infotype']) )
        {
           $cond_where .= " AND infotype = '".intval($form_param['infotype'])."'";
        }
        
        //Դ۸
        if ( isset($form_param["price_rent"]) && !empty($form_param["price_rent"]) ) 
        {  
            switch($form_param["price_rent"])
            {
                case 1:	
                    $cond_where .= " AND price <= '800' ";
                    break;
                case 2:
                    $cond_where .= " AND price > '800' and price <= '1200' ";
                    break;
                case 3:
                    $cond_where .= " AND price > '1200' and price <= '2000' ";
                    break;
                case 4:
                    $cond_where .= " AND price > '2000' and price <= '3000' ";
                    break;
                case 5:
                    $cond_where .= " AND price > '3000' and price <= '5000' ";
                    break;
                case 6:
                    $cond_where .= " AND price > '5000' and price <= '10000' ";
                    break;
                case 7:
                    $cond_where .= " AND price > '10000'";
                    break;
            }       
        }
        
        //
        if (isset($form_param["buildarea"]) && !empty($form_param["buildarea"])) 
        {
            switch($form_param["buildarea"])
            {
                case 1:	
                    $cond_where .= " AND buildarea <= '40' ";
                    break;
                case 2:
                    $cond_where .= " AND buildarea > '40' AND buildarea <= '60' ";
                    break;
                case 3:
                    $cond_where .= " AND buildarea > '60' AND buildarea <= '80' ";
                    break;
                case 4:
                    $cond_where .= " AND buildarea > '80' AND buildarea <= '100' ";
                    break;
                case 5:
                    $cond_where .= " AND buildarea > '100' AND buildarea <= '120' ";
                    break;
                case 6:
                    $cond_where .= " AND buildarea > '120' AND buildarea <= '144' ";
                    break;
                case 7:
                    $cond_where .= " AND buildarea > '144'  AND  buildarea <= '200' ";
                    break;
                case 8:
                    $cond_where .= " AND buildarea > '200'  AND  buildarea <= '400' ";
                    break;
                case 9:
                    $cond_where .= " AND buildarea > '400' ";
                    break;
            }       
        }
        
        //
        if (isset($form_param['roomtype']) && !empty($form_param['roomtype'])) 
        {
            switch ($form_param['roomtype']) 
            {
              case 1:
                    $cond_where .= " AND  room = '1'";
                    break;
              case 2:
                    $cond_where .= " AND   room = '2' ";
                    break;
              case 3:
                    $cond_where .= " AND  room = '3' ";
                    break;
              case 4:
                    $cond_where .= " AND  room = '4' ";
                    break;
              case 5:
                    $cond_where .= " AND  room >= '5' ";
                    break;
            }
        }
        
        //ؼ
        if (isset($form_param['keywords']) && !empty($form_param['keywords']) && $form_param['k_id']) 
        {   
            $keyword = trim(strip_tags($form_param['keywords']));
            switch ($form_param['k_id']) 
            {
                case 1:
                    $cond_where .= " AND blockshowname LIKE '%".$keyword."%'";
                    break;
                case 2:
                    $cond_where .= " AND id = '".$keyword."'";
                    break;
                case 3:
                    $cond_where .= " AND ownid = '".$keyword."'";
                    break;
            }
        }

		//С
		if (isset($form_param['blockid']) && !empty($form_param['blockid']) && $form_param['blockid'] > 0) 
        {	
			$blockid = intval($form_param['blockid']);
			$cond_where .= " AND blockid = '".$blockid."'";
		}

        //ȫԴ
        if ( isset($form_param['roomcategory']) && !empty($form_param['roomcategory']) ) 
        {
            switch ($form_param['roomcategory']) 
            {
                case 1:
                    $cond_where .= ' AND  isstar = 0 ';
                    break;
                case 2:
                    $cond_where .= ' AND  isstar = 3 ';
                    break;
                case 3:
                    $cond_where .= ' AND  istag = 1 ';
                    break;
                case 4:
                    $cond_where .= ' AND  isreal = 1 ';
                    break;
            }
        }
        return $cond_where;
    }
    
    
    //ȡַ
    private function _get_orderby_arr( $order_val ) 
    {   
        $arr_order = array();
        
        switch ($order_val) 
        {
            case 1:
                $arr_order['order_key'] = 'updatetime' ;
                $arr_order['order_by'] = 'DESC';
                break;
            case 2:
                $arr_order['order_key'] = 'updatetime' ;
                $arr_order['order_by'] = 'ASC';
                break;
            case 3:
                $arr_order['order_key'] = 'creattime' ;
                $arr_order['order_by'] = 'DESC';
                break;
            case 4:
                $arr_order['order_key'] = 'creattime' ;
                $arr_order['order_by'] = 'ASC';
                break;
            case 5:
                $arr_order['order_key'] = 'price' ;
                $arr_order['order_by'] = 'ASC';
                break;
            case 6:
                $arr_order['order_key'] = 'price' ;
                $arr_order['order_by'] = 'DESC';
                break;
            case 7:
                $arr_order['order_key'] = 'buildarea' ;
                $arr_order['order_by'] = 'ASC';
                break;
            case 8:
                $arr_order['order_key'] = 'buildarea' ;
                $arr_order['order_by'] = 'DESC';
                break;
            default:
                $arr_order['order_key'] = 'updatetime' ;
                $arr_order['order_by'] = 'DESC';
        }

        return $arr_order;
    }

    /**
     * swfuploadϴļ
     */
    public function swf_upload()
    {
        $this->load->view('pic_inc');
    }
}
/* End of file rent.php */
/* Location: ./application/zsb/controllers/rent.php */