<?php

/**
 * model\growth\GrowthBlockImprove.php
 */

/**
 * С
 *
 * @author bsw
 */
class GrowthBlock {
    /**
     *
     * @var TINY_ADODB ݿ 
     */    
    private $db;
    
    /**
     *
     * @var type ݿ
     */
    private $dbback;
    
    /**
     *
     * @var type 
     */
    private $mc;

    /**
     *
     * @var String ı 
     */
    private $table;

    /**
     * 캯ʼdb memcache ȡ
     * @param string $table ʹĬֵ
     */
    public function __construct($table=null) {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->mc = $container->get('mc');
        $this->table = 'block';
    }


	/**
     * ȡСѾŵ
	 * @param array  $attrs  Сֶ 
     * @param int  $id  Сid  
     * return array
	 */
	 function getBlockAtttOpen($attrs,$id){
		if(!$attrs || !is_array($attrs) || !$id) return array();
        
		$attr_info = array();
		$block_info = $this->getBlockInfoById($id);
		foreach($attrs as $val){
			$attr_info[$val] = $block_info[$val];
		}
		return $attr_info;
	 }


	 	/**
     * ѯСϢ
     * @param int  $block_id  Сid  
     * return array
	 */
	 function getBlockLockInfo($block_id){
		if(!$block_id) return array();
		$sql = SqlCombinHelper::select_sql('block',array('id,lock_flag,lock_opennum'), "id = '".$block_id."'");
		$result = $this->dbback->getRow($sql);
        $result = $result ? $result : array();
		return $result;
	 }

	/**
     * ȡϤС 
     * @param array  $blockIds  Сid  
     * return int
	 */
	 function getfamiliarBlockCount($blockIds){
		if(!is_array($blockIds) || !$blockIds) return 0;

		$block_ids_str = implode(',',$blockIds);
		if(!$block_ids_str) return 0;

		$sql = SqlCombinHelper::select_sql('block',array('count(id) as num'), " id in ($block_ids_str) and esta = 2 ");
		$result = $this->dbback->getOne($sql);
        $result = $result ? $result : 0;
		return $result;
	 }

	/**
     * ݰidȡС 
     * @param int  $district  id  
     * return array
	 */
	 function getStreetByDistrict($district,$type=null){
		if(!$district) return array();
 
		$sql = SqlCombinHelper::select_sql('street',array('id,streetname'), " district='{$district}' ");
		$result = $this->dbback->getAll($sql);
		$street = array();
		if($type == 1){
			$street[''] = 'ѡ';
		}
        if(is_array($result)){
			foreach($result as $val){
				$street[$val['id']] = $val['streetname'];
			}
		}
		return $street;
	 }

	/**
     * idȡСϢ
     * @param int  $id  Сid  
     * @param array $attr С
     * return array
	 */
	 function getBlockInfoById($id,$attr=null){
		if(!$id) return array();
		$attr = $attr ? $attr : array('*');
		$sql = SqlCombinHelper::select_sql('block',$attr, "id = '".$id."'");
		$result = $this->dbback->getRow($sql);
		return $result;
	 }


    /**
     * ݾagentcodeȡ
     * @param int  $agentcode   agentcode  
     * return int string
	 */
	function getBlockStreetByAgentCode($agentcode){
		if(!$agentcode) return '';
		$sql = "select streetid from agency  where  agentcode='{$agentcode}'";

         //ȡ
		$result = $this->mc->get($sql);
		if($result === false){
			$result = $this->dbback->getOne($sql);
			$this->mc->set($sql,$result,3600);
		}
		return $result;
	 }

	/**
     * ݰidȡӦС(ŲзԴС)
     * @param int  $streetid   id 
	 * @param string  $block_ids_str   зԴСid
     * return int
	 */
	 function getBlockCountByStreetId($streetid,$block_ids_str){
		if(!$streetid) return 0;
		$sql_in = $block_ids_str ? " and id not in ($block_ids_str) " : "";

		$sql = "select count(id) as num from block where streetid='{$streetid}' and esta=2 {$sql_in} ";
		$result = $this->dbback->getOne($sql);
		return $result;
	 }

	/**
     * ݰidȡӦСб(ŲзԴС)
     * @param int  $streetid   id 
	 * @param string  $block_ids_str   зԴСid
     * return int
	 */
	 function getBlockByStreetId($streetid,$block_ids_str,$start,$limit){
		if(!$streetid) return array();
		$sql_in = $block_ids_str ? " and id not in ($block_ids_str) " : "";

		$sql = "select id,blockname,district,lock_opennum,lock_outside,lock_flag from block where   streetid = '{$streetid}' and esta=2 {$sql_in} order by lock_opennum desc,id desc limit {$start},{$limit}";
		$result = $this->dbback->getAll($sql);
		return $result;
	 }

	/**
     * ݰidȡϢ
     * @param int  $streetid   id 
     * return array
	 */
	 function getStreetById($streetid){
		if(!$streetid) return array();
		$sql = "select streetname  from street where  id = '{$streetid}'";

        //ȡ
		$result = $this->mc->get($sql);
		if($result === false){
			$result = $this->dbback->getRow($sql);
			$this->mc->set($sql,$result,3600);
		}
		return $result;
	 }


         
}

?>
