<?php
/**
 * ֵ
 * @author sun
 */
class PaymentRechargeActive {
    
    /**
     * ݿ 
     * @var TINY_ADODB 
     */    
    private $db;
    
    /**
     * ݿ
     * @var type
     */
    private $dbback;
    
    /**
     * 
     * @var type
     */
    private $mc;

    /**
     * ı 
     * @var String
     */
    private $table;
    
    /**
     * Ǯı
     * @var type 
     */
    public static $rate = '0.1';
    
    /**
     * ѯ䷶Χ
     * @param int $start ʼֵ
     * @param int $limit ÿҳʾ
     * @return string
     */
    private function getLimitCond($start, $limit) {
        $start = $start > 0 ? $start : 0;
        $limit_cond = ($start == 0 && $limit == 0) ? '' : ' LIMIT '
                      . $start . ' , ' . $limit;
        return $limit_cond;
    }
    
    /**
     * ֶ֤ǷϷ
     * @param type $field
     * @return type
     */
    private function validateFiled($field) {
        return in_array($field, $this->fields);
    }
    
    /**
     * 
     * @param string $orderField ֶ
     * @param string $order 
     * @return string
     */
    private function getOrder($orderField, $order = 'ASC') {
        $strOrder = '';
        if ($this->validateFiled($orderField)) {
            $strOrder = "ORDER BY $orderField $order";
        }
        return $strOrder;
    }
    
    /**
     * 캯ʼdb memcache ȡ
     * @param string $table ʹĬֵ
     */
    public function __construct() {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->table = 'payment_housebean_recharge_active';
        $this->mc = $container->get('mc');
        $sqlfield = "DESC $this->table";
        $fieldsMKey = $sqlfield;
        $this->fields = $this->mc->get($fieldsMKey);
        if($this->fields === false) {
            $fields = $this->dbback->getAll($sqlfield);
            foreach ($fields as $field) {
                $this->fields[] = $field['Field'];
            }
            $this->mc->set($fieldsMKey, $this->fields, 3600);
        }
    }
    
    /**
     * ֵ¼
     * @param int $num 
     * @param string $operator 
     * @param int $isActive Ƿ
     * @param int $price ۸
     * @param date $starttime ʼʱ
     * @param date $endtime ʱ
     * @return true or false
     */
    public function insert($num, $operator, $isActive = 0, $price = '', 
            $starttime = '', $endtime = '') {
        $fieldData = array();
        $fieldData['num'] = $num;
        $fieldData['operator'] = $operator;
        $fieldData['isactive'] = $isActive;
        $fieldData['price'] = $price;
        $fieldData['starttime'] = $starttime;
        $fieldData['endtime'] = $endtime;
        $fieldData['ctime'] = date('Y-m-d H:i:s');
        $sql = SqlCombinHelper::insert_sql($this->table, $fieldData);
        return $this->db->execute($sql);
    }
    
    /**
     * idȡĳֵ¼
     * @param int $id 
     * @return array
     */
    public function getOneById($id) {
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, "id = '$id'");
        return $this->dbback->getRow($sql);
    }
    
    /**
     * óֵ״̬
     * @param int $id 
     * @param int $status ״̬
     * @return return or false
     */
    public function setStatus($id, $status, $operator) {
        $fieldData = array('status' => $status, 'operator' => $operator);
        $sql = SqlCombinHelper::update_sql($this->table, $fieldData, "id='$id' and isactive =1");
        if($this->db->execute($sql)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * ͳ
     * @return int
     */
    public function getCount() {
       $sql = SqlCombinHelper::count_sql($this->table);
       return $this->dbback->getOne($sql);
    }
    
    /**
     * չʾֵ¼
     * @param int $start ʼҳ
     * @param int $pagesize ÿҳʾ
     * @param string $order ǽ
     * @return array
     */
    public function getList($start = null, $pagesize = 20, $order = 'desc') {
        if($start !== null && $pagesize !== null) {
            $limit = $this->getLimitCond($start, $pagesize);
        } else {
            $limit = '';
        }
		if($order !== null){
		    $order = $this->getOrder('id', $order);
        } else {
            $order = '';
        }
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, 
                "1 = 1 {$order} {$limit} ");
        return $this->dbback->getAll($sql);
    }
    
    /**
     * ȡеĳֵ¼
     * @return array
     */
    public function getAll()
    {
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, 
                "1 = 1 order by isactive asc ");
        return $this->dbback->getAll($sql);
    }
}
