<?php
/**
 * ɳֵ¼
 *
 * @author sun
 */
class GrowthExpRecord {
    /**
     * ݿ
     */
    private $db;

    /**
     * ݿ
     */
    private $dbback;

    /**
     * 
     */
    private $mc;
    
    /**
     * ı
     * @var string
     */
    private $table;
    
    /**
     * аֶ
     * @var array
     */
    private static $fields = array('id','broker_id','way_alias','score','exp',
        'description', 'discard','ctime');
    
    public function __construct($strDate = null) {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        if ($strDate == '') {
            $strDate = date('Ymd');
        }
        $this->table = "growth_exp_record_" . $strDate;
        $this->exp = new GrowthExp();
    }
    
    /**
     * ṹ
     * @param type $strDate
     * @return type
     */
    public function createTable($tablename) {
        $sql = "CREATE TABLE IF NOT EXISTS `{$tablename}` (
            `id` int(10) unsigned NOT NULL auto_increment,
            `broker_id` int(11) NOT NULL COMMENT 'ID',
            `way_alias` varchar(20) NOT NULL COMMENT 'ȡ;exp_wayway_aliasֶ',
            `score` int(11) NOT NULL COMMENT 'λȡɳֵֵ0ʾãС0ʾ۳',
            `exp` int(11) NOT NULL COMMENT 'λȡʱĳɳֵ',
            `description` varchar(256) character set gbk default NULL COMMENT '',
            `ip` varchar(30) NOT NULL COMMENT '¼˵IPַ',
            `ctime` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT 'ɳֵ仯ʱ',
            `discard` tinyint(4) NOT NULL default '0' COMMENT 'Ƿ10״̬',
            PRIMARY KEY  (`id`),
            KEY `brokerid` (`broker_id`)
          ) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ɳֵ仯¼'";
        return $this->db->execute($sql);
    }
    
    /**
     * ɾ
     * @param type $tablename
     */
    public function dropTable($tablename) {
        $sql = "DROP TABLE  IF EXISTS  $tablename";
        return $this->db->execute($sql);
    }
    
    /**
     * ֶ֤ǷϷ
     * @param type $field
     * @return type
     */
    private function validateFiled($field) {
        return in_array($field, self::$fields);
    }
    
    /**
     * 
     * @param type $start
     * @param type $limit
     * @return type
     */
    private function getLimitCond($start, $limit) {
        $start = $start > 0 ? $start : 0;
        $limit_cond = ($start == 0 && $limit == 0) ? '' : ' LIMIT '
                      . $start . ' , ' . $limit;
        return $limit_cond;
    }
    
    /**
     * 
     * @param type $orderField
     * @param type $order
     * @return string Description
     */
    private function getOrder($orderField, $order = 'ASC') {
        $strOrder = '';
        if ($this->validateFiled($orderField)) {
            $strOrder = 'ORDER BY $orderField $order';
        }
        return $strOrder;
    }
    
    
    /**
     * 
     * @param type $brokerId
     * @param type $wayAlias
     * @param type $score
     * @param type $description
     * @param type $discard
     * @return type
     */
    public function insertData($brokerId,$wayAlias,$score,$description,
            $discard = 0) {
        $arrFieldsValue = array();
        $expOne = $this->exp->findOneByBrokerId($brokerId);
        $arrFieldsValue['broker_id'] = $brokerId;
        $arrFieldsValue['way_alias'] = $wayAlias;
        $arrFieldsValue['score'] = $score;
        $arrFieldsValue['exp'] = $expOne['exp'];
        $arrFieldsValue['description'] = $description;
        $arrFieldsValue['ip'] = GetIp();;
        $arrFieldsValue['discard'] = $discard;
        $sql = SqlCombinHelper::insert_sql($this->table, $arrFieldsValue);
        return $this->db->execute($sql);
    }
    
    /**
     * 
     * @param type $wayAlias
     * @param type $brokerId
     */
    public function countNumData($wayAlias, $brokerId) {
        
    }
    
    /**
     * 
     * @param type $wayAlias
     * @param type $brokerId
     */
    public function findAllByWayAliasAndBrokerId($wayAlias, $brokerId, 
            $start, $limit) {
        
    }
    
    /**
     * 
     * @param type $brokerId
     * @param type $start
     * @param type $limit
     */
    public function findAllByBrokerId($brokerId, $start, $limit) {
        
    }
    
    /**
     * 
     * @param type $brokerId
     * @param type $start
     * @param type $limit
     */
    public function findRowByBrokerId($brokerId, $start, $limit) {
        
    }

	/**
     * ݾid ҳɳֵ仯¼
     * @param int $brokerId id
     * @param int $start ʼļ¼
     * @param int $number ص
     * @return type
     */
    public function findByBrokerId($brokerId,$start=null,$number=null,$order=null) {
        $limit = '';
        if($start !== null&&$number !== null) {
            $limit = "limit $start,$number";
        }
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields,"broker_id = '$brokerId'");
		if($order !== null){
		    $sql .= "order by id $order ";
		}
        $sql .= $limit;
       return $this->dbback->getAll($sql);
    }
    
    public function findCountByBrokerId($brokerId) {
       $sql = SqlCombinHelper::select_sql($this->table, "count(id) as num","broker_id = '$brokerId'");
       return $this->dbback->getOne($sql);
    }
}
