<?php

/**
 * core\lib\block\BlockLevelHeatSetting.php
 */

/**
 * ȶȣpvͷԴСȼ
 *
 * @author Administrator
 */
class BlockLevelHeatSetting {

    /**
     *
     * @var TINY_ADODB ݿ
     */
    private $db;
    /**
     *
     * @var TINY_ADODB ݿ
     */
    private $dbback;
    /**
     *
     * @var Memcache  
     */
    private $mc;
    /**
     *
     * @var string 
     */
    private $table;
    /**
     *
     * @var array аֶ
     */
    public static $fields = array('id', 'level', 'min_house_number', 'max_house_number', 'credit_way_alias', 'exp_way_alias');

    /**
     *
     * @var array ּĸ
     */
    public static $levels = array('1'=>'A','2'=>'B','3'=>'C','4'=>'D',);

    /**
     * 캯 ʼdbmemcache
     * @param string $table 
     */
    public function __construct($table = 'block_level_heat_setting') {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->mc = $container->get('mc');
        $this->table = $table;
    }

    /**
     * СּݣA,B,C,D4ּ
     * @return array Сȼ
     */
    public function findAll() {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields);
        $sql .= "order by level";
        $res = $this->db->getAll($sql);
        if ($res) {
            foreach ($res as $key => $value) {
                $res[$key] = $this->removeNumberKey($value);
            }
        }
        return $res;
    }

    /**
     * ȥмֵΪԪ
     * @param array $arr ֵַֺ
     * @return array ֵ
     */
    private function removeNumberKey($arr) {
        $rarr = array();
        foreach ($arr as $k => $val) {
            if (!is_int($k)) {
                $rarr[$k] = $val;
            }
        }
        return $rarr;
    }

    /**
     * ߸Сȼ
     * @param array $fields Сȼ
     * @return boolean ɹtrueʧܷfalse
     */
    public function save($fields) {
        $keys = array_keys($fields);
        if (array_key_exists('min_house_number', $fields) && array_key_exists('max_house_number', $fields)) {
            $min_house_number = $fields['min_house_number'];
            $max_house_number = $fields['max_house_number'];
            $sql = "insert into $this->table (" . implode(",", $keys) . ") value ('" . implode("','", $fields) . "')";
            $sql .= " ON DUPLICATE KEY UPDATE min_house_number = '$min_house_number',max_house_number='$max_house_number'";
            if ($this->db->execute($sql)) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    /**
     * $min_house_number,$max_house_number
     * @param int $pv Ϊnullʱ
     * @param int $houseNumber Ϊnullʱ
     * @return int ظµļ¼Ŀ
     */
    public function update($housenumber) {        
        $fields = array();
        $affected_row = 0;
        if(is_array($housenumber)&&!empty($housenumber)) {
            foreach ($housenumber as $value){
                if($value['min']!==null) {
                    $fields['min_house_number'] = $value['min'];
                }
                if($value['max']!==null) {
                    $fields['max_house_number'] = $value['max'];
                }
                $where = "level='".$value['level']."'";
                $sql = SqlCombinHelper::update_sql($this->table, $fields, $where);               
                $this->db->execute($sql);
                
                $affected_row += $this->db->affected_Rows();
                
            }        
            return $affected_row;
           
        } else {
             return false;
        }
    }
    
    


    /**
     * СԴ
     * @param int $houseNumber Դֵ
     * @return int ظµļ¼Ŀ
     */
    public function updateMinHouseNumber($houseNumber) {
        $sql = SqlCombinHelper::update_sql($this->table, array('min_house_number' => $houseNumber));
        $this->db->execute($sql);
        return $this->db->affected_Rows();
    }

    /**
     * ·Դ
     * @param int $houseNumber Դ
     * @return int ظµļ¼Ŀ
     */
    public function updateMaxHouseNumber($houseNumber) {
        $sql = SqlCombinHelper::update_sql($this->table, array('max_house_number' => $houseNumber));
        $this->db->execute($sql);
        return $this->db->affected_Rows();
    }

    /**
     * ݵȼһֻȡʽı
     * @param int $level Сȼ
     * @return string  ֻȡʽ
     */
    public function getCreditWayAlias($level) {
        $sql = SqlCombinHelper::select_sql($this->table, 'credit_way_alias', "level = '$level'");
        return $this->dbback->getOne($sql);
    }

    /**
     * ݵȼҾȡʽı
     * @param int $level Сȼ
     * @return string ȡʽı
     */
    public function getExpWayAlias($level) {
        $sql = SqlCombinHelper::select_sql($this->table, 'exp_way_alias', "level = '$level'");
        return $this->dbback->getOne($sql);
    }

    /**
     * Сȼñ
     */
    public function emptyTable() {
        $sql = "TRUNCATE TABLE $this->table";
        $this->db->Execute($sql);
    }
}

?>
