<?php
/**
 * ַԴ
 *
 * @author user
 */
class HouseSell {
    private $orderCond;
    private $limitCond;
    private $searchCond;
    public function __construct() {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->mc = $container->get('mc');
        $this->block =  new Block();
        $this->table = 'sell';
        $this->fields = 'id,district,streetid,address,room,hall,buildarea,price,expiretime,'
                . 'grade,blockshowname,isstar,infotype,esta,blockid,pic1,is360';
    }

    
    public function setLimit($start, $limit) {
        $start = $start > 0 ? $start : 0;
        $limitCond = ($start == 0 && $limit == 0) ? '' : ' LIMIT '
                    . $start . ' , ' . $limit;
        $this->limitCond = $limitCond;
    }
    
    /**
     * 
     * @param type $start
     * @param type $limit
     * @return type
     */
    public function getLimit() {
        return $this->limitCond;
    }
    
    /**
     * 
     * @param type $orderField
     * @param type $order
     */
    public function setOrder($orderField, $order = 'ASC') {
        $this->orderCond = " ORDER BY $orderField $order";
    }
    
    /**
     * 
     * @return type
     */
    public function getOrder() {
        return $this->orderCond;
    }
    
    public function setWhere($searchWhere) {
        foreach ($searchWhere as $key => $value) {
            if (preg_match('/IN|LIKE/', $value)) {
                $confx[]= "$key $value";
            } else if(is_string($value)) {
               $confx[]= "$key = '$value'";
            } else if (is_int($value)) {
                $confx[]= "$key = $value";
            }
        }
        if($confx) {$confx = implode(" and ", $confx);}
        $this->searchCond = $confx;
    }
    
    /**
     * 
     * @param type $arrWhere
     * @return type
     */
    public function getWhere() {
        return $this->searchCond;
    }
    
    /**
     * ȡԴ(Ҫ)
     * @param type $arrWhere
     * @param type $orderField
     * @param type $order
     * @param type $start
     * @param type $limit
     * @return array
     */
    public function getHouseList($fields = '') {
        if ($fields == '') {$fields = $this->fields;}
        $blockId = $this->block->findAllEstaBlockId();
        $blockIds = implode(',', $blockId);
        $strWhere = $this->getWhere();
        $strOrder = $this->getOrder();
        $strLimit = $this->getLimit();
        $sql = SqlCombinHelper::select_sql($this->table, $fields, 
                $strWhere . " AND blockid IN ($blockIds) " . $strOrder . $strLimit);
        return $this->dbback->getAll($sql);
    }
    
    
   /**
    * ȡԴ(Ҫ)
    * @param type $arrWhere
    * @return int
    */
    public function getHouseCount() {
        $blockId = $this->block->findAllEstaBlockId();
        $blockIds = implode(',', $blockId);
        $strWhere = $this->getWhere() . "AND blockid IN ($blockIds) " ;
        $sql = SqlCombinHelper::count_sql($this->table, $strWhere);
        return $this->dbback->getOne($sql);
    }


    /**
     * ȡԴ(new,inŻѯ)
     * @param type $arrWhere
     * @param type $orderField
     * @param type $order
     * @param type $start
     * @param type $limit
     * @return array
     */
    public function getHouseListNew($fields = '') {
        if ($fields == '') {$fields = $this->fields;}

		$strWhere = $this->getWhere();
        $myValidBlocks = $this->getBrokerSellValidBlock($strWhere);
		$blockIds = implode(',', $myValidBlocks);
		if(!$blockIds) return array();
        
        $strOrder = $this->getOrder();
        $strLimit = $this->getLimit();
        $sql = SqlCombinHelper::select_sql($this->table, $fields, 
                $strWhere . " AND blockid IN ($blockIds) " . $strOrder . $strLimit);
        return $this->dbback->getAll($sql);
    }

   /**
    * ȡԴ(new,inŻѯ)
    * @param type $arrWhere
    * @return int
	* bianshiwu 2014-12-09
    */
    public function getHouseCountNew() {
		
		$strWhere = $this->getWhere();
        $myValidBlocks = $this->getBrokerSellValidBlock($strWhere);

		$blockIds = implode(',', $myValidBlocks);
		if(!$blockIds) return array();

        $strWhere = $strWhere. "AND blockid IN ($blockIds) " ;
	
        $sql = SqlCombinHelper::count_sql($this->table, $strWhere);
        return $this->dbback->getOne($sql);
    }


   /**
    * ȡĳЧ۷ԴС
    * @param type $arrWhere
    * @return int
	* bianshiwu 2014-12-09
    */
    public function getBrokerValidSellBlock($where) {
	    if(!$where) return array();

		$result = $this->mc->get($where);
        if($result === false) {
			$sql = SqlCombinHelper::select_sql($this->table,' blockid', $where);
			$result = $this->dbback->getAll($sql);
            $this->mc->set($where,$result,120);
        }
		return $result;
    }

   /**
    * ȡĳЧ۷ԴʽС
    * @param type $arrWhere
    * @return int
	* bianshiwu 2014-12-09
    */
    public function getBrokerSellValidBlock($where) {
		
		if(!$where) return array();

        $myBlocks = $this->getBrokerValidSellBlock($where);
		
		$myValidBlocks = array();
        if(is_array($myBlocks)){
			$blockId = $this->block->findAllEstaBlockId();
			//print_r($blockId);
			$blockId = array_flip($blockId);

			foreach($myBlocks as $val){
				if(!array_key_exists($val['blockid'],$myValidBlocks) && array_key_exists($val['blockid'],$blockId)){
					$myValidBlocks[$val['blockid']] = $val['blockid'];
				}
			}
		}
        //print_r($myValidBlocks);
        return $myValidBlocks;
    }
    
    /**
     * ȡԴһϢ
     * @param type $id
     * @return type
     */
    public function getOneHouse($fields = '') {
		if ($fields == '') {$fields = $this->fields;}

        $strWhere = $this->getWhere();
        $sql = SqlCombinHelper::select_sql($this->table, $fields, "$strWhere");
		return $this->dbback->getRow($sql);
    }

	public function getAllHouse() {
        $strWhere = $this->getWhere();
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, "$strWhere");
		return $this->dbback->getAll($sql);
	}
}
