<?php
/**
 * Description of GrowthBidHouseRecord
 *
 * @author user
 */
abstract class GrowthBidRentRecord extends GrowthBidRecord {
    public function __construct($table) {
        parent::__construct($table);
    }
    
    public function save($fieldData) {}
    
    private $orderCond;
    private $limitCond;
    private $searchCond;
    
    public function setLimit($start, $limit) {
        $start = $start > 0 ? $start : 0;
        $limitCond = ($start == 0 && $limit == 0) ? '' : ' LIMIT '
                    . $start . ' , ' . $limit;
        $this->limitCond = $limitCond;
    }
    
    /**
     * 
     * @param type $start
     * @param type $limit
     * @return type
     */
    public function getLimit() {
        return $this->limitCond;
    }
    
    /**
     * 
     * @param type $orderField
     * @param type $order
     */
    public function setOrder($orderField, $order = 'ASC') {
        $this->orderCond = " ORDER BY $orderField $order";
    }
    
    /**
     * 
     * @return type
     */
    public function getOrder() {
        return $this->orderCond;
    }
    
    public function setWhere($searchWhere) {
        foreach ($searchWhere as $key => $value) {
            if (preg_match('/IN|LIKE/', $value)) {
                $confx[]= "$key $value";
            } else if(is_string($value)) {
               $confx[]= "$key = '$value'";
            } else if (is_int($value)) {
                $confx[]= "$key = $value";
            }
        }
        if($confx) {$confx = implode(" and ", $confx);}
        $this->searchCond = $confx;
    }
    
    /**
     * 
     * @param type $arrWhere
     * @return type
     */
    public function getWhere() {
        return $this->searchCond;
    }
    
    /**
     * ݾͶidȡһЩͶ¼
     * @param type $bidId
     * @return type
     */
    /***
    public function findBidRecordByBid($bidId) {
        if (is_array($bidId)) {
            $strBids = implode(',', $bidId);
            $strBidWhere = " bid_id in({$strBids})";
        } else {
            $strBidWhere = " bid_id = $bidId";
        }
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, $strBidWhere);
        return $this->dbback->getAll($sql);
    }**/

    /**
     * ȡĳĳڴоͶ˷Դ
     * @param type $periodsId
     * @param type $brokerId
     * @return type
     */
    public function findBrokerbidHouseCount() {
        $strWhere = $this->getWhere();
        $sql = SqlCombinHelper::select_sql($this->table, 'id',$strWhere 
                . ' group by bid_periods_id,house_id');
        return count($this->dbback->getAll($sql));
    }
    
    /**
     * ȡĳĳڴоͶЩԴbid_periods_idhouse_id
     * @param type $brokerId
     * @param type $orderField
     * @param type $order
     * @param type $start
     * @param type $limit
     * @return type
     */
    public function findBrokerBidHouse() {
        $strOrder = $this->getOrder();
        $strLimit = $this->getLimit();
        $strWhere = $this->getWhere();
        $sql = SqlCombinHelper::select_sql($this->table, 'bid_periods_id,house_id', 
                "$strWhere group by bid_periods_id,house_id $strOrder $strLimit");
		$bidRecord = $this->dbback->getAll($sql);
        return $bidRecord;
    }
    
    /**
     * ĳͶʷ汾¼
     * @param type $strWhere
     */
    public function findBidHistoryByCount($strWhere) {
		if ($strWhere == '') {
			$strWhere = '1 = 1';
		}
        $sql = SqlCombinHelper::select_sql($this->table, 'COUNT(DISTINCT(bid_id))', 
                "$strWhere ORDER BY  bid_periods_id DESC, utime DESC");
        $bidHistoryCount = $this->dbback->getOne($sql);
        return $bidHistoryCount;
    }
    
    /**
     * ȡĳĳڴоͶЩԴbid_periods_idhouse_id
     * @param type $brokerId
     * @param type $orderField
     * @param type $order
     * @param type $start
     * @param type $limit
     * @return type
     */
    public function findBidHistoryBy($strWhere, $start, $limit) {
        $strLimit = $this->getLimit($start, $limit);
        $sql = SqlCombinHelper::select_sql($this->table, 'DISTINCT(bid_id),bid_periods_id, type,blockname', 
                "$strWhere  group by bid_id ORDER BY  bid_periods_id DESC, utime DESC  $strLimit");
        $bidHistoryRecord = $this->dbback->getAll($sql);
        return $bidHistoryRecord;
    }
}
