<?php

/**
 * core\lib\growth\GrowthCreditWayPackage.php
 */

/**
 * ֻȡʽײͶӦĻֵ
 * @author wxj
 */
class GrowthCreditWayPackage {
    /**
     *
     * @var Mixed ݿ
     */
    private $db;
    
    /**
     *
     * @var Mixed ݿ
     */
    private $dbback;
    
    /**
     *
     * @var Memcache memcache
     */
    private $mc;
    
    /**
     *
     * @var array еֶ
     */
    private $fields = array('id','way_alias','package_id','score');
    
    /**
     *
     * @var String 
     */
    private $table;
    
    /**
     *
     * @var type ֵ
     */
    private $data;
    
    /**
     * 캯ʼdbmemcache
     */
    public function __construct() {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->table = 'growth_credit_way_package';
        $this->mc = $container->get('mc');
        $sqlfield = "DESC $this->table";
        $fieldsMKey = $sqlfield;
        $this->fields = $this->mc->get($fieldsMKey);
        if($this->fields === false) {
            $fields = $this->dbback->getAll($sqlfield);
            foreach ($fields as $field) {
                $this->fields[] = $field['Field'];
            }
            $this->mc->set($fieldsMKey, $this->fields, 3600);
        }
    }
    
    /**
     * ݻȡַʽidȡײ͵ĶӦֵ
     * @param String $wayAlias ȡʽı
     * @return array
     */
    public function getByWayAlias($wayAlias) {
        $this->setData();
        $res = array();
        foreach ($this->data as $value) {
            if($value['way_alias']==$wayAlias) {
                $res[] = $value;
            }
        }
        return $res;
        //$sql = "select ".$this->fields()." from $this->table where way_id = $wayId";
        //return $this->dbback->getAll($sql);
    }
    
    /**
     * ݻȡʽײidûֵ
     * @param String $wayAlias ȡʽı
     * @param Integer $packageId
     * @return Array
     */
    public function getScoreByWayAliasAndPackageId($wayAlias,$packageId) {
        $this->setData();
        $res = 0;
        foreach ($this->data as $value) {
            if($value['way_alias']==$wayAlias&&$value['package_id']==$packageId) {
                $res = $value['score'];
                break;;
            }
        }
        return $res;
    }


    /**
     * ײidлȡʽĻ
     * @param int $packageId ײid
     * @return array
     */
    public function getByPackageId($packageId) {
        $this->setData();
        $res = array();
        foreach ($this->data as $value) {
            if($value['package_id']==$packageId) {
                $res[] = $value;
            }
        }
        return $res;
        //$sql = "select ".$this->fields()." from $this->table where package_id = $packageId";
        //return $this->dbback->getAll($sql);
        
    }
    
    /**
     * зʽӦĻ
     * @return array
     */
    public function findAll() {
        $this->setData();
        return $this->data;
    }
    
    /**
     * Data dataжӦĻֵ
     */
    private function setData() {
        if(!$this->data) {
            //$sql = "select id,way_alias,package_id,score from $this->table";
            $sql = SqlCombinHelper::select_sql($this->table, $this->fields, "");
            //print_r($this->dbback->GetAll($sql));
            $res = $this->dbback->GetAll($sql);
            if($res) {
                $this->data = $res;
            } else {
                $this->data = array();
            }
        }
    }

    /**
     * Զӵֶַ
     * @return string
     */
    private function fields() {
        return implode(',', $this->fields);
    }
    /**
     * ñ
     * @return string 
     */
    public function getTableName() {
        return $this->table;
    }
    
    /**
     * ֵ
     * @param array $fields
     * @return boolean
     */
    public function save($fields) {
        $keys = array_keys($fields);
        if(array_key_exists('score', $fields)) {
            $score = $fields['score'];
            //$sql = "replace into $this->table (".  implode(",", $keys).") value ('".  implode("','", $fields)."')";
            $sql = "insert into $this->table (".  implode(",", $keys).") value ('".  implode("','", $fields)."') ON DUPLICATE KEY UPDATE score='$score'";
            if($this->db->execute($sql)) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
        
    }
}

?>
