<?php



/**
 * Description of GrowthBid
 *
 * @author user
 */
class GrowthBid {
    /**
     *
     * @var TINY_ADODB ݿ
     */
    public $db;
    /**
     *
     * @var TINY_ADODB ݿ
     */
    public $dbback;
    /**
     *
     * @var Memcache 
     */
    public $mc;
    /**
     *
     * @var string 
     */
    public $table;
    /**
     *
     * @var ֶ 
     */
    public $fields;
    
    /**
     * ʼ
     * @param string $table ĬΪgrowth_bid_periods
     */
    public function __construct($table = '') {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->mc = $container->get('mc');
        $this->table = $table;
        $this->mc = $container->get('mc');
        $sqlfield = "DESC $this->table";
        $fieldsMKey = $sqlfield;
        $this->fields = $this->mc->get($fieldsMKey);
        if($this->fields === false) {
            $fields = $this->dbback->getAll($sqlfield);
            foreach ($fields as $field) {
                $this->fields[] = $field['Field'];
            }
            $this->mc->set($fieldsMKey, $this->fields, 3600);
        }
        $this->growthBidPeriods = new GrowthBidPeriods();
    }
    
    public function findByPeriodsId($bid) {
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, "bid_periods_id='$bid'");
        return $this->dbback->GetAll($sql);
    }
    
    public function findByBlockId($blockId) {
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields,"block_id='$blockId'");
        return $this->dbback->GetAll($sql);
    }
    
    public function findOneBy($conf,$order='') {
        $res = $this->findBy($conf, $order, 'limit 0,1');
        if($res) {
            return $res[0];
        } else {
            return array();
        }
    }
    
    public function findById($bidId) {
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields,"id='$bidId'");
        return $this->dbback->GetRow($sql);
    }
    
    public function findBy($conf,$order = '',$limit = '') {
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields,$conf);
        if($order) {
            $orderByString = SqlCombinHelper::orderby($order);
            $sql .= " ".$orderByString;
        }
        if($limit) {
            $sql .= " ".$limit;
        }
        return $this->dbback->GetAll($sql);
    }
    
    public function findNumberBy($conf) {
        $sql = SqlCombinHelper::count_sql($this->table, $conf);
        return $this->dbback->GetOne($sql);
    }
    
    public function insert($fieldData) {
        $sql = SqlCombinHelper::insert_sql($this->table, $fieldData);
        $this->db->Execute($sql);
        return $this->db->Insert_ID();
    }

    public function insertMutl($fieldsData) {
        $sql = SqlCombinHelper::insertMutil_sql($this->table, $fieldsData);
        $this->db->Execute($sql);
        return $this->db->Affected_Rows();
        //return $this->db->Insert_ID();
    }

    public function getStatus($bid) {
        
    }
    
    public function stop($bid) {
        $strWhere = "id='$bid'";
        $sql = SqlCombinHelper::update_sql($this->table, array('valid'=>0), $strWhere);
        $this->db->Execute($sql);
        return $this->db->Affected_Rows();
    }
    
    
    //ݾͶidȡһ¼
    public function findOneById($id) {
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, "id = $id");
        return $this->dbback->getRow($sql);
    }
    
    //ݾͶidȡͶڼid
    public function findPeriodsIdById($id) {
        $arrBidHouse = $this->findOneById($id);
        return $arrBidHouse['bid_periods_id'];
    }
    
    //ڴIdȡһ¼
    public function findPeriodsByPeriodsId($periodsId) {
        return $this->growthBidPeriods->findById($periodsId);
    }
    
    
    //ڴIdȡƹʱ
    public function findTgTimeByPeriodsId($periodsId) {
         return $this->growthBidPeriods->findTgTimeByPeriodsId($periodsId);
    }
    
    //ݾͶidȡƹʱ
    public function findTgTimeByBidId($id) {
        $periodsId = $this->findPeriodsIdById($id);
        return $this->findTgTimeByPeriodsId($periodsId);
    }
    
    /**
     * ӾͶ
     * @param int $bidId Ͷid
     * @param int $number ҪӵĲμӾͶ
     * @return type
     */
    public function addJoinNumber($bidId,$number=1) {
        $sql = SqlCombinHelper::updateSelf_sql($this->table, array("number"=>1), "id='$bidId'");
        return $this->db->Execute($sql);
    }
}
