<?php
/**
 * Դģ
 *
 * @author sun
 */
class House_template_xiao extends MY_Controller {
    
    /**
     * ʼطԴģҵ
     */
    public function __construct() 
    {
        parent::__construct();
        $this->load->model('house_template_model');
    }
   
    /**
     * Ⱦӡ޸ķԴģҳ
     * @param array $data_page ҳ
     */
    private function render_house_template($data_page = array())
    {
        //ͷ js
        $data_page['js'] = load_js('common/js/jquery.validate.min.js,'
                . 'common/js/jquery_ui_autocomplete/ui/jquery.ui.core.js,'
                . 'common/js/jquery_ui_autocomplete/ui/jquery.ui.position.js,'
                . 'common/js/jquery_ui_autocomplete/ui/jquery.ui.widget.js,'
                . 'common/js/jquery_ui_autocomplete/ui/jquery.ui.autocomplete.js');
        $data_page['css'] = load_css('zsb/css/v1.0/autocomlete_xiao.css,'
                . 'zsb/css/v1.0/style2.css');
        //ҳҪ
        $data_page['page_js'] = load_js('zsb/js/v1.0/house_xiao.js');
        $data_page['house'] = $this->config->item('house');
        //ģ
        $this->view('house_template', 'house_template_xiao', $data_page);
    }
    
    /**
     * ӷԴģҳ
     * @param string $module ģͣsellrent ĬΪsell
     */
    public function add($module = '')
    {
        //ҳ
        $module = $this->house_template_model->check_module($module);
        $data_page['module'] = $module;
        $data_page['module_name'] = $this->house_template_model->find_module_name($module);
        $data_page['method'] = 'add';
        $data_page['method_name'] = '';
        $data_page['url_manage'] = $this->house_template_model->find_func_url('manage');
        $data_page['action'] = $this->house_template_model->
                find_func_url('insert') . $module;
        //Դʱģ
        $data_page['block_name'] = $this->input->post('t_blockname');
        $data_page['block_id'] = $this->input->post('t_block_id');
        $data_page['district'] = $this->input->post('t_district');
        $data_page['street'] = $this->input->post('t_street');
        $data_page['address'] = $this->input->post('t_blockaddress');
        $data_page['remark'] = $this->input->post('t_remark');
        $data_page['page_title'] = 'Դ-' . $data_page['method_name'] 
                . $data_page['module_name'] . 'Դģ';
         $data_page['documentation'] = $this->config->item('documentation');//ĵ
        $this->render_house_template($data_page);
    }
    
    /**
     * 淿ԴģϢ
     * ܵĲ ģƣСƣСţͣϸ
     * ֤ģǷ񳬹ޡģǷظ
     * @return bollean ɹתģбҳ
     */
    public function insert()
    {
        //ǰĸģ
        $module = $this->input->post('module');
        //ɹ󷵻ģбҳ
        $url_manage_module = $this->house_template_model->
                find_func_url('manage') . $module . '/';
        //жϲЧ ģơԴСΪ
        if (ltrim($this->input->post('template_name') == '') 
                || ltrim($this->input->post('blockshowname')) == ''
                || ltrim($this->input->post('remark')) == '')
        {
            //תҳ
            $this->jump($url_manage_module, 'ģơСϢͷԴΪ');
            return;
        }
        //жģĸûг
        $moudle_template_num = $this->house_template_model->find_count_by_module(
                $module, $this->user_arr['uid']);
        //ģ >= ģ
        if($moudle_template_num >= $this->house_template_model->template_num)
        {
            $page_text = $module == 'sell' ? 'Բĳ۷Դģ'
                    . '뼰ʱɾҪģ壡' : 'ԲĳⷿԴģ'
                . '뼰ʱɾҪģ壡';
            $this->jump($url_manage_module, $page_text);
            return;
        }
        //װsql
        $template_info = array(
            'template_name' => ltrim($this->input->post('template_name')),
            'block_id'      => $this->input->post('block_id'),
            'block_name'    => $this->input->post('blockshowname'),
            'broker_id'     => $this->user_arr['uid'],
            'remark'        => $this->input->post('remark'),
            'update_time'   => time(),
            'flag'          => $this->house_template_model->flag($module),
        );
        //жͬģ
        $same_template_name_num = $this->house_template_model->find_count_by_name(
                $template_info['template_name'], $module, $this->user_arr['uid']);
        if ($same_template_name_num > 0)
        {
            $page_text = "ģѴ!";
        }
        else
        {
            //ģ 
            $insert_id = $this->house_template_model->insert($template_info);
            $page_text = $insert_id ? 'ģ汣ɹ!' : 'ģ汣ʧ!';
        }
        
        //תҳ
        $this->jump($url_manage_module, $page_text);
        return;
    }
    
    /**
     * ޸ķԴģҳ
     * ܲ id ģ
     * @param string $module ģͣsellrent ĬΪsell
     */
    public function modify($module = '', $id = '')
    {
        //޸ҳ
        $module = $this->house_template_model->check_module($module);
        if ($module == '' || $id == '') 
        {
            $this->jump($this->house_template_model->
                find_func_url('manage') . $module . '/', 'Ϸ', 3000);
            return;
        }
        $data_page['module'] = $module;
        $data_page['module_name'] = $this->house_template_model->find_module_name($module);
        $data_page['method'] = 'modify';
        $data_page['method_name'] = '޸';
        $data_page['url_manage'] = $this->house_template_model->find_func_url('manage');
        $data_page['action'] = $this->house_template_model->
                find_func_url('update') . $module;
        //ѯԴģϢ
        $template_detail = $this->house_template_model->find_by_id($id, 
                $this->user_arr['uid']);
        if ($template_detail)
        {
            $block_id = $template_detail['block_id'];
            $data_page['id'] = $template_detail['id'];
            $data_page['template_name'] = $template_detail['template_name'];
            $data_page['block_name'] = $template_detail['block_name'];
            $data_page['block_id'] = $block_id;
            $data_page['remark'] = $template_detail['remark'];
            $this->load->model('block_model');
            //СĻϢ
            $block_detail = $this->block_model->base_info_by_id($block_id);
            if ($block_detail)
            {
                $data_page['district'] = $block_detail['district'];
                $data_page['street'] = $block_detail['streetname'];
                $data_page['address'] = $block_detail['address'];
            }
            $data_page['documentation'] = $this->config->item('documentation');//ĵ
            $data_page['page_title'] = 'Դ-' . $data_page['method_name'] 
                                     . $data_page['module_name'] . 'Դģ';
            $this->render_house_template($data_page);
        } 
        else 
        {
            $this->jump($this->house_template_model->
                find_func_url('manage') . $module . '/');
        }
    }
    
    /**
     * ģϢ
     * ܵĲ ģƣСƣСţͣϸ
     * ֤ģǷظ
     * @return bollean ɹתģбҳ
     */
    public function update()
    {
        //ǰĸģ
        $module = $this->input->post('module');
        //ģ
        $id = $this->input->post('id');
        //ɹ󷵻ģбҳ
        $url_manage_module = $this->house_template_model->
                find_func_url('manage') . $module . '/';
        //жϲЧ ģơСͷԴΪ
        if (ltrim($this->input->post('template_name') == '') 
                || ltrim($this->input->post('blockshowname')) == ''
                || ltrim($this->input->post('remark')) == '')
        {
            //תҳ
            $this->jump($url_manage_module, 'ģơСϢͷԴΪ');
            return;
        }
        $url_manage_module = $this->house_template_model->
                find_func_url('manage') . $module;
        //װsql
        $template_info = array(
            'template_name' => ltrim($this->input->post('template_name')),
            'block_id'      => $this->input->post('block_id'),
            'block_name'    => $this->input->post('blockshowname'),
            'remark'        => $this->input->post('remark'),
            'update_time'   => time(),
            'flag'          => $this->house_template_model->flag($module),
        );
        //ѯǰԴģϢ
        $template_detail = $this->house_template_model->find_by_id($id, 
                $this->user_arr['uid']);
        //޸ķԴģ
        if ($template_detail['template_name'] != $template_info['template_name']) 
        {
            //жͬģ
            $same_template_name_num = $this->house_template_model->find_count_by_name(
                    $template_info['template_name'], $module, $this->user_arr['uid']);
            if ($same_template_name_num > 0)
            {
                $page_text = "ģѴ!";
                //תҳ
                $this->jump($url_manage_module, $page_text);
                return;
            } 
        }
        $affected_rows = $this->house_template_model->update($template_info, $id, 
                $this->user_arr['uid']);
        $page_text = $affected_rows > 0 ? 'ģ汣ɹ!' : 'ģ汣ʧ!';
        $this->jump($url_manage_module, $page_text);
    }
    
    /**
     * ɾԴģ
     * ܲ id ģ
     * @param string $module ģͣsellrent ĬΪsell
     */
    public function delete($module = '', $id = '')
    {
        $module = $this->house_template_model->check_module($module);
        if ($module == '' || $id == '') 
        {
            $this->jump($this->house_template_model->
                find_func_url('manage') . $module . '/', 'Ϸ', 3000);
            return;
        }
        $status = $this->house_template_model->delete($id, $this->user_arr['uid']);
        $page_text = $status ? 'ģɾɹ' : 'ģɾʧܡ';
        $this->jump($this->house_template_model->
                find_func_url('manage') . $module, $page_text);
    }
    
    /**
     * Դģ
     * @param string $module ģͣsellrent ĬΪsell
     */
    public function manage($module = '')
    {
        //ͷ
        $data_page['page_title'] = '۱';
        $data_page['css'] = load_css('zsb/css/v1.0/style2.css');
        //ҳҪ
        $module = $this->house_template_model->check_module($module);
        $data_page['module'] = $module;
        $data_page['module_name'] = $this->house_template_model->find_module_name($module);
        //ȡԴģб
        $data_page['array_template'] = $this->house_template_model->find_by_module($module, 
                $this->user_arr['uid']);
        //ģ
        $data_page['template_num'] = $this->house_template_model->
                find_count_by_module($module, $this->user_arr['uid']);
        //ۺͳķԴַ
        if ($module == 'sell')
        {
            $this->load->model('sell_model');
            $data_page['url_add_house'] = $this->sell_model->find_func_url('add');
        } 
        else 
        {
            $this->load->model('rent_model');
            $data_page['url_add_house'] = $this->rent_model->find_func_url('add');
        }
        //ӷԴģַ
        $data_page['url_add'] = $this->house_template_model
                ->find_func_url('add') . $module . '/';
        //޸ķԴģַ
        $data_page['url_modify'] = $this->house_template_model
                ->find_func_url('modify') . $module . '/';
        //ɾԴģַ
        $data_page['url_delete'] = $this->house_template_model->find_func_url('delete');   
        //ҳ
        $data_page['title'] = 'Դģ';  
        //۷Դģбַ
        $data_page['url_manage_sell'] = $this->house_template_model->
                find_func_url('manage') . 'sell/';   
        //ⷿԴģбַ
        $data_page['url_manage_rent'] = $this->house_template_model->
                find_func_url('manage') . 'rent/';   
        $data_page['page_title'] = 'Դ-Դģ';
        //ģ
        $this->view('house_template_manage', 'house_template_manage', $data_page);
    }
}
