<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
header("Content-type: text/html; charset=gb2312"); 
/**
 * ajax Class
 *
 * ajax
 *
 * @package     zsb
 * @subpackage      Controllers
 * @category        Controllers
 * @author      sun
 */
class Ajax extends MY_Controller {
    /**
    * 
    *
    * @access public
    * @return void
    */
    public function __construct()
    {   
        parent::__construct();
        if(!$this->input->is_ajax_request())
        {
           // echo 'Ƿ';
            //die();
        }
        $this->load->model('ajax_model');
		$this->load->helper('common_string');
    }
    
    //@todo
    public function index()
    {
        echo 'ֶ֤';
    }
    
    /**
     * СidŻȡϢ
     */
    public function find_block_detail()
    {
        $this->load->model('block_model');
        $id = $this->input->get('id');
        $block = $this->block_model->base_info_by_id($id);
        echo $this->ajax_model->array_to_json($block);
    }
    
    /**
     * СģȡСбϢ
     */
    public function find_like_block_list()
    {
        $this->load->model('block_model');
        $blockname = $this->input->post('blockname');
        $infotype = $this->input->post('infotype');
        $blockname = trim(iconv('UTF-8', 'gbk', rawurldecode($blockname)));
        //ҵΪסլܷС
        if( empty($infotype) || $infotype == 1 ){
            $block_list = $this->block_model->auto_blockname($blockname);
        }else{
            $block_list = $this->block_model->auto_blockname($blockname,20,array(0,1,2));
        }
        echo $this->ajax_model->array_to_json($block_list);
    }
    
    /**
     * ȡµİб
     */
    public function find_street_list()
    {
        $this->load->model('street_model');
        $district = $this->input->get('district');
        $district = iconv("utf-8","gb2312", urldecode($district));
        echo $this->street_model->street_html_by_district($district);
    }
    
    /**
     * ʱС
     */
    public function add_temp_block()
    {
        $blockname = iconv("utf-8","gb2312",$this->input->get('tcblockname'));
        $blockaddress = iconv("utf-8","gb2312",$this->input->get('tcaddress'));
        $district = iconv("utf-8","gb2312",$this->input->get('tcdistrict'));
        $streetid = $this->input->get('tcstreetid');
        $this->load->model('block_model');
        $result = $this->block_model->add_temp_block($blockname, $blockaddress, 
                $district, $streetid, $this->user_arr);
        echo $this->ajax_model->array_to_json($result);
    }
    
    /**
     * жϷԴģǷѾ
     */
    public function exist_templatename()
    {
        $moudle = $this->input->get('module');
        $templatename = mb_convert_encoding(urldecode(
                $this->input->get('templatename')),"gb2312","utf-8");
        $this->load->model('house_template_model');
        $num = $this->house_template_model->find_count_by_name($templatename, 
                $moudle, $this->user_arr['uid']);
        // 1 Ѵͬģ 0 û
        echo $num > 0 ? 1 : 0;
    }
    
    /**
     * ݷԴģŻȡϸϢ
     */
    public function find_module_detail()
    {
        $id = $this->input->get('id');
        $this->load->model('house_template_model');
        $detail = $this->house_template_model->find_by_id($id, $this->user_arr['uid']);
        $this->load->model('block_model');
        $block_detail = $this->block_model->base_info_by_id($detail['block_id']);
        $detail['district'] = $block_detail['district'];
        $detail['street'] = $block_detail['streetname'];
        $detail['address'] = $block_detail['address'];
        $detail['averprice'] = $block_detail['averprice'];
        $detail['esta_block'] = $block_detail['esta_block'];
        $detail['url_block'] = $block_detail['url_block'];
        echo $this->ajax_model->array_to_json($detail);
    }
    
    /**
     * ͬҵͻȡӦĲϢ
     */
    public function find_house_add_ext()
    {
        $data = array();
        $infotype = $this->input->get('infotype');
        $house_id = $this->input->get('house_id');
        $tbl = $this->input->get('tbl');
        $data['infotype'] = $infotype;
        $data['house'] = $this->config->item('house');
        $broker_info =$this->broker_model->get_broker_info();
        $data['real_status'] = $broker_info['real_status'];

        $packageId = $this->user_arr['package_id'];
        $this->load->model('real_house_model');
        $realNumLimit =$this->broker_model->get_realnum_by_packageid($packageId);
        $data['realNumLimit'] = $realNumLimit;  //ײͿɷ淿Դ
        $data['realHouseNum']= $this->real_house_model->getUidRealHouseNum($this->user_arr['uid']); // ѷ淿Դ

        $data['balance']= $this->real_house_model->getBrokerRealHouseMoney($this->user_arr['uid']);//˺
        if($house_id){
            $this->load->model('sell_model');
            $data['house_detail'] = $this->sell_model->find_by_uid_id($this->user_arr['uid'], $house_id);
        }
        $data['house_detail']['realNumLimit'] =$data['realNumLimit'] ;
        $data['house_detail']['realHouseNum'] =$data['realHouseNum'] ;

        $data['rent_allow_release'] = 1;
        if(GB_CITY == 'nj'){
            $this->load->model('broker_model');
            $rent_allow_release = $this->broker_model->rent_allow_release($infotype);
            $data['rent_allow_release'] = $rent_allow_release;
            $data['rent_allow_release_alert'] = $this->config->item('rent_allow_release');
        }
        echo $this->load->view($tbl . '_add_ext', $data, TRUE);
    }
    
    /**
     * ȡСͼ
     */
    public function find_block_img()
    {

        $blockname = iconv('UTF-8','GBK',urldecode($this->input->get('blockname')));

        $room = intval($this->input->get('room'));
        $hall = intval($this->input->get('hall'));
        $page = intval($this->input->get('page'));
        $page = intval($page)?intval($page):1;
        $perpage = 10;
        $offset =($page-1)*$perpage;
        $num = 0;
        $this->load->model('block_model');

        if(!($room == 0 && $hall == 0))
        {

            //ƼͼƬֻʾ365ͼԺͼƬ
            $this->block_model->set_select_fields(array('bi.id','bi.bi_img'));
            $imgs = $this->block_model->find_room_img($blockname, $room, $hall, $perpage, $offset);

            $num = $this->block_model->find_room_img_count($blockname, $room, $hall);
            $sort = 9;//ͼ 0
        }
        else
        {

            //ƼͼƬֻʾ365ͼԺͼƬ
            $this->block_model->set_select_fields(array('bi.id','bi.bi_img'));
            $imgs = $this->block_model->find_outdoor_img($blockname, $perpage, $offset);
            $num = $this->block_model->find_outdoor_img_count($blockname);
            $sort = 10;//⾰ͼ 1
        }
        $pages = ceil($num/$perpage);  //ҳ
        if($num > 0)
        {
            $ss = '';
            foreach($imgs as $img)
			{
                //$img['big_img'] = str_replace("/thumb","",$img['bi_img']);
                $img['big_img'] = pic_thumbTobig($img['bi_img']);
                $ss .= '<div class="item"><div class="itemInner">
                        <div class="pic"><img alt="" id="' . $img['id'] .'" src="'
                        . $img['bi_img'] . '" width="130" height="100" num="' . $img['id'] 
                        . '" /></div><div class="btn" title="ѡ"></div><a href="' 
                        . $img['big_img'] . '" target="_balnk" title="鿴ͼ" class="bigPicLin">鿴ͼ</a>
                    </div>
                </div>';
            }
            $pagenavi = zsb_pagenavi_ajax($page,$pages, 'getBlockImg');
            if(!($room == 0 && $hall == 0))
            {
                $ss .= '<input type="hidden" name="pic_num1" value="' . $num 
                        . '" id="pic_num1"></div>';
            }
            else
            {
                $ss .= '<input type="hidden" name="pic_num" value="' . $num 
                        . '" id="pic_num"></div>';
            }
            if($pagenavi){
                $ss .= "<div class='picPreviewPag clear'>";
                $ss .= $pagenavi;
                $ss .= "</div>";
            }
            echo $ss;
        }
    }
    
    //Դɫ
    public function find_housefeature() 
    {
        $tbl = $this->input->get('tbl');
        $infotype = $this->input->get('infotype');
        $this->load->model('house_feature');
        $arr = $this->house_feature->find_feature($tbl, $infotype);
        $ss = '';
		if(is_array($arr) && !empty($arr))
	    {
			foreach($arr as $k => $val)
			{
                $ss .= '<p num="' . $k . '" class="addTagInner radius4">'
                . $val . '</p>';
			}
		}
        echo $ss;
    }

	 //Դɫ
    public function find_infotype_rent() 
    {
        $infotype = $this->input->get('infotype');
		if(empty($infotype))
		{
			$infotype=1;
		}
        echo $infotype;
    }

	//Դɫ
    public function find_housefeature_test() 
    {
        $tbl = $this->input->get('tbl');
        $infotype = $this->input->get('infotype');
        $this->load->model('house_feature_test');
        $arr = $this->house_feature_test->find_feature($tbl, $infotype);
        $ss = '';
		if(is_array($arr) && !empty($arr))
	    {
			foreach($arr as $k => $val)
			{
                $ss .= '<p num="' . $k . '" class="addTagInner radius4">'
                . $val . '</p>';
			}
		}
        echo $ss;
    }
    
    /**
    * ȡݷԴŻȡĳַԴϢ
    * 
    * @access private
    * @param  int $uid ˺
    * @param  int $rowid Դ
    * @param  array $select_fields Ҫѯֶ
    * @return array ԴϢ
    */
    private function _get_sellinfo_by_id( $uid , $rowid ,$select_fields = array())
    {   
        $sellinfo = array();
        
        //˺ű
        $uid = intval( $uid );
        
        //Դ
        $rowid = intval( $rowid );

        //سmodel
        $this->load->model('sell_model');
        
        //òѯֶ
        if( is_array( $select_fields ) && !empty( $select_fields ) )
        {
            $this->sell_model->set_select_fields( $select_fields );
        }
        
        //ѯԴϢ
        $sellinfo = $this->sell_model->find_by_uid_id( $uid , $rowid );
        
        return  $sellinfo;
    }
    
	
    /**
    * ȡݷԴŻȡĳⷿԴϢ
    * 
    * @access private
    * @param  int $uid ˺
    * @param  int $rowid Դ
    * @param  array $select_fields Ҫѯֶ
    * @return array ԴϢ
    */
    private function _get_rentinfo_by_id( $uid , $rowid , $select_fields = array())
    {   
        $rentinfo = array();
        
        //˺ű
        $uid = intval( $uid );
        
        //Դ
        $rowid = intval( $rowid );
        
        //سmodel
        $this->load->model('rent_model');
        
        //òѯֶ
        if(is_array($select_fields) && !empty($select_fields))
        {
            $this->rent_model->set_select_fields($select_fields);
        }
        
        //ѯԴϢ
        $rentinfo = $this->rent_model->find_by_uid_id( $uid , $rowid );
        
        return  $rentinfo;
    }
    
    
   /**
    * ݸϢŻȡķԴ
    * 
    * @access pubic
    * @return json ԴϢ
    */
    public function get_houselist_by_wantid()
    {   
        $page = $this->input->get('page');
        $want_id = $this->input->get('want_id');
       
        //ȡϢ
        $demand_info = array();
        $this->load->model('buy_demand_model');
        
        //òѯֶ
        $select_field = array('id','street','street1','street2','buildarea1'
                    ,'buildarea2','price1','price2','buildyear1','buildyear1');
        $this->buy_demand_model->set_search_fields($select_field);
        
        //ȡϢ
        $this->buy_demand_model->set_id($want_id);
        $demand_info = $this->buy_demand_model->get_info_by_id();
        
        //Ϣѯþ˷ķԴ
        if(is_array($demand_info) && !empty($demand_info))
        {   
            //˱
            $uid = $this->user_arr['uid'];
            $cond_where = "uid = '".$uid."' AND esta = 1 AND infofrom = '5' ";
            
            $street_ids = '';
            if( isset ($demand_info['street']) && $demand_info['street'] > 0 )
            {
                $street_ids .= $demand_info['street'];
            }

            if( isset ($demand_info['street1']) && $demand_info['street1'] > 0 )
            {
                $street_ids .= ','.$demand_info['street1'];
            }

            if( isset ($demand_info['street2']) && $demand_info['street2'] > 0 )
            {
                $street_ids .= ','.$demand_info['street2'];
            }
            $cond_where .= " AND streetid IN(".$street_ids.")";
            
            
            //˧ѡ
            if( isset ($demand_info['buildarea1']) && isset ($demand_info['buildarea2']) 
                && $demand_info['buildarea1'] >= 0 && $demand_info['buildarea2'] > 0 )
            {
                $cond_where .= " AND buildarea >= ".$demand_info['buildarea1']." "
                        . "AND buildarea <= ".$demand_info['buildarea2'] ;
            }

            //۸ɸѡ
            if( isset ($demand_info['price1']) && isset ($demand_info['price2']) 
                && $demand_info['price1'] >= 0 && $demand_info['price2'] > 0 )
            {
                $cond_where .= " AND price >= ".$demand_info['price1']." AND price <= ".$demand_info['price2'] ;
            }

            //˧ѡ
            if( isset ($demand_info['buildyear1']) && isset ($demand_info['buildyear2']) 
                && $demand_info['buildyear1'] >= 0 && $demand_info['buildyear2'] > 0 )
            {
                $cond_where .= " AND buildyear >= ".$demand_info['buildyear1']." AND buildyear <= ".$demand_info['buildyear2'] ;
            }
            
            
            //ضַģ
            $this->load->model('sell_model');

            //òѯֶ
            $house_fields = array( 'id' , 'infotype' , 'address' , 'buildarea' 
                          , 'price' , 'buildyear');
            $this->sell_model->set_select_fields( $house_fields );
            
            //ѯ
            $num_rows = $this->sell_model->find_count_by( $cond_where );
            
            $perpage_num = 4;
            $num_rows = intval( $num_rows );
            $total_page = ceil( $num_rows / $perpage_num );

            if( $page != '' && $page > $total_page )
            {
                $page = $total_page;
            }

            if( $page == '' ||  $page == 0 )
            {
                $page = 1;
            }
            $offset = ( $page - 1 ) * $perpage_num;

            //ѯԴϢ
            $sellinfo = $this->sell_model->find_all_by( $cond_where , $offset , $perpage_num );
        }
        
        if( is_array ($sellinfo) && !empty($sellinfo) )
        {   
            $house = $this->config->item('house');
            $this->load->helper('common_string');
            foreach($sellinfo as $key => $value )
            {   
                $sellinfo[$key]['infotype_str'] = isset($house['infotype'][$sellinfo[$key]['infotype']]) 
                        ? $house['infotype'][$sellinfo[$key]['infotype']] : 'δ֪';
                
                $sellinfo[$key]['buildarea'] = strip_end_0( $sellinfo[$key]['buildarea'] );
                $sellinfo[$key]['price'] = strip_end_0($sellinfo[$key]['price']);
                
            }
            $data_info['total_page'] = $total_page;
            $data_info['house_info'] = $sellinfo;
        }
        else
        {
            $data_info['total_page'] = 0;
            $data_info['house_info'] = array();
        }
        
        echo $this->ajax_model->array_to_json($data_info);
    }
    
    
    /**
    * ݸϢŻȡķԴ
    * 
    * @access pubic
    * @return json ԴϢ
    */
    public function get_renthouselist_by_wantid()
    {   
        $page = $this->input->get('page');
        $want_id = $this->input->get('want_id');
       
        //ȡϢ
        $demand_info = array();
        $this->load->model('rent_demand_model');
        
        //òѯֶ
        $select_field = array('id','street','street1','street2','buildarea1'
                    ,'buildarea2','price1','price2','renttype');
        $this->rent_demand_model->set_search_fields($select_field);
        
        //ȡϢ
        $this->rent_demand_model->set_id($want_id);
        $demand_info = $this->rent_demand_model->get_info_by_id();
        
        //Ϣѯþ˷ķԴ
        if(is_array($demand_info) && !empty($demand_info))
        {   
            //˱
            $uid = $this->user_arr['uid'];
            $cond_where = "uid = '".$uid."' AND esta = 1 AND infofrom = '5' ";
            
            $street_ids = '';
            if( isset ($demand_info['street']) && $demand_info['street'] > 0 )
            {
                $street_ids .= $demand_info['street'];
            }

            if( isset ($demand_info['street1']) && $demand_info['street1'] > 0 )
            {
                $street_ids .= ','.$demand_info['street1'];
            }

            if( isset ($demand_info['street2']) && $demand_info['street2'] > 0 )
            {
                $street_ids .= ','.$demand_info['street2'];
            }
            $cond_where .= " AND streetid IN(".$street_ids.")";
            
            
            //˧ѡ
            if( isset ($demand_info['buildarea1']) && isset ($demand_info['buildarea2']) 
                && $demand_info['buildarea1'] >= 0 && $demand_info['buildarea2'] > 0 )
            {
                $cond_where .= " AND buildarea >= ".$demand_info['buildarea1']." "
                        . "AND buildarea <= ".$demand_info['buildarea2'] ;
            }

            //۸ɸѡ
            if( isset ($demand_info['price1']) && isset ($demand_info['price2']) 
                && $demand_info['price1'] >= 0 && $demand_info['price2'] > 0 )
            {
                $cond_where .= " AND price >= ".$demand_info['price1']." AND price <= ".$demand_info['price2'] ;
            }

            //޷ʽ
            /*if( isset ($demand_info['renttype']) && isset ($demand_info['renttype']))
              {
                $cond_where .= " AND renttype = '".$demand_info['renttype']."'" ;
               }*/
            
            
            //ضַģ
            $this->load->model('rent_model');

            //òѯֶ
            $house_fields = array( 'id' , 'infotype' , 'address' , 'buildarea' 
                          , 'price' , 'renttype');
            $this->rent_model->set_select_fields( $house_fields );
            
            //ѯ
            $num_rows = $this->rent_model->find_count_by( $cond_where );
            
            $perpage_num = 4;
            $num_rows = intval( $num_rows );
            $total_page = ceil( $num_rows / $perpage_num );

            if( $page != '' && $page > $total_page )
            {
                $page = $total_page;
            }

            if( $page == '' ||  $page == 0 )
            {
                $page = 1;
            }
            $offset = ( $page - 1 ) * $perpage_num;

            //ѯԴϢ
            $sellinfo = $this->rent_model->find_all_by( $cond_where , $offset , $perpage_num );
        }
        
        if( is_array ($sellinfo) && !empty($sellinfo) )
        {   
            $house = $this->config->item('house');
            $this->load->helper('common_string');
            foreach($sellinfo as $key => $value )
            {   
                $sellinfo[$key]['infotype_str'] = isset($house['infotype'][$sellinfo[$key]['infotype']]) 
                        ? $house['infotype'][$sellinfo[$key]['infotype']] : 'δ֪';
                
                $sellinfo[$key]['buildarea'] = strip_end_0( $sellinfo[$key]['buildarea'] );
                $sellinfo[$key]['price'] = strip_end_0($sellinfo[$key]['price']);
                
            }
            $data_info['total_page'] = $total_page;
            $data_info['house_info'] = $sellinfo;
        }
        else
        {
            $data_info['total_page'] = 0;
            $data_info['house_info'] = array();
        }
        
        echo $this->ajax_model->array_to_json($data_info);
    }
    
    
    /**
    * Ϣţȡƥ䷿ԴϢ
    * 
    * @access pubic
    * @return json ԴϢ
    */
    public function get_sell_details_matched( )
    {   
        $rowid_arr = array();
        
        //Ϣ
        $wantid = $this->input->get('wantid');
        
        //˱
        $uid = $this->user_arr['uid'];
        
       //ƥϢķԴ
       $this->load->model('buy_match_model');
       
       $this->buy_match_model->set_want_id($wantid);
       $this->buy_match_model->set_match_uid($uid);
       $matched_info = $this->buy_match_model->get_rowid_by_matchuid( 5 );

       $sellinfo = array();
       if( is_array ($matched_info) && !empty($matched_info) 
           && isset($matched_info['match_id']) &&  $matched_info['match_id'] > 0)
       {   
           $rowid = $matched_info['match_id'];
           $select_fields = array( 'id' , 'address' , 'infotype' 
                            , 'streetid' , 'buildarea' , 'price' , 'buildyear' );
           $sellinfo = $this->_get_sellinfo_by_id( $uid , $rowid , $select_fields);
       }

       if( is_array( $sellinfo ) && !empty( $sellinfo ) )
       {    
           $this->load->helper('common_url_helper');
           $house = $this->config->item('house');
           $sellinfo['info_url'] = get_sellinfo_url($sellinfo['id']);
           $sellinfo['infotype'] = isset($house['infotype'][$sellinfo['infotype']]) 
                            ? $house['infotype'][$sellinfo['infotype']] : '';
       }
       else 
       {
           $sellinfo['id'] = 0; 
       }
       
       echo $this->ajax_model->array_to_json($sellinfo);
    }
    
    
    /**
    * Ϣţȡƥ䷿ԴϢ
    * 
    * @access pubic
    * @return json ԴϢ
    */
    public function get_rent_details_matched( )
    {   
        $rowid_arr = array();
        
        //Ϣ
        $wantid = $this->input->get('wantid');
        
        //˱
        $uid = $this->user_arr['uid'];
        
       //ƥϢķԴ
       $this->load->model('rent_match_model');
       
       $this->rent_match_model->set_want_id($wantid);
       $this->rent_match_model->set_match_uid($uid);
       $matched_info = $this->rent_match_model->get_rowid_by_matchuid( 5 );

       $rentinfo = array();
       if( is_array ($matched_info) && !empty($matched_info) 
           && isset($matched_info['match_id']) &&  $matched_info['match_id'] > 0)
       {   
           $rowid = $matched_info['match_id'];
           $select_fields = array( 'id' , 'address' , 'infotype' 
                            , 'streetid' , 'buildarea' , 'price' , 'renttype' );
           $rentinfo = $this->_get_rentinfo_by_id( $uid , $rowid , $select_fields);
       }

       if( is_array( $rentinfo ) && !empty( $rentinfo ) )
       {    
           $this->load->helper('common_url_helper');
           $house = $this->config->item('house');
           $rentinfo['info_url'] = get_rentinfo_url($rentinfo['id']);
           $rentinfo['infotype'] = isset($house['infotype'][$rentinfo['infotype']]) 
                            ? $house['infotype'][$rentinfo['infotype']] : '';
       }
       else 
       {
           $rentinfo['id'] = 0; 
       }
       
       echo $this->ajax_model->array_to_json($rentinfo);
    }
    
    
    /**
    * ͨѡеķԴƥϢ
    * 
    * @access pubic
    * @return json ԴϢ
    */
    function match_buy_demand_by_rowid()
    {
        //Ϣ
        $want_id = $this->input->get('want_id');
        
        //ƥľ˷ԴID
        $match_id = $this->input->get('rowid');
        
        //ƥ侭˺ű
        $match_uid = $this->user_arr['uid'];
        
        $msg_result = 'error';
        $start_time = strtotime(date('Y-m-d'));
        $now_time = intval (date( 'His' , time())); //ǰʱ

        //Ϣƥ
        $fields_arr = array('uid','infotype','street','street1','street2','address'
                    ,'buildyear1','buildyear2', 'buildarea1','buildarea2'
                    ,'price1','price2','creattime');

        //ԴϢ
        $house_fields_arr = array('infotype','streetid','buildarea','price','buildyear');

        $subject = 'Ϣµƥ䷿Դ';
         $msg = 'Ϣ%sµķԴƥɹ'
                . '<a href="http://www.house365.com/center/want/buylist" target="_blank">鿴</a>';
        
        //ʼƥ
        if( $match_id > 0 && $match_uid > 0 && $want_id > 0 )
        {   
            //ѯϢ
            $requirement_info = array();
            $this->load->model('buy_demand_model');
            //ŻȡϢ
            $this->buy_demand_model->set_id($want_id);
            $this->buy_demand_model->set_search_fields($fields_arr);
            $requirement_info = $this->buy_demand_model->get_info_by_id();
            
            //жǷ
            if( !is_array($requirement_info) || empty($requirement_info))
            {
                $msg_result = 'demand_no_exisit';
                echo $msg_result;
                exit;
            }
            
            $want_uid = $requirement_info['uid'];
            
            //ƥ
            $match_info = array();
            $this->load->model('buy_match_model');
            //ŻȡƥϢ
            $this->buy_match_model->set_want_id( $want_id );
            $matched_num = $this->buy_match_model->get_count_by_wantid( 5 );
            
            if( $matched_num > 0)
            {
                $match_info = $this->buy_match_model->get_list_by_wantid( 5 , 0 , $matched_num );
            }
            
            //Ϣܹƥ
            $total_match_num = count( $match_info );
            
            //Ϣƥ
            $today_match_num = 0;
            
            //Ϣ˺ƥ
            $my_match_num = 0;

            //Ϣʱ
            $publish_time = intval(date('His' , $requirement_info['creattime']));

            //ÿϢƥʱͱƥ俪ʼڵ
            if( $now_time < $publish_time )
            {
                $start_time_str = date( 'Y-m-d' , time() - 86400 ).''
                        . ' '.date('H:i:s' , $requirement_info['creattime']);
            }
            else
            {
                $start_time_str = date( 'Y-m-d' , time() ).''
                        . ' '.date('H:i:s' ,$requirement_info['creattime']);
            }

            //ֿʼʱڵ
            $start_time = strtotime( $start_time_str );

            //ƥ
            for( $i = 0 ; $i < $total_match_num ; $i++ )
            {
                //ƥ
                if( $match_info[$i]['creattime'] >= $start_time )
                {
                    $today_match_num ++;
                }

                //ƥ
                if( $match_info[$i]['match_uid'] == $match_uid )
                {
                    $my_match_num ++;
                }
            }

            //
            if( $total_match_num >= 200)
            {
                $msg_result = 'total_limit_error';
                echo $msg_result;
                exit;
            }

            //
            if( $today_match_num >= 20)
            {
                $msg_result = 'day_limit_error';
                echo $msg_result;
                exit;
            }

            //ظƥ֤
            if( $my_match_num >= 1)
            {
                $msg_result = 'my_limit_error';
                echo $msg_result;
                exit;
            }

            /*ƥ䷿ԴϢǷ֤Ϣ*/
            $house_fields_str = '';
            foreach( $house_fields_arr as $key => $value)
            {
                $house_fields_str .= $house_fields_str != '' ? ','.$value : $value;
            }

            //׼ƥķԴϢ
            $match_info = $this->_get_sellinfo_by_id( $match_uid , $match_id , $house_fields_arr);
            
            //Դ֤
            $infotype = $match_info['infotype'];
            if( $infotype != $requirement_info['infotype'] )
            {
                if( $requirement_info['infotype'] != 6 && $infotype != 5  )
                {
                    $msg_result = 'infotype_error';
                    echo $msg_result;
                    exit;
                }
            }

            //ƥֵ
            $street_id = intval($match_info['streetid']);
            $require_street[0] = intval( $requirement_info['street'] );
            $require_street[1] = intval( $requirement_info['street1'] );
            $require_street[2] = intval( $requirement_info['street2'] );
            
            if( $street_id == 0 || !in_array($street_id , $require_street))
            {
                $msg_result = 'street_error';
                echo $msg_result;
                exit;
            }

            //ƥbuildarea
            $buildarea = intval($match_info['buildarea']);
            if( $buildarea < $requirement_info['buildarea1'] 
                    || $buildarea > $requirement_info['buildarea2'] )
            {
                $msg_result = 'buildarea_error';
                echo $msg_result;
                exit;
            }

            //ƥbuildyear
            $buildyear = intval( $match_info['buildyear'] );
            if( in_array(array('buildyear1','buildyear2'), $fields_arr ) 
                    && ($buildyear < $requirement_info['buildyear1'] 
                    || $buildyear > $requirement_info['buildyear2']) )
            {
                $msg_result = 'buildyear_error';
                echo $msg_result;
                exit;
            }

            //ƥprice
            $price = intval($match_info['price']);
            if( $price < $requirement_info['price1'] || $price > $requirement_info['price2'] )
            {
                $msg_result = 'price_error';
                echo $msg_result;
                exit;
            }

            $tt = array();
            $tt['match_id'] = $match_id;
            $tt['match_uid'] = $match_uid;
            $tt['want_id']  = $want_id;
            $tt['want_uid'] = $want_uid;
            $tt['infofrom'] = 5; //н
            $tt['esta']     = 0; //ƥ״̬
            $tt['isread']   = 0; //ǷѾ鿴
            $tt['creattime'] = time();
            
            //(ƥ䷿Դ۳)
            $arrBroker = $arrBroker = array(
                'id' => $match_uid,
                'groupid' => $this->user_arr['package_id'],
            );
            
            $gbc  = new GrowthBrokerCredit($arrBroker); 
            $inCreditStatus = $gbc->reduce('matchBuy');

            //
            if( is_array($inCreditStatus) && $inCreditStatus['status'] == 1 )
            {   
                //ƥϢ
                $result = $this->buy_match_model->add_match_info($tt);

                if( $result )
                {   
                    //޸ⷿԴƥ
                    $update_arr = array('matched_num' => '`matched_num` + 1');
                    $up_result = $this->buy_demand_model->update_info_by_id( $update_arr , FALSE);

                    //վ
                    if( $up_result === TRUE)
                    {
                        $subject = urlencode($subject);
                        $msg = urlencode(sprintf($msg,$requirement_info['address']));
                        $ulr = 'http://www.house365.com/center';
                        $param = '/esf_center_api/api_sendmessage?uid='.$want_uid.''
                                . '&msg='.$msg.'&subject='.$subject.'&city=nj';
                        curl_get_contents( $ulr . $param );
                    }
  
                    $msg_result = 'sucess';
                }
                else
                {
                    $msg_result = 'insert_error';
                }
            }
            else
            {
                $msg_result = 'credit_not_enough_error';
            }
        }
        else
        {
            $msg_result = 'info_error';
        }

        echo $msg_result;
        exit;
    }
    
    
   /**
    * ͨѡеķԴƥϢ
    * 
    * @access pubic
    * @return json ԴϢ
    */
    function match_rent_demand_by_rowid()
    {
        //Ϣ
        $want_id = $this->input->get('want_id');
        
        //ƥľ˷ԴID
        $match_id = $this->input->get('rowid');
        
        //ƥ侭˺ű
        $match_uid = $this->user_arr['uid'];
        
        $msg_result = 'error';
        $start_time = strtotime(date('Y-m-d'));
        $now_time = intval (date( 'His' , time())); //ǰʱ

        //Ϣƥ
        $fields_arr = array('uid','infotype','street','street1','street2','address',
                        'buildarea1','buildarea2','price1','price2','renttype','creattime');

        //ԴϢ
        $house_fields_arr = array('infotype','streetid','buildarea','price','renttype');

        $subject = 'Ϣµƥ䷿Դ';
         $msg = 'Ϣ%sµķԴƥɹ'
                . '<a href="http://www.house365.com/center/want/rentlist" target="_blank">鿴</a>';
        
        //ʼƥ
        if( $match_id > 0 && $match_uid > 0 && $want_id > 0 )
        {   
            //ѯϢ
            $requirement_info = array();
            $this->load->model('rent_demand_model');
            //ŻȡϢ
            $this->rent_demand_model->set_id($want_id);
            $this->rent_demand_model->set_search_fields($fields_arr);
            $requirement_info = $this->rent_demand_model->get_info_by_id();
            
            //жǷ
            if( !is_array($requirement_info) || empty($requirement_info))
            {
                $msg_result = 'demand_no_exisit';
                echo $msg_result;
                exit;
            }
            
            $want_uid = $requirement_info['uid'];
            
            //ƥ
            $match_info = array();
            $this->load->model('rent_match_model');
            //ŻȡƥϢ
            $this->rent_match_model->set_want_id( $want_id );
            $matched_num = $this->rent_match_model->get_count_by_wantid( 5 );
            
            if( $matched_num > 0)
            {
                $match_info = $this->rent_match_model->get_list_by_wantid( 5 , 0 , $matched_num );
            }
            
            //Ϣܹƥ
            $total_match_num = count( $match_info );
            
            //Ϣƥ
            $today_match_num = 0;
            
            //Ϣ˺ƥ
            $my_match_num = 0;

            //Ϣʱ
            $publish_time = intval(date('His' , $requirement_info['creattime']));

            //ÿϢƥʱͱƥ俪ʼڵ
            if( $now_time < $publish_time )
            {
                $start_time_str = date( 'Y-m-d' , time() - 86400 ).''
                        . ' '.date('H:i:s' , $requirement_info['creattime']);
            }
            else
            {
                $start_time_str = date( 'Y-m-d' , time() ).''
                        . ' '.date('H:i:s' ,$requirement_info['creattime']);
            }

            //ֿʼʱڵ
            $start_time = strtotime( $start_time_str );

            //ƥ
            for( $i = 0 ; $i < $total_match_num ; $i++ )
            {
                //ƥ
                if( $match_info[$i]['creattime'] >= $start_time )
                {
                    $today_match_num ++;
                }

                //ƥ
                if( $match_info[$i]['match_uid'] == $match_uid )
                {
                    $my_match_num ++;
                }
            }

            //
            if( $total_match_num >= 200)
            {
                $msg_result = 'total_limit_error';
                echo $msg_result;
                exit;
            }

            //
            if( $today_match_num >= 20)
            {
                $msg_result = 'day_limit_error';
                echo $msg_result;
                exit;
            }

            //ظƥ֤
            if( $my_match_num >= 1)
            {
                $msg_result = 'my_limit_error';
                echo $msg_result;
                exit;
            }

            /*ƥ䷿ԴϢǷ֤Ϣ*/
            $house_fields_str = '';
            foreach( $house_fields_arr as $key => $value)
            {
                $house_fields_str .= $house_fields_str != '' ? ','.$value : $value;
            }

            //׼ƥķԴϢ
            $match_info = $this->_get_rentinfo_by_id( $match_uid , $match_id , $house_fields_arr);
            
            //Դ֤
            $infotype = $match_info['infotype'];
            if( $infotype != $requirement_info['infotype'] )
            {
                if( $requirement_info['infotype'] != 6 && $infotype != 5  )
                {
                    $msg_result = 'infotype_error';
                    echo $msg_result;
                    exit;
                }
            }

            //ƥֵ
            $street_id = intval($match_info['streetid']);
            $require_street[0] = intval( $requirement_info['street'] );
            $require_street[1] = intval( $requirement_info['street1'] );
            $require_street[2] = intval( $requirement_info['street2'] );
            
            if( $street_id == 0 || !in_array($street_id , $require_street))
            {
                $msg_result = 'street_error';
                echo $msg_result;
                exit;
            }

            //ƥbuildarea
            $buildarea = intval($match_info['buildarea']);
            if( $buildarea < $requirement_info['buildarea1'] 
                    || $buildarea > $requirement_info['buildarea2'] )
            {
                $msg_result = 'buildarea_error';
                echo $msg_result;
                exit;
            }

            //ƥprice
            $price = intval($match_info['price']);
            if( $price < $requirement_info['price1'] || $price > $requirement_info['price2'] )
            {
                $msg_result = 'price_error';
                echo $msg_result;
                exit;
            }
            
            //ƥrenttype
            $renttype = $match_info['renttype'];
            if( in_array( 'renttype' , $fields_arr ) && $renttype != $requirement_info['renttype'] )
            {
                if( $renttype != '' && $requirement_info['renttype'] != '⹫Ԣ' )
                {
                    $msg_result = 'renttype_error';
                    echo $msg_result;
                    exit;
                }
            }

            $tt = array();
            $tt['match_id'] = $match_id;
            $tt['match_uid'] = $match_uid;
            $tt['want_id']  = $want_id;
            $tt['want_uid'] = $want_uid;
            $tt['infofrom'] = 5; //н
            $tt['esta']     = 0; //ƥ״̬
            $tt['isread']   = 0; //ǷѾ鿴
            $tt['creattime'] = time();
            
            //(ƥ䷿Դ۳)
            $arrBroker = $arrBroker = array(
                'id' => $match_uid,
                'groupid' => $this->user_arr['package_id'],
            );
            
            $gbc  = new GrowthBrokerCredit($arrBroker); 
            $inCreditStatus = $gbc->reduce('matchRent');

            //
            if( is_array($inCreditStatus) && $inCreditStatus['status'] == 1 )
            {   
                //ƥϢ
                $result = $this->rent_match_model->add_match_info($tt);

                if( $result )
                {   
                    //޸ⷿԴƥ
                    $update_arr = array('matched_num' => '`matched_num` + 1');
                    $up_result = $this->rent_demand_model->update_info_by_id( $update_arr , FALSE);

                    //վ
                    if( $up_result === TRUE)
                    {
                        $subject = urlencode($subject);
                        $msg = urlencode(sprintf($msg , $requirement_info['address']));
                        $ulr = 'http://www.house365.com/center';
                        $param = '/esf_center_api/api_sendmessage?uid='.$want_uid.''
                                . '&msg='.$msg.'&subject='.$subject.'&city=nj';
                        curl_get_contents( $ulr . $param );
                    }
  
                    $msg_result = 'sucess';
                }
                else
                {
                    $msg_result = 'insert_error';
                }
            }
            else
            {
                $msg_result = 'credit_not_enough_error';
            }
        }
        else
        {
            $msg_result = 'info_error';
        }

        echo $msg_result;
        exit;
    }
    
    
    /**
     * һ
     * @access public
     * @return int
     */
    public function find_pasword(){
        $telno = $this->input->get('mobilePhone',TRUE); 
        $username = $this->input->get('loginAccount',TRUE);      
        $this->load->model('broker_model');
        $data_arr = $this->broker_model->get_info_by_username($username); 
        if(!empty($data_arr)&&$data_arr['telno']){
            if($data_arr['telno']==$telno){
                //ѯü
                $count_num = $this->broker_model->get_findpwd_count($telno);
                if($count_num<3){
                    $validcode = random(6);
                    $data = array('tbl'=>'broker','rowid'=>$data_arr['uid'],'validcode'=>$validcode,'mobile'=>$telno,'dateline'=>time());
                    $smsid = $this->broker_model->insert_info_sms($data);
                    if($smsid){
                        $msg   = '𾴵365ѣ֤Ϊ'.$validcode.',ȷ֤ɳʼ';
                        send_sms($telno, $msg,'sx',$validcode);
                        $session_data = array('vaildmoblie'=>$telno,'vaildbrokerid'=>$data_arr['uid']);
                        $this->session->set_userdata($session_data);
                        $message_text = 4; //ɹ      
                    }
                                          
                }else{
                    $message_text = 3;//Ϣ3
                }         
            }else{
                $message_text = 2; //ֻĲ           
            }
        }else{
            $message_text = 1; //Ϊջֻ
        }
        echo $message_text;
        exit();
    }
    
    /**
     * ٴλȡһ֤
     * @access public
     * @return int
     */
    public function revalidcode(){
        $telno = $this->input->get('telno'); 
        $brokerid = $this->input->get('brokerid');        
        $this->load->model('broker_model');
        if($telno&&$brokerid){            
            //ѯü
            $count_num = $this->broker_model->get_findpwd_count($telno);
            if($count_num<3){
                $validcode = random(6);
                $data = array('tbl'=>'broker','rowid'=>$brokerid,'validcode'=>$validcode,'mobile'=>$telno,'dateline'=>time());
                $smsid = $this->broker_model->insert_info_sms($data);
                if($smsid){
                    $msg   = '𾴵365ѣ֤Ϊ'.$validcode.',ȷ֤ɳʼ';
                    send_sms($telno, $msg,'sx',$validcode);
                    $result = 2;                     
                }                 
            }else{
                $result = 1;               
            }
        }else{
           $result = 3;
        }
        echo $result;
        exit;
    }
    
    /**
     * ֤һ֤
     * vaild_find_pwd
     */
    public function vaild_find_pwd(){
         $vaildcode = $this->input->get('code',TRUE);    
         $brokerid = $this->input->get('brokerid',TRUE);
         $telno = $this->input->get('telno',TRUE);       
         //brokerģ
         $this->load->model('broker_model'); 
         $message_flag = 0;
         $lastst_sms = $this->broker_model->get_lastst_sms($telno);
         if(!empty($lastst_sms)&&$lastst_sms['validcode']==$vaildcode){
             $is_expire = $this->broker_model->is_expire_code($lastst_sms['dateline']);
             if(!$is_expire){
                 $message_flag = 2; 
             }else{
                 $this->broker_model->update_broker_pwd($lastst_sms['rowid']);
                 $this->broker_model->update_sms_flag($lastst_sms['id']);                
                 $message_flag = 3;                   
             }       
         }else{
             $message_flag = 1;                           
         }         
        echo $message_flag;
        exit;
    }
    
    
    
    /**
     * ȡͷϵͳϢ
     * get_remind_message
     * @param $uid
     * @return array
     */
    public function get_remind_message($uid){
        if($uid != $this->user_arr['uid']){
            echo "login";
	    exit;
        }       
        $this->load->model('message_model');
        $data = $this->message_model->get_message_no_read($this->user_arr['uid']);
        echo json_encode($data);
        exit;
    }

    public function banwords() {
         $address = urldecode($this->input->get('address',TRUE));    
         $remark = urldecode($this->input->get('remark',TRUE));
         $this->load->helper('common_house_helper');
         $filename = STATIC_SOURCE_URL . '/common/banwords/banwords.txt';
         $result = array('status' => 1);
         if (publish_banwordCheck($address, $filename)) {
             $result['status'] = 2;
         } else if (publish_banwordCheck($remark, $filename)) {
            $result['status'] = 3;
         }
         echo $this->ajax_model->array_to_json($result);
    }

	public function check_sensitive_word()
	{
		$keyword = '';

		if(!empty($_POST['keyword']))
		{
			$keyword =  iconv('utf-8','gbk',urldecode($_POST['keyword']));
		}
		
		$this->load->model('ajax_model');
		$sensitive_word = $this->ajax_model->check_sensitive_word($keyword);
		
		$result = true;
		if(!empty($sensitive_word))
		{
			$result = iconv('gbk','utf-8',$sensitive_word);
		}
		
		exit(json_encode($result));
	}
	
	/**
	 * ȡСͬľ
	 *
	 * @param unknown_type $block_id
	 */
	public function find_block_area_prices($block_id){
	    $data = bm('block')->block_area_prices($block_id,'nj');
        echo json_encode($data);die();
	}
}
