<?php

/**
 * core\lib\block\BlockLevelHeat.php
 */

/**
 * ѧУȶȵȼ
 *
 * @author Administrator
 */
class SchoolLevelHeat {
    //put your code here
    /**
     *
     * @var TINY_ADODB ݿ
     */
    private $db;
    /**
     *
     * @var TINY_ADODB ݿ
     */
    private $dbback;
    /**
     *
     * @var Memcache  
     */
    private $mc;
    /**
     *
     * @var string 
     */
    private $table;
    /**
     *
     * @var array аֶ
     */
    public static $fields = array('id', 'school_id', 'level', 'utime');

    /**
     * 캯 ʼdbmemcache
     * @param string $table 
     */
    public function __construct($table = 'school_level') {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->mc = $container->get('mc');
        $this->table = $table;
    }
    
    /**
     * һѧУȼ
     * @param array $fieldData block_id,level
     * @return int زݵid
     */
    public function insert($fieldData) {
        $sql = SqlCombinHelper::insert_sql($this->table, $fieldData);
        $this->db->Execute($sql);
        return $this->db->Insert_ID();
    }
    
    /**
     * һӶѧУȼ
     * @param array $fieldsData school_id,levelĶά
     * @return int 
     */
    public function insertMutl($fieldsData) {
        $sql = SqlCombinHelper::insertMutil_sql($this->table, $fieldsData);
        //exit;
        $this->db->Execute($sql);
        return $this->db->Affected_Rows();
    }

    /**
     * ѧУidѧУȶȵȼ
     * @param int $schoolId ѧУid
     * @return array Сȼ
     */
    public function findBySchoolId($schoolId) {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields, "school_id='$schoolId'");
        return $this->dbback->GetRow($sql);
    }
    
    
    public function findAll() {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields);     
        return $this->dbback->getAll($sql);
    }

        /**
     * ҵȼΪ$levelѧУ
     * @param  mixed $level A,B,C,D
     * @return array ذСidĶά
     */
    public function findByLevel($level) {
        if(is_numeric($level)) {
            $where = "level=$level";
        } else {
            $where = "level='$level'";
        }
        $sql = SqlCombinHelper::select_sql($this->table, $where);
        return $this->db->Execute($sql);
    }
    
    /**
     * ѧУȶȵȼ
     */
    public function emptyTable() {
        $sql = "TRUNCATE TABLE $this->table";
        $this->db->Execute($sql);
    }
    
    public function findBy($select,$conf,$arrayType=1) {
        $sql = SqlCombinHelper::select_sql($this->table, $select, $conf);
        if($arrayType) {
            return $this->dbback->GetAll($sql);
        } else {
            return $this->dbback->GetAssoc($sql);
        }
        
    }

    /**
     * ˢѧУȼ
     * @param array $data Сȼ,array(0=>array('block_id'=>10,'level'=>'A'))
     * @return int ˢµ
     */
    public function refreshData($data) {
        $this->emptyTable();
        return $this->insertMutl($data);
    }
    
    public static function friendlyShow($schoolLevel) {
        
        $levelDef = array('A'=>3,'B'=>2,'C'=>1);
        $re = array();
        if($schoolLevel&&is_array($schoolLevel)) {
            foreach($schoolLevel as $v) {
                $width = $levelDef[$v['level']]*20;
                $re[$v['school_id']] = '<div l="'.$v['level'].'" style="width:'.$width.'px;" class="hot_bg_inner2"></div>';
            }
            return $re;
        } else {
            $width = $levelDef[$schoolLevel]*20;
            return '<div l="'.$schoolLevel.'" style="width:'.$width.'px;" class="hot_bg_inner2"></div>';
        }
    }
}

?>
