<?php
/**
 * Description of GrowthBrokerExp
 *
 * @author sun
 */
class GrowthBrokerExp {
    
    /**
     *
     * @var GrowthExp 
     */
    private $exp;
    
    /**
     *
     * @var GrowthExpDayCount 
     */
    private $expDayCount;
    /**
     *
     * @var GrowthExpRecord 
     */
    private $expRecord;
    
    /**
     *
     * @var GrowthExpControllPackage 
     */
    private $expControllPackage;
    
    /**
     *
     * @var type 
     */
    private $broker;
    
    
    public function __construct($broker, $strDate = '') {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->exp = new GrowthExp();
        $this->expDayCount = new GrowthExpDayCount();
        $this->expRecord = new GrowthExpRecord($strDate);
        $this->expControllPackage = new GrowthExpControllPackage();
        $this->broker = $broker;
    }
    
    /**
     * ˱
     * @return int
     */
    private function getBrokerId() {
        return $this->broker['id'];
    }
    
    /**
     * ײ
     * @return int
     */
    private function getBrokerPackageId() {
        return $this->broker['groupid'];
    }
    
    /**
     * ݳɳֵȡʽ
     * @param type $wayAlias
     * @return type
     */
    private function getWayAliasName($wayAlias) {
        $expWay = new GrowthExpWay();
        return $expWay->findNameByAlias($wayAlias);
    }
    
    /**
     * ݳɳֵȡʽӻ߼ٵķֵ
     * @param string $wayAlias ȡɳֵķʽ
     * @return int سɳֵ
     */
    public function getScoreByWayAlias($wayAlias) {
        
        $packageId = $this->getBrokerPackageId();
        $wayPackageScore = new GrowthExpWayPackage();
        $score = $wayPackageScore->findScoreByWayAliasAndPackageId($wayAlias,
                $packageId);       
        return $score;
    }
    
    private function getTime() {
        return date('Y') . '' . date('m') . '' . date('d') . '';
    }
    
    /**
     * ӳɳֵ
     * @param string $wayAlias ȡɳֵķʽ
     * @param string $description ȡɳֵʽԶ
     * @param type ظ÷ʽĳɳֵԶ
     */
    public function increase($wayAlias, $description = null, $score = null) {
        if ($wayAlias == null) {
            return array('status' => false, 'msg' => 'wayAliasֶβΪ');
        }
        if($score == null) {
            $score = $this->getScoreByWayAlias($wayAlias);
        } else {
            $score = abs($score);
        }
        $updateScoreStatus = '';
        $brokerId = $this->getBrokerId();
        //¾˷ֵ
        $ctime = date("Y-m-d");
        if ($wayAlias == 'false'/**'openPayPackage'**/ ) {
            $updateScoreStatus = $this->exp->insertData($brokerId, $score);
			$status = 1; 
        } else {
            //ȡײÿĳɳֵ
            $upperLimitScore = $this->expControllPackage->findScoreByWayAliasPackageId(
                    'dayExpLimit', $this->getBrokerPackageId());
            //ȡ˼ͼѾȡٳɳֵ
            $wayArr = array('systemReward','openPayPackage','birthdayReward','accountFailure');//ųĿ
            $sumScoreDay = $this->expDayCount->findCountExpByDayExOther($ctime, $brokerId,$wayArr);
            $arrRtnResult = array();
            if ($sumScoreDay >= $upperLimitScore && !in_array($wayAlias, $wayArr)) {//ϵͳͲƷֵ
                $status = 2;
		        $isFull = TRUE;
            }elseif ($sumScoreDay+$score > $upperLimitScore && !in_array($wayAlias, $wayArr)){//ϵͳͲƷֵ
                $miusScore = $upperLimitScore - $sumScoreDay;
                $updateScoreStatus = $this->exp->addExpToOneBrokerId($brokerId, $miusScore);
				$score = $miusScore;
				$status = 2;               
            } else {
                $updateScoreStatus = $this->exp->addExpToOneBrokerId($brokerId, $score);
                $status = 1;
            }
        }
		if($description == null) {
            $description = $this->getWayAliasName($wayAlias);            
        } 
        $description = $this->getTime() . ' ' . $description . ''
                         . $score . 'ɳֵ';
        if ($updateScoreStatus) {
            //޸ÿĳļ¼
            $this->expDayCount->increase($ctime, $wayAlias, $brokerId, $score);
            //Ӳ¼
            $this->expRecord->insertData($brokerId, $wayAlias, $score, $description);
            $arrRtnResult['status'] = $status;
	    }elseif ($isFull){
            $arrRtnResult['status'] = $status;
            $arrRtnResult['score'] = $score;
	    } else {
            $arrRtnResult['status'] = 0;
            $arrRtnResult['msg'] = 'ӳɳֵʧ';
	    }
        return $arrRtnResult;
    }
    
    /**
     * ٳɳֵ
     * @param string $wayAlias ȡɳֵķʽ
     * @param string $description ȡɳֵʽԶ
     * @param type ظ÷ʽĳɳֵԶ
     */
    public function reduce($wayAlias, $description = null, $score = null) {
        if ($wayAlias == null) {
            return array('status' => false, 'msg' => 'wayAliasֶβΪ');
        }
        if($score == null) {
            $score = $this->getScoreByWayAlias($wayAlias);
        } else {
            $score = '-' . abs($score);
        }

        $brokerId = $this->getBrokerId();       

		 //¾˷ֵ
         $updateScoreStatus = $this->exp->addExpToOneBrokerId($brokerId, $score);
	

        if($description == null) {
            $description = $this->getWayAliasName($wayAlias);           
        }
        $description = $this->getTime() . ' '. $description. '۳'
                         . abs($score) . 'ɳֵ';
     
       
        $arrRtnResult = array();
        if ($updateScoreStatus) {
            //޸ÿĳļ¼
            $ctime = date("Y-m-d");
            $this->expDayCount->reduce($ctime, $wayAlias, $brokerId, $score);

            //Ӳ¼
            $this->expRecord->insertData($brokerId, $wayAlias, $score, $description);
            $arrRtnResult['status'] = 1;
            $arrRtnResult['score'] = $score;
        } else {
            $arrRtnResult['status'] = 0;
            $arrRtnResult['msg'] = '۳ɳֵʧ';
        }
        return $arrRtnResult;
    }
    
    /**
     * ȡ˵ȼ
     */
    public function getLevel($resultType=1) {
        $exp = $this->getExp();
        //ȼ
        $growthLevel = new GrowthLevel();
        $brokerLevel = $growthLevel->findLevelNameByExp($exp);
        if($resultType===2) {
            $brokerLevel = intval(substr($brokerLevel,2));
        }
        return $brokerLevel;
    }
    
    public function getExp() {
        $brokerId = $this->broker['id'];
        $brokerExp = $this->exp->findOneByBrokerId($brokerId);
        if($brokerExp) {
         $brokerExp['exp'] = $brokerExp['exp'] == '' ? 0 : $brokerExp['exp'];
        } else {
            $brokerExp['exp'] = 0;
        }
        return $brokerExp['exp'];
    }
    
    /**
     * 
     */
    public function getRank($allBrokerNumber,$exp) {
        $container = Container::getInstance();
        $mc = $container->get('mc');
        $key = 'nj_growth_broker_less_exp'.$this->getBrokerId();
        $lessBrokerExpNum = $mc->get($key);
        if($lessBrokerExpNum === false) {
            $lessBrokerExpNum = $this->exp->findCountBrokerByLtExp($exp);
            //$lessBrokerExpNum = count($lessBrokerExpInfo);
            $mc->set($key,$lessBrokerExpNum,1800);
        }
        return $allBrokerNumber-$lessBrokerExpNum;
    }
    
    /**
     * ؾ
     * @return type
     */
    public function getBrokerNumber() {
        return $this->exp->findCountBrokerAndExpInfo();
        $container = Container::getInstance();
        $mc = $container->get('mc');
        $key = 'nj_growth_all_broker_number';
        $allBrokerExpNum = $mc->get($key);
        if($allBrokerExpNum === false){
            $allBrokerExpInfo = $this->exp->findAllBrokerAndExpInfo();
            $allBrokerExpNum = count($allBrokerExpInfo);
            $mc->set($key,$allBrokerExpNum,300); 
        }
        return $allBrokerExpNum;
    }
}
