<?php

/**
 * Description of GrowthBidHouseBlock
 *
 * @author user
 */
class GrowthBidRent extends GrowthBid {
    
    /**
     * Ͷʵ
     * @var type 
     */
    public static $bidWordsType = array(
        'block' => 1,  
        'hotsearch'  => 2
    );
    
    public function __construct($table = 'growth_bid_rent') {
        parent::__construct($table);
    }
    
    
    public function findByBid($type, $bid,$order='',$limit='') {
        $sql = SqlCombinHelper::innerSelect_sql($this->table, 'broker',
                implode(",", $this->fields).',agentcode' 
                , "$this->table.broker_id=broker.uid", "bid_id='$bid' AND type"
                . " = $type");
        if($order) {
            $sql .= " ORDER BY $order";
        }
        if($limit) {
            $sql .= " LIMIT $limit";
        }
        return $this->dbback->GetAll($sql);
    }
    
    public function findPeriodsByPeriodsId($periodsId) {
        parent::findPeriodsByPeriodsId($periodsId);
    }
    
    /**
     * ڴid;Ͷͻȡ
     * @param type $periodsId
     * @param type $type
     * @return type
     */
    public function findByPeriodsIdAndType($periodsId, $type) {
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, 
                "bid_periods_id = $periodsId AND type = $type");
        return $this->dbback->GetAll($sql);
    }
    
    /**
     * ȡһβ뾺ͶС
     */
    public function findNewPeriodsBlockWords() {
        $growthBidPeriods = new GrowthBidPeriods();
        $cPeriods = $growthBidPeriods->currentBidPeriods(3);
        return $this->findByPeriodsIdAndType($cPeriods['id'], self::$bidWordsType['block']);
    }
    
    /**
     * ȡһβľͶѴ
     */
    public function findNewPeriodsHotSearch() {
        $growthBidPeriods = new GrowthBidPeriods();
        $cPeriods = $growthBidPeriods->currentBidPeriods(3);
        return $this->findByPeriodsIdAndType($cPeriods['id'], self::$bidWordsType['hotsearch']);
    }
    public function findPeriodsBlock($periodsId) {
        return $this->findByPeriodsIdAndType($periodsId, self::$bidWordsType['block']);
    }
    public function findPeriodsHotSearch($periodsId) {
        return $this->findByPeriodsIdAndType($periodsId, self::$bidWordsType['hotsearch']);
    }
    
    /**
     * ȡĳͶȡǰ
     * @param type $bid
     */
    public function getMaxWinNumberBid($bid) {
        $arrBidOne = $this->findOneById($bid);
        return $arrBidOne['max_win_number'];
    }
    
    /**
     * ݾͶIDȡͶ
     * @param type $bid
     * @return type
     */
    public function getBidHotWordsByBid($bid) {
        $sql = SqlCombinHelper::select_sql($this->table, 'keyword', "id = $bid");
        $keyword = $this->mc->get($sql);
        if ($keyword === false) {
            $keyword = $this->dbback->getOne($sql);
            $this->mc->set($sql, $keyword, 86400);
        }
        return $keyword;
    }
    
    /**
     * ȡСڵǰbidľͶʵʷ¼
     * @param type $bidId
     * @return type
     */
    public function findHistoryByTypeAndBid($type, $bidId) {
		if ($type == '' || $bidId == '') {return array();}
        $bidOne = $this->findById($bidId);
        if ($type == 1) {
            $blockId = $bidOne['block_id'];
            $strWhere = " block_id = $blockId";
        } else {
            $keyword = $bidOne['keyword'];
            $strWhere = " keyword = '$keyword'";
        }
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, "id < $bidId  AND $strWhere ORDER BY id DESC");
        $this->mc->delete($sql);
        $allBid = $this->mc->get($sql);
        if ($allBid === false) {
            $allBid = $this->dbback->getAll($sql);
            $this->mc->set($sql, $allBid, 3600);
        }
        return $allBid;
    }
}
