<?php
/**
 * Description of GrowthBidHouseRecordFactory
 *
 * @author user
 */
class GrowthBidRecordFactory {
    
    //ùͶ
    public static $objConfig = array(
        'house' => array(
            'on' => 'GrowthBidHouseRecordOn', 'finish' => 'GrowthBidHouseRecordFinish', 
            'history' => 'GrowthBidHouseRecordHistory'), //ַ       
        'blockExpert' => array(
            'on' => 'GrowthBidBlockExpertRecordOn', 'finish' => 'GrowthBidBlockExpertRecordFinish', 
            'history' => 'GrowthBidBlockExpertRecordHistory'), //Сר
        'rent' => array(
            'on' => 'GrowthBidRentRecordOn', 'finish' => 'GrowthBidRentRecordFinish', 
            'history' => 'GrowthBidRentRecordHistory'), //ⷿ
        'schoolExpert' => array(
            'on' => 'GrowthBidSchoolExpertRecordOn', 'finish' => 'GrowthBidSchoolExpertRecordFinish', 
            'history' => 'GrowthBidSchoolExpertRecordHistory'), //ѧר
    );

    public static function getRecordClassByTime($bidType, $isBidOn) {
        if ($isBidOn) {
            return self::getRecordOnClass($bidType);
        } else {
            return self::getRecordHistoryClass($bidType);
        }
    }
    
    public static function getRecordHistoryClass($bidType) {
        return new self::$objConfig[$bidType]['history'];
        /**
        return $bidType == 'house' ? new GrowthBidHouseRecordHistory()
                : new GrowthBidBlockExpertRecordHistory();***/
    }
    
    public static function getRecordFinishClass($bidType) {
        return new self::$objConfig[$bidType]['finish'];
        /***
        return $bidType == 'house' ? new GrowthBidHouseRecordFinish()
                : new GrowthBidBlockExpertRecordFinish();**/
    }
    
    public static function getRecordOnClass($bidType) {
        return new self::$objConfig[$bidType]['on'];
        /**
        return $bidType == 'house' ? new GrowthBidHouseRecordOn()
                : new GrowthBidBlockExpertRecordOn();**/
    }
}
